/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;

public abstract class DeleteSelectionController {
    private List<Integer> defaultSelection;
    private HashMap<Integer, Integer> indexSelection;
    private GridTab currentTab;
    private boolean isOkPressed = false;
    private int[] selection;
    private String keyColumnName;
    private String sql;

    public DeleteSelectionController(GridTab tab, List<Integer> defaultSelection) {
        this.currentTab = tab;
        this.defaultSelection = defaultSelection;
        this.keyColumnName = this.currentTab.getKeyColumnName();
        if (this.keyColumnName.trim().length() > 0) {
            this.sql = MLookupFactory.getLookup_TableDirEmbed(Env.getLanguage(Env.getCtx()), this.keyColumnName, "[?", "?]").replace("[?.?]", "?");
        }
    }

    public DeleteSelectionController(GridTab tab) {
        this(tab, null);
    }

    public GridTab getTab() {
        return this.currentTab;
    }

    public List<Integer> getDefaultSelection() {
        return this.defaultSelection;
    }

    public int[] getSelection() {
        return this.selection;
    }

    public void setSelection(int[] userSelection) {
        if (this.defaultSelection == null) {
            this.selection = userSelection;
        } else {
            this.selection = new int[userSelection.length];
            for (int i = 0; i < userSelection.length; ++i) {
                this.selection[i] = this.indexSelection.get(userSelection[i]);
            }
        }
        Arrays.sort(this.selection);
    }

    public boolean isOkPressed() {
        return this.isOkPressed;
    }

    public void setIsOkPressed(boolean isOkPressed) {
        this.isOkPressed = isOkPressed;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelection != null;
    }

    public Vector<String> getData() {
        Vector<String> data = new Vector<String>();
        if (this.defaultSelection == null) {
            int noOfRows = this.currentTab.getRowCount();
            this.selection = new int[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                data.add(this.getValue(i));
                this.selection[i] = i;
            }
        } else {
            this.indexSelection = new HashMap();
            this.selection = new int[this.defaultSelection.size()];
            for (int i = 0; i < this.defaultSelection.size(); ++i) {
                int currentIndex = this.defaultSelection.get(i);
                this.indexSelection.put(i, currentIndex);
                data.add(this.getValue(currentIndex));
                this.selection[i] = i;
            }
        }
        return data;
    }

    private String getValue(int index) {
        StringBuffer displayValue = new StringBuffer();
        if (this.keyColumnName.trim().length() == 0) {
            ArrayList<String> parentColumnNames = this.currentTab.getParentColumnNames();
            for (String columnName : parentColumnNames) {
                GridField field = this.currentTab.getField(columnName);
                if (field.isLookup()) {
                    Lookup lookup = field.getLookup();
                    if (lookup != null) {
                        displayValue = displayValue.append(lookup.getDisplay(this.currentTab.getValue(index, columnName))).append(" | ");
                        continue;
                    }
                    displayValue = displayValue.append(this.currentTab.getValue(index, columnName)).append(" | ");
                    continue;
                }
                displayValue = displayValue.append(this.currentTab.getValue(index, columnName)).append(" | ");
            }
        } else {
            int id = this.currentTab.getKeyID(index);
            String value = DB.getSQLValueStringEx(null, this.sql, id);
            if (value != null) {
                value = value.replace(" - ", " | ");
            }
            displayValue.append(value);
            if (displayValue.length() == 0 || CLogMgt.isLevelFine()) {
                if (displayValue.length() > 0) {
                    displayValue.append(" | ");
                }
                displayValue.append("<").append(id).append(">");
            }
        }
        return displayValue.toString();
    }

    public abstract void showDialog();
}

