/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.controller.ed.CPaymentEditor;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccount;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.ValueNamePair;

public class PaymentFormController {
    public static final String MSG_PaymentCreateConfirmation = "PaymentFormController: PaymentCreateConfirmation";
    public static final String MSG_PaymentError = "PaymentError";
    public static final String MSG_PaymentCreated = "PaymentCreated";
    public static final String MSG_PaymentProcessed = "PaymentProcessed";
    public static final String MSG_CashJournal = "PaymentFormController: CashJournal";
    public static final String MSG_CashJournalTip = "PaymentFormController: CashJournalTip";
    private static final String MSG_PaymentNotCreated = "PaymentFormController: PaymentNotCreated";
    private static final String MSG_PaymentNotCompletedAfterProcessApproval = "PaymentFormController: PaymentNotCompletedAfterProcessApproval";
    private static final String MSG_PaymentNotProcessed = "PaymentFormController: PaymentNotProcessed";
    private static final String MSG_NoBusinessPartnerFound = "PaymentFormController: NoBusinessPartnerFound";
    private static final String MSG_DocumentReverserdOrVoided = "PaymentFormController: DocumentReversedOrVoided";
    private static final String Msg_NoCashJournalSelected = "PaymentFormController: NoCashJournalSelected";
    private static final String MSG_NoCreditCardTypeSelected = "PaymentFormController: NoCreditCardTypeSelected";
    private static final String MSG_NoBPBankAccountSelected = "PaymentFormController: NoBPBankAccountSelected";
    private static final String MSG_ZeroPaymentAmount = "PaymentFormController: ZeroPaymentAmount";
    private static CLogger log = CLogger.getCLogger(PaymentFormController.class);
    private int windowNo = 0;
    private GridTab gridTab;
    private boolean isSOTrx = true;
    private String docStatus = null;
    private boolean onlyChangePaymentRule;
    private int c_currency_id = 0;
    private int ad_client_id = 0;
    private int ad_org_id = 0;
    private int c_bpartner_id = 0;
    private BigDecimal paymentAmount = Env.ZERO;
    private String paymentRule = "";
    private int c_paymentTerm_id = 0;
    private Timestamp dateAcct = null;
    private MPayment payment = null;
    private String ccType = "";
    private int c_bankAccount_id = 0;
    private int cashBook_id = 0;
    private String new_paymentRule = "";
    private Timestamp new_dateAcct = null;
    private int new_c_paymentTerm_id = 0;
    private int new_cashBook_id = 0;
    private String new_ccType = "";
    private String new_ccNumber = "";
    private String new_ccExpDate = "";
    private int new_c_bankAccount_id = 0;
    private int new_c_bp_bankAccount_id = 0;
    private BigDecimal new_paymentAmount = Env.ZERO;
    private String new_checkRoutingNumber = "";
    private String new_checkAccountNumber = "";
    private String new_checkNumber = "";
    private String new_ccName = "";
    private static Hashtable<Integer, KeyNamePair> currencies = null;
    private String errorMsg = "";
    private String onlineInfo = "";
    private HashMap<String, String> paymentRuleValues;
    private ValueNamePair selectedPaymentRule;
    private KeyNamePair selectedPaymentTerm;
    private ValueNamePair selectedCreditCard;
    private KeyNamePair selectedBankAccount;
    private KeyNamePair selectedCashBook;
    private CPaymentEditor editor;
    private String paymentDocNumber;
    private int c_order_id;
    private int c_invoice_id;
    private List<MInvoice> invoices = new ArrayList<MInvoice>();
    private List<MPayment> payments = new ArrayList<MPayment>();
    private BigDecimal invoiceAmountOpen = Env.ZERO;
    private BigDecimal grandTotal = Env.ZERO;
    private BigDecimal paidAmount = Env.ZERO;
    private BigDecimal paidAmountAllocated = Env.ZERO;
    private BigDecimal paidAmountUnallocated = Env.ZERO;
    private BigDecimal invoiceAmount = Env.ZERO;
    private boolean isOrder = false;
    private boolean isInvoice = false;
    private boolean processOnline = false;
    private String errorInfo;

    public PaymentFormController(CPaymentEditor editor, int WindowNo, GridTab tab, HashMap<String, String> buttonValues) {
        this.editor = editor;
        this.windowNo = WindowNo;
        this.gridTab = tab;
        this.paymentRuleValues = buttonValues;
    }

    public boolean init() {
        if (this.gridTab.getValue("C_BPartner_ID") == null) {
            this.errorMsg = MSG_NoBusinessPartnerFound;
            return false;
        }
        this.dateAcct = this.getDate();
        this.docStatus = (String)this.gridTab.getValue("DocStatus");
        log.config(this.docStatus);
        if (this.docStatus == null) {
            this.docStatus = "";
        }
        if (this.docStatus.equals("RE") || this.docStatus.equals("VO")) {
            this.errorMsg = MSG_DocumentReverserdOrVoided;
            return false;
        }
        this.paymentRule = (String)this.gridTab.getValue("PaymentRule");
        String payTypes = "KTSDBP";
        if (!payTypes.contains(this.paymentRule) || this.paymentRule == null || this.paymentRule.isEmpty()) {
            this.paymentRule = "S";
        }
        this.isSOTrx = "Y".equals(Env.getContext(Env.getCtx(), this.windowNo, "IsSOTrx"));
        this.grandTotal = (BigDecimal)this.gridTab.getValue("GrandTotal");
        this.onlyChangePaymentRule = false;
        if (!this.docStatus.equals("CO") && !this.docStatus.equals("WP") || !this.isSOTrx && this.gridTab.getTableName().equals("C_Order") || this.grandTotal.compareTo(Env.ZERO) == 0) {
            this.onlyChangePaymentRule = true;
        }
        this.ad_client_id = (Integer)this.gridTab.getValue("AD_Client_ID");
        this.ad_org_id = (Integer)this.gridTab.getValue("AD_Org_ID");
        this.c_bpartner_id = (Integer)this.gridTab.getValue("C_BPartner_ID");
        this.c_currency_id = (Integer)this.gridTab.getValue("C_Currency_ID");
        if (this.gridTab.getValue("C_PaymentTerm_ID") != null) {
            this.c_paymentTerm_id = (Integer)this.gridTab.getValue("C_PaymentTerm_ID");
        }
        this.dateAcct = new Timestamp(System.currentTimeMillis());
        if (currencies == null) {
            this.loadCurrencies();
        }
        this.isOrder = this.gridTab.getTableName().equals("C_Order");
        this.isInvoice = this.gridTab.getTableName().equals("C_Invoice");
        if (this.isOrder) {
            this.c_order_id = (Integer)this.gridTab.getValue("C_Order_ID");
            this.c_invoice_id = 0;
            for (MInvoice inv : MInvoice.getOfOrder(Env.getCtx(), this.c_order_id, null)) {
                if (!inv.isPaid()) {
                    this.invoices.add(inv);
                }
                this.invoiceAmountOpen = this.invoiceAmountOpen.add(inv.getOpenAmt(true, null));
                this.invoiceAmount = this.invoiceAmount.add(inv.getGrandTotal(true));
            }
            if (this.invoices.size() == 1) {
                this.c_invoice_id = this.invoices.get(0).getC_Invoice_ID();
            }
        } else if (this.isInvoice) {
            this.c_invoice_id = (Integer)this.gridTab.getValue("C_Invoice_ID");
            MInvoice invoice = new MInvoice(Env.getCtx(), this.c_invoice_id, null);
            this.invoices.add(invoice);
            this.invoiceAmount = invoice.getGrandTotal(true);
            this.invoiceAmountOpen = invoice.getOpenAmt(true, null);
            this.c_order_id = invoice.getC_Order_ID();
        }
        this.payments = new ArrayList<MPayment>();
        this.paidAmount = Env.ZERO;
        this.paidAmountAllocated = Env.ZERO;
        this.paidAmountUnallocated = Env.ZERO;
        if (this.c_order_id > 0) {
            for (MPayment pmt : MPayment.getOfOrder(Env.getCtx(), this.c_order_id, null)) {
                this.payments.add(pmt);
                this.paidAmount = this.paidAmount.add(pmt.getPayAmt());
                if (pmt.isAllocated()) {
                    this.paidAmountAllocated = this.paidAmountAllocated.add(pmt.getPayAmt());
                    continue;
                }
                this.paidAmountUnallocated = this.paidAmountUnallocated.add(pmt.getPayAmt());
            }
        }
        this.paymentAmount = this.c_order_id > 0 && this.invoiceAmount.equals(Env.ZERO) ? this.grandTotal.subtract(this.paidAmount) : this.invoiceAmountOpen.subtract(this.paidAmountUnallocated);
        this.payment = new MPayment(Env.getCtx(), 0, null);
        this.payment.setAmount(this.c_currency_id, this.paymentAmount);
        return true;
    }

    public String getErrorMsg() {
        if (this.errorMsg == null || this.errorMsg.isEmpty()) {
            return "";
        }
        String message = Msg.translate(Env.getCtx(), this.errorMsg);
        if (this.errorInfo != null && !this.errorInfo.isEmpty()) {
            message = message + " " + this.errorInfo;
        }
        return message;
    }

    private void loadCurrencies() {
        currencies = new Hashtable(12);
        String SQL = "SELECT C_Currency_ID, ISO_Code FROM C_Currency WHERE (IsEMUMember='Y' AND EMUEntryDate<SysDate) OR IsEuro='Y' ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String name = rs.getString(2);
                currencies.put(new Integer(id), new KeyNamePair(id, name));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
    }

    public boolean isEMUCurrency() {
        if (currencies == null) {
            this.loadCurrencies();
        }
        Integer C_Currency_ID = new Integer(this.c_currency_id);
        return currencies.containsKey(C_Currency_ID);
    }

    public Hashtable<Integer, KeyNamePair> getCurrencies() {
        if (currencies == null) {
            this.loadCurrencies();
        }
        return currencies;
    }

    public KeyNamePair getCurrentCurrency() {
        if (currencies != null) {
            return currencies.get(this.c_currency_id);
        }
        return null;
    }

    public ArrayList<ValueNamePair> getPaymentRules() {
        ArrayList<ValueNamePair> rules = new ArrayList<ValueNamePair>();
        Object[] a = this.paymentRuleValues.keySet().toArray();
        this.selectedPaymentRule = null;
        for (int i = 0; i < a.length; ++i) {
            String PaymentRule = (String)a[i];
            ValueNamePair pp = new ValueNamePair(PaymentRule, this.paymentRuleValues.get(a[i]));
            rules.add(pp);
            if (!PaymentRule.toString().equals(this.paymentRule)) continue;
            this.selectedPaymentRule = pp;
        }
        return rules;
    }

    public ValueNamePair getSelectedPaymentRule() {
        return this.selectedPaymentRule;
    }

    public String whichPanel(ValueNamePair pp) {
        String s = pp.getValue().toLowerCase();
        if ("D".equalsIgnoreCase(s)) {
            s = "T".toLowerCase();
        }
        s = s + "Panel";
        return s;
    }

    public ArrayList<KeyNamePair> getPaymentTerms() {
        ArrayList<KeyNamePair> paymentTerms = new ArrayList<KeyNamePair>();
        this.selectedPaymentTerm = null;
        String SQL = MRole.getDefault().addAccessSQL("SELECT C_PaymentTerm_ID, Name FROM C_PaymentTerm WHERE IsActive='Y' ORDER BY Name", "C_PaymentTerm", false, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name = rs.getString(2);
                KeyNamePair pp = new KeyNamePair(key, name);
                paymentTerms.add(pp);
                if (key != this.c_paymentTerm_id) continue;
                this.selectedPaymentTerm = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ept) {
            log.log(Level.SEVERE, SQL, ept);
        }
        return paymentTerms;
    }

    public KeyNamePair getSelectedPaymentTerm() {
        return this.selectedPaymentTerm;
    }

    public ArrayList<KeyNamePair> getBPAccounts() {
        ArrayList<KeyNamePair> accounts = new ArrayList<KeyNamePair>();
        String SQL = "SELECT a.C_BP_BankAccount_ID, NVL(b.Name, ' ')||'_'||NVL(a.AccountNo, ' ') AS Acct FROM C_BP_BankAccount a LEFT OUTER JOIN C_Bank b ON (a.C_Bank_ID=b.C_Bank_ID) WHERE a.C_BPartner_ID=?AND a.IsActive='Y' AND a.IsACH='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, this.c_bpartner_id);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name = rs.getString(2);
                KeyNamePair pp = new KeyNamePair(key, name);
                accounts.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException eac) {
            log.log(Level.SEVERE, SQL, eac);
        }
        return accounts;
    }

    public ArrayList<ValueNamePair> getCreditCards() {
        ArrayList<ValueNamePair> cards = new ArrayList<ValueNamePair>();
        if (this.payment == null) {
            return cards;
        }
        this.selectedCreditCard = null;
        ValueNamePair[] ccs = this.payment.getCreditCards();
        for (int i = 0; i < ccs.length; ++i) {
            cards.add(ccs[i]);
            if (!ccs[i].getValue().equals(this.ccType)) continue;
            this.selectedCreditCard = ccs[i];
        }
        return cards;
    }

    public ValueNamePair getSelecteCreditCard() {
        return this.selectedCreditCard;
    }

    public ArrayList<KeyNamePair> getBankAccounts() {
        return this.getBankAccounts(false);
    }

    private ArrayList<KeyNamePair> getBankAccounts(boolean cashJournal) {
        ArrayList<KeyNamePair> accounts = new ArrayList<KeyNamePair>();
        String bankType = "B";
        if (cashJournal) {
            bankType = "C";
        }
        String SQL = MRole.getDefault().addAccessSQL("SELECT C_BankAccount_ID, ba.accountno, IsDefault FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE b.IsActive='Y' AND b.BankType=?", "ba", true, false);
        this.selectedBankAccount = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setString(1, bankType);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name = rs.getString(2);
                KeyNamePair pp = new KeyNamePair(key, name);
                accounts.add(pp);
                if (cashJournal) {
                    if (key == this.c_bankAccount_id) {
                        this.selectedCashBook = pp;
                    }
                    if (this.selectedCashBook != null || !rs.getString(3).equals("Y")) continue;
                    this.selectedCashBook = pp;
                    continue;
                }
                if (key == this.c_bankAccount_id) {
                    this.selectedBankAccount = pp;
                }
                if (this.selectedBankAccount != null || !rs.getString(3).equals("Y")) continue;
                this.selectedBankAccount = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ept) {
            log.log(Level.SEVERE, SQL, ept);
        }
        return accounts;
    }

    public KeyNamePair getSelectedBankAccount() {
        return this.selectedBankAccount;
    }

    public ArrayList<KeyNamePair> getCashBooks() {
        return this.getBankAccounts(true);
    }

    public KeyNamePair getSelectedCashBook() {
        return this.selectedCashBook;
    }

    public BigDecimal getConvertedAmount(int currencyTo_id) {
        return MConversionRate.convert(Env.getCtx(), this.paymentAmount, this.c_currency_id, currencyTo_id, this.ad_client_id, this.ad_org_id);
    }

    public boolean saveChanges() {
        this.errorMsg = "";
        this.errorInfo = "";
        if (!this.checkMandatory()) {
            return false;
        }
        final boolean[] success = new boolean[]{false};
        TrxRunnable r = new TrxRunnable(){

            @Override
            public void run(String trxName) {
                success[0] = PaymentFormController.this.saveChangesInTrx(trxName);
            }
        };
        try {
            Trx.run(r);
        }
        catch (Throwable e) {
            success[0] = false;
            this.errorMsg = e.getLocalizedMessage();
        }
        if (this.payment != null) {
            this.payment.set_TrxName(null);
        }
        return success[0];
    }

    private boolean saveChangesInTrx(String trxName) {
        boolean ok;
        MInvoice invoice;
        String new_paymentRule = this.editor.getPaymentRule();
        log.info("Payment Rule: " + new_paymentRule);
        String payTypes = "KTSDBP";
        if (!payTypes.contains(new_paymentRule) || new_paymentRule == null || new_paymentRule.isEmpty()) {
            throw new IllegalArgumentException("Payment Rule is null, empty or not recognized.");
        }
        log.config("Saving changes");
        if (!new_paymentRule.equals(this.paymentRule)) {
            this.gridTab.setValue("PaymentRule", (Object)new_paymentRule);
        }
        if (this.onlyChangePaymentRule) {
            return true;
        }
        if (new_paymentRule.equals("P")) {
            if (!new_paymentRule.equals(this.paymentRule)) {
                this.gridTab.setValue("PaymentRule", (Object)new_paymentRule);
            }
            if (this.new_c_paymentTerm_id != this.c_paymentTerm_id) {
                this.gridTab.setValue("C_PaymentTerm_ID", (Object)this.new_c_paymentTerm_id);
            }
            return true;
        }
        BigDecimal payAmount = this.new_paymentAmount;
        if (this.new_dateAcct == null) {
            this.new_dateAcct = this.dateAcct;
        }
        if (this.isInvoice && (invoice = this.invoices.get(0)).isCreditMemo()) {
            payAmount = payAmount.negate();
        }
        log.config("C_Order_ID=" + this.c_order_id + ", C_Invoice_ID=" + this.c_invoice_id + ", Amt=" + payAmount);
        log.fine("Creating new Payment - " + new_paymentRule);
        this.payment = new MPayment(Env.getCtx(), 0, trxName);
        this.payment.setC_BPartner_ID(this.c_bpartner_id);
        this.payment.setC_Invoice_ID(this.c_invoice_id);
        this.payment.setC_Order_ID(this.c_order_id);
        this.payment.setDateTrx(this.new_dateAcct);
        this.payment.setDateAcct(this.new_dateAcct);
        this.payment.setAmount(this.c_currency_id, payAmount);
        if (new_paymentRule.equals("K")) {
            this.payment.setCreditCard("S", this.new_ccType, this.new_ccNumber, "", this.new_ccExpDate);
            this.payment.setA_Name(this.new_ccName);
        } else if (new_paymentRule.equals("T") || new_paymentRule.equals("D")) {
            MBankAccount bpBankAccount = new MBankAccount(Env.getCtx(), this.new_c_bp_bankAccount_id, null);
            this.payment.setBankACH(this.new_c_bp_bankAccount_id, this.isSOTrx, new_paymentRule, bpBankAccount.getBank().getRoutingNo(), bpBankAccount.getAccountNo());
        } else if (new_paymentRule.equals("S")) {
            this.payment.setBankCheck(this.new_c_bankAccount_id, this.isSOTrx, this.new_checkRoutingNumber, this.new_checkAccountNumber, this.new_checkNumber);
        } else if (new_paymentRule.equals("B")) {
            this.payment.setBankCash(this.new_cashBook_id, this.isSOTrx, "X");
        }
        if (!this.payment.save()) {
            log.warning("Unable to save draft payment! Payment deleted.");
            this.errorMsg = MSG_PaymentNotCreated;
            this.errorInfo = this.payment.getErrorMessage();
            this.payment.deleteEx(true);
            this.payment = null;
            return false;
        }
        boolean approved = false;
        if (this.processOnline) {
            log.config("Processing payment on-line");
            approved = this.payment.processOnline();
            this.onlineInfo = this.payment.getR_RespMsg() + " (" + this.payment.getR_AuthCode() + ") ID=" + this.payment.getR_PnRef();
            this.processOnline = false;
            if (!approved) {
                log.warning("Unable to save process payment online! Payment (deleted): " + this.payment.toString());
                this.errorMsg = MSG_PaymentNotProcessed;
                this.errorInfo = this.payment.getErrorMessage();
                this.payment.delete(true);
                this.payment = null;
                return false;
            }
        }
        if (!(ok = this.payment.processIt("CO"))) {
            if (approved) {
                this.errorMsg = MSG_PaymentNotCompletedAfterProcessApproval;
                this.payment.saveEx();
                log.severe("Payment approved online but not completed! Payment exists: " + this.payment.toString());
            } else {
                log.warning("Unable to complete payment! Payment (deleted): " + this.payment.toString());
                this.errorMsg = MSG_PaymentNotCreated;
                this.errorInfo = this.payment.getErrorMessage();
                this.payment.delete(true);
                this.payment = null;
            }
            return false;
        }
        this.payment.saveEx();
        this.paymentDocNumber = this.payment.getDocumentNo();
        log.config("Payment completed: " + this.payment.toString());
        this.gridTab.setValue("C_Payment_ID", (Object)new Integer(this.payment.getC_Payment_ID()));
        return this.errorMsg.isEmpty();
    }

    public String getPaymentDocNumber() {
        return this.paymentDocNumber;
    }

    public boolean checkMandatory() {
        log.config("");
        if (this.onlyChangePaymentRule) {
            return true;
        }
        this.getValues();
        boolean dataOK = true;
        this.editor.setMandatory("bAmountField", true);
        this.editor.setMandatory("kAmountField", true);
        this.editor.setMandatory("sAmountField", true);
        this.editor.setMandatory("tAmountField", true);
        if (this.new_paymentAmount.equals(Env.ZERO)) {
            this.editor.setError("bAmountField", true);
            this.editor.setError("kAmountField", true);
            this.editor.setError("sAmountField", true);
            this.editor.setError("tAmountField", true);
            this.errorMsg = MSG_ZeroPaymentAmount;
            dataOK = false;
        }
        if (this.new_paymentRule.equals("B")) {
            this.editor.setMandatory("bCashBookCombo", true);
            if (this.new_cashBook_id == 0) {
                this.editor.setError("bCashBookCombo", true);
                this.errorMsg = Msg_NoCashJournalSelected;
                dataOK = false;
            } else {
                this.editor.setError("bCashBookCombo", false);
            }
        } else if (this.new_paymentRule.equals("K")) {
            this.editor.setMandatory("kTypeCombo", true);
            if (this.new_ccType.isEmpty()) {
                this.errorMsg = MSG_NoCreditCardTypeSelected;
                this.editor.setError("kTypeCombo", true);
                dataOK = false;
            }
        } else if (this.new_paymentRule.equals("T") || this.new_paymentRule.equals("D")) {
            this.editor.setMandatory("tAccountCombo", true);
            if (this.new_c_bp_bankAccount_id == 0) {
                this.errorMsg = MSG_NoBPBankAccountSelected;
                this.editor.setError("tAccountCombo", true);
                dataOK = false;
            }
        } else if (this.new_paymentRule.equals("P")) {
            this.editor.setMandatory("pTermCombo", true);
        } else if (this.new_paymentRule.equals("S")) {
            this.editor.setMandatory("sBankAccountCombo", true);
            this.editor.setMandatory("sRoutingField", true);
            this.editor.setMandatory("sAccountNumberField", true);
            this.editor.setMandatory("sCheckNumberField", true);
            if (this.new_c_bankAccount_id == 0) {
                this.editor.setError("sBankAccountCombo", true);
                this.errorMsg = "PaymentNoProcessor";
                dataOK = false;
            }
            this.errorMsg = MPaymentValidate.validateRoutingNo(this.new_checkRoutingNumber);
            if (!this.errorMsg.isEmpty()) {
                this.editor.setError("sRoutingField", true);
                dataOK = false;
            }
            this.errorMsg = MPaymentValidate.validateAccountNo(this.new_checkAccountNumber);
            if (!this.errorMsg.isEmpty()) {
                this.editor.setError("sAccountNumberField", true);
                dataOK = false;
            }
            this.errorMsg = MPaymentValidate.validateCheckNo(this.new_checkNumber);
            if (!this.errorMsg.isEmpty()) {
                this.editor.setError("sCheckNumberField", true);
                dataOK = false;
            }
        } else {
            log.log(Level.SEVERE, "Unknown PaymentRule " + this.new_paymentRule);
            this.errorMsg = "Unknown PaymentRule " + this.new_paymentRule;
            return false;
        }
        log.config("OK=" + dataOK);
        return dataOK;
    }

    public boolean processOnline() {
        this.processOnline = true;
        return this.saveChanges();
    }

    public String getOnlineInfo() {
        return this.onlineInfo;
    }

    private void getValues() {
        this.new_dateAcct = this.dateAcct;
        this.new_c_paymentTerm_id = this.c_paymentTerm_id;
        this.new_cashBook_id = this.cashBook_id;
        this.new_ccType = this.ccType;
        this.new_ccName = "";
        this.new_ccNumber = "";
        this.new_ccExpDate = "";
        this.new_c_bankAccount_id = 0;
        this.new_c_bp_bankAccount_id = 0;
        this.new_paymentAmount = Env.ZERO;
        this.new_checkRoutingNumber = "";
        this.new_checkAccountNumber = "";
        this.new_checkNumber = "";
        this.new_dateAcct = this.editor.getDateAcct(this.new_paymentRule);
        this.new_paymentRule = this.editor.getPaymentRule();
        this.new_c_bankAccount_id = this.editor.getBankAccount(this.new_paymentRule);
        this.new_cashBook_id = this.editor.getCashBook(this.new_paymentRule);
        this.new_dateAcct = this.editor.getDateAcct(this.new_paymentRule);
        this.new_paymentAmount = this.editor.getPaymentAmount(this.new_paymentRule);
        this.new_ccType = this.editor.getCreditCardType(this.new_paymentRule);
        this.new_ccName = this.editor.getCreditCardName(this.new_paymentRule);
        this.new_ccNumber = this.editor.getCreditCardNumber(this.new_paymentRule);
        this.new_ccExpDate = this.editor.getCreditCardExpiry(this.new_paymentRule);
        this.new_c_bp_bankAccount_id = this.editor.getBPBankAccount(this.new_paymentRule);
        this.new_c_paymentTerm_id = this.editor.getPaymentTerm(this.new_paymentRule);
        this.new_checkAccountNumber = this.editor.getCheckAccountNumber(this.new_paymentRule);
        this.new_checkRoutingNumber = this.editor.getCheckRoutingNumber(this.new_paymentRule);
        this.new_checkNumber = this.editor.getCheckNumber(this.new_paymentRule);
    }

    public Timestamp getDate() {
        return new Timestamp(System.currentTimeMillis());
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public boolean isOnlyChangePaymentRule() {
        return this.onlyChangePaymentRule;
    }
}

