/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.adempiere.controller.SmallViewEditable;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.ValueChangeEvent;
import org.adempiere.exceptions.ValueChangeListener;
import org.adempiere.model.MBrowseField;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MLookup;
import org.compiere.model.MProcessPara;
import org.compiere.model.M_Element;
import org.compiere.swing.CEditor;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public abstract class SmallViewController
implements SmallViewEditable,
VetoableChangeListener,
PropertyChangeListener,
ValueChangeListener {
    private ArrayList<GridField> fields = new ArrayList();
    private ArrayList<GridField> fieldsTo = new ArrayList();
    private HashMap<String, Boolean> fieldsInfoOnly = new HashMap();
    private ArrayList<CEditor> editors = new ArrayList();
    private ArrayList<CEditor> editorsTo = new ArrayList();
    private LinkedHashMap<String, Object> m_search;
    protected boolean m_IsLoaded = false;
    private boolean m_IsSwing = true;
    private boolean m_HasParameters = false;
    private CLogger log = CLogger.getCLogger(this.getClass());
    public static final int MAXDISPLAY_LENGTH = 30;

    public SmallViewController() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (!ste.getClassName().contains("webui") && !ste.getClassName().contains("zk.ui")) continue;
            this.m_IsSwing = false;
            break;
        }
    }

    @Override
    public abstract boolean loadData();

    @Override
    public abstract CEditor createEditor(GridField var1);

    @Override
    public abstract void setComponentVisibility(int var1, Boolean var2, Boolean var3);

    public Boolean init() {
        this.m_IsLoaded = false;
        if (this.loadData()) {
            this.m_search = new LinkedHashMap();
            this.setHasParameters(true);
            this.createEditors();
            this.initComponents();
            for (int i = 0; i < this.editors.size(); ++i) {
                this.formatEditor(this.editors.get(i), this.editorsTo.get(i));
            }
            this.dynamicDisplay();
            this.setLoaded(true);
            return this.hasParameters();
        }
        this.initComponents();
        this.dispose();
        return false;
    }

    private void createEditors() {
        for (int i = 0; i < this.fields.size(); ++i) {
            GridField field = this.fields.get(i);
            GridField field_To = this.fieldsTo.get(i);
            this.createEditors(field, field_To);
        }
    }

    private void createEditors(GridField field, GridField fieldTo) {
        if (field == null) {
            this.editors.add(null);
            return;
        }
        field.lookupLoadComplete();
        CEditor editor = this.createEditor(field);
        if (editor == null) {
            this.editors.add(null);
            return;
        }
        this.editors.add(editor);
        this.setParameter(field.getColumnNameAlias(), editor);
        Object defaultObject = field.getDefault();
        field.setValue(defaultObject, false);
        field.validateValue();
        editor.setValue(field.getValue());
        if (this.m_IsSwing) {
            editor.addVetoableChangeListener(this);
        } else {
            editor.addValueChangeListener(this);
        }
        field.addPropertyChangeListener(editor);
        field.addPropertyChangeListener(this);
        if (fieldTo == null) {
            this.editorsTo.add(null);
            return;
        }
        fieldTo.lookupLoadComplete();
        CEditor editorTo = this.createEditor(fieldTo);
        if (editorTo == null) {
            this.editorsTo.add(null);
            return;
        }
        this.editorsTo.add(editorTo);
        this.setParameter(fieldTo.getColumnNameAlias(), editorTo);
        Object defaultObject2 = fieldTo.getDefault();
        fieldTo.setValue(defaultObject2, false);
        fieldTo.validateValue();
        editorTo.setValue(fieldTo.getValue());
        if (this.m_IsSwing) {
            editorTo.addVetoableChangeListener(this);
        } else {
            editorTo.addValueChangeListener(this);
        }
        fieldTo.addPropertyChangeListener(editorTo);
        fieldTo.addPropertyChangeListener(this);
    }

    public boolean hasParameters() {
        return this.m_HasParameters;
    }

    public void setHasParameters(boolean hasParameters) {
        this.m_HasParameters = hasParameters;
    }

    public int getFieldSize() {
        return this.fields.size();
    }

    public GridField getField(int index) {
        return this.fields.get(index);
    }

    public GridField getFieldTo(int index) {
        return this.fieldsTo.get(index);
    }

    public CEditor getEditor(int index) {
        return this.editors.get(index);
    }

    public CEditor getEditorTo(int index) {
        return this.editorsTo.get(index);
    }

    protected void createField(MBrowseField field, int windowNo) {
        GridFieldVO voBase = this.createVO(field, false, windowNo);
        GridField gField = new GridField(voBase);
        this.fields.add(gField);
        this.fieldsInfoOnly.put(gField.getColumnNameAlias(), field.isInfoOnly());
        if (voBase.IsRange) {
            GridFieldVO voBase_To = this.createVO(field, true, windowNo);
            GridField gField_To = new GridField(voBase_To);
            this.fieldsTo.add(gField_To);
        } else {
            this.fieldsTo.add(null);
        }
    }

    protected void createField(MProcessPara processParameter, int windowNo) {
        GridFieldVO voF = GridFieldVO.createParameter(Env.getCtx(), windowNo, processParameter);
        GridField field = new GridField(voF);
        GridField fieldTo = null;
        this.fields.add(field);
        if (voF.IsRange) {
            GridFieldVO voF2 = GridFieldVO.createParameter(voF);
            voF2.DefaultValue = voF2.DefaultValue2;
            voF2.ColumnName = voF2.ColumnName + "_To";
            fieldTo = new GridField(voF2);
            this.fieldsTo.add(fieldTo);
        } else {
            this.fieldsTo.add(null);
        }
    }

    private GridFieldVO createVO(MBrowseField field, boolean isTo, int windowNo) {
        GridFieldVO voBase = GridFieldVO.createStdField(field.getCtx(), windowNo, 0, 0, 0, false, false, false);
        String uniqueName = field.getAD_View_Column().getColumnName() + (isTo ? "_To" : "");
        voBase.isProcess = true;
        voBase.IsDisplayed = true;
        voBase.IsReadOnly = false;
        voBase.IsUpdateable = true;
        voBase.WindowNo = windowNo;
        M_Element element = (M_Element)field.getAD_Element();
        voBase.ColumnName = element.getColumnName();
        voBase.ColumnSQL = field.getAD_View_Column().getColumnSQL();
        if (field.getAD_View_Column().getAD_Column_ID() > 0) {
            voBase.AD_Column_ID = field.getAD_View_Column().getAD_Column_ID();
            voBase.AD_Table_ID = field.getAD_View_Column().getAD_Column().getAD_Table_ID();
        }
        voBase.ColumnNameAlias = uniqueName;
        voBase.displayType = field.getAD_Reference_ID();
        voBase.AD_Reference_Value_ID = field.getAD_Reference_Value_ID();
        voBase.IsMandatory = field.isMandatory();
        voBase.IsAlwaysUpdateable = true;
        voBase.IsKey = field.isKey();
        voBase.DefaultValue = isTo ? field.getDefaultValue2() : field.getDefaultValue();
        voBase.DefaultValue2 = field.getDefaultValue2();
        voBase.InfoFactoryClass = field.getInfoFactoryClass();
        if (field.getFieldLength() == 0) {
            field.setFieldLength(30);
        }
        voBase.FieldLength = field.getFieldLength();
        voBase.DisplayLength = field.getFieldLength();
        voBase.ReadOnlyLogic = field.getReadOnlyLogic();
        voBase.DisplayLogic = field.getDisplayLogic();
        voBase.VFormat = field.getVFormat();
        voBase.ValueMin = field.getValueMin();
        voBase.ValueMax = field.getValueMax();
        voBase.ValidationCode = field.getAD_Val_Rule().getCode();
        voBase.IsRange = field.isRange();
        voBase.Description = field.getDescription();
        voBase.Help = field.getHelp();
        voBase.Header = isTo ? Msg.getMsg(Env.getCtx(), "To") : field.getName();
        voBase.IsColumnSQLReference = true;
        voBase.FieldLength = field.getFieldLength();
        voBase.DisplayLength = field.getFieldLength();
        voBase.initFinish();
        return voBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.log.fine(evt.getPropertyName() + "=" + evt.getNewValue() + " (" + evt.getOldValue() + ") " + (evt.getOldValue() == null ? "" : evt.getOldValue().getClass().getName()));
        GridField changedField = null;
        if (!(evt.getSource() instanceof CEditor)) return;
        changedField = ((CEditor)evt.getSource()).getField();
        if ((evt.getNewValue() == null || evt.getNewValue().toString().isEmpty()) && evt.getOldValue() != null && evt.getOldValue().toString().length() > 0) {
            if (changedField.getVO().IsMandatory) throw new PropertyVetoException("FillMandatory", evt);
            changedField.setValue(null, false);
            return;
        } else {
            if (evt.getNewValue() == null || evt.getNewValue().equals(evt.getOldValue())) return;
            changedField.setValue(evt.getNewValue(), false);
        }
    }

    protected void dynamicDisplay() {
        for (int index = 0; index < this.fields.size(); ++index) {
            boolean rw;
            GridField field = this.getField(index);
            if (field == null) continue;
            boolean bl = rw = !field.isReadOnly();
            if (field.isDisplayed(true)) {
                this.setComponentVisibility(index, true, field.isRange());
                rw = field.isEditablePara(true);
                this.setEditor_RW(index, rw);
                Boolean valueSet = false;
                Object value = field.getValue();
                if (value != null && value.toString().length() != 0 && this.m_IsLoaded && rw) continue;
                Object defaultValue = field.getDefault();
                if (!(defaultValue == null || field.getOldValue() != null && defaultValue.equals(field.getOldValue()) && !DisplayType.isNumeric(field.getVO().displayType) || value != null && value.equals(defaultValue))) {
                    CEditor editor;
                    field.setValue(defaultValue, false);
                    valueSet = true;
                    boolean manMissing = false;
                    boolean noValue = false;
                    boolean bl2 = noValue = field.getValue() == null || field.getValue().toString().length() == 0;
                    if (noValue && field.isEditable(true) && field.isMandatory(true)) {
                        manMissing = true;
                    }
                    if ((editor = this.getEditor(index)) != null) {
                        editor.setBackground(manMissing || field.isError());
                    }
                }
                if (field.isRange() && this.getFieldTo(index) != null) {
                    Object defaultValueTo;
                    GridField fieldTo = this.getFieldTo(index);
                    rw = fieldTo.isEditablePara(true);
                    this.setEditorTo_RW(index, rw);
                    Object valueTo = fieldTo.getValue();
                    if (!(valueTo != null && valueTo.toString().length() != 0 && this.m_IsLoaded && (rw || !DisplayType.isNumeric(fieldTo.getVO().displayType) && !DisplayType.isDate(fieldTo.getVO().displayType)) || (defaultValueTo = fieldTo.getDefault()) == null || fieldTo.getOldValue() != null && defaultValueTo.equals(fieldTo.getOldValue()) && !DisplayType.isNumeric(fieldTo.getVO().displayType) || valueTo != null && valueTo.equals(defaultValueTo))) {
                        CEditor editorTo;
                        fieldTo.setValue(defaultValueTo, false);
                        valueSet = true;
                        boolean manMissing = false;
                        boolean noValue = false;
                        boolean bl3 = noValue = fieldTo.getValue() == null || fieldTo.getValue().toString().length() == 0;
                        if (noValue && fieldTo.isEditable(true) && fieldTo.isMandatory(true)) {
                            manMissing = true;
                        }
                        if ((editorTo = this.getEditorTo(index)) != null) {
                            editorTo.setBackground(manMissing || fieldTo.isError());
                        }
                    }
                }
                if (!valueSet.booleanValue()) continue;
                break;
            }
            this.setComponentVisibility(index, false, field.isRange());
        }
    }

    private void fieldChange(GridField field, Object newValue, String propertyName) {
        if (field != null) {
            this.processDependencies(field);
        }
        this.processNewValue(newValue, propertyName);
    }

    private void processDependencies(GridField changedField) {
        String columnName = Util.isEmpty(changedField.getColumnNameAlias()) ? changedField.getColumnName() : changedField.getColumnNameAlias();
        for (GridField field : this.fields) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
        for (GridField field : this.fieldsTo) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
    }

    private void verifyChangedField(GridField field, String columnName) {
        ArrayList<String> list = field.getDependentOn();
        if (list.contains(columnName)) {
            Object value = field.getValue();
            if (field.getLookup() instanceof MLookup) {
                MLookup mLookup = (MLookup)field.getLookup();
                if (mLookup.getValidation().indexOf("@" + columnName + "@") != -1) {
                    this.log.fine(columnName + " changed - " + field.getColumnName() + " set to null");
                    mLookup.refresh();
                }
                if (mLookup.containsKey(value)) {
                    mLookup.setSelectedItem(mLookup.get(value));
                } else {
                    field.setValue(field.getDefault(), false);
                }
            }
        }
    }

    public String validateFields() {
        this.log.config("");
        StringBuffer sb = new StringBuffer();
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            GridField fieldTo;
            GridField field = this.fields.get(i);
            if (field == null || field.isInfoOnly() || !field.isDisplayed(true)) continue;
            if (!field.validateValue()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(field.getHeader());
                CEditor editor = this.editors.get(i);
                if (editor != null) {
                    editor.setBackground(field.isError());
                }
            }
            if ((fieldTo = this.fieldsTo.get(i)) == null || fieldTo.validateValue()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fieldTo.getHeader());
            CEditor editor = this.editorsTo.get(i);
            if (editor == null) continue;
            editor.setBackground(fieldTo.isError());
        }
        if (sb.length() != 0) {
            return sb.toString();
        }
        return null;
    }

    public String validateParameters() {
        return this.validateFields();
    }

    public void dispose() {
        if (this.isLoaded()) {
            this.fields.clear();
            this.fieldsTo.clear();
            this.editors.clear();
            this.editorsTo.clear();
            this.setLoaded(false);
        }
    }

    private void setParameter(String name, Object value) {
        if (value != null && !this.isInfoOnly(name)) {
            this.m_search.put(name, value);
        }
    }

    public LinkedHashMap<String, Object> getParameters() {
        if (this.m_search == null) {
            return new LinkedHashMap<String, Object>();
        }
        return this.m_search;
    }

    public boolean isInfoOnly(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return false;
        }
        Boolean isInfoOnly = this.fieldsInfoOnly.get(columnName);
        return isInfoOnly != null && isInfoOnly != false;
    }

    private void setEditor_RW(int index, Boolean readWrite) {
        CEditor editor = this.getEditor(index);
        editor.setReadWrite(readWrite);
    }

    private void setEditorTo_RW(int index, Boolean readWrite) {
        CEditor editorTo = this.getEditorTo(index);
        editorTo.setReadWrite(readWrite);
    }

    private void processNewValue(Object value, String name) {
        this.dynamicDisplay();
    }

    protected boolean isLoaded() {
        return this.m_IsLoaded;
    }

    protected void setLoaded(boolean loaded) {
        this.m_IsLoaded = loaded;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        GridField changedField = null;
        if (!(evt.getSource() instanceof GridField)) {
            return;
        }
        changedField = (GridField)evt.getSource();
        this.fieldChange(changedField, evt.getNewValue(), evt.getPropertyName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void valueChange(ValueChangeEvent evt) {
        GridField changedField = null;
        if (evt.getSource() instanceof CEditor) {
            changedField = ((CEditor)evt.getSource()).getField();
        }
        if ((evt.getNewValue() == null || evt.getNewValue().toString().isEmpty()) && evt.getOldValue() != null && evt.getOldValue().toString().length() > 0) {
            if (changedField.getVO().IsMandatory) throw new AdempiereException("FillMandatory");
            changedField.setValue(null, false);
            return;
        } else {
            if (evt.getNewValue() == null || evt.getNewValue().equals(evt.getOldValue())) return;
            changedField.setValue(evt.getNewValue(), false);
        }
    }

    public void refreshContext() {
        this.dynamicDisplay();
    }

    public void restoreContext() {
        for (int i = 0; i < this.fields.size(); ++i) {
            GridField field = this.fields.get(i);
            GridField fieldTo = this.fieldsTo.get(i);
            if (field != null) {
                field.restoreValue();
            }
            if (fieldTo == null) continue;
            fieldTo.restoreValue();
        }
    }

    protected String getDisplay(int index) {
        CEditor editor = this.getEditor(index);
        if (editor != null) {
            return editor.getDisplay();
        }
        return null;
    }

    protected String getDisplay_To(int index) {
        CEditor editor = this.getEditorTo(index);
        if (editor != null) {
            return editor.getDisplay();
        }
        return null;
    }

    protected Object getValue(int index) {
        if (this.getField(index) != null) {
            return this.getField(index).getValue();
        }
        return null;
    }

    protected Object getValue_To(int index) {
        if (this.getFieldTo(index) != null) {
            return this.getFieldTo(index).getValue();
        }
        return null;
    }

    protected void setValue(int index, Object value) {
        if (this.getField(index) != null) {
            this.getField(index).setValue(value, false);
        }
    }

    protected void setValue_To(int index, Object value) {
        if (this.getFieldTo(index) != null) {
            this.getFieldTo(index).setValue(value, false);
        }
    }
}

