/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostDimension;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MPPCostCollector;

public class AveragePOCostingMethod
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        if (model instanceof MMatchInv) {
            if (this.costDetail != null && this.costDetail.get_ID() > 0) {
                this.costDetail.setC_InvoiceLine_ID(((MMatchInv)model).getC_InvoiceLine_ID());
                this.costDetail.saveEx();
            }
            return;
        }
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = model;
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
        MDocType documentType = new MDocType(transaction.getCtx(), transaction.getDocumentLine().getC_DocType_ID(), transaction.get_TrxName());
        this.isOpenPeriod = MPeriod.isOpen(transaction.getCtx(), model.getDateAcct(), documentType.getDocBaseType(), transaction.getAD_Org_ID());
        this.dateAccounting = this.isOpenPeriod != false ? model.getDateAcct() : null;
        this.movementQuantity = transaction.getMovementQty();
    }

    public void calculate() {
        this.lastCostDetail = MCostDetail.getLastTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.dateAccounting, this.costingLevel);
        if (this.model.getReversalLine_ID() > 0 && this.costDetail == null) {
            return;
        }
        if (this.costDetail != null && this.costDetail.isReversal() && this.model.getReversalLine_ID() > 0) {
            this.setReversalCostDetail();
            return;
        }
        if (this.lastCostDetail == null) {
            this.lastCostDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), Env.ZERO, Env.ZERO, Env.ZERO, this.transaction.get_TrxName());
            this.lastCostDetail.setDateAcct(this.dateAccounting);
        }
        BigDecimal quantityOnHand = this.getNewAccumulatedQuantity(this.lastCostDetail);
        if (this.transaction.getM_Transaction_ID() == this.lastCostDetail.getM_Transaction_ID()) {
            this.movementQuantity = Env.ZERO;
            BigDecimal provisionOfPurchaseCost = BigDecimal.ZERO;
            BigDecimal provisionOfPurchaseCostLL = BigDecimal.ZERO;
            this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail).add(this.movementQuantity);
            if (this.model instanceof MMatchPO) {
                provisionOfPurchaseCost = this.lastCostDetail.getCostAmt();
                provisionOfPurchaseCostLL = this.lastCostDetail.getCostAmtLL();
                MMatchPO iMatch = (MMatchPO)this.model;
                this.lastCostDetail.setC_InvoiceLine_ID(iMatch.getC_InvoiceLine_ID());
                this.lastCostDetail.saveEx();
                if (this.lastCostDetail != null && this.lastCostDetail.getM_CostDetail_ID() > 0) {
                    this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail);
                }
            }
            this.adjustCost = this.model.getMovementQty().multiply(this.costThisLevel).subtract(provisionOfPurchaseCost);
            this.adjustCostLowerLevel = this.model.getMovementQty().multiply(this.costLowLevel).subtract(provisionOfPurchaseCostLL);
            this.accumulatedAmount = this.getNewAccumulatedAmount(this.lastCostDetail);
            this.accumulatedAmount = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmount.add(this.adjustCost) : this.accumulatedAmount.add(this.adjustCost.negate());
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail);
            this.accumulatedAmountLowerLevel = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmountLowerLevel.add(this.adjustCostLowerLevel) : this.accumulatedAmountLowerLevel.add(this.adjustCostLowerLevel.negate());
            this.currentCostPrice = this.accumulatedAmount.divide(this.accumulatedQuantity.signum() != 0 ? this.accumulatedQuantity : BigDecimal.ONE, this.accountSchema.getCostingPrecision(), 4);
            this.currentCostPriceLowerLevel = this.accumulatedAmountLowerLevel.divide(this.accumulatedQuantity.signum() != 0 ? this.accumulatedQuantity : BigDecimal.ONE, this.accountSchema.getCostingPrecision(), 4);
            if (this.adjustCost.add(this.adjustCostLowerLevel).signum() == 0) {
                return;
            }
            if (this.costDetail == null) {
                return;
            }
            this.costDetail.setCostAdjustment(this.adjustCost);
            this.costDetail.setAmt(this.costDetail.getCostAmt().add(this.costDetail.getCostAdjustment()));
            this.costDetail.setCostAdjustmentLL(this.adjustCostLowerLevel);
            this.costDetail.setAmtLL(this.costDetail.getCostAmtLL().add(this.costDetail.getCostAdjustmentLL()));
            this.updateAmountCost();
            return;
        }
        if (this.transaction.getMovementType().endsWith("+")) {
            if (quantityOnHand.signum() != 0 && this.getNewAccumulatedAmount(this.lastCostDetail).signum() == 0 && this.costThisLevel.signum() != 0) {
                this.adjustCost = quantityOnHand.add(this.movementQuantity).multiply(this.costThisLevel).subtract(this.costThisLevel.multiply(this.movementQuantity));
            } else if (quantityOnHand.add(this.movementQuantity).signum() < 0 && this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4).signum() != 0 && this.costThisLevel.signum() == 0) {
                this.currentCostPrice = this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4);
                this.adjustCost = this.currentCostPrice.multiply(this.movementQuantity).abs();
            }
            if (this.model instanceof MLandedCostAllocation || this.model instanceof MMatchPO) {
                if (!this.isOpenPeriod.booleanValue()) {
                    int attributeSetInstanceId = 0;
                    if (this.model instanceof MLandedCostAllocation) {
                        MLandedCostAllocation costAllocation = (MLandedCostAllocation)this.model;
                        attributeSetInstanceId = costAllocation.getM_AttributeSetInstance_ID();
                    }
                    if (this.model instanceof MMatchPO) {
                        MMatchPO matchPO = (MMatchPO)this.model;
                        attributeSetInstanceId = matchPO.getM_AttributeSetInstance_ID();
                    }
                    this.movementQuantity = MCostDetail.getQtyOnHandByASIAndSeqNo(this.transaction.getCtx(), this.transaction.getM_Product_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), attributeSetInstanceId, this.lastCostDetail.getSeqNo(), this.transaction.get_TrxName());
                    this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail);
                    this.currentCostPrice = this.movementQuantity.multiply(this.costThisLevel);
                    this.currentCostPriceLowerLevel = this.movementQuantity.multiply(this.costLowLevel);
                    this.adjustCost = this.currentCostPrice;
                    this.adjustCostLowerLevel = this.currentCostPriceLowerLevel;
                }
            } else {
                this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail).add(this.movementQuantity);
                this.currentCostPrice = this.costThisLevel;
                this.currentCostPriceLowerLevel = this.costLowLevel;
            }
            this.amount = this.movementQuantity.multiply(this.costThisLevel);
            this.amountLowerLevel = this.movementQuantity.multiply(this.costLowLevel);
            this.accumulatedAmount = this.getNewAccumulatedAmount(this.lastCostDetail);
            this.accumulatedAmount = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmount.add(this.amount) : this.accumulatedAmount.add(this.amount.negate());
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail);
            this.accumulatedAmountLowerLevel = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmountLowerLevel.add(this.amountLowerLevel) : this.accumulatedAmountLowerLevel.add(this.amountLowerLevel.negate());
        } else if (this.transaction.getMovementType().endsWith("-")) {
            if (quantityOnHand.add(this.movementQuantity).signum() >= 0) {
                this.currentCostPrice = this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4);
                this.currentCostPriceLowerLevel = this.getNewCurrentCostPriceLowerLevel(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4);
            } else {
                this.currentCostPrice = CostEngine.getCostThisLevel(this.accountSchema, this.dimension.getM_CostType(), this.dimension.getM_CostElement(), this.transaction, this.model, this.costingLevel);
            }
            this.amount = this.transaction.getMovementQty().multiply(this.currentCostPrice);
            this.amountLowerLevel = this.movementQuantity.multiply(this.currentCostPriceLowerLevel);
            this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail).add(this.movementQuantity);
            this.accumulatedAmount = this.getNewAccumulatedAmount(this.lastCostDetail);
            this.accumulatedAmount = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmount.add(this.amount) : this.accumulatedAmount.add(this.amount.negate());
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail);
            BigDecimal bigDecimal = this.accumulatedAmountLowerLevel = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmountLowerLevel.add(this.amountLowerLevel) : this.accumulatedAmountLowerLevel.add(this.amountLowerLevel.negate());
            if (this.costDetail != null) {
                this.costDetail.setAmt(this.currentCostPrice.multiply(this.movementQuantity.abs()));
                this.costDetail.setAmtLL(this.currentCostPriceLowerLevel.multiply(this.movementQuantity).abs());
            }
        }
        if (this.costDetail == null) {
            return;
        }
        this.updateAmountCost();
    }

    private void createCostDetail() {
        if (this.model.getReversalLine_ID() > 0 && this.costDetail == null) {
            this.createReversalCostDetail();
            return;
        }
        if (this.model.getReversalLine_ID() > 0) {
            return;
        }
        int seqNo = this.lastCostDetail.getSeqNo() + 10;
        if (this.transaction.getM_Transaction_ID() != this.lastCostDetail.getM_Transaction_ID() && this.costDetail == null || this.adjustCost.add(this.adjustCostLowerLevel).signum() != 0 && this.costDetail == null) {
            if (this.adjustCost.add(this.adjustCostLowerLevel).signum() != 0 && this.costDetail != null || this.model instanceof MLandedCostAllocation || this.model instanceof MMatchPO) {
                this.movementQuantity = Env.ZERO;
            }
            this.costDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.currentCostPrice.multiply(this.movementQuantity).abs(), this.currentCostPriceLowerLevel.multiply(this.movementQuantity).abs(), this.movementQuantity, this.transaction.get_TrxName());
            this.costDetail.setDateAcct(this.dateAccounting);
            this.costDetail.setSeqNo(seqNo);
            if (this.transaction != null) {
                this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
            }
            if (this.isSalesTransaction != null && this.isSalesTransaction.booleanValue()) {
                this.costDetail.setIsSOTrx(this.isSalesTransaction);
            } else if (this.isSalesTransaction != null && !this.isSalesTransaction.booleanValue()) {
                this.costDetail.setIsSOTrx(this.model.isSOTrx());
            }
            if (this.adjustCost.signum() != 0 || this.adjustCostLowerLevel.signum() != 0) {
                String description;
                String string = description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
                if (this.adjustCost.signum() != 0) {
                    this.costDetail.setCostAdjustmentDate(this.model.getDateAcct());
                    this.costDetail.setCostAdjustment(this.adjustCost);
                    this.costDetail.setCostAmt(BigDecimal.ZERO);
                    this.costDetail.setAmt(this.costDetail.getAmt().add(this.costDetail.getCostAdjustment()));
                    this.costDetail.setDescription(description + Msg.parseTranslation(Env.getCtx(), "@CostAdjustment@ ") + this.adjustCost);
                }
                if (this.adjustCostLowerLevel.signum() != 0) {
                    description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
                    this.costDetail.setCostAdjustmentDateLL(this.model.getDateAcct());
                    this.costDetail.setCostAdjustmentLL(this.adjustCostLowerLevel);
                    this.costDetail.setCostAmtLL(BigDecimal.ZERO);
                    this.costDetail.setAmtLL(this.costDetail.getCostAmtLL().add(this.costDetail.getCostAdjustmentLL()));
                    this.costDetail.setDescription(description + Msg.parseTranslation(Env.getCtx(), "@CostAdjustmentLL@ ") + this.adjustCost);
                }
            }
            this.updateAmountCost();
            return;
        }
    }

    @Override
    public MCostDetail process() {
        this.calculate();
        this.createCostDetail();
        this.updateInventoryValue();
        this.createCostAdjustment();
        return this.costDetail;
    }

    public void createCostAdjustment() {
        if (!this.accountSchema.isAdjustCOGS()) {
            return;
        }
        if (this.costDetail == null || this.costDetail.isProcessing()) {
            return;
        }
        List<MCostDetail> costDetails = MCostDetail.getAfterDate(this.costDetail, this.costingLevel);
        if (costDetails == null || costDetails.size() == 0) {
            return;
        }
        MCostDetail lastCostDetail = this.costDetail;
        this.costDetail = null;
        for (MCostDetail cost : costDetails) {
            cost.setSeqNo(lastCostDetail.getSeqNo() + 10);
            cost.setProcessing(true);
            cost.saveEx();
            lastCostDetail = cost;
        }
        int costDetailAdjustmentNo = 0;
        for (MCostDetail cost : costDetails) {
            ++costDetailAdjustmentNo;
            this.adjustCostDetail(cost);
            cost.setProcessing(false);
            cost.saveEx();
        }
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmount(cost).signum() != 0) {
            return this.getNewAccumulatedAmount(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cost) {
        BigDecimal accumulatedAmount = Env.ZERO;
        if (cost.getQty().signum() > 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
            }
        }
        return accumulatedAmount;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cost) {
        BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
        if (cost.getQty().signum() >= 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
            }
        }
        return accumulatedAmountLowerLevel;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmountLowerLevel(cost).signum() != 0) {
            return this.getNewAccumulatedAmountLowerLevel(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cost) {
        return cost.getCumulatedQty().add(cost.getQty());
    }

    @Override
    public void updateAmountCost() {
        if (this.movementQuantity.signum() > 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().subtract(this.costDetail.getCostAdjustment()));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().subtract(this.costDetail.getCostAdjustmentLL()));
        } else if (this.movementQuantity.signum() < 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().add(this.adjustCost));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().add(this.adjustCostLowerLevel));
        }
        this.costDetail.setCumulatedQty(this.getNewAccumulatedQuantity(this.lastCostDetail));
        this.costDetail.setCumulatedAmt(this.getNewAccumulatedAmount(this.lastCostDetail));
        this.costDetail.setCumulatedAmtLL(this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail));
        this.costDetail.setCurrentCostPrice(this.currentCostPrice);
        this.costDetail.setCurrentCostPriceLL(this.currentCostPriceLowerLevel);
        String idColumnName = CostEngine.getIDColumnName(this.model);
        this.costDetail.set_ValueOfColumn(idColumnName, (Object)CostEngine.getIDColumn(this.model));
        if (this.model instanceof MInOutLine) {
            MInOutLine ioLine = (MInOutLine)this.model;
            this.costDetail.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
            this.costDetail.setC_InvoiceLine_ID(0);
        }
        if (this.model instanceof MMatchPO && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchPO poMatch = (MMatchPO)this.model;
            this.costDetail.setM_InOutLine_ID(poMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MLandedCostAllocation) {
            MLandedCostAllocation allocation = (MLandedCostAllocation)this.model;
            this.costDetail.setM_InOutLine_ID(allocation.getM_InOutLine_ID());
            this.costDetail.setC_InvoiceLine_ID(allocation.getC_InvoiceLine_ID());
            this.costDetail.setC_LandedCostAllocation_ID(allocation.getC_LandedCostAllocation_ID());
            this.costDetail.setProcessed(false);
        }
        this.costDetail.saveEx();
    }

    @Override
    public void updateInventoryValue() {
        if (this.accumulatedQuantity.signum() != 0) {
            this.dimension.setCurrentCostPrice(this.accumulatedAmount.divide(this.accumulatedQuantity, this.accountSchema.getCostingPrecision(), 4));
            this.dimension.setCurrentCostPriceLL(this.accumulatedAmountLowerLevel.divide(this.accumulatedQuantity, this.accountSchema.getCostingPrecision(), 4));
        }
        this.dimension.setCumulatedAmt(this.accumulatedAmount);
        this.dimension.setCumulatedAmtLL(this.accumulatedAmountLowerLevel);
        this.dimension.setCumulatedQty(this.accumulatedQuantity);
        this.dimension.setCurrentQty(this.accumulatedQuantity);
        this.dimension.saveEx();
    }

    @Override
    public void adjustCostDetail(MCostDetail cost) {
        Properties ctx = cost.getCtx();
        String trxName = cost.get_TrxName();
        int transactionId = cost.getM_Transaction_ID();
        int clientId = cost.getAD_Client_ID();
        MTransaction transaction = new MTransaction(ctx, transactionId, trxName);
        MCostType costType = (MCostType)cost.getM_CostType();
        MCostElement costElement = (MCostElement)cost.getM_CostElement();
        MAcctSchema accountSchema = (MAcctSchema)cost.getC_AcctSchema();
        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).clearAccounting(accountSchema, transaction);
        if ("V+".equals(transaction.getMovementType())) {
            MInOutLine line = (MInOutLine)transaction.getDocumentLine();
            if ("M".equals(costElement.getCostElementType())) {
                if (cost.getM_InOutLine_ID() > 0 && cost.getQty().signum() != 0) {
                    CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, line, true);
                } else if (cost.getM_InOutLine_ID() > 0 && cost.getQty().signum() != 0 && cost.getC_OrderLine_ID() > 0) {
                    List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
                    for (MMatchPO match : orderMatches) {
                        if (match.getM_InOutLine_ID() != line.getM_InOutLine_ID() || match.getM_Product_ID() != transaction.getM_Product_ID()) continue;
                        CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, match, true);
                    }
                } else if (cost.getM_InOutLine_ID() > 0 && cost.getQty().signum() == 0 && cost.getC_OrderLine_ID() > 0 && cost.getC_LandedCostAllocation_ID() == 0) {
                    List<MMatchPO> poMatches = MMatchPO.getInOutLine(line);
                    for (MMatchPO match : poMatches) {
                        if (match.getM_Product_ID() != transaction.getM_Product_ID()) continue;
                        CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, match, true);
                    }
                }
            }
            if (cost.getC_LandedCostAllocation_ID() != 0) {
                MLandedCostAllocation allocation = (MLandedCostAllocation)cost.getC_LandedCostAllocation();
                CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, allocation, true);
            }
        } else {
            CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, transaction.getDocumentLine(), true);
        }
    }

    public void createUpdateAverageCostDetail(MPPCostCollector costCollectorVariance, BigDecimal costVarianceThisLevel, BigDecimal costVarianceLowLevel, MProduct product, MAcctSchema acctSchema, MCostType costType, MCostElement costElement) {
        String whereClause = " exists (select 1 from pp_cost_collector pc where pc.pp_cost_collector_ID=m_transaction.pp_Cost_collector_ID and costcollectortype =?  and pc.pp_order_ID=?)";
        MTransaction mtrx = (MTransaction)new Query(costCollectorVariance.getCtx(), "M_Transaction", whereClause, costCollectorVariance.get_TrxName()).setParameters("100", costCollectorVariance.getPP_Order_ID()).setOrderBy("M_Transaction_ID desc").first();
        BigDecimal costThisLevel = Env.ZERO;
        BigDecimal costLowLevel = Env.ZERO;
        String costingLevel = MProduct.get(mtrx.getCtx(), mtrx.getM_Product_ID()).getCostingLevel(acctSchema, mtrx.getAD_Org_ID());
        costCollectorVariance.set_ValueOfColumn("Cost", (Object)(costVarianceThisLevel.compareTo(Env.ZERO) != 0 ? costVarianceThisLevel : costVarianceLowLevel));
        costCollectorVariance.saveEx();
        MPPCostCollector model = costCollectorVariance;
        MCost cost = MCost.validateCostForCostType(acctSchema, costType, costElement, product.getM_Product_ID(), 0, 0, 0, mtrx.get_TrxName());
        ICostingMethod method = CostingMethodFactory.get().getCostingMethod(costType.getCostingMethod());
        method.setCostingMethod(acctSchema, mtrx, model, cost, costThisLevel, costLowLevel, model.isSOTrx());
        method.process();
    }

    public BigDecimal getResourceActualCostRate(MPPCostCollector costCollector, int resourceId, CostDimension costDimension, String trxName) {
        if (resourceId <= 0) {
            return Env.ZERO;
        }
        MProduct resourceProduct = MProduct.forS_Resource_ID(Env.getCtx(), resourceId, null);
        return this.getProductActualCostPrice(costCollector, resourceProduct, MAcctSchema.get(Env.getCtx(), costDimension.getC_AcctSchema_ID()), MCostElement.get(Env.getCtx(), costDimension.getM_CostElement_ID()), trxName);
    }

    public BigDecimal getProductActualCostPrice(MPPCostCollector costCollector, MProduct product, MAcctSchema acctSchema, MCostElement costElement, String trxName) {
        int attributeSetInstanceId;
        String CostingLevel = product.getCostingLevel(acctSchema);
        int orgId = 0;
        int warehouseId = 0;
        if (product.getS_Resource_ID() != 0) {
            orgId = product.getS_Resource().getAD_Org_ID();
            warehouseId = product.getS_Resource().getM_Warehouse_ID();
        } else {
            orgId = costCollector == null ? costElement.getAD_Org_ID() : costCollector.getAD_Org_ID();
            warehouseId = costCollector == null ? 0 : costCollector.getM_Warehouse_ID();
        }
        int n = attributeSetInstanceId = costCollector == null ? 0 : costCollector.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            orgId = 0;
            attributeSetInstanceId = 0;
            warehouseId = 0;
        } else if ("O".equals(CostingLevel)) {
            attributeSetInstanceId = 0;
        } else if ("B".equals(CostingLevel)) {
            orgId = 0;
        }
        CostDimension costDimension = new CostDimension(product, acctSchema, acctSchema.getM_CostType_ID(), orgId, attributeSetInstanceId, warehouseId, costElement.getM_CostElement_ID());
        MCost cost = (MCost)costDimension.toQuery(MCost.class, trxName).firstOnly();
        if (cost == null) {
            return Env.ZERO;
        }
        BigDecimal price = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
        return this.roundCost(price, acctSchema.getC_AcctSchema_ID());
    }

    protected BigDecimal roundCost(BigDecimal price, int accountSchemaId) {
        int precision = MAcctSchema.get(Env.getCtx(), accountSchemaId).getCostingPrecision();
        BigDecimal priceRounded = price;
        if (priceRounded.scale() > precision) {
            priceRounded = priceRounded.setScale(precision, RoundingMode.HALF_UP);
        }
        return priceRounded;
    }

    public BigDecimal getResourceFutureCostRate(MPPCostCollector costCollector, int resourceId, CostDimension costDimension, String trxName) {
        if (resourceId <= 0) {
            return Env.ZERO;
        }
        MProduct resourceProduct = MProduct.forS_Resource_ID(Env.getCtx(), resourceId, null);
        return this.getProductFutureCostPrice(costCollector, resourceProduct, MAcctSchema.get(Env.getCtx(), costDimension.getC_AcctSchema_ID()), MCostElement.get(Env.getCtx(), costDimension.getM_CostElement_ID()), trxName);
    }

    public BigDecimal getProductFutureCostPrice(MPPCostCollector costCollector, MProduct product, MAcctSchema acctSchema, MCostElement costElement, String trxName) {
        int attributeSetInstanceId;
        String CostingLevel = product.getCostingLevel(acctSchema);
        int orgId = 0;
        int warehouseId = 0;
        if (product.getS_Resource_ID() != 0) {
            orgId = product.getS_Resource().getAD_Org_ID();
            warehouseId = product.getS_Resource().getM_Warehouse_ID();
        } else {
            orgId = costCollector == null ? costElement.getAD_Org_ID() : costCollector.getAD_Org_ID();
            warehouseId = costCollector == null ? 0 : costCollector.getM_Warehouse_ID();
        }
        int n = attributeSetInstanceId = costCollector == null ? 0 : costCollector.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            orgId = 0;
            attributeSetInstanceId = 0;
            warehouseId = 0;
        } else if ("O".equals(CostingLevel)) {
            attributeSetInstanceId = 0;
        } else if ("B".equals(CostingLevel)) {
            orgId = 0;
        }
        CostDimension d = new CostDimension(product, acctSchema, acctSchema.getM_CostType_ID(), orgId, attributeSetInstanceId, warehouseId, costElement.getM_CostElement_ID());
        MCost cost = (MCost)d.toQuery(MCost.class, trxName).firstOnly();
        if (cost == null) {
            return Env.ZERO;
        }
        BigDecimal price = cost.getFutureCostPrice().add(cost.getFutureCostPriceLL());
        return this.roundCost(price, acctSchema.getC_AcctSchema_ID());
    }
}

