/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class DBException
extends AdempiereException {
    private static final long serialVersionUID = 4264201718343118625L;
    private String m_sql = null;
    private Object[] m_params = null;

    public DBException(Exception e) {
        super(e);
        if (CLogMgt.isLevelFinest()) {
            e.printStackTrace();
        }
    }

    public DBException(Exception e, String sql) {
        this(e, sql, (Object[])null);
    }

    public DBException(Exception e, String sql, Object[] params) {
        this(e);
        this.m_sql = sql;
        if (params != null) {
            this.m_params = Arrays.copyOf(params, params.length);
        }
    }

    public DBException(Exception e, String sql, List<Object> params) {
        this(e);
        this.m_sql = sql;
        if (params != null) {
            this.m_params = params.toArray();
        }
    }

    public DBException(String msg) {
        super(msg);
    }

    public String getSQL() {
        return this.m_sql;
    }

    public SQLException getSQLException() {
        Throwable cause = this.getCause();
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        return null;
    }

    public int getErrorCode() {
        SQLException e = this.getSQLException();
        return e != null ? e.getErrorCode() : -1;
    }

    public SQLException getNextException() {
        SQLException e = this.getSQLException();
        return e != null ? e.getNextException() : null;
    }

    public String getSQLState() {
        SQLException e = this.getSQLException();
        return e != null ? e.getSQLState() : null;
    }

    public Object[] getSQLParams() {
        return this.m_params;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        String msg = super.getMessage();
        if (!Util.isEmpty(msg)) {
            sb.append(msg);
        }
        if (!Util.isEmpty(this.m_sql)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("SQL=").append(this.m_sql);
            if (this.m_params != null) {
                sb.append(" -- ").append(Arrays.toString(this.m_params));
            }
        }
        return sb.toString();
    }

    private static final boolean isErrorCode(Exception e, int errorCode) {
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException) {
            return ((SQLException)e).getErrorCode() == errorCode;
        }
        if (e instanceof DBException) {
            SQLException sqlEx = ((DBException)e).getSQLException();
            if (sqlEx != null) {
                return sqlEx.getErrorCode() == errorCode;
            }
            return false;
        }
        return false;
    }

    private static final boolean isSQLState(Exception e, String SQLState) {
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException) {
            return ((SQLException)e).getSQLState().equals(SQLState);
        }
        if (e instanceof DBException) {
            SQLException sqlEx = ((DBException)e).getSQLException();
            if (sqlEx != null) {
                return sqlEx.getSQLState().equals(SQLState);
            }
            return false;
        }
        return false;
    }

    public static boolean isUniqueContraintError(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "23505");
        }
        return DBException.isErrorCode(e, 1);
    }

    public static boolean isChildRecordFoundError(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "23503");
        }
        return DBException.isErrorCode(e, 2292);
    }

    public static boolean isInvalidIdentifierError(Exception e) {
        return DBException.isErrorCode(e, 904);
    }

    public static boolean isInvalidUserPassError(Exception e) {
        return DBException.isErrorCode(e, 1017);
    }

    public static boolean isTimeout(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "57014");
        }
        return DBException.isErrorCode(e, 1013);
    }
}

