/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.impexp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public abstract class AbstractExcelExporter {
    protected final CLogger log = CLogger.getCLogger(this.getClass());
    private Workbook m_workbook;
    private DataFormat m_dataFormat;
    private Font m_fontHeader = null;
    private Font m_fontDefault = null;
    private Language m_lang = null;
    private int m_sheetCount = 0;
    protected boolean dataIncludeHeader = false;
    public boolean isXLSX = false;
    private int m_colSplit = 1;
    private int m_rowSplit = 1;
    private HashMap<String, CellStyle> m_styles = new HashMap();

    public abstract boolean isFunctionRow();

    public abstract int getColumnCount();

    public abstract int getRowCount();

    protected abstract void setCurrentRow(int var1);

    public abstract boolean isColumnPrinted(int var1);

    public abstract String getHeaderName(int var1);

    public abstract String getFormatPattern(int var1);

    public abstract int getDisplayType(int var1, int var2);

    public abstract Object getValueAt(int var1, int var2);

    public abstract boolean isPageBreak(int var1, int var2);

    public AbstractExcelExporter() {
        this.m_workbook = new XSSFWorkbook();
        this.m_dataFormat = this.m_workbook.createDataFormat();
    }

    protected Properties getCtx() {
        return Env.getCtx();
    }

    protected void setFreezePane(int colSplit, int rowSplit) {
        this.m_colSplit = colSplit;
        this.m_rowSplit = rowSplit;
    }

    private String fixString(String str) {
        return Util.stripDiacritics(str);
    }

    protected Language getLanguage() {
        if (this.m_lang == null) {
            this.m_lang = Env.getLanguage(this.getCtx());
        }
        return this.m_lang;
    }

    private Font getFont(boolean isHeader) {
        Font font = null;
        if (isHeader) {
            if (this.m_fontHeader == null) {
                this.m_fontHeader = this.m_workbook.createFont();
                this.m_fontHeader.setBold(true);
            }
            font = this.m_fontHeader;
        } else if (this.isFunctionRow()) {
            font = this.m_workbook.createFont();
            font.setBold(true);
            font.setItalic(true);
        } else {
            if (this.m_fontDefault == null) {
                this.m_fontDefault = this.m_workbook.createFont();
            }
            font = this.m_fontDefault;
        }
        return font;
    }

    private String getFormatString(NumberFormat df, boolean isHighlightNegativeNumbers) {
        StringBuffer format = new StringBuffer();
        int integerDigitsMin = df.getMinimumIntegerDigits();
        int integerDigitsMax = df.getMaximumIntegerDigits();
        for (int i = 0; i < integerDigitsMax; ++i) {
            if (i < integerDigitsMin) {
                format.insert(0, "0");
            } else {
                format.insert(0, "#");
            }
            if (i != 2) continue;
            format.insert(0, ",");
        }
        int fractionDigitsMin = df.getMinimumFractionDigits();
        int fractionDigitsMax = df.getMaximumFractionDigits();
        for (int i = 0; i < fractionDigitsMax; ++i) {
            if (i == 0) {
                format.append(".");
            }
            if (i < fractionDigitsMin) {
                format.append("0");
                continue;
            }
            format.append("#");
        }
        if (isHighlightNegativeNumbers) {
            String f = format.toString();
            format = new StringBuffer(f).append(";[RED]-").append(f);
        }
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("NumberFormat: " + format);
        }
        return format.toString();
    }

    private CellStyle getStyle(int row, int col) {
        int displayType = this.getDisplayType(row, col);
        String key = "cell-" + col + "-" + displayType;
        CellStyle cs = this.m_styles.get(key);
        if (cs == null) {
            boolean isHighlightNegativeNumbers = true;
            cs = this.m_workbook.createCellStyle();
            Font font = this.getFont(false);
            cs.setFont(font);
            cs.setBorderLeft(BorderStyle.THIN);
            cs.setBorderTop(BorderStyle.THIN);
            cs.setBorderRight(BorderStyle.THIN);
            cs.setBorderBottom(BorderStyle.THIN);
            String formatPattern = this.getFormatPattern(col);
            if (DisplayType.isDate(displayType)) {
                if (formatPattern != null) {
                    cs.setDataFormat(this.m_dataFormat.getFormat(formatPattern));
                } else {
                    SimpleDateFormat sdf = DisplayType.getDateFormat(15, this.getLanguage());
                    cs.setDataFormat(this.m_dataFormat.getFormat(sdf.toPattern()));
                }
            } else if (DisplayType.isNumeric(displayType)) {
                if (formatPattern != null) {
                    cs.setDataFormat(this.m_dataFormat.getFormat(formatPattern));
                } else {
                    DecimalFormat df = DisplayType.getNumberFormat(displayType, this.getLanguage());
                    String format = this.getFormatString(df, isHighlightNegativeNumbers);
                    cs.setDataFormat(this.m_dataFormat.getFormat(format));
                }
            }
            this.m_styles.put(key, cs);
        }
        return cs;
    }

    private CellStyle getHeaderStyle(int col) {
        String key = "header-" + col;
        CellStyle cs_header = this.m_styles.get(key);
        if (cs_header == null) {
            Font font_header = this.getFont(true);
            cs_header = this.m_workbook.createCellStyle();
            cs_header.setFont(font_header);
            cs_header.setBorderLeft(BorderStyle.THIN);
            cs_header.setBorderTop(BorderStyle.THIN);
            cs_header.setBorderRight(BorderStyle.THIN);
            cs_header.setBorderBottom(BorderStyle.THIN);
            cs_header.setDataFormat(this.m_workbook.createDataFormat().getFormat("text"));
            cs_header.setWrapText(true);
            this.m_styles.put(key, cs_header);
        }
        return cs_header;
    }

    private void fixColumnWidth(SXSSFSheet sheet, int lastColumnIndex) {
        for (int colnum = 0; colnum < lastColumnIndex; colnum = (int)((short)(colnum + 1))) {
            sheet.autoSizeColumn(colnum);
        }
    }

    private void closeTableSheet(SXSSFSheet prevSheet, String prevSheetName, int colCount) {
        if (prevSheet == null) {
            return;
        }
        this.fixColumnWidth(prevSheet, colCount);
        if (this.m_colSplit >= 0 || this.m_rowSplit >= 0) {
            prevSheet.createFreezePane(this.m_colSplit >= 0 ? this.m_colSplit : 0, this.m_rowSplit >= 0 ? this.m_rowSplit : 0);
        }
        if (!Util.isEmpty(prevSheetName, true) && this.m_sheetCount > 0) {
            int prevSheetIndex = this.m_sheetCount - 1;
            try {
                this.m_workbook.setSheetName(prevSheetIndex, prevSheetName);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Error setting sheet " + prevSheetIndex + " name to " + prevSheetName, e);
            }
        }
    }

    private SXSSFSheet createTableSheet() {
        SXSSFSheet sheet = (SXSSFSheet)this.m_workbook.createSheet();
        this.formatPage((Sheet)sheet);
        sheet.trackAllColumnsForAutoSizing();
        this.createHeaderFooter((Sheet)sheet);
        if (!this.dataIncludeHeader) {
            this.createTableHeader((Sheet)sheet);
        }
        ++this.m_sheetCount;
        return sheet;
    }

    private void createTableHeader(Sheet sheet) {
        int colnumMax = 0;
        Row row = sheet.createRow(0);
        int colnum = 0;
        for (int col = 0; col < this.getColumnCount(); ++col) {
            if (colnum > colnumMax) {
                colnumMax = colnum;
            }
            if (!this.isColumnPrinted(col)) continue;
            Cell cell = row.createCell(colnum);
            CellStyle style = this.getHeaderStyle(col);
            cell.setCellStyle(style);
            String str = this.fixString(this.getHeaderName(col));
            cell.setCellValue(sheet.getWorkbook().getCreationHelper().createRichTextString(str));
            colnum = (short)(colnum + 1);
        }
    }

    protected void createHeaderFooter(Sheet sheet) {
        Header header = sheet.getHeader();
        header.setRight("Page &P of &N");
        Footer footer = sheet.getFooter();
        footer.setLeft("Powered by ADempiere ERP\u00ae");
        footer.setCenter(Env.getHeader(this.getCtx(), 0));
        Timestamp now = new Timestamp(System.currentTimeMillis());
        footer.setRight(DisplayType.getDateFormat(16, this.getLanguage()).format(now));
    }

    protected void formatPage(Sheet sheet) {
        sheet.setFitToPage(true);
        PrintSetup ps = sheet.getPrintSetup();
        ps.setFitWidth((short)1);
        ps.setNoColor(true);
        ps.setPaperSize((short)9);
        ps.setLandscape(false);
    }

    private void export(OutputStream out) throws Exception {
        SXSSFSheet sheet = this.createTableSheet();
        String sheetName = null;
        int colnumMax = 0;
        int rownum = 0;
        int xls_rownum = 1;
        while (rownum < this.getRowCount()) {
            this.setCurrentRow(rownum);
            boolean isPageBreak = false;
            SXSSFRow row = sheet.createRow(xls_rownum);
            int colnum = 0;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                if (colnum > colnumMax) {
                    colnumMax = colnum;
                }
                if (!this.isColumnPrinted(col)) continue;
                Cell cell = row.createCell(colnum);
                Object obj = this.getValueAt(rownum, col);
                int displayType = this.getDisplayType(rownum, col);
                if (obj != null) {
                    Object value;
                    if (DisplayType.isDate(displayType)) {
                        value = (Timestamp)obj;
                        cell.setCellValue((Date)value);
                    } else if (DisplayType.isNumeric(displayType)) {
                        double value2 = 0.0;
                        if (obj instanceof Number) {
                            value2 = ((Number)obj).doubleValue();
                        }
                        cell.setCellValue(value2);
                    } else if (20 == displayType) {
                        boolean value3 = false;
                        value3 = obj instanceof Boolean ? ((Boolean)obj).booleanValue() : "Y".equals(obj);
                        cell.setCellValue(sheet.getWorkbook().getCreationHelper().createRichTextString(Msg.getMsg(this.getLanguage(), value3 ? "Y" : "N")));
                    } else {
                        value = this.fixString(obj.toString());
                        cell.setCellValue(sheet.getWorkbook().getCreationHelper().createRichTextString((String)value));
                    }
                }
                CellStyle style = this.getStyle(rownum, col);
                cell.setCellStyle(style);
                if (this.isPageBreak(rownum, col)) {
                    isPageBreak = true;
                    sheetName = this.fixString(cell.getRichStringCellValue().getString());
                }
                ++colnum;
            }
            if (isPageBreak) {
                this.closeTableSheet(sheet, sheetName, colnumMax);
                sheet = this.createTableSheet();
                xls_rownum = 0;
                isPageBreak = false;
            }
            ++rownum;
            ++xls_rownum;
        }
        this.closeTableSheet(sheet, sheetName, colnumMax);
        this.m_workbook.write(out);
        out.close();
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Sheets #" + this.m_sheetCount);
            this.log.fine("Styles used #" + this.m_styles.size());
        }
    }

    public void export(File file, Language language) throws Exception {
        this.export(file, language, true);
    }

    public void export(File file, Language language, boolean autoOpen) throws Exception {
        this.m_lang = language;
        this.m_workbook = new SXSSFWorkbook();
        this.m_dataFormat = this.m_workbook.createDataFormat();
        if (file == null) {
            file = File.createTempFile("Report_", ".xls");
        }
        FileOutputStream out = new FileOutputStream(file);
        this.export(out);
        if (autoOpen && Ini.isClient()) {
            Env.startBrowser(file.toURI().toString());
        }
    }

    public File export() throws Exception {
        this.m_lang = Env.getLanguage(this.getCtx());
        File file = File.createTempFile("Report_", ".xls");
        FileOutputStream out = new FileOutputStream(file);
        this.export(out);
        return file;
    }
}

