/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.IZoomProvider;
import org.adempiere.model.ZoomInfoFactory;
import org.adempiere.model.ZoomMetaInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MTab;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenericZoomProvider
implements IZoomProvider {
    private static final CLogger logger = CLogger.getCLogger(GenericZoomProvider.class);
    private static CCache<String, List<ZoomMetaInfo>> cache = new CCache("ZoomMetaInfo", 40, 5);

    @Override
    public List<ZoomInfoFactory.ZoomInfo> retrieveZoomInfos(PO po) {
        ArrayList<ZoomInfoFactory.ZoomInfo> result = new ArrayList<ZoomInfoFactory.ZoomInfo>();
        List<ZoomMetaInfo> infoList = cache.get(po.get_TableName());
        if (infoList == null) {
            infoList = this.loadZoom(po.get_TableName());
        }
        infoList.stream().forEach(zoomInfoMetaData -> {
            MQuery query = GenericZoomProvider.evaluateQuery(zoomInfoMetaData.getTargetTableName(), zoomInfoMetaData.getTabId(), zoomInfoMetaData.getName(), po);
            result.add(new ZoomInfoFactory.ZoomInfo(zoomInfoMetaData.getWindowId(), query, zoomInfoMetaData.getName()));
            if (zoomInfoMetaData.getpOWindowId() != 0 && zoomInfoMetaData.getpOTabId() != 0) {
                MQuery querypo = GenericZoomProvider.evaluateQuery(zoomInfoMetaData.getTargetTableName(), zoomInfoMetaData.getpOTabId(), zoomInfoMetaData.getpOName(), po);
                result.add(new ZoomInfoFactory.ZoomInfo(zoomInfoMetaData.getpOWindowId(), querypo, zoomInfoMetaData.getpOName()));
            }
        });
        return result;
    }

    private List<ZoomMetaInfo> loadZoom(String tableName) {
        String sql = "SELECT DISTINCT ws.AD_Window_ID, ws.Name, wp.AD_Window_ID, wp.Name, t.TableName, tts.AD_Tab_ID, ttp.AD_Tab_ID FROM AD_Table t ";
        boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Window");
        sql = baseLanguage ? sql + "INNER JOIN AD_Window ws ON (t.AD_Window_ID=ws.AD_Window_ID) LEFT OUTER JOIN AD_Window wp ON (t.PO_Window_ID=wp.AD_Window_ID) " : sql + "INNER JOIN AD_Window_Trl ws ON (t.AD_Window_ID=ws.AD_Window_ID AND ws.AD_Language=?) LEFT OUTER JOIN AD_Window_Trl wp ON (t.PO_Window_ID=wp.AD_Window_ID AND wp.AD_Language=?) ";
        sql = sql + "JOIN AD_Tab tts ON (tts.AD_Window_ID=ws.AD_Window_ID AND tts.AD_Table_ID=t.AD_Table_ID) LEFT OUTER JOIN AD_Tab ttp ON (ttp.AD_Window_ID=wp.AD_Window_ID AND ttp.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName NOT LIKE 'I%' AND t.AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName=? AND IsKey='N' AND IsParent='N' AND ColumnSQL IS NULL) ORDER BY 2";
        CPreparedStatement pstmt = DB.prepareStatement(sql, null);
        ResultSet rs = null;
        ArrayList<ZoomMetaInfo> zoomList = new ArrayList<ZoomMetaInfo>();
        try {
            int index = 1;
            if (!baseLanguage) {
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
            }
            pstmt.setString(index++, tableName + "_ID");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int windowId = rs.getInt(1);
                String name = rs.getString(2);
                int pOWindowId = rs.getInt(3);
                String pOName = rs.getString(4);
                String targetTableName = rs.getString(5);
                int tabId = rs.getInt(6);
                int pOTabId = rs.getInt(7);
                zoomList.add(new ZoomMetaInfo(windowId, pOWindowId, tabId, pOTabId, name, pOName, targetTableName));
            }
            cache.put(tableName, zoomList);
        }
        catch (SQLException e) {
            try {
                logger.log(Level.SEVERE, sql, e);
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        return zoomList;
    }

    private static MQuery evaluateQuery(String targetTableName, int AD_Tab_ID, String Name, PO po) {
        MTab tab = new MTab(Env.getCtx(), AD_Tab_ID, null);
        MQuery query = new MQuery();
        query.addRestriction(po.get_TableName() + "_ID=" + po.get_ID());
        if (tab.getWhereClause() != null && tab.getWhereClause().length() > 0) {
            query.addRestriction("(" + tab.getWhereClause() + ")");
        }
        query.setZoomTableName(targetTableName);
        query.setZoomColumnName(po.get_KeyColumns()[0]);
        query.setZoomValue(po.get_ID());
        String sql = "SELECT COUNT(*) FROM " + targetTableName + " WHERE " + Env.parseVariable(query.getWhereClause(false), po, null, false);
        int count = DB.getSQLValue(null, sql);
        query.setRecordCount(count);
        return query;
    }
}

