/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.lang.reflect.Field;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GridTabWrapper;
import org.adempiere.model.POWrapper;
import org.adempiere.util.Check;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class InterfaceWrapperHelper {
    private static final transient CLogger logger = CLogger.getCLogger(InterfaceWrapperHelper.class);

    public static <T> T newInstance(Class<T> cl, Object contextProvider) {
        Check.assumeNotNull(contextProvider, "contextProvider not null", new Object[0]);
        Properties ctx = InterfaceWrapperHelper.getCtx(contextProvider);
        String trxName = InterfaceWrapperHelper.getTrxName(contextProvider);
        return InterfaceWrapperHelper.create(ctx, cl, trxName);
    }

    public static <T> T create(Object model, Class<T> cl) {
        if (model == null) {
            return null;
        }
        if (GridTabWrapper.isHandled(model)) {
            return GridTabWrapper.create(model, cl);
        }
        if (POWrapper.isHandled(model)) {
            return POWrapper.create(model, cl);
        }
        throw new AdempiereException("Model wrapping is not supported for " + model + " (class:" + model.getClass() + ")");
    }

    public static <T> T create(Properties ctx, Class<T> cl, String trxName) {
        T bean = POWrapper.create(ctx, cl, trxName);
        return bean;
    }

    public static <T> T create(Properties ctx, int id, Class<T> cl, String trxName) {
        T bean = POWrapper.create(ctx, id, cl, trxName);
        return bean;
    }

    public static <T> T create(Properties ctx, String tableName, int id, Class<T> cl, String trxName) {
        T bean = POWrapper.create(ctx, tableName, id, cl, trxName);
        return bean;
    }

    public static void refresh(Object model) {
        if (GridTabWrapper.isHandled(model)) {
            GridTabWrapper.refresh(model);
        } else if (POWrapper.isHandled(model)) {
            POWrapper.refresh(model);
        } else {
            throw new AdempiereException("Not supported model " + model + " (class:" + model.getClass() + ")");
        }
    }

    public static void refresh(Object model, String trxName) {
        if (GridTabWrapper.isHandled(model)) {
            GridTabWrapper.refresh(model);
        } else if (POWrapper.isHandled(model)) {
            POWrapper.refresh(model, trxName);
        } else {
            throw new AdempiereException("Not supported model " + model + " (class:" + model.getClass() + ")");
        }
    }

    public static void save(Object model) {
        if (model == null) {
            logger.log(Level.WARNING, "Saving null model ignored. Possible development issue. Ignored.", new AdempiereException());
        } else if (GridTabWrapper.isHandled(model)) {
            GridTabWrapper.save(model);
        } else if (POWrapper.isHandled(model)) {
            POWrapper.save(model);
        } else {
            logger.log(Level.SEVERE, "PO not handled: " + model + "(class=" + model.getClass() + "). Ignored.", new AdempiereException());
        }
    }

    public static Properties getCtx(Object model) {
        return InterfaceWrapperHelper.getCtx(model, false);
    }

    public static Properties getCtx(Object model, boolean useClientOrgFromModel) {
        if (model == null) {
            return Env.getCtx();
        }
        if (GridTabWrapper.isHandled(model)) {
            return Env.getCtx();
        }
        if (POWrapper.isHandled(model)) {
            return POWrapper.getCtx(model, useClientOrgFromModel);
        }
        logger.log(Level.WARNING, "Cannot get context from object: " + model + ". Returning global context.", new AdempiereException());
        return Env.getCtx();
    }

    public static String getTrxName(Object model) {
        if (model == null) {
            return null;
        }
        if (GridTabWrapper.isHandled(model)) {
            return null;
        }
        if (POWrapper.isHandled(model)) {
            return POWrapper.getTrxName(model);
        }
        logger.log(Level.WARNING, "Cannot get trxName from object: " + model + ". Returning null.", new AdempiereException());
        return null;
    }

    public static void delete(Object model) {
        Check.assume(model != null, "model is null", new Object[0]);
        if (!POWrapper.isHandled(model)) {
            throw new IllegalStateException("delete is not supported for " + model);
        }
        POWrapper.delete(model);
    }

    public static PO getPO(Object model) {
        return POWrapper.getPO(model);
    }

    public static int getId(Object model) {
        if (model == null) {
            return -1;
        }
        if (POWrapper.isHandled(model)) {
            Object po = POWrapper.getPO(model, false);
            if (po == null) {
                return -1;
            }
            String[] keyColumns = ((PO)po).get_KeyColumns();
            if (keyColumns == null || keyColumns.length != 1) {
                return -1;
            }
            return ((PO)po).get_ID();
        }
        if (GridTabWrapper.isHandled(model)) {
            return GridTabWrapper.getGridTab(model).getRecord_ID();
        }
        throw new AdempiereException("Not supported model " + model + " (class:" + model.getClass() + ")");
    }

    public static String getTableName(Class<?> clazz) throws AdempiereException {
        try {
            Field field = clazz.getField("Table_Name");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (String)field.get(null);
        }
        catch (Exception e) {
            throw new MissingTableNameException(e);
        }
    }

    public static String getTableNameOrNull(Class<?> clazz) {
        try {
            Field field = clazz.getField("Table_Name");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (String)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getModelTableName(Object model) {
        if (model == null) {
            throw new AdempiereException("Cannot get TableName for a null model. Possible development issue.");
        }
        if (GridTabWrapper.isHandled(model)) {
            return GridTabWrapper.getGridTab(model).getTableName();
        }
        if (POWrapper.isHandled(model)) {
            return ((PO)POWrapper.getPO(model)).get_TableName();
        }
        throw new AdempiereException("Cannot get TableName from model: " + model);
    }

    public static boolean isNull(Object model, String columnName) {
        if (model == null) {
            return true;
        }
        if (GridTabWrapper.isHandled(model)) {
            return GridTabWrapper.isNull(model, columnName);
        }
        if (POWrapper.isHandled(model)) {
            return POWrapper.isNull(model, columnName);
        }
        throw new AdempiereException("Model wrapping is not supported for " + model + " (class:" + model.getClass() + ")");
    }

    public static <T> T getValueByColumnId(Object model, int adColumnId) {
        Check.assumeNotNull(model, "model is not null", new Object[0]);
        Check.assume(adColumnId > 0, "adColumnId > 0", new Object[0]);
        if (GridTabWrapper.isHandled(model)) {
            GridTab gridTab = GridTabWrapper.getGridTab(model);
            for (GridField field : gridTab.getFields()) {
                if (field.getAD_Column_ID() != adColumnId) continue;
                Object value = field.getValue();
                return (T)value;
            }
            throw new AdempiereException("No field with AD_Column_ID=" + adColumnId + " found in " + gridTab + " for " + model);
        }
        if (POWrapper.isHandled(model)) {
            Object po = POWrapper.getPO(model, false);
            Object value = ((PO)po).get_ValueOfColumn(adColumnId);
            return (T)value;
        }
        throw new AdempiereException("Model wrapping is not supported for " + model + " (class:" + model.getClass() + ")");
    }

    public static <T> T getValueOrNull(Object model, String columnName) {
        boolean throwExIfColumnNotFound = false;
        T value = InterfaceWrapperHelper.getValue(model, columnName, false);
        return value;
    }

    public static <T> T getValue(Object model, String columnName) {
        boolean throwExIfColumnNotFound = true;
        T value = InterfaceWrapperHelper.getValue(model, columnName, true);
        return value;
    }

    private static <T> T getValue(Object model, String columnName, boolean throwExIfColumnNotFound) {
        Check.assumeNotNull(model, "model is not null", new Object[0]);
        Check.assumeNotNull(columnName, "columnName is not null", new Object[0]);
        if (GridTabWrapper.isHandled(model)) {
            GridTab gridTab = GridTabWrapper.getGridTab(model);
            GridField gridField = gridTab.getField(columnName);
            if (gridField == null) {
                if (throwExIfColumnNotFound) {
                    throw new AdempiereException("No field with ColumnName=" + columnName + " found in " + gridTab + " for " + model);
                }
                return null;
            }
            Object value = gridField.getValue();
            return (T)value;
        }
        if (POWrapper.isHandled(model)) {
            Object po = POWrapper.getPO(model, false);
            int idx = ((PO)po).get_ColumnIndex(columnName);
            if (idx < 0) {
                if (throwExIfColumnNotFound) {
                    throw new AdempiereException("No columnName " + columnName + " found for " + model);
                }
                return null;
            }
            Object value = ((PO)po).get_Value(idx);
            return (T)value;
        }
        throw new AdempiereException("Model wrapping is not supported for " + model + " (class:" + model.getClass() + ")");
    }

    static class MissingTableNameException
    extends AdempiereException {
        private static final long serialVersionUID = 6469196469943285793L;

        private MissingTableNameException(Throwable cause) {
            super(cause);
        }
    }
}

