/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MViewColumn;
import org.adempiere.model.X_AD_Browse_Field;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.M_Element;
import org.compiere.model.Query;
import org.compiere.util.DB;

public class MBrowseField
extends X_AD_Browse_Field {
    private static final long serialVersionUID = 3076943543303710639L;
    private static final String CONTEXT_TABLE_PREFIX = "Table_";
    private M_Element m_element = null;
    private MViewColumn m_view_column = null;

    public static GridField createGridFieldVO(MBrowseField field, int windowNo) {
        GridFieldVO valueObject = GridFieldVO.createStdField(field.getCtx(), windowNo, 0, 0, 0, false, false, false);
        String uniqueName = field.getAD_View_Column().getColumnName();
        valueObject.isProcess = true;
        valueObject.IsDisplayed = field.isDisplayed();
        valueObject.IsReadOnly = field.isReadOnly();
        valueObject.IsUpdateable = true;
        valueObject.WindowNo = windowNo;
        if (field.getAD_View_Column().getAD_Column_ID() > 0) {
            valueObject.ColumnName = field.getAD_View_Column().getAD_Column().getColumnName();
            valueObject.AD_Column_ID = field.getAD_View_Column().getAD_Column_ID();
            valueObject.AD_Table_ID = field.getAD_View_Column().getAD_Column().getAD_Table_ID();
        } else {
            valueObject.ColumnName = field.getAD_View_Column().getColumnSQL();
        }
        valueObject.ColumnNameAlias = CONTEXT_TABLE_PREFIX + uniqueName;
        valueObject.displayType = field.getAD_Reference_ID();
        valueObject.AD_Reference_Value_ID = field.getAD_Reference_Value_ID();
        valueObject.IsMandatory = field.isMandatory();
        valueObject.IsAlwaysUpdateable = false;
        valueObject.IsKey = field.isKey();
        valueObject.DefaultValue = field.getDefaultValue();
        valueObject.DefaultValue2 = field.getDefaultValue2();
        valueObject.InfoFactoryClass = field.getInfoFactoryClass();
        valueObject.FieldLength = field.getFieldLength();
        valueObject.ReadOnlyLogic = field.getReadOnlyLogic();
        valueObject.DisplayLogic = field.getDisplayLogic();
        valueObject.VFormat = field.getVFormat();
        valueObject.ValueMin = field.getValueMin();
        valueObject.ValueMax = field.getValueMax();
        valueObject.ValidationCode = field.getAD_Val_Rule().getCode();
        valueObject.IsRange = field.isRange();
        try {
            valueObject.Description = field.getDescription();
        }
        catch (IllegalArgumentException e) {
            valueObject.Description = (String)field.get_Value("Description");
        }
        if (field.getAD_View_Column().getAD_Column_ID() <= 0 && field.isReadOnly()) {
            valueObject.ColumnSQL = uniqueName;
        }
        valueObject.Help = uniqueName;
        try {
            valueObject.Header = field.getName();
        }
        catch (IllegalArgumentException e) {
            valueObject.Header = (String)field.get_Value("Name");
        }
        valueObject.Callout = field.getCallout();
        valueObject.initFinish();
        GridField gridField = new GridField(valueObject);
        if (gridField.isLookup()) {
            gridField.lookupLoadComplete();
        }
        if (!gridField.isReadOnly()) {
            Object defaultObject = gridField.getDefault();
            gridField.setValue(defaultObject, true);
        }
        return gridField;
    }

    public static MBrowseField get(MBrowse browse, MViewColumn column) {
        String whereClause = "AD_Browse_ID=? AND AD_View_Column_ID=?";
        return (MBrowseField)new Query(column.getCtx(), "AD_Browse_Field", whereClause, column.get_TrxName()).setOnlyActiveRecords(true).setParameters(browse.getAD_Browse_ID(), column.getAD_View_Column_ID()).first();
    }

    public static int getIdByColumnName(MBrowse browse, String columnName) {
        String whereClause = "AD_Browse_ID=? AND EXISTS (SELECT 1 FROM AD_View_Column vc WHERE vc.AD_View_Column_ID=AD_Browse_Field.AD_View_Column_ID AND vc.ColumnName=?)";
        return new Query(browse.getCtx(), "AD_Browse_Field", whereClause, browse.get_TrxName()).setParameters(browse.getAD_Browse_ID(), columnName).firstIdOnly();
    }

    public MBrowseField(Properties ctx, int AD_SmartBrowseField_ID, String trxName) {
        super(ctx, AD_SmartBrowseField_ID, trxName);
        if (AD_SmartBrowseField_ID == 0) {
            // empty if block
        }
    }

    public MBrowseField(Properties ctx, int AD_SmartBrowseField_ID) {
        this(ctx, AD_SmartBrowseField_ID, null);
    }

    public MBrowseField(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBrowseField(MBrowse browse, MViewColumn column) {
        super(browse.getCtx(), 0, browse.get_TrxName());
        this.setAD_Browse_ID(browse.getAD_Browse_ID());
        if (column.get_ID() > 0) {
            this.setAD_View_Column_ID(column.getAD_View_Column_ID());
        }
        if (column.getAD_Element_ID() > 0) {
            this.setAD_Element_ID(column.getAD_Element_ID());
        }
        this.setName(column.getName());
        this.setDescription(column.getDescription());
        this.setHelp(column.getHelp());
        this.setIsActive(true);
        this.setIsIdentifier(column.isIdentifier());
        this.setIsRange(false);
        this.setIsQueryCriteria(false);
        if (column.get_ID() > 0) {
            this.setAD_Reference_ID(column.getAD_Reference_ID());
        }
        if (column.get_ID() > 0) {
            this.setAD_Reference_Value_ID(column.getAD_Column().getAD_Reference_Value_ID());
        }
        if (column.get_ID() > 0) {
            this.setFieldLength(column.getAD_Column().getFieldLength());
        }
        this.setIsKey(false);
        this.setIsDisplayed(true);
        this.m_view_column = column;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("IsKey")) {
            // empty if block
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        DB.executeUpdate("DELETE FROM AD_Browse_Field_Trl WHERE AD_Browse_Field_ID=? ", this.getAD_Browse_Field_ID(), this.get_TrxName());
        return true;
    }

    public M_Element getElement() {
        if (this.m_element == null) {
            this.m_element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
        }
        return this.m_element;
    }

    @Override
    public MViewColumn getAD_View_Column() {
        if (this.m_view_column == null) {
            this.m_view_column = new MViewColumn(this.getCtx(), this.getAD_View_Column_ID(), this.get_TrxName());
        }
        return this.m_view_column;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MSmartBrowseField").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.get_Translation("Name");
    }

    @Override
    public String getDescription() {
        return this.get_Translation("Description");
    }

    @Override
    public String getHelp() {
        return this.get_Translation("Help");
    }

    public MBrowseField getDuplicated() {
        try {
            return (MBrowseField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.warning("Error " + e.getLocalizedMessage());
            return null;
        }
    }
}

