/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GridTabWrapper;
import org.adempiere.model.InterfaceWrapperHelper;
import org.adempiere.util.Check;
import org.compiere.model.GridTab;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class POWrapper
implements InvocationHandler {
    private final CLogger log = CLogger.getCLogger(this.getClass());
    private final Class<?> interfaceClass;
    private final PO po;
    private final boolean useOldValues;
    private final String trlAdLanguage;

    public static <T> T create(Object po, Class<T> cl) {
        return POWrapper.create(po, cl, false);
    }

    public static <T> T create(Object po, Class<T> cl, boolean useOldValues) {
        return POWrapper.create(po, cl, useOldValues, null);
    }

    public static <T> T create(Object obj, Class<T> cl, boolean useOldValues, String trlAdLanguage) {
        String poTableName;
        if (obj == null) {
            return null;
        }
        if (cl.isInstance(obj) && !useOldValues && trlAdLanguage == null) {
            return (T)obj;
        }
        PO po = obj instanceof PO ? (PO)obj : POWrapper.getPO(obj);
        if (!(po instanceof PO)) {
            throw new AdempiereException("Not a PO object - " + obj);
        }
        String classTableName = InterfaceWrapperHelper.getTableNameOrNull(cl);
        if (classTableName != null && !(poTableName = po.get_TableName()).equals(classTableName)) {
            throw new IllegalArgumentException("PO " + po + " (TableName:" + poTableName + ") and class " + cl + " (TableName:" + classTableName + ") are not compatible");
        }
        return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (InvocationHandler)new POWrapper(cl, po, useOldValues, trlAdLanguage));
    }

    public static <T> T create(Properties ctx, int id, Class<T> cl, String trxName) {
        if (id < 0) {
            return null;
        }
        String tableName = POWrapper.getTableName(cl);
        return POWrapper.create(ctx, tableName, id, cl, trxName);
    }

    public static <T> T create(Properties ctx, String tableName, int id, Class<T> cl, String trxName) {
        if (id < 0) {
            return null;
        }
        Check.assumeNotNull(tableName, "tableName not null", new Object[0]);
        PO po = MTable.get(ctx, tableName).getPO(id, trxName);
        if (po == null || po.get_ID() != id) {
            return null;
        }
        return POWrapper.create(po, cl);
    }

    public static <T> T create(Properties ctx, Class<T> cl, String trxName) {
        String tableName = POWrapper.getTableName(cl);
        PO po = MTable.get(ctx, tableName).getPO(0, trxName);
        if (po == null) {
            return null;
        }
        return POWrapper.create(po, cl);
    }

    public static <T> T translate(T model, Class<T> cl) {
        return POWrapper.translate(model, cl, null);
    }

    public static <T> T translate(T model, Class<T> cl, String trlAdLanguage) {
        T po = POWrapper.getPO(model);
        if (trlAdLanguage == null) {
            Properties ctx = POWrapper.getCtx(model);
            trlAdLanguage = Env.getAD_Language(ctx);
        }
        if (Env.isBaseLanguage(trlAdLanguage, ((PO)po).get_TableName())) {
            trlAdLanguage = null;
        }
        boolean useOldValues = false;
        return POWrapper.create(po, cl, false, trlAdLanguage);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("set") && args.length == 1) {
            String propertyName = methodName.substring(3);
            this.po.set_ValueOfColumn(propertyName, args[0]);
            return null;
        }
        if (methodName.startsWith("get") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(3);
            Object value = null;
            int idx = this.po.get_ColumnIndex(propertyName);
            if (idx >= 0) {
                value = this.po.get_Value(propertyName);
            }
            if (value != null) {
                return value;
            }
            if (method.getReturnType() == Integer.TYPE) {
                value = 0;
            } else if (method.getReturnType() == BigDecimal.class) {
                value = BigDecimal.ZERO;
            } else if (this.isModelInterface(method.getReturnType())) {
                value = this.getReferencedObject(propertyName, method);
            } else if (PO.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method not supported - " + methodName);
            }
            return value;
        }
        if (methodName.startsWith("is") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(2);
            int ii = this.po.get_ColumnIndex(propertyName);
            if (ii >= 0) {
                return this.po.get_Value(ii);
            }
            ii = this.po.get_ColumnIndex("Is" + propertyName);
            if (ii >= 0) {
                return this.po.get_Value(ii);
            }
            throw new IllegalArgumentException("Method not supported - " + methodName);
        }
        return method.invoke((Object)this.po, args);
    }

    public static <T extends PO> T getPO(Object model) {
        boolean checkOtherWrapper = true;
        T po = POWrapper.getPO(model, true);
        return po;
    }

    public static <T extends PO> T getPO(Object model, boolean checkOtherWrapper) {
        if (model == null) {
            return null;
        }
        if (model instanceof PO) {
            return (T)((PO)model);
        }
        if (Proxy.isProxyClass(model.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(model);
            if (ih instanceof POWrapper) {
                POWrapper wrapper = (POWrapper)ih;
                return (T)wrapper.getPO();
            }
            if (ih instanceof GridTabWrapper && checkOtherWrapper) {
                GridTab gridTab = GridTabWrapper.getGridTab(model);
                String tableName = gridTab.get_TableName();
                int recordID = gridTab.getKeyID(gridTab.getCurrentRow());
                return (T)MTable.get(Env.getCtx(), tableName).getPO(recordID, null);
            }
        }
        return null;
    }

    public static Properties getCtx(Object model) {
        return POWrapper.getCtx(model, false);
    }

    public static Properties getCtx(Object model, boolean useClientOrgFromModel) {
        Object po = POWrapper.getPO(model);
        if (po != null) {
            Properties poCtx;
            if (useClientOrgFromModel) {
                poCtx = new Properties(((PO)po).getCtx());
                Env.setContext(poCtx, "#AD_Client_ID", ((PO)po).getAD_Client_ID());
                Env.setContext(poCtx, "#AD_Org_ID", ((PO)po).getAD_Org_ID());
            } else {
                poCtx = ((PO)po).getCtx();
            }
            return poCtx;
        }
        return Env.getCtx();
    }

    public static String getTrxName(Object model) {
        Object po = POWrapper.getPO(model);
        if (po != null) {
            return ((PO)po).get_TrxName();
        }
        return null;
    }

    public static String getTableName(Class<?> clazz) throws AdempiereException {
        return InterfaceWrapperHelper.getTableName(clazz);
    }

    private POWrapper(Class<?> interfaceClass, PO po, boolean useOldValues, String trlAdLanguage) {
        this.po = po;
        this.useOldValues = useOldValues;
        this.interfaceClass = interfaceClass;
        this.trlAdLanguage = trlAdLanguage;
    }

    protected Properties getCtx() {
        return this.po.getCtx();
    }

    protected String getTrxName() {
        return this.po.get_TrxName();
    }

    protected int getColumnIndex(String name) {
        return this.po.get_ColumnIndex(name);
    }

    protected Object getValue(String columnName, int index, Class<?> returnType) {
        if (this.trlAdLanguage != null && String.class.equals(returnType)) {
            return this.po.get_Translation(columnName, this.trlAdLanguage);
        }
        Object value = this.useOldValues ? this.po.get_ValueOld(index) : this.po.get_Value(index);
        if (Boolean.TYPE.equals(returnType)) {
            if (value == null) {
                return false;
            }
            return value instanceof Boolean ? value : Boolean.valueOf("Y".equals(value));
        }
        return value;
    }

    protected static final Object checkZeroIdValue(String columnName, Object value) {
        if (!(value instanceof Integer)) {
            return value;
        }
        if (!columnName.endsWith("_ID")) {
            return value;
        }
        int id = (Integer)value;
        if (id > 0) {
            return id;
        }
        int firstOK = 1;
        if (columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("Record_ID") || columnName.equals("C_DocType_ID") || columnName.equals("Node_ID") || columnName.equals("AD_Role_ID") || columnName.equals("M_AttributeSet_ID") || columnName.equals("M_AttributeSetInstance_ID")) {
            firstOK = 0;
        }
        if (id < firstOK) {
            return null;
        }
        return id;
    }

    protected Object invokeParent(Method method, Object[] args) throws Exception {
        return method.invoke((Object)this.po, args);
    }

    public PO getPO() {
        return this.po;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    private final Object getReferencedObject(String propertyName, Method method) {
        String tableName;
        int i = this.po.get_ColumnIndex(propertyName + "_ID");
        if (i < 0) {
            return null;
        }
        Integer record_id = this.po.get_ValueAsInt(i);
        if (record_id == null || record_id <= 0) {
            return null;
        }
        Class<?> cl = method.getReturnType();
        try {
            tableName = (String)cl.getField("Table_Name").get(null);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        PO child = MTable.get(this.po.getCtx(), tableName).getPO(record_id, this.po.get_TrxName());
        return child;
    }

    private boolean isModelInterface(Class<?> cl) {
        try {
            String tableName = POWrapper.getTableName(cl);
            return tableName != null;
        }
        catch (InterfaceWrapperHelper.MissingTableNameException e) {
            return false;
        }
    }

    public static void save(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("model is null");
        }
        Object po = POWrapper.getPO(o);
        if (po == null) {
            throw new IllegalArgumentException("Class is not supported - " + o.getClass());
        }
        ((PO)po).saveEx();
    }

    public static void delete(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("model is null");
        }
        Object po = POWrapper.getPO(o);
        if (po == null) {
            throw new IllegalArgumentException("Class is not supported - " + o.getClass());
        }
        ((PO)po).deleteEx(false);
    }

    public static boolean isHandled(Object model) {
        return POWrapper.getPO(model, false) != null;
    }

    public static void refresh(Object model) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        Object po = POWrapper.getPO(model);
        if (po == null) {
            throw new IllegalArgumentException("Class is not supported - " + model.getClass());
        }
        ((PO)po).load(((PO)po).get_TrxName());
    }

    public static void refresh(Object model, String trxName) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        Object po = POWrapper.getPO(model);
        if (po == null) {
            throw new IllegalArgumentException("Class is not supported - " + model.getClass());
        }
        ((PO)po).load(trxName);
    }

    public static boolean isNull(Object model, String columnName) {
        Object po = POWrapper.getPO(model, false);
        if (po == null) {
            return true;
        }
        Object value = ((PO)po).get_Value(columnName);
        return value == null;
    }
}

