/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pdf;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import io.konik.carriage.itext.ITextInvoiceAppender;
import io.konik.carriage.itext.ITextInvoiceExtractor;
import io.konik.harness.AppendParameter;
import io.konik.harness.FileAppender;
import io.konik.harness.FileExtractor;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.adempiere.pdf.IText7Document;
import org.adempiere.pdf.viewer.PDFViewerBean;
import org.compiere.util.CLogger;

@Named
@Singleton
public class ITextDocument
implements FileExtractor,
FileAppender {
    private static CLogger log = CLogger.getCLogger(ITextDocument.class);
    private static final FileExtractor invoiceExtractor = new ITextInvoiceExtractor();
    private static final FileAppender invoiceAppender = new ITextInvoiceAppender();
    private static final IText7Document itext7 = new IText7Document();

    private void writePDF(Pageable pageable, OutputStream output) throws DocumentException, IndexOutOfBoundsException, PrinterException {
        PageFormat pf = pageable.getPageFormat(0);
        log.config("pageable PageFormat.Height (in DTP points) =" + pf.getHeight());
        Rectangle pageSize = new Rectangle((float)((int)pf.getWidth()), (float)((int)pf.getHeight()));
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)output);
        writer.setPdfVersion(PdfWriter.PDF_VERSION_1_7);
        document.open();
        log.config("PDFXConformance:" + writer.getPDFXConformance());
        PdfContentByte contentByte = writer.getDirectContent();
        float width = (float)pf.getWidth();
        float height = (float)pf.getHeight();
        for (int page = 0; page < pageable.getNumberOfPages(); ++page) {
            if (page != 0) {
                document.newPage();
            }
            PdfTemplate temp = contentByte.createTemplate(width, height);
            PdfGraphics2D g2d = new PdfGraphics2D(contentByte, width, height);
            temp.setWidth(width);
            temp.setHeight(height);
            pageable.getPrintable(page).print((Graphics)g2d, pf, page);
            g2d.dispose();
            contentByte.addTemplate(temp, 0.0f, 0.0f);
        }
        document.close();
    }

    public void merge(OutputStream result, InputStream origin, String title) {
        itext7.merge(result, origin, title);
    }

    public File getPDFAsFile(String filename, Pageable pageable) {
        File result = new File(filename);
        try {
            this.writePDF(pageable, new FileOutputStream(result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public byte[] getPDFAsArray(Pageable pageable) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(10240);
            this.writePDF(pageable, output);
            return output.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PDFViewerBean getViewer() {
        return new PDFViewerBean();
    }

    public boolean isValid(Pageable layout) {
        return true;
    }

    public boolean isLicensed() {
        return true;
    }

    public byte[] extract(InputStream inpStream) {
        return invoiceExtractor.extract(inpStream);
    }

    public InputStream extractToStream(InputStream inpStream) {
        return invoiceExtractor.extractToStream(inpStream);
    }

    public void append(AppendParameter param) {
        log.info("zugferdVersion:" + param.zugferdVersion() + " zugferdConformanceLevel:" + param.zugferdConformanceLevel());
        invoiceAppender.append(param);
    }

    public int getPriority() {
        return invoiceAppender.getPriority();
    }
}

