/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.ElementHandler;
import org.adempiere.pipo.IDFinder;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractElementHandler
implements ElementHandler {
    protected CLogger log = CLogger.getCLogger("PackIn");

    public int get_ID(Properties ctx, String tableName, String name) {
        return IDFinder.get_ID(tableName, name, this.getClientId(ctx), this.getTrxName(ctx));
    }

    public int getIdFromUUID(Properties ctx, String tableName, String uuid) {
        return IDFinder.getIdFromUUID(ctx, tableName, uuid, this.getClientId(ctx), this.getTrxName(ctx));
    }

    public String getUUIDFromId(Properties ctx, String tableName, int value) {
        return IDFinder.getUUIDFromId(tableName, value, this.getClientId(ctx), this.getTrxName(ctx));
    }

    public int get_IDWithColumn(Properties ctx, String tableName, String columnName, Object value) {
        return IDFinder.get_IDWithColumn(tableName, columnName, value, this.getClientId(ctx), this.getTrxName(ctx));
    }

    public int recordLog(Properties ctx, int success, String objectName, String objectType, int objectID, int objectIDBackup, String objectStatus, String tableName, int AD_Table_ID) throws SAXException {
        StringBuffer recordLayout = new StringBuffer();
        int id = 0;
        TransformerHandler hd_document = this.getLogDocument(ctx);
        AttributesImpl attsOut = new AttributesImpl();
        String result = success == 1 ? "Success" : "Failure";
        recordLayout.append("Type:").append(objectType).append("  -   Name:").append(objectName).append("  -  ID:").append(objectID).append("  -  Action:").append(objectStatus).append("  -  " + result);
        hd_document.startElement("", "", result, attsOut);
        hd_document.characters(recordLayout.toString().toCharArray(), 0, recordLayout.length());
        hd_document.endElement("", "", result);
        X_AD_Package_Imp_Detail detail = new X_AD_Package_Imp_Detail(ctx, 0, this.getTrxName(ctx));
        detail.setAD_Package_Imp_ID(this.getPackageImpId(ctx));
        detail.setAD_Org_ID(Env.getAD_Org_ID(ctx));
        detail.setType(objectType);
        detail.setName(objectName);
        detail.setAction(objectStatus);
        detail.setSuccess(result);
        detail.setAD_Original_ID(objectID);
        detail.setAD_Backup_ID(objectIDBackup);
        detail.setTableName(tableName);
        detail.setAD_Table_ID(AD_Table_ID);
        detail.saveEx(this.getTrxName(ctx));
        id = detail.get_ID();
        return id;
    }

    public int get_IDWithMaster(Properties ctx, String tableName, String name, String tableNameMaster, String nameMaster) {
        return IDFinder.get_IDWithMaster(tableName, name, tableNameMaster, nameMaster, this.getTrxName(ctx));
    }

    public int get_IDWithMasterAndColumn(Properties ctx, String tableName, String columnName, String name, String tableNameMaster, int masterID) {
        return IDFinder.get_IDWithMasterAndColumn(tableName, columnName, name, tableNameMaster, masterID, this.getTrxName(ctx));
    }

    public int get_IDWithMaster(Properties ctx, String tableName, String name, String tableNameMaster, int masterID) {
        return IDFinder.get_IDWithMaster(tableName, name, tableNameMaster, masterID, this.getTrxName(ctx));
    }

    public int getIDbyName(Properties ctx, String tableName, String name) {
        return IDFinder.getIDbyName(tableName, name, this.getClientId(ctx), this.getTrxName(ctx));
    }

    public int getIDbyValue(Properties ctx, String tableName, String value) {
        return IDFinder.getIDbyValue(tableName, value, this.getClientId(ctx), this.getTrxName(ctx));
    }

    public int copyRecord(Properties ctx, String tableName, PO from) {
        int idBackup = 0;
        String colValue = null;
        int tableId = this.get_IDWithColumn(ctx, "AD_Table", "TableName", tableName);
        POInfo poInfo = POInfo.getPOInfo(ctx, tableId, this.getTrxName(ctx));
        for (int i = 0; i < poInfo.getColumnCount(); ++i) {
            StringBuffer sqlB;
            int no;
            colValue = null;
            int columnId = poInfo.getAD_Column_ID(poInfo.getColumnName(i));
            StringBuffer sqlD = new StringBuffer();
            int referenceId = poInfo.getColumnDisplayType(i);
            idBackup = DB.getNextID(this.getClientId(ctx), "AD_Package_Imp_Backup", this.getTrxName(ctx));
            sqlD = new StringBuffer("SELECT MAX(AD_PACKAGE_IMP_DETAIL_ID) FROM AD_PACKAGE_IMP_DETAIL");
            int idDetail = DB.getSQLValue(this.getTrxName(ctx), sqlD.toString()) + 1;
            if (referenceId == 10 || referenceId == 14 || referenceId == 34 || referenceId == 17) {
                if (from != null && from.get_Value(i) != null) {
                    colValue = from.get_Value(i).toString().replaceAll("'", "''");
                } else if ((referenceId == 20 || referenceId == 28) && from != null && from.get_Value(i) != null) {
                    colValue = from.get_Value(i).toString().replaceAll("'", "''");
                }
            }
            if ((no = DB.executeUpdate((sqlB = new StringBuffer("INSERT INTO AD_Package_Imp_Backup").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_PACKAGE_IMP_BACKUP_ID, AD_PACKAGE_IMP_DETAIL_ID, AD_PACKAGE_IMP_ID,").append(" AD_TABLE_ID, AD_COLUMN_ID, AD_REFERENCE_ID, COLVALUE)").append("VALUES(").append(" " + Env.getAD_Client_ID(ctx)).append(", " + Env.getAD_Org_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + idBackup).append(", " + idDetail).append(", " + this.getPackageImpId(ctx)).append(", " + tableId).append(", " + (columnId == -1 ? "null" : Integer.valueOf(columnId))).append(", " + (referenceId == -1 ? "null" : Integer.valueOf(referenceId))).append(", '" + (colValue != null ? colValue : (from != null ? from.get_Value(i) : "null"))).append("')")).toString(), this.getTrxName(ctx))) != -1) continue;
            this.log.info("Insert to import backup failed");
        }
        return idBackup;
    }

    public FileInputStream OpenInputfile(String filePath) {
        FileInputStream fileTarget = null;
        try {
            fileTarget = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filePath);
            return null;
        }
        return fileTarget;
    }

    public OutputStream OpenOutputfile(String filePath) {
        FileOutputStream fileTarget = null;
        try {
            fileTarget = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filePath);
            return null;
        }
        return fileTarget;
    }

    public int copyFile(InputStream source, OutputStream target) {
        int byteCount = 0;
        int success = 0;
        try {
            int data;
            while ((data = source.read()) >= 0) {
                target.write(data);
                ++byteCount;
            }
            source.close();
            target.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred while copying.  " + byteCount + " bytes copied.");
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            success = -1;
        }
        return success;
    }

    protected int getClientId(Properties ctx) {
        return Env.getContextAsInt(ctx, "AD_Client_ID");
    }

    protected int getPackageImpId(Properties ctx) {
        return Env.getContextAsInt(ctx, "AD_Package_Imp_ID");
    }

    protected String getUpdateMode(Properties ctx) {
        return Env.getContext(ctx, "UpdateMode");
    }

    protected String getTrxName(Properties ctx) {
        return Env.getContext(ctx, "TrxName");
    }

    protected TransformerHandler getLogDocument(Properties ctx) {
        return (TransformerHandler)ctx.get("LogDocument");
    }

    protected String getPackageDirectory(Properties ctx) {
        return Env.getContext(ctx, "PackageDirectory");
    }

    protected boolean isProcessElement(Properties ctx, String entityType) {
        if ("D".equals(entityType) || "C".equals(entityType)) {
            return "true".equalsIgnoreCase(this.getUpdateMode(ctx));
        }
        return true;
    }

    protected String getStringValue(Attributes atts, String qName) {
        String s = atts.getValue(qName);
        return "".equals(s) ? null : s;
    }

    protected boolean getBooleanValue(Attributes atts, String columnName) {
        String value = atts.getValue(columnName);
        if (!Util.isEmpty(value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    protected String getUUIDValue(Attributes atts, String columnName) {
        return this.getStringValue(atts, AttributeFiller.getUUIDAttribute(columnName));
    }

    protected int getIntValue(Attributes atts, String name, int defaultValue) {
        String value = atts.getValue(name);
        if (Util.isEmpty(value, true)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value.trim());
        return i;
    }

    protected long getLongValue(Attributes atts, String name, int defaultValue) {
        String value = atts.getValue(name);
        if (Util.isEmpty(value, true)) {
            return defaultValue;
        }
        long i = Integer.parseInt(value.trim());
        return i;
    }

    protected double getDoubleValue(Attributes atts, String name, double defaultValue) {
        String value = atts.getValue(name);
        if (Util.isEmpty(value, true)) {
            return defaultValue;
        }
        double i = Double.parseDouble(value.trim());
        return i;
    }

    protected Timestamp getTimestampValue(Attributes atts, String name) {
        long time = this.getLongValue(atts, name, 0);
        if (time > 0L) {
            return new Timestamp(time);
        }
        return null;
    }

    protected int getIntValue(Attributes atts, String name) {
        return this.getIntValue(atts, name, 0);
    }

    protected BigDecimal getBigDecimalValue(Attributes atts, String name) {
        return new BigDecimal(this.getDoubleValue(atts, name, 0.0));
    }
}

