/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.PO;
import org.xml.sax.helpers.AttributesImpl;

public class AttributeFiller {
    private AttributesImpl atts = null;
    private PO po = null;

    public AttributeFiller(AttributesImpl attributes) {
        attributes.clear();
        this.atts = attributes;
        this.po = null;
    }

    public AttributeFiller(AttributesImpl attributes, PO poToAutoFill) {
        attributes.clear();
        this.atts = attributes;
        this.po = poToAutoFill;
    }

    public void addUnchecked(String name, String value) {
        this.atts.addAttribute("", "", name, "CDATA", value);
    }

    public void addString(String name, String stringValue) {
        this.atts.addAttribute("", "", name, "CDATA", stringValue != null ? stringValue : "");
    }

    public void addInt(String name, int value) {
        this.atts.addAttribute("", "", name, "CDATA", String.valueOf(value));
    }

    public static String getUUIDAttribute(String name) {
        return name + "UUID";
    }

    public void addBoolean(String name, boolean boolValue) {
        this.atts.addAttribute("", "", name, "CDATA", boolValue ? "true" : "false");
    }

    public void add(String columnName) {
        this.add(columnName, false);
    }

    public void addUUID() {
        this.addString(AttributeFiller.getUUIDAttribute(this.po.get_TableName()), this.po.get_ValueAsString("UUID"));
    }

    public void addUUID(String name, String uuid) {
        this.addString(AttributeFiller.getUUIDAttribute(name), uuid);
    }

    public void add(String columnName, boolean onlyValidId) {
        Object value = this.po.get_Value(columnName);
        if (value == null) {
            this.atts.addAttribute("", "", columnName, "CDATA", "");
            return;
        }
        if (value instanceof String) {
            this.atts.addAttribute("", "", columnName, "CDATA", (String)value);
        } else if (value instanceof Boolean) {
            this.atts.addAttribute("", "", columnName, "CDATA", (Boolean)value == true ? "true" : "false");
        } else if (value instanceof Integer) {
            if (onlyValidId) {
                int intValue = Integer.parseInt(value.toString());
                if (intValue > 0) {
                    this.atts.addAttribute("", "", columnName, "CDATA", value.toString());
                } else {
                    this.atts.addAttribute("", "", columnName, "CDATA", "");
                }
            } else {
                this.atts.addAttribute("", "", columnName, "CDATA", value.toString());
            }
        } else if (value instanceof BigDecimal) {
            this.atts.addAttribute("", "", columnName, "CDATA", value.toString());
        } else if (value instanceof Timestamp) {
            this.atts.addAttribute("", "", columnName, "CDATA", String.valueOf(((Timestamp)value).getTime()));
        } else {
            throw new IllegalArgumentException("Add your own type implementation here.");
        }
    }

    public void addIsActive() {
        this.atts.addAttribute("", "", "IsActive", "CDATA", Boolean.valueOf(this.po.isActive()) == true ? "true" : "false");
    }

    public AttributesImpl getAttributes() {
        return this.atts;
    }
}

