/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.adempiere.pipo.exception.NonUniqueIDLookupException;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

public final class IDFinder {
    private static CLogger log = CLogger.getCLogger(IDFinder.class);
    private static Map<String, Integer> idCache = new HashMap<String, Integer>();
    private static Map<String, String> uUIDCache = new HashMap<String, String>();

    public static int get_ID(String tableName, String name, int AD_Client_ID, String trxName) {
        StringBuffer key = new StringBuffer();
        key.append(tableName).append(".Name=").append(name);
        if (!tableName.startsWith("AD_")) {
            key.append(" and AD_Client_ID=").append(AD_Client_ID);
        }
        if (idCache.containsKey(key.toString())) {
            return idCache.get(key.toString());
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sqlB = new StringBuffer("select ").append(tableName).append("_ID from ").append(tableName).append(" where name=?");
        params.add(name);
        if (!tableName.startsWith("AD_")) {
            sqlB = sqlB.append(" and AD_Client_ID=?");
            params.add(AD_Client_ID);
        }
        return IDFinder.getID(sqlB.toString(), params, key.toString(), true, trxName);
    }

    public static int getIdFromUUID(Properties ctx, String tableName, String uuid, int clientId, String trxName) {
        return IDFinder.get_IDWithColumn(tableName, "UUID", uuid, clientId, trxName);
    }

    public static int get_IDWithColumn(String tableName, String columnName, Object value, int AD_Client_ID, String trxName) {
        return IDFinder.get_IDWithColumn(tableName, columnName, value, AD_Client_ID, true, trxName);
    }

    public static int get_IDWithColumn(String tableName, String columnName, Object value, int AD_Client_ID, boolean strict, String trxName) {
        if (value == null) {
            return 0;
        }
        StringBuffer key = new StringBuffer();
        key.append(tableName).append(".").append(columnName).append("=").append(value.toString());
        if (!tableName.startsWith("AD_")) {
            key.append(" and AD_Client_ID=").append(AD_Client_ID);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sqlB = new StringBuffer("select ").append(tableName).append("_ID from ").append(tableName).append(" where ").append(columnName).append(" = ?");
        params.add(value);
        if (!tableName.startsWith("AD_")) {
            sqlB = sqlB.append(" and AD_Client_ID=?");
            params.add(AD_Client_ID);
        }
        sqlB = sqlB.append(" Order By ").append(tableName).append("_ID");
        return IDFinder.getID(sqlB.toString(), params, key.toString(), strict, trxName);
    }

    public static String getUUIDFromId(String tableName, int value, int clientId, String trxName) {
        if (value <= 0) {
            return null;
        }
        StringBuffer key = new StringBuffer();
        key.append(tableName).append(".").append(tableName).append("_ID").append("=").append(value);
        if (!tableName.startsWith("AD_")) {
            key.append(" and AD_Client_ID=").append(clientId);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("select ").append("UUID").append(" from ").append(tableName).append(" where ").append(tableName).append("_ID").append(" = ?");
        params.add(value);
        if (!tableName.startsWith("AD_")) {
            sql = sql.append(" and AD_Client_ID=?");
            params.add(clientId);
        }
        sql = sql.append(" Order By ").append(tableName).append("_ID");
        return IDFinder.getUUID(sql.toString(), params, key.toString(), trxName);
    }

    private static String getUUID(String sql, List<Object> params, String key, String trxName) {
        if (key != null && uUIDCache.containsKey(key)) {
            return uUIDCache.get(key);
        }
        String value = DB.getSQLValueString(trxName, sql, params);
        if (!Util.isEmpty(value)) {
            uUIDCache.put(key, value);
        }
        return value;
    }

    public static int get_IDWithMaster(String tableName, String name, String tableNameMaster, String nameMaster, String trxName) {
        StringBuffer key = new StringBuffer();
        key.append(tableName).append(".Name=").append(name).append(" and ").append(tableNameMaster).append(".Name=").append(nameMaster);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sqlB = new StringBuffer("select ").append(tableName).append("_ID from ").append(tableName).append(" where name = ? and ").append(tableNameMaster).append("_ID = (select ").append(tableNameMaster).append("_ID from ").append(tableNameMaster).append(" where name = ?)");
        params.add(name);
        params.add(nameMaster);
        return IDFinder.getID(sqlB.toString(), params, key.toString(), true, trxName);
    }

    public static int get_IDWithMasterAndColumn(String tableName, String columnName, String name, String tableNameMaster, int masterID, String trxName) {
        String key = tableName + "." + columnName + "=" + name + tableNameMaster + "=" + masterID;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sqlB = new StringBuffer("select ").append(tableName).append("_ID from ").append(tableName).append(" where ").append(columnName).append(" = ? and ").append(tableNameMaster + "_ID =?");
        params.add(name);
        params.add(masterID);
        return IDFinder.getID(sqlB.toString(), params, key, true, trxName);
    }

    public static int get_IDWithMaster(String tableName, String name, String tableNameMaster, int masterID, String trxName) {
        StringBuffer key = new StringBuffer();
        key.append(tableName).append(".Name=").append(name).append(" and ").append(tableNameMaster).append(".").append(tableNameMaster).append("_ID=").append(masterID);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sqlB = new StringBuffer("select ").append(tableName).append("_ID from ").append(tableName).append(" where name=? and ").append(tableNameMaster).append("_ID=?");
        params.add(name);
        params.add(masterID);
        return IDFinder.getID(sqlB.toString(), params, key.toString(), true, trxName);
    }

    public static int getIDbyColumn(String tableName, String column, String name, int AD_Client_ID, String trxName) {
        StringBuffer key = new StringBuffer();
        key.append(tableName).append("." + column + "=").append(name);
        if (!tableName.startsWith("AD_")) {
            key.append(" AND AD_Client_ID=").append(AD_Client_ID);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("SELECT ").append(tableName).append("_ID ").append("FROM ").append(tableName).append(" ").append("WHERE " + column + "=?");
        params.add(name);
        if (!tableName.startsWith("AD_")) {
            sql.append(" AND AD_Client_ID=?");
            params.add(AD_Client_ID);
        }
        return IDFinder.getID(sql.toString(), params, key.toString(), true, trxName);
    }

    public static int getIDbyName(String tableName, String name, int AD_Client_ID, String trxName) {
        return IDFinder.getIDbyColumn(tableName, "Name", name, AD_Client_ID, trxName);
    }

    public static int getIDbyValue(String tableName, String name, int AD_Client_ID, String trxName) {
        return IDFinder.getIDbyColumn(tableName, "Value", name, AD_Client_ID, trxName);
    }

    public static void clearIDCache() {
        idCache.clear();
    }

    private static int getID(String sql, List<Object> params, String key, boolean strict, String trxName) {
        if (key != null && idCache.containsKey(key)) {
            return idCache.get(key);
        }
        int id = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt(1);
            }
            if (rs.next()) {
                if (strict) {
                    throw new NonUniqueIDLookupException(key);
                }
                log.warning("Non Unique ID Lookup found for " + key);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (key != null && id > 0) {
            idCache.put(key, id);
        }
        return id;
    }
}

