/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.Util;
import org.xml.sax.Attributes;

public class PoFiller {
    private PO entity = null;
    private Attributes atts = null;
    private POInfo poInfo = null;

    public PoFiller(PO entity, Attributes atts) {
        this.entity = entity;
        this.atts = atts;
        this.poInfo = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID(), entity.get_TrxName());
    }

    public void setString(String columnName) {
        String value = this.atts.getValue(columnName);
        value = "".equals(value) ? null : value;
        this.entity.set_ValueOfColumn(columnName, (Object)value);
    }

    public void setBoolean(String columnName) {
        String value = this.atts.getValue(columnName);
        boolean bool = "true".equals(value);
        this.entity.set_ValueOfColumn(columnName, (Object)bool);
    }

    public void setAttribute(String columnName) {
        String value;
        String originalValue = value = this.atts.getValue(columnName);
        value = Util.isEmpty(value, true) ? null : value.trim();
        int index = this.poInfo.getColumnIndex(columnName);
        boolean isMandatory = this.poInfo.isColumnMandatory(index);
        boolean isKeyColumn = this.poInfo.isKey(index);
        if (isMandatory && Util.isEmpty(value)) {
            Object valueObject;
            if (!isKeyColumn && (valueObject = this.entity.getDefaultValue(index)) != null) {
                this.entity.set_ValueOfColumn(columnName, valueObject);
            }
            return;
        }
        Class<?> clazz = this.poInfo.getColumnClass(index);
        if (value == null) {
            this.entity.set_ValueOfColumn(columnName, null);
        } else if (clazz == BigDecimal.class) {
            this.entity.set_ValueOfColumn(columnName, (Object)new BigDecimal(value));
        } else if (clazz == Integer.class) {
            this.entity.set_ValueOfColumn(columnName, (Object)new BigDecimal(value).intValueExact());
        } else if (clazz == String.class) {
            this.entity.set_ValueOfColumn(columnName, (Object)originalValue);
        } else if (clazz == Boolean.class) {
            this.entity.set_ValueOfColumn(columnName, (Object)Boolean.valueOf(value));
        } else if (clazz == Timestamp.class) {
            Timestamp ts = Timestamp.valueOf(value);
            this.entity.set_ValueOfColumn(columnName, (Object)ts);
        } else {
            throw new AdempiereException("Class not supported - " + clazz);
        }
    }

    public String toString() {
        return "PO = " + this.entity + ", Attributes = " + this.atts;
    }
}

