/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.model.GenericPO;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PoFiller;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.I_AD_EntityType;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GenericPOHandler
extends AbstractElementHandler {
    private final List<String> list = new ArrayList<String>();
    public static final String TABLE_NAME_TAG = "TableNameTag";
    public static final String TABLE_ID_TAG = "TableIdTag";
    public static final String RECORD_ID_TAG = "RecordIdTag";
    public static final String TAG_Name = "GenericPO";
    public static final String HANDLE_TRANSLATION_FLAG = "2PACK_HANDLE_TRANSLATIONS";
    public static final String Column_TAG_Name = "GenericPO_AD_Column";

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String objectStatus;
        int backupId;
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        String tableName = this.getStringValue(atts, TABLE_NAME_TAG);
        int tableId = this.getIntValue(atts, TABLE_ID_TAG, -1);
        this.log.info(elementValue + " " + tableName);
        String uuid = this.getUUIDValue(atts, tableName);
        if (Util.isEmpty(uuid) || tableId == -1) {
            element.skip = true;
        }
        POInfo poInfo = POInfo.getPOInfo(ctx, tableId, this.getTrxName(ctx));
        String keyColumnName = poInfo.getKeyColumnName();
        int recordId = 0;
        if (!Util.isEmpty(keyColumnName)) {
            recordId = this.getIdFromUUID(ctx, tableName, uuid);
        }
        PO entity = null;
        boolean isTranslation = false;
        if (tableName.endsWith("_Trl")) {
            isTranslation = true;
            entity = this.getCreatePOTrl(ctx, tableName, atts, this.getTrxName(ctx));
            if (entity == null) {
                entity = new GenericPO(tableName, ctx, -1, this.getTrxName(ctx));
            }
        } else {
            entity = this.getCreatePO(ctx, tableId, recordId, this.getTrxName(ctx));
        }
        if (recordId > 0) {
            backupId = this.copyRecord(ctx, poInfo.getTableName(), entity);
            objectStatus = "Update";
        } else {
            objectStatus = "New";
            backupId = 0;
        }
        PoFiller filler = new PoFiller(entity, atts);
        entity.setIsDirectLoad(true);
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            int foreignId;
            String parentTableName;
            String parentNameUuid;
            String parentUuid;
            String columnName;
            if (poInfo.isVirtualColumn(index) || poInfo.isKey(index) && entity.get_ID() > 999999 || poInfo.isEncrypted(index) || (columnName = poInfo.getColumnName(index)).equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy") || columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID")) continue;
            if (poInfo.isColumnLookup(index) && !Util.isEmpty(parentUuid = atts.getValue(parentNameUuid = AttributeFiller.getUUIDAttribute(columnName))) && !Util.isEmpty(parentTableName = this.getParentTableName(ctx, poInfo.getAD_Column_ID(columnName), poInfo.getColumnDisplayType(index))) && (foreignId = this.getParentId(ctx, parentTableName, parentUuid)) > 0) {
                entity.set_ValueOfColumn(columnName, (Object)foreignId);
                continue;
            }
            filler.setAttribute(columnName);
        }
        try {
            this.beforeSave(entity);
            entity.saveEx(this.getTrxName(ctx));
            int originalId = entity.get_ID();
            if (isTranslation) {
                originalId = entity.get_ValueAsInt(tableName.replaceAll("_Trl", "") + "_ID");
            }
            this.recordLog(ctx, 1, entity.get_ValueAsString("UUID"), this.getTagName(entity), originalId, backupId, objectStatus, "AD_EntityType", I_AD_EntityType.Table_ID);
            this.afterSave(entity);
        }
        catch (Exception e) {
            if (backupId > 0) {
                this.recordLog(ctx, 0, entity.get_ValueAsString("UUID"), this.getTagName(entity), backupId, backupId, objectStatus, "AD_EntityType", I_AD_EntityType.Table_ID);
            }
            throw new POSaveFailedException(e);
        }
    }

    protected void beforeSave(PO entity) {
    }

    protected void afterSave(PO entity) {
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.create(ctx, document, null, true, null);
    }

    public void create(Properties ctx, TransformerHandler document, PO entity) throws SAXException {
        this.create(ctx, document, entity, false, null);
    }

    public void create(Properties ctx, TransformerHandler document, PO entity, boolean includeParents, List<String> excludedParentList) throws SAXException {
        AttributesImpl atts;
        int tableId = 0;
        int recordId = 0;
        if (entity != null) {
            tableId = entity.get_Table_ID();
            recordId = entity.get_ID();
        } else {
            tableId = Env.getContextAsInt(ctx, TABLE_ID_TAG);
            recordId = Env.getContextAsInt(ctx, RECORD_ID_TAG);
        }
        if (tableId <= 0) {
            return;
        }
        String key = tableId + "|" + recordId;
        MTable table = MTable.get(ctx, tableId);
        if (!table.getTableName().endsWith("_Trl") && this.list.contains(key)) {
            return;
        }
        this.list.add(key);
        if (entity == null) {
            entity = this.getCreatePO(ctx, tableId, recordId, null);
        }
        if (entity == null) {
            return;
        }
        if (includeParents) {
            this.createParent(ctx, document, entity, excludedParentList);
        }
        if ((atts = this.createBinding(ctx, entity)) != null) {
            document.startElement("", "", this.getTagName(entity), atts);
            document.endElement("", "", this.getTagName(entity));
        }
        this.createTranslation(ctx, document, entity);
    }

    private void createParent(Properties ctx, TransformerHandler document, PO entity, List<String> excludedParentList) throws SAXException {
        POInfo poInfo = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID());
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            PO parentEntity;
            int referenceId;
            String parentTableName;
            String columnName;
            if (poInfo.isVirtualColumn(index) || poInfo.isEncrypted(index) || (columnName = poInfo.getColumnName(index)).equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy") || columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || Util.isEmpty(parentTableName = this.getParentTableName(ctx, poInfo.getAD_Column_ID(columnName), poInfo.getColumnDisplayType(index))) || (referenceId = entity.get_ValueAsInt(columnName)) <= 0 || excludedParentList != null && excludedParentList.contains(parentTableName) || (parentEntity = MTable.get(ctx, parentTableName).getPO(referenceId, null)) == null || parentEntity.get_ID() <= 0 || !this.isValidAccess(MTable.get(ctx, entity.get_Table_ID()).getAccessLevel(), MTable.get(ctx, parentEntity.get_Table_ID()).getAccessLevel())) continue;
            this.create(ctx, document, parentEntity, true, excludedParentList);
        }
    }

    private boolean isValidAccess(String accessLevel, String parentAccessLevel) {
        return !parentAccessLevel.equals("4") && !parentAccessLevel.equals("6") || accessLevel.equals("4") || accessLevel.equals("6");
    }

    private String getTagName(PO entity) {
        return "GenericPO_" + entity.get_TableName();
    }

    private PO getCreatePO(Properties ctx, int tableId, int recordId, String trxName) {
        return MTable.get(ctx, tableId).getPO(recordId, trxName);
    }

    private PO getCreatePOTrl(Properties ctx, String tableName, Attributes atts, String trxName) {
        String parentKey = tableName.replaceAll("_Trl", "") + "_ID";
        String uuid = this.getUUIDValue(atts, tableName);
        String language = atts.getValue("AD_Language");
        int parentId = Integer.parseInt(atts.getValue(parentKey));
        return new Query(ctx, tableName, "UUID = ? OR (" + parentKey + " = ? AND AD_Language = ?)", trxName).setParameters(uuid, parentId, language).first();
    }

    private AttributesImpl createBinding(Properties ctx, PO entity) {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        POInfo poInfo = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID());
        AttributeFiller filler = new AttributeFiller(atts, entity);
        filler.addUUID();
        filler.addString(TABLE_NAME_TAG, entity.get_TableName());
        filler.addInt(TABLE_ID_TAG, entity.get_Table_ID());
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            String columnName;
            if (poInfo.isVirtualColumn(index) || poInfo.isKey(index) && entity.get_ID() > 999999 || poInfo.isEncrypted(index) || (columnName = poInfo.getColumnName(index)).equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy") || columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID")) continue;
            filler.add(columnName);
            String foreignUuid = this.getParentUuid(ctx, poInfo.getAD_Column_ID(columnName), poInfo.getColumnDisplayType(index), columnName, entity);
            if (Util.isEmpty(foreignUuid)) continue;
            filler.addString(AttributeFiller.getUUIDAttribute(columnName), foreignUuid);
        }
        return atts;
    }

    private String getParentTableName(Properties ctx, int columnId, int displayType) {
        if (!DisplayType.isLookup(displayType)) {
            return null;
        }
        if (17 == displayType) {
            return null;
        }
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, 0, columnId, displayType);
        if (info == null) {
            return null;
        }
        return info.TableName;
    }

    private String getParentUuid(Properties ctx, int columnId, int displayType, String columnName, PO entity) {
        String parentTableName = this.getParentTableName(ctx, columnId, displayType);
        if (Util.isEmpty(parentTableName)) {
            return null;
        }
        int foreignId = entity.get_ValueAsInt(columnName);
        String referenceUuid = this.getUUIDFromId(ctx, parentTableName, foreignId);
        if (Util.isEmpty(referenceUuid)) {
            return null;
        }
        return referenceUuid;
    }

    private int getParentId(Properties ctx, String parentTableName, String uuid) {
        if (Util.isEmpty(parentTableName)) {
            return -1;
        }
        return this.getIdFromUUID(ctx, parentTableName, uuid);
    }

    public void createTranslation(Properties ctx, TransformerHandler document, PO entity) throws SAXException {
        if (!MSysConfig.getBooleanValue(HANDLE_TRANSLATION_FLAG, false)) {
            return;
        }
        String tableName = entity.get_TableName() + "_Trl";
        MTable table = MTable.get(ctx, tableName);
        if (table == null || Util.isEmpty(table.getTableName())) {
            return;
        }
        String whereClause = entity.get_TableName() + "_ID = ? AND EXISTS(SELECT 1 FROM AD_Language l WHERE l.AD_Language = " + tableName + ".AD_Language AND l.IsSystemLanguage = ? AND l.IsBaseLanguage = ?)";
        List translationList = new Query(ctx, tableName, whereClause, null).setParameters(entity.get_ID(), true, false).setOnlyActiveRecords(true).list();
        for (PO translation : translationList) {
            this.create(ctx, document, translation);
        }
    }
}

