/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MMenu;
import org.compiere.model.MTree;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.X_AD_Menu;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MenuElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        MTree tree;
        MTree_NodeMM treeNode;
        int detailId;
        String action;
        int id;
        String elementValue = element.getElementValue();
        int backupId = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        String uuid = this.getUUIDValue(atts, "AD_Menu");
        this.log.info(elementValue + " " + uuid);
        int menuId = this.getIdFromUUID(ctx, "AD_Menu", uuid);
        X_AD_Menu menu = new X_AD_Menu(ctx, menuId, this.getTrxName(ctx));
        if (menuId <= 0 && this.getIntValue(atts, "AD_Menu_ID") > 0 && this.getIntValue(atts, "AD_Menu_ID") <= 999999) {
            menu.setAD_Menu_ID(this.getIntValue(atts, "AD_Menu_ID"));
        }
        if (menuId > 0) {
            backupId = this.copyRecord(ctx, "AD_Menu", menu);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            backupId = 0;
        }
        menu.setIsDirectLoad(true);
        menu.setUUID(uuid);
        menu.setName(atts.getValue("Name"));
        uuid = this.getUUIDValue(atts, "AD_Window_ID");
        if (!Util.isEmpty(uuid)) {
            id = this.getIdFromUUID(ctx, "AD_Window", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Window_ID(id);
        }
        if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Process_ID"))) {
            id = this.getIdFromUUID(ctx, "AD_Process", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Process_ID(id);
        }
        if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Form_ID"))) {
            id = this.getIdFromUUID(ctx, "AD_Form", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Form_ID(id);
        }
        if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Browse_ID"))) {
            id = this.getIdFromUUID(ctx, "AD_Browse", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Browse_ID(id);
        }
        if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Task_ID"))) {
            id = this.getIdFromUUID(ctx, "AD_Task", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Task_ID(id);
        }
        if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Workbench_ID"))) {
            id = this.getIdFromUUID(ctx, "AD_Workbench", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Workbench_ID(id);
        }
        if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Workflow_ID"))) {
            id = this.getIdFromUUID(ctx, "AD_Workflow", uuid);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            menu.setAD_Workflow_ID(id);
        }
        String string = action = atts.getValue("Action") != null ? atts.getValue("Action") : " ";
        if (action.compareTo(" ") > -1) {
            menu.setAction(action);
        }
        menu.setDescription(this.getStringValue(atts, "Description"));
        menu.setEntityType(this.getStringValue(atts, "EntityType"));
        menu.setIsReadOnly(this.getBooleanValue(atts, "IsReadOnly"));
        menu.setIsSOTrx(this.getBooleanValue(atts, "IsSOTrx"));
        menu.setIsSummary(this.getBooleanValue(atts, "IsSummary"));
        menu.setIsActive(this.getBooleanValue(atts, "IsActive"));
        try {
            menu.saveEx(this.getTrxName(ctx));
            detailId = this.recordLog(ctx, 1, menu.getUUID(), "Menu", menu.get_ID(), backupId, Object_Status, "AD_Menu", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Menu"));
        }
        catch (Exception e) {
            int detailId2 = this.recordLog(ctx, 0, menu.getUUID(), "Menu", menu.get_ID(), backupId, Object_Status, "AD_Menu", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Menu"));
            throw new POSaveFailedException(e);
        }
        uuid = this.getUUIDValue(atts, "Parent_ID");
        int parentId = this.getIdFromUUID(ctx, "AD_Menu", uuid);
        int defaultTreeId = MTree.getDefaultTreeIdFromTableId(menu.getAD_Client_ID(), I_AD_Menu.Table_ID);
        String sqlCounter = "SELECT count(Parent_ID) FROM AD_TREENODEMM WHERE AD_Tree_ID = " + defaultTreeId + " AND Node_ID = " + menuId;
        int countRecords = DB.getSQLValue(this.getTrxName(ctx), sqlCounter);
        if (countRecords > 0) {
            StringBuffer sqlColumn = new StringBuffer("select * from AD_TREENODEMM where AD_Tree_ID = 10 and  Node_ID =?");
            try {
                CPreparedStatement pstmt1 = DB.prepareStatement(sqlColumn.toString(), this.getTrxName(ctx));
                pstmt1.setInt(1, menuId);
                ResultSet rs1 = pstmt1.executeQuery();
                if (rs1.next()) {
                    String colValue = null;
                    ResultSetMetaData meta = rs1.getMetaData();
                    int columns = meta.getColumnCount();
                    int tableId = this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_TreeNodeMM");
                    for (int q = 1; q <= columns; ++q) {
                        String col_Name = meta.getColumnName(q);
                        StringBuffer sql = new StringBuffer("SELECT AD_Column_ID FROM AD_column WHERE Upper(ColumnName) = '" + col_Name + "' AND AD_Table_ID = ?");
                        int columnId = DB.getSQLValue(this.getTrxName(ctx), sql.toString(), tableId);
                        sql = new StringBuffer("SELECT AD_Reference_ID FROM AD_COLUMN WHERE AD_Column_ID = " + (columnId == -1 ? "null" : Integer.valueOf(columnId)));
                        int referenceId = DB.getSQLValue(this.getTrxName(ctx), sql.toString());
                        int idBackup = DB.getNextID(Env.getAD_Client_ID(ctx), "AD_Package_Imp_Backup", this.getTrxName(ctx));
                        colValue = referenceId == 20 || referenceId == 28 ? (rs1.getObject(q).equals("Y") ? "true" : "false") : rs1.getObject(q).toString();
                        StringBuffer sqlD = new StringBuffer("INSERT INTO AD_Package_Imp_Backup(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, AD_PACKAGE_IMP_BACKUP_ID, AD_PACKAGE_IMP_DETAIL_ID, AD_PACKAGE_IMP_ID, AD_TABLE_ID, AD_COLUMN_ID, AD_REFERENCE_ID, COLVALUE)VALUES( " + Env.getAD_Client_ID(ctx) + ", " + Env.getAD_Org_ID(ctx) + ", " + Env.getAD_User_ID(ctx) + ", " + Env.getAD_User_ID(ctx) + ", " + idBackup + ", " + detailId + ", " + this.getPackageImpId(ctx) + ", " + tableId + ", " + (columnId == -1 ? "null" : Integer.valueOf(columnId)) + ", " + (referenceId == -1 ? "null" : Integer.valueOf(referenceId)) + ", '" + colValue + "')");
                        int no = DB.executeUpdate(sqlD.toString(), this.getTrxName(ctx));
                        if (no != -1) continue;
                        this.log.info("Insert to import backup failed");
                    }
                }
                rs1.close();
                pstmt1.close();
                pstmt1 = null;
            }
            catch (Exception e) {
                this.log.info("get_IDWithMasterID:" + e);
            }
        }
        if ((treeNode = MTree_NodeMM.get(tree = MTree.get(ctx, defaultTreeId, this.getTrxName(ctx)), menu.getAD_Menu_ID())) == null) {
            treeNode = new MTree_NodeMM(tree, menu.getAD_Menu_ID());
        }
        treeNode.setSeqNo(Integer.valueOf(atts.getValue("SeqNo")));
        treeNode.setParent_ID(parentId);
        treeNode.saveEx();
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int menuId = Env.getContextAsInt(ctx, "AD_Menu_ID");
        this.createApplication(ctx, document, menuId);
    }

    private AttributesImpl createMenuBinding(AttributesImpl atts, X_AD_Menu menu) {
        atts.clear();
        AttributeFiller filler = new AttributeFiller(atts, menu);
        filler.add("AD_Menu_ID");
        filler.addUUID();
        if (menu.getAD_Window_ID() > 0) {
            filler.add("AD_Window_ID", true);
            filler.addUUID("AD_Window_ID", this.getUUIDFromId(menu.getCtx(), "AD_Window", menu.getAD_Window_ID()));
        }
        if (menu.getAD_Process_ID() > 0) {
            filler.add("AD_Process_ID", true);
            filler.addUUID("AD_Process_ID", this.getUUIDFromId(menu.getCtx(), "AD_Process", menu.getAD_Process_ID()));
        }
        if (menu.getAD_Form_ID() > 0) {
            filler.add("AD_Form_ID", true);
            filler.addUUID("AD_Form_ID", this.getUUIDFromId(menu.getCtx(), "AD_Form", menu.getAD_Form_ID()));
        }
        if (menu.getAD_Browse_ID() > 0) {
            filler.add("AD_Browse_ID", true);
            filler.addUUID("AD_Browse_ID", this.getUUIDFromId(menu.getCtx(), "AD_Browse", menu.getAD_Browse_ID()));
        }
        if (menu.getAD_Task_ID() > 0) {
            filler.add("AD_Task_ID", true);
            filler.addUUID("AD_Task_ID", this.getUUIDFromId(menu.getCtx(), "AD_Task", menu.getAD_Task_ID()));
        }
        if (menu.getAD_Workbench_ID() > 0) {
            filler.add("AD_Workbench_ID", true);
            filler.addUUID("AD_Workbench_ID", this.getUUIDFromId(menu.getCtx(), "AD_Workbench", menu.getAD_Workbench_ID()));
        }
        if (menu.getAD_Workflow_ID() > 0) {
            filler.add("AD_Workflow_ID", true);
            filler.addUUID("AD_Workflow_ID", this.getUUIDFromId(menu.getCtx(), "AD_Workflow", menu.getAD_Workflow_ID()));
        }
        filler.add("Name");
        filler.add("Action");
        filler.add("Description");
        filler.add("EntityType");
        filler.add("IsActive");
        filler.add("IsReadOnly");
        filler.add("IsSOTrx");
        filler.add("IsSummary");
        int defaultTreeId = MTree.getDefaultTreeIdFromTableId(menu.getAD_Client_ID(), I_AD_Menu.Table_ID);
        MTree_NodeMM node = MTree_NodeMM.get(MTree.get(Env.getCtx(), defaultTreeId, null), menu.getAD_Menu_ID());
        if (node.getParent_ID() > 0) {
            MMenu parent = MMenu.getFromId(Env.getCtx(), node.getParent_ID());
            filler.addUUID("Parent_ID", parent.getUUID());
        }
        filler.addInt("SeqNo", node.getSeqNo());
        return atts;
    }

    private void createApplication(Properties ctx, TransformerHandler document, int menuId) throws SAXException {
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        AttributesImpl atts = new AttributesImpl();
        X_AD_Menu menu = new X_AD_Menu(ctx, menuId, null);
        atts = this.createMenuBinding(atts, menu);
        document.startElement("", "", "menu", atts);
        if (menu.isSummary()) {
            int[] ids;
            int defaultTreeId = MTree.getDefaultTreeIdFromTableId(menu.getAD_Client_ID(), I_AD_Menu.Table_ID);
            String childSQL = "SELECT m.AD_Menu_ID FROM AD_Menu m WHERE EXISTS(SELECT 1 FROM AD_TreeNodeMM tnm \t\t\tWHERE tnm.Node_ID = m.AD_Menu_ID \t\t\tAND tnm.AD_Tree_ID = " + defaultTreeId + " \t\t\tAND tnm.Parent_ID = ?)";
            for (int id : ids = DB.getIDsEx(null, childSQL, menu.getAD_Menu_ID())) {
                this.createApplication(ctx, document, id);
            }
        } else if (menu.getAD_Window_ID() > 0 || menu.getAD_Workflow_ID() > 0 || menu.getAD_Task_ID() > 0 || menu.getAD_Process_ID() > 0 || menu.getAD_Form_ID() > 0 || menu.getAD_Browse_ID() > 0 || menu.getAD_Workbench_ID() > 0) {
            if (menu.getAD_Window_ID() > 0) {
                packOut.createWindow(menu.getAD_Window_ID(), document);
            } else if (menu.getAD_Process_ID() > 0) {
                packOut.createProcess(menu.getAD_Process_ID(), document);
            } else if (menu.getAD_Task_ID() > 0) {
                packOut.createTask(menu.getAD_Task_ID(), document);
            } else if (menu.getAD_Form_ID() > 0) {
                packOut.createForm(menu.getAD_Form_ID(), document);
            } else if (menu.getAD_Browse_ID() > 0) {
                packOut.createBrowse(menu.getAD_Browse_ID(), document);
            } else if (menu.getAD_Workflow_ID() > 0) {
                packOut.createWorkflow(menu.getAD_Workflow_ID(), document);
            }
        }
        document.endElement("", "", "menu");
    }
}

