/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.WorkflowNodeElementHandler;
import org.adempiere.pipo.handler.WorkflowNodeNextConditionElementHandler;
import org.adempiere.pipo.handler.WorkflowNodeNextElementHandler;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Workflow;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowElementHandler
extends AbstractElementHandler {
    private WorkflowNodeElementHandler nodeHandler = new WorkflowNodeElementHandler();
    private WorkflowNodeNextElementHandler nodeNextHandler = new WorkflowNodeNextElementHandler();
    private WorkflowNodeNextConditionElementHandler nextConditionHandler = new WorkflowNodeNextConditionElementHandler();
    private List<Integer> workflows = new ArrayList<Integer>();

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String uuid = this.getUUIDValue(atts, "AD_Workflow");
        this.log.info(uuid);
        String entitytype = this.getStringValue(atts, "EntityType");
        if (this.isProcessElement(ctx, entitytype)) {
            int id = this.getIdFromUUID(ctx, "AD_Workflow", uuid);
            if (id > 0 && this.workflows.contains(id)) {
                element.skip = true;
                return;
            }
            X_AD_Workflow workflow = new X_AD_Workflow(ctx, id, this.getTrxName(ctx));
            int backupId = -1;
            String objectStatus = null;
            if (id <= 0 && this.getIntValue(atts, "AD_Workflow_ID") > 0 && this.getIntValue(atts, "AD_Workflow_ID") <= 999999) {
                workflow.setAD_Workflow_ID(this.getIntValue(atts, "AD_Workflow_ID"));
                workflow.setIsDirectLoad(true);
            }
            if (id > 0) {
                backupId = this.copyRecord(ctx, "AD_Workflow", workflow);
                objectStatus = "Update";
            } else {
                objectStatus = "New";
                backupId = 0;
            }
            workflow.setUUID(uuid);
            uuid = this.getUUIDValue(atts, "AD_Table_ID");
            if (!Util.isEmpty(uuid)) {
                id = this.getIdFromUUID(ctx, "AD_Table", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                workflow.setAD_Table_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_WF_Responsible_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_WF_Responsible", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                workflow.setAD_WF_Responsible_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_WorkflowProcessor_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_WorkflowProcessor", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                workflow.setAD_WorkflowProcessor_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "S_Resource_ID"))) {
                id = this.getIdFromUUID(ctx, "S_Resource", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                workflow.setS_Resource_ID(id);
            }
            workflow.setValue(this.getStringValue(atts, "Value"));
            workflow.setName(this.getStringValue(atts, "Name"));
            workflow.setDescription(this.getStringValue(atts, "Description"));
            workflow.setHelp(this.getStringValue(atts, "Help"));
            workflow.setAccessLevel(this.getStringValue(atts, "AccessLevel"));
            workflow.setAuthor(this.getStringValue(atts, "Author"));
            workflow.setCost(this.getBigDecimalValue(atts, "Cost"));
            String documentNo = this.getStringValue(atts, "DocumentNo");
            workflow.setDocumentNo(documentNo == null ? "" : documentNo);
            workflow.setDocValueLogic(this.getStringValue(atts, "DocValueLogic"));
            workflow.setDuration(this.getIntValue(atts, "Duration"));
            workflow.setDurationUnit(this.getStringValue(atts, "DurationUnit"));
            workflow.setEntityType(this.getStringValue(atts, "EntityType"));
            workflow.setIsActive(this.getBooleanValue(atts, "IsActive"));
            workflow.setIsBetaFunctionality(this.getBooleanValue(atts, "IsBetaFunctionality"));
            workflow.setIsDefault(this.getBooleanValue(atts, "IsDefault"));
            workflow.setIsValid(this.getBooleanValue(atts, "IsValid"));
            workflow.setLimit(this.getIntValue(atts, "Limit"));
            workflow.setMovingTime(this.getIntValue(atts, "MovingTime"));
            workflow.setOverlapUnits(this.getBigDecimalValue(atts, "OverlapUnits"));
            workflow.setPriority(this.getIntValue(atts, "Priority"));
            workflow.setProcessType(this.getStringValue(atts, "ProcessType"));
            workflow.setPublishStatus(this.getStringValue(atts, "PublishStatus"));
            workflow.setQtyBatchSize(this.getBigDecimalValue(atts, "QtyBatchSize"));
            workflow.setQueuingTime(this.getIntValue(atts, "QueuingTime"));
            workflow.setSetupTime(this.getIntValue(atts, "SetupTime"));
            workflow.setUnitsCycles(this.getBigDecimalValue(atts, "UnitsCycles"));
            workflow.setValidFrom(this.getTimestampValue(atts, "ValidFrom"));
            workflow.setValidTo(this.getTimestampValue(atts, "ValidTo"));
            workflow.setVersion(this.getIntValue(atts, "Version"));
            workflow.setWaitingTime(this.getIntValue(atts, "WaitingTime"));
            workflow.setWorkflowType(this.getStringValue(atts, "WorkflowType"));
            workflow.setWorkingTime(this.getIntValue(atts, "WorkingTime"));
            workflow.setYield(this.getIntValue(atts, "Yield"));
            workflow.setAD_WF_Node_ID(-1);
            try {
                workflow.saveEx(this.getTrxName(ctx));
                this.recordLog(ctx, 1, workflow.getUUID(), "Workflow", workflow.get_ID(), backupId, objectStatus, "AD_Workflow", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Workflow"));
                this.workflows.add(workflow.getAD_Workflow_ID());
                element.recordId = workflow.getAD_Workflow_ID();
            }
            catch (Exception e) {
                this.recordLog(ctx, 0, workflow.getUUID(), "Workflow", workflow.get_ID(), backupId, objectStatus, "AD_Workflow", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Workflow"));
                throw new POSaveFailedException(e);
            }
        } else {
            element.skip = true;
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
        Attributes atts;
        String name;
        if (!element.defer && !element.skip && element.recordId > 0 && (name = (atts = element.attributes).getValue("ADWorkflowNodeNameID")) != null && name.trim().length() > 0) {
            MWorkflow m_Workflow = new MWorkflow(ctx, element.recordId, this.getTrxName(ctx));
            int id = this.get_IDWithMasterAndColumn(ctx, "AD_WF_Node", "Name", name, "AD_Workflow", m_Workflow.getAD_Workflow_ID());
            if (id <= 0) {
                this.log.warning("Failed to resolve start node reference for workflow element. Workflow=" + m_Workflow.getUUID() + " StartNode=" + name);
                return;
            }
            m_Workflow.setAD_WF_Node_ID(id);
            if (m_Workflow.save(this.getTrxName(ctx))) {
                this.log.info("m_Workflow update success");
                this.recordLog(ctx, 1, m_Workflow.getUUID(), "Workflow", m_Workflow.get_ID(), 0, "Update", "AD_Workflow", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Workflow"));
                this.workflows.add(m_Workflow.getAD_Workflow_ID());
                element.recordId = m_Workflow.getAD_Workflow_ID();
            } else {
                this.log.info("m_Workflow update fail");
                this.recordLog(ctx, 0, m_Workflow.getName(), "Workflow", m_Workflow.get_ID(), 0, "Update", "AD_Workflow", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Workflow"));
                throw new POSaveFailedException("MWorkflow");
            }
        }
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        MWFNode[] nodes;
        int workflowId = Env.getContextAsInt(ctx, "AD_Workflow_ID");
        if (this.workflows.contains(workflowId)) {
            return;
        }
        this.workflows.add(workflowId);
        AttributesImpl atts = new AttributesImpl();
        MWorkflow workflow = new MWorkflow(ctx, workflowId, null);
        this.createWorkflowBinding(atts, workflow);
        document.startElement("", "", "workflow", atts);
        for (MWFNode node : nodes = workflow.getNodes(true, Env.getAD_Client_ID(ctx))) {
            this.createNode(ctx, document, node.getAD_WF_Node_ID());
            List nextNodeList = new Query(ctx, "AD_WF_NodeNext", "AD_WF_Node_ID = ?", null).setParameters(node.getAD_WF_Node_ID()).setClient_ID().list();
            for (MWFNodeNext nextNode : nextNodeList) {
                this.createNodeNext(ctx, document, nextNode.getAD_WF_NodeNext_ID());
                List nextConditionList = new Query(ctx, "AD_WF_NextCondition", "AD_WF_NodeNext_ID = ?", null).setParameters(nextNode.getAD_WF_NodeNext_ID()).setClient_ID().list();
                for (MWFNextCondition nextCondition : nextConditionList) {
                    this.createNodeNextCondition(ctx, document, nextCondition.getAD_WF_NextCondition_ID());
                }
            }
        }
        document.endElement("", "", "workflow");
    }

    private void createNodeNextCondition(Properties ctx, TransformerHandler document, int nodeNextConditionId) throws SAXException {
        Env.setContext(ctx, "AD_WF_NextCondition_ID", nodeNextConditionId);
        this.nextConditionHandler.create(ctx, document);
        ctx.remove("AD_WF_NextCondition_ID");
    }

    private void createNodeNext(Properties ctx, TransformerHandler document, int nodeNextId) throws SAXException {
        Env.setContext(ctx, "AD_WF_NodeNext_ID", nodeNextId);
        this.nodeNextHandler.create(ctx, document);
        ctx.remove("AD_WF_NodeNext_ID");
    }

    private void createNode(Properties ctx, TransformerHandler document, int nodeId) throws SAXException {
        Env.setContext(ctx, "AD_WF_Node_ID", nodeId);
        this.nodeHandler.create(ctx, document);
        ctx.remove("AD_WF_Node_ID");
    }

    private AttributesImpl createWorkflowBinding(AttributesImpl atts, X_AD_Workflow workflow) {
        atts.clear();
        AttributeFiller filler = new AttributeFiller(atts, workflow);
        if (workflow.getAD_Workflow_ID() <= 999999) {
            filler.add("AD_Workflow_ID");
        }
        filler.addUUID();
        if (workflow.getAD_Table_ID() > 0) {
            filler.add("AD_Table_ID", true);
            filler.addUUID("AD_Table_ID", this.getUUIDFromId(workflow.getCtx(), "AD_Table", workflow.getAD_Table_ID()));
        }
        if (workflow.getAD_WF_Node_ID() > 0) {
            filler.add("AD_WF_Node_ID", true);
            filler.addUUID("AD_WF_Node_ID", this.getUUIDFromId(workflow.getCtx(), "AD_WF_Node", workflow.getAD_WF_Node_ID()));
        }
        if (workflow.getAD_WF_Responsible_ID() > 0) {
            filler.add("AD_WF_Responsible_ID", true);
            filler.addUUID("AD_WF_Responsible_ID", this.getUUIDFromId(workflow.getCtx(), "AD_WF_Responsible", workflow.getAD_WF_Responsible_ID()));
        }
        if (workflow.getAD_WorkflowProcessor_ID() > 0) {
            filler.add("AD_WorkflowProcessor_ID", true);
            filler.addUUID("AD_WorkflowProcessor_ID", this.getUUIDFromId(workflow.getCtx(), "AD_WorkflowProcessor", workflow.getAD_WorkflowProcessor_ID()));
        }
        if (workflow.getS_Resource_ID() > 0) {
            filler.add("S_Resource_ID", true);
            filler.addUUID("S_Resource_ID", this.getUUIDFromId(workflow.getCtx(), "S_Resource", workflow.getS_Resource_ID()));
        }
        filler.add("Value");
        filler.add("Name");
        filler.add("Description");
        filler.add("Help");
        filler.add("AccessLevel");
        filler.add("Author");
        filler.add("Cost");
        filler.add("DocumentNo");
        filler.add("DocValueLogic");
        filler.add("Duration");
        filler.add("DurationUnit");
        filler.add("EntityType");
        filler.add("IsActive");
        filler.add("IsBetaFunctionality");
        filler.add("IsDefault");
        filler.add("IsValid");
        filler.add("Limit");
        filler.add("MovingTime");
        filler.add("OverlapUnits");
        filler.add("Priority");
        filler.add("ProcessType");
        filler.add("PublishStatus");
        filler.add("QtyBatchSize");
        filler.add("QueuingTime");
        filler.add("SetupTime");
        filler.add("UnitsCycles");
        filler.add("ValidFrom");
        filler.add("ValidTo");
        filler.add("Version");
        filler.add("WaitingTime");
        filler.add("WorkflowType");
        filler.add("WorkingTime");
        filler.add("Yield");
        return atts;
    }
}

