/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String elementValue = element.getElementValue();
        String uuid = this.getUUIDValue(atts, "AD_WF_Node");
        String workflowUuid = this.getUUIDValue(atts, "AD_Window_ID");
        this.log.info(elementValue + " " + uuid);
        String entitytype = this.getStringValue(atts, "EntityType");
        if (this.isProcessElement(ctx, entitytype)) {
            if (element.parent != null && element.parent.skip) {
                element.skip = true;
                return;
            }
            if (element.parent != null && element.parent.getElementValue().equals("workflow") && element.parent.defer) {
                element.unresolved = "Parent element mark as defer: " + workflowUuid;
                element.defer = true;
                return;
            }
            int workflowId = 0;
            if (element.parent != null && element.parent.getElementValue().equals("workflow") && element.parent.recordId > 0) {
                workflowId = element.parent.recordId;
            } else {
                workflowId = this.getIdFromUUID(ctx, "AD_WF_Node", workflowUuid);
                if (workflowId <= 0) {
                    element.defer = true;
                    element.unresolved = "AD_Workflow: " + workflowUuid;
                    return;
                }
                if (element.parent != null && element.parent.getElementValue().equals("workflow")) {
                    element.parent.recordId = workflowId;
                }
            }
            int id = this.getIdFromUUID(ctx, "AD_WF_Node", uuid);
            X_AD_WF_Node wFNode = new X_AD_WF_Node(ctx, id, this.getTrxName(ctx));
            int backupId = -1;
            String objectStatus = null;
            if (id <= 0 && this.getIntValue(atts, "AD_WF_Node_ID") > 0 && this.getIntValue(atts, "AD_WF_Node_ID") <= 999999) {
                wFNode.setAD_WF_Node_ID(this.getIntValue(atts, "AD_WF_Node_ID"));
                wFNode.setIsDirectLoad(true);
            }
            if (id > 0) {
                backupId = this.copyRecord(ctx, "AD_WF_Node", wFNode);
                objectStatus = "Update";
            } else {
                objectStatus = "New";
                backupId = 0;
            }
            wFNode.setUUID(uuid);
            uuid = this.getUUIDValue(atts, "AD_Workflow_ID");
            if (!Util.isEmpty(uuid)) {
                id = this.getIdFromUUID(ctx, "AD_Workflow", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Workflow_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Window_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_Window", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Window_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Task_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_Task", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Task_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Process_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_WF_Process", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Process_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Form_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_Form", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Form_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Browse_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_Browse", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Browse_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_WF_Block_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_WF_Block", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_WF_Block_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_WF_Responsible_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_WF_Responsible", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_WF_Responsible_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Image_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_Image", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Image_ID(id);
            }
            if (!Util.isEmpty(uuid = this.getUUIDValue(atts, "AD_Column_ID"))) {
                id = this.getIdFromUUID(ctx, "AD_Column", uuid);
                if (id <= 0) {
                    element.defer = true;
                    return;
                }
                wFNode.setAD_Column_ID(id);
            }
            wFNode.setValue(this.getStringValue(atts, "Value"));
            wFNode.setName(this.getStringValue(atts, "Name"));
            wFNode.setDescription(this.getStringValue(atts, "Description"));
            wFNode.setHelp(this.getStringValue(atts, "Help"));
            wFNode.setAction(this.getStringValue(atts, "Action"));
            wFNode.setAttributeName(this.getStringValue(atts, "AttributeName"));
            wFNode.setAttributeValue(this.getStringValue(atts, "AttributeValue"));
            wFNode.setCost(this.getBigDecimalValue(atts, "Cost"));
            wFNode.setDocAction(this.getStringValue(atts, "DocAction"));
            wFNode.setDuration(this.getIntValue(atts, "Duration"));
            wFNode.setDynPriorityChange(this.getBigDecimalValue(atts, "DynPriorityChange"));
            wFNode.setDynPriorityUnit(this.getStringValue(atts, "DynPriorityUnit"));
            wFNode.setEMail(this.getStringValue(atts, "EMail"));
            wFNode.setEMailRecipient(this.getStringValue(atts, "EMailRecipient"));
            wFNode.setEntityType(this.getStringValue(atts, "EntityType"));
            wFNode.setFinishMode(this.getStringValue(atts, "FinishMode"));
            wFNode.setIsActive(this.getBooleanValue(atts, "IsActive"));
            wFNode.setIsCentrallyMaintained(this.getBooleanValue(atts, "IsCentrallyMaintained"));
            wFNode.setIsMilestone(this.getBooleanValue(atts, "IsMilestone"));
            wFNode.setIsSubcontracting(this.getBooleanValue(atts, "IsSubcontracting"));
            wFNode.setJoinElement(this.getStringValue(atts, "JoinElement"));
            wFNode.setLimit(this.getIntValue(atts, "Limit"));
            wFNode.setMovingTime(this.getIntValue(atts, "MovingTime"));
            wFNode.setOverlapUnits(this.getIntValue(atts, "OverlapUnits"));
            wFNode.setPriority(this.getIntValue(atts, "Priority"));
            wFNode.setQueuingTime(this.getIntValue(atts, "QueuingTime"));
            wFNode.setSetupTime(this.getIntValue(atts, "SetupTime"));
            wFNode.setSplitElement(this.getStringValue(atts, "SplitElement"));
            wFNode.setStartMode(this.getStringValue(atts, "StartMode"));
            wFNode.setSubflowExecution(this.getStringValue(atts, "SubflowExecution"));
            wFNode.setUnitsCycles(this.getBigDecimalValue(atts, "UnitsCycles"));
            wFNode.setValidFrom(this.getTimestampValue(atts, "ValidFrom"));
            wFNode.setValidTo(this.getTimestampValue(atts, "ValidTo"));
            wFNode.setWaitingTime(this.getIntValue(atts, "WaitingTime"));
            wFNode.setWaitTime(this.getIntValue(atts, "WaitTime"));
            wFNode.setWorkingTime(this.getIntValue(atts, "WorkingTime"));
            wFNode.setXPosition(this.getIntValue(atts, "XPosition"));
            wFNode.setYield(this.getIntValue(atts, "Yield"));
            wFNode.setYPosition(this.getIntValue(atts, "YPosition"));
            try {
                wFNode.saveEx(this.getTrxName(ctx));
                this.log.info("m_WFNode save success");
                this.recordLog(ctx, 1, wFNode.getName(), "WFNode", wFNode.get_ID(), backupId, objectStatus, "AD_WF_Node", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_Node"));
            }
            catch (Exception e) {
                this.log.info("m_WFNode save failure");
                this.recordLog(ctx, 0, wFNode.getName(), "WFNode", wFNode.get_ID(), backupId, objectStatus, "AD_WF_Node", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_Node"));
                throw new POSaveFailedException(e);
            }
        } else {
            element.skip = true;
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int nodeId = Env.getContextAsInt(ctx, "AD_WF_Node_ID");
        AttributesImpl atts = new AttributesImpl();
        X_AD_WF_Node m_WF_Node = new X_AD_WF_Node(ctx, nodeId, this.getTrxName(ctx));
        this.createWorkflowNodeBinding(atts, m_WF_Node);
        document.startElement("", "", "workflowNode", atts);
        document.endElement("", "", "workflowNode");
    }

    private AttributesImpl createWorkflowNodeBinding(AttributesImpl atts, X_AD_WF_Node node) {
        atts.clear();
        AttributeFiller filler = new AttributeFiller(atts, node);
        if (node.getAD_WF_Node_ID() <= 999999) {
            filler.add("AD_WF_Node_ID");
        }
        filler.addUUID();
        if (node.getAD_Workflow_ID() > 0) {
            filler.add("AD_Workflow_ID", true);
            filler.addUUID("AD_Workflow_ID", this.getUUIDFromId(node.getCtx(), "AD_Workflow", node.getAD_Workflow_ID()));
        }
        if (node.getAD_Window_ID() > 0) {
            filler.add("AD_Window_ID", true);
            filler.addUUID("AD_Window_ID", this.getUUIDFromId(node.getCtx(), "AD_Window", node.getAD_Window_ID()));
        }
        if (node.getAD_Task_ID() > 0) {
            filler.add("AD_Task_ID", true);
            filler.addUUID("AD_Task_ID", this.getUUIDFromId(node.getCtx(), "AD_Task", node.getAD_Task_ID()));
        }
        if (node.getAD_Process_ID() > 0) {
            filler.add("AD_Process_ID", true);
            filler.addUUID("AD_Process_ID", this.getUUIDFromId(node.getCtx(), "AD_Process", node.getAD_Process_ID()));
        }
        if (node.getAD_Form_ID() > 0) {
            filler.add("AD_Form_ID", true);
            filler.addUUID("AD_Form_ID", this.getUUIDFromId(node.getCtx(), "AD_Form", node.getAD_Form_ID()));
        }
        if (node.getAD_Browse_ID() > 0) {
            filler.add("AD_Browse_ID", true);
            filler.addUUID("AD_Browse_ID", this.getUUIDFromId(node.getCtx(), "AD_Browse", node.getAD_Browse_ID()));
        }
        if (node.getAD_WF_Block_ID() > 0) {
            filler.add("AD_WF_Block_ID", true);
            filler.addUUID("AD_WF_Block_ID", this.getUUIDFromId(node.getCtx(), "AD_WF_Block", node.getAD_WF_Block_ID()));
        }
        if (node.getAD_WF_Responsible_ID() > 0) {
            filler.add("AD_WF_Responsible_ID", true);
            filler.addUUID("AD_WF_Responsible_ID", this.getUUIDFromId(node.getCtx(), "AD_WF_Responsible", node.getAD_WF_Responsible_ID()));
        }
        if (node.getAD_Image_ID() > 0) {
            filler.add("AD_Image_ID", true);
            filler.addUUID("AD_Image_ID", this.getUUIDFromId(node.getCtx(), "AD_Image", node.getAD_Image_ID()));
        }
        if (node.getWorkflow_ID() > 0) {
            filler.add("Workflow_ID", true);
            filler.addUUID("Workflow_ID", this.getUUIDFromId(node.getCtx(), "AD_Workflow", node.getWorkflow_ID()));
        }
        if (node.getAD_Column_ID() > 0) {
            filler.add("AD_Column_ID", true);
            filler.addUUID("AD_Column_ID", this.getUUIDFromId(node.getCtx(), "AD_Column", node.getAD_Column_ID()));
        }
        filler.add("Value");
        filler.add("Name");
        filler.add("Description");
        filler.add("Help");
        filler.add("Action");
        filler.add("AttributeName");
        filler.add("AttributeValue");
        filler.add("Cost");
        filler.add("DocAction");
        filler.add("Duration");
        filler.add("DynPriorityChange");
        filler.add("DynPriorityUnit");
        filler.add("EMail");
        filler.add("EMailRecipient");
        filler.add("EntityType");
        filler.add("FinishMode");
        filler.add("IsActive");
        filler.add("IsCentrallyMaintained");
        filler.add("IsMilestone");
        filler.add("IsSubcontracting");
        filler.add("JoinElement");
        filler.add("Limit");
        filler.add("MovingTime");
        filler.add("OverlapUnits");
        filler.add("Priority");
        filler.add("QueuingTime");
        filler.add("SetupTime");
        filler.add("SplitElement");
        filler.add("StartMode");
        filler.add("SubflowExecution");
        filler.add("UnitsCycles");
        filler.add("ValidFrom");
        filler.add("ValidTo");
        filler.add("WaitingTime");
        filler.add("WaitTime");
        filler.add("WorkingTime");
        filler.add("XPosition");
        filler.add("Yield");
        filler.add("YPosition");
        return atts;
    }
}

