/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_WF_NextCondition;
import org.compiere.util.Env;
import org.compiere.wf.MWFNextCondition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeNextConditionElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String uuid = this.getUUIDValue(atts, "AD_WF_NextCondition");
        this.log.info(uuid);
        String entitytype = this.getStringValue(atts, "EntityType");
        if (this.isProcessElement(ctx, entitytype)) {
            if (element.parent != null && element.parent.skip) {
                element.skip = true;
                return;
            }
            String workflowUuid = this.getUUIDValue(atts, "AD_Workflow_ID");
            int workflowId = this.getIdFromUUID(ctx, "AD_Workflow", workflowUuid);
            if (workflowId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Workflow: " + workflowUuid;
                return;
            }
            String workflowNodeUuid = this.getUUIDValue(atts, "AD_WF_Node_ID");
            String workflowNodeNextUuid = this.getUUIDValue(atts, "AD_WF_NodeNext_ID");
            int wfNodeId = this.getIdFromUUID(ctx, "AD_WF_Node", workflowNodeUuid);
            if (wfNodeId <= 0) {
                element.unresolved = "AD_WF_Node=" + workflowNodeUuid;
                element.defer = true;
                return;
            }
            int wfNodeNextId = this.getIdFromUUID(ctx, "AD_WF_NodeNext", workflowNodeNextUuid);
            if (wfNodeNextId <= 0) {
                element.unresolved = "AD_WF_Node=" + workflowNodeNextUuid;
                element.defer = true;
                return;
            }
            int id = this.getIdFromUUID(ctx, "AD_WF_NextCondition", uuid);
            MWFNextCondition wFNodeNextCondition = new MWFNextCondition(ctx, id, this.getTrxName(ctx));
            int backupId = -1;
            String objectStatus = null;
            if (id <= 0 && this.getIntValue(atts, "AD_WF_NextCondition_ID") > 0 && this.getIntValue(atts, "AD_WF_NextCondition_ID") <= 999999) {
                wFNodeNextCondition.setAD_WF_NextCondition_ID(this.getIntValue(atts, "AD_WF_NextCondition_ID"));
                wFNodeNextCondition.setIsDirectLoad(true);
            }
            if (id > 0) {
                backupId = this.copyRecord(ctx, "AD_WF_NextCondition", wFNodeNextCondition);
                objectStatus = "Update";
            } else {
                objectStatus = "New";
                backupId = 0;
            }
            wFNodeNextCondition.setUUID(uuid);
            wFNodeNextCondition.setAndOr(this.getStringValue(atts, "AndOr"));
            wFNodeNextCondition.setEntityType(this.getStringValue(atts, "EntityType"));
            wFNodeNextCondition.setIsActive(this.getBooleanValue(atts, "IsActive"));
            wFNodeNextCondition.setOperation(this.getStringValue(atts, "Operation"));
            wFNodeNextCondition.setSeqNo(this.getIntValue(atts, "SeqNo"));
            wFNodeNextCondition.setValue(this.getStringValue(atts, "Value"));
            wFNodeNextCondition.setValue2(this.getStringValue(atts, "Value2"));
            try {
                wFNodeNextCondition.saveEx(this.getTrxName(ctx));
                this.log.info("m_WFNodeNextCondition save success");
                this.recordLog(ctx, 1, wFNodeNextCondition.getUUID(), "WFNextCondition", wFNodeNextCondition.get_ID(), backupId, objectStatus, "AD_WF_NextCondition", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NextCondition"));
            }
            catch (Exception e) {
                this.log.info("m_WFNodeNextCondition save failure");
                this.recordLog(ctx, 0, wFNodeNextCondition.getUUID(), "WFNextCondition", wFNodeNextCondition.get_ID(), backupId, objectStatus, "AD_WF_NextCondition", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NextCondition"));
                throw new POSaveFailedException(e);
            }
        } else {
            element.skip = true;
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int nodenextconditionId = Env.getContextAsInt(ctx, "AD_WF_NextCondition_ID");
        X_AD_WF_NextCondition nodeNextCondition = new X_AD_WF_NextCondition(ctx, nodenextconditionId, null);
        AttributesImpl atts = new AttributesImpl();
        this.createWorkflowNodeNextConditionBinding(atts, nodeNextCondition);
        document.startElement("", "", "workflowNodeNextCondition", atts);
        document.endElement("", "", "workflowNodeNextCondition");
    }

    private AttributesImpl createWorkflowNodeNextConditionBinding(AttributesImpl atts, X_AD_WF_NextCondition nodeNextCondition) {
        atts.clear();
        AttributeFiller filler = new AttributeFiller(atts, nodeNextCondition);
        if (nodeNextCondition.getAD_WF_NextCondition_ID() <= 999999) {
            filler.add("AD_WF_NextCondition_ID");
        }
        filler.addUUID();
        if (nodeNextCondition.getAD_WF_NodeNext_ID() > 0) {
            filler.add("AD_WF_NodeNext_ID", true);
            filler.addUUID("AD_WF_NodeNext_ID", this.getUUIDFromId(nodeNextCondition.getCtx(), "AD_WF_NodeNext", nodeNextCondition.getAD_WF_NodeNext_ID()));
            nodeNextCondition.getAD_WF_NodeNext().getAD_WF_Node().getUUID();
            filler.addUUID("AD_WF_Node_ID", nodeNextCondition.getAD_WF_NodeNext().getAD_WF_Node().getUUID());
            filler.addUUID("AD_Workflow_ID", nodeNextCondition.getAD_WF_NodeNext().getAD_WF_Node().getAD_Workflow().getUUID());
        }
        if (nodeNextCondition.getAD_Column_ID() > 0) {
            filler.add("AD_Column_ID", true);
            filler.addUUID("AD_Column_ID", this.getUUIDFromId(nodeNextCondition.getCtx(), "AD_Column", nodeNextCondition.getAD_Column_ID()));
        }
        filler.add("AndOr");
        filler.add("EntityType");
        filler.add("IsActive");
        filler.add("Operation");
        filler.add("SeqNo");
        filler.add("Value");
        filler.add("Value2");
        return atts;
    }
}

