/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_WF_NodeNext;
import org.compiere.util.Env;
import org.compiere.wf.MWFNodeNext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeNextElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String elementValue = element.getElementValue();
        String uuid = this.getUUIDValue(atts, "AD_WF_NodeNext");
        this.log.info(elementValue + " " + uuid);
        String entitytype = this.getStringValue(atts, "EntityType");
        if (this.isProcessElement(ctx, entitytype)) {
            if (element.parent != null && element.parent.skip) {
                element.skip = true;
                return;
            }
            String workflowUuid = this.getUUIDValue(atts, "AD_Workflow_ID");
            int workflowId = this.getIdFromUUID(ctx, "AD_Workflow", workflowUuid);
            if (workflowId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Workflow: " + workflowUuid;
                return;
            }
            String workflowNodeUuid = this.getUUIDValue(atts, "AD_WF_Node_ID");
            String workflowNodeNextUuid = this.getUUIDValue(atts, "AD_WF_Next_ID");
            int wfNodeId = this.getIdFromUUID(ctx, "AD_WF_Node", workflowNodeUuid);
            if (wfNodeId <= 0) {
                element.defer = true;
                element.unresolved = "AD_WF_Node: " + workflowNodeUuid;
                return;
            }
            int wfNodeNextId = this.getIdFromUUID(ctx, "AD_WF_Node", workflowNodeNextUuid);
            if (wfNodeNextId <= 0) {
                element.defer = true;
                element.unresolved = "AD_WF_Node: " + workflowNodeNextUuid;
                return;
            }
            int id = this.getIdFromUUID(ctx, "AD_WF_NodeNext", uuid);
            MWFNodeNext nodeNext = new MWFNodeNext(ctx, id, this.getTrxName(ctx));
            int backupId = -1;
            String objectStatus = null;
            if (id <= 0 && this.getIntValue(atts, "AD_WF_NodeNext_ID") > 0 && this.getIntValue(atts, "AD_WF_NodeNext_ID") <= 999999) {
                nodeNext.setAD_WF_NodeNext_ID(this.getIntValue(atts, "AD_WF_NodeNext_ID"));
                nodeNext.setIsDirectLoad(true);
            }
            if (id > 0) {
                backupId = this.copyRecord(ctx, "AD_WF_NodeNext", nodeNext);
                objectStatus = "Update";
            } else {
                objectStatus = "New";
                backupId = 0;
            }
            nodeNext.setUUID(uuid);
            nodeNext.setAD_WF_Node_ID(wfNodeId);
            nodeNext.setAD_WF_Next_ID(wfNodeNextId);
            nodeNext.setDescription(this.getStringValue(atts, "Description"));
            nodeNext.setEntityType(this.getStringValue(atts, "EntityType"));
            nodeNext.setIsActive(this.getBooleanValue(atts, "IsActive"));
            nodeNext.setIsStdUserWorkflow(this.getBooleanValue(atts, "IsStdUserWorkflow"));
            nodeNext.setSeqNo(this.getIntValue(atts, "SeqNo"));
            nodeNext.setTransitionCode(this.getStringValue(atts, "TransitionCode"));
            try {
                nodeNext.saveEx(this.getTrxName(ctx));
                this.log.info("m_WFNodeNext save success");
                this.recordLog(ctx, 1, nodeNext.getUUID(), "WFNodeNext", nodeNext.get_ID(), backupId, objectStatus, "AD_WF_NodeNext", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NodeNext"));
            }
            catch (Exception e) {
                this.log.info("m_WFNodeNext save failure");
                this.recordLog(ctx, 0, nodeNext.getUUID(), "WFNodeNext", nodeNext.get_ID(), backupId, objectStatus, "AD_WF_NodeNext", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NodeNext"));
                throw new POSaveFailedException(e);
            }
        } else {
            element.skip = true;
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int nodenextId = Env.getContextAsInt(ctx, "AD_WF_NodeNext_ID");
        X_AD_WF_NodeNext m_WF_NodeNext = new X_AD_WF_NodeNext(ctx, nodenextId, null);
        AttributesImpl atts = new AttributesImpl();
        this.createWorkflowNodeNextBinding(atts, m_WF_NodeNext);
        document.startElement("", "", "workflowNodeNext", atts);
        document.endElement("", "", "workflowNodeNext");
    }

    private AttributesImpl createWorkflowNodeNextBinding(AttributesImpl atts, X_AD_WF_NodeNext nodeNext) {
        atts.clear();
        AttributeFiller filler = new AttributeFiller(atts, nodeNext);
        if (nodeNext.getAD_WF_NodeNext_ID() <= 999999) {
            filler.add("AD_WF_NodeNext_ID");
        }
        filler.addUUID();
        if (nodeNext.getAD_WF_Node_ID() > 0) {
            filler.add("AD_WF_Node_ID", true);
            filler.addUUID("AD_WF_Node_ID", this.getUUIDFromId(nodeNext.getCtx(), "AD_WF_Node", nodeNext.getAD_WF_Node_ID()));
            filler.addUUID("AD_Workflow_ID", nodeNext.getAD_WF_Node().getAD_Workflow().getUUID());
        }
        if (nodeNext.getAD_WF_Next_ID() > 0) {
            filler.add("AD_WF_Next_ID", true);
            filler.addUUID("AD_WF_Next_ID", this.getUUIDFromId(nodeNext.getCtx(), "AD_WF_Node", nodeNext.getAD_WF_Next_ID()));
        }
        filler.add("Description");
        filler.add("EntityType");
        filler.add("IsActive");
        filler.add("IsStdUserWorkflow");
        filler.add("SeqNo");
        filler.add("TransitionCode");
        return atts;
    }
}

