/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.POSActionMenu;
import org.adempiere.pos.POSLookupProduct;
import org.adempiere.pos.POSSubPanel;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.search.QueryBPartner;
import org.adempiere.pos.search.QueryDocType;
import org.adempiere.pos.search.QueryOrderHistory;
import org.adempiere.pos.service.CPOS;
import org.adempiere.pos.service.POSLookupProductInterface;
import org.adempiere.pos.service.POSPanelInterface;
import org.adempiere.pos.service.POSQueryInterface;
import org.adempiere.pos.service.POSQueryListener;
import org.compiere.apps.ADialog;
import org.compiere.apps.search.InfoProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class POSActionPanel
extends POSSubPanel
implements ActionListener,
POSPanelInterface,
POSQueryListener,
POSLookupProductInterface {
    private static final long serialVersionUID = 5895558315889871887L;
    private CButton buttonNew;
    private CButton buttonPrint;
    private CButton buttonDocType;
    private CButton buttonProduct;
    private CButton buttonBPartner;
    private CButton buttonProcess;
    private CButton buttonHistory;
    private CButton buttonBack;
    private CButton buttonNext;
    private CButton buttonCollect;
    private CButton buttonCancel;
    private CButton buttonLogout;
    private CPanel buttonPanel;
    private POSTextField fieldProductName;
    private Timer findProductTimer;
    private POSLookupProduct lookupProduct;
    private POSActionMenu actionProcessMenu;
    private int topPadding;
    private int bottonPadding;
    private int rightPadding;
    private int leftPadding;
    private static CLogger logger = CLogger.getCLogger(POSActionPanel.class);
    private final String ACTION_NEW = "New";
    private final String ACTION_PRINT = "Print";
    private final String ACTION_DOCTYPE = "Assignment";
    private final String ACTION_PRODUCT = "InfoProduct";
    private final String ACTION_BPARTNER = "BPartner";
    private final String ACTION_PROCESS = "Process";
    private final String ACTION_HISTORY = "History";
    private final String ACTION_BACK = "Parent";
    private final String ACTION_NEXT = "Detail";
    private final String ACTION_PAYMENT = "Payment";
    private final String ACTION_CANCEL = "Cancel";
    private final String ACTION_LOGOUT = "End";

    public POSActionPanel(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    public void init() {
        this.setLayout(new GridBagLayout());
        this.buttonPanel = new CPanel(new GridBagLayout());
        this.topPadding = 0;
        this.leftPadding = 1;
        this.bottonPadding = 0;
        this.rightPadding = 1;
        this.buttonNew = this.createButtonAction("New", KeyStroke.getKeyStroke(113, 0));
        this.buttonNew.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonNew.setToolTipText("F2-" + Msg.translate(this.ctx, "new.order"));
        this.buttonPanel.add((Component)this.buttonNew, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonPrint = this.createButtonAction("Print", KeyStroke.getKeyStroke(123, 0));
        this.buttonPrint.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonPrint.setToolTipText("F12-" + Msg.translate(this.ctx, "Print"));
        this.buttonPanel.add((Component)this.buttonPrint, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonDocType = this.createButtonAction("Assignment", KeyStroke.getKeyStroke(121, 0));
        this.buttonDocType.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonDocType.setToolTipText("F10-" + Msg.translate(this.ctx, "C_DocType_ID"));
        this.buttonPanel.add((Component)this.buttonDocType, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonProduct = this.createButtonAction("InfoProduct", KeyStroke.getKeyStroke(73, 8));
        this.buttonProduct.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonProduct.setToolTipText("ALT+I-" + Msg.translate(this.ctx, "InfoProduct"));
        this.buttonPanel.add((Component)this.buttonProduct, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonBPartner = this.createButtonAction("BPartner", KeyStroke.getKeyStroke(73, 10));
        this.buttonBPartner.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonBPartner.setToolTipText("CTL+ALT+I-" + Msg.translate(this.ctx, "C_BPartner_ID"));
        this.buttonPanel.add((Component)this.buttonBPartner, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonProcess = this.createButtonAction("Process", KeyStroke.getKeyStroke(80, 8));
        this.buttonProcess.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonProcess.setToolTipText("ALT+P-" + Msg.translate(this.ctx, "Process"));
        this.buttonPanel.add((Component)this.buttonProcess, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonHistory = this.createButtonAction("History", KeyStroke.getKeyStroke(120, 0));
        this.buttonHistory.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonHistory.setToolTipText("F9-" + Msg.translate(this.ctx, "smenu.order.history"));
        this.buttonPanel.add((Component)this.buttonHistory, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonBack = this.createButtonAction("Parent", KeyStroke.getKeyStroke(37, 8));
        this.buttonBack.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonBack.setToolTipText("ALT-LEFT-" + Msg.translate(this.ctx, "prev"));
        this.buttonPanel.add((Component)this.buttonBack, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonBack.setEnabled(true);
        this.buttonNext = this.createButtonAction("Detail", KeyStroke.getKeyStroke(39, 8));
        this.buttonNext.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonNext.setToolTipText("ALT-RIGHT-" + Msg.translate(this.ctx, "next"));
        this.buttonPanel.add((Component)this.buttonNext, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonNext.setEnabled(true);
        this.buttonCollect = this.createButtonAction("Payment", KeyStroke.getKeyStroke(115, 0));
        this.buttonCollect.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonCollect.setToolTipText("F4-" + Msg.translate(this.ctx, "Payment"));
        this.buttonPanel.add((Component)this.buttonCollect, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonCollect.setEnabled(false);
        this.buttonCancel = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(114, 0));
        this.buttonCancel.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonCancel.setToolTipText("F3-" + Msg.translate(this.ctx, "POS.IsCancel"));
        this.buttonPanel.add((Component)this.buttonCancel, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonLogout = this.createButtonAction("End", KeyStroke.getKeyStroke(76, 8));
        this.buttonLogout.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonLogout.setToolTipText("ALT+L-" + Msg.translate(this.ctx, "LogOut"));
        this.buttonPanel.add((Component)this.buttonLogout, new GridBagConstraints(11, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        String string = Msg.translate(Env.getCtx(), "M_Product_ID");
        this.fieldProductName = new POSTextField(string, this.posPanel.getKeyboard());
        this.fieldProductName.setPlaceholder(string);
        this.fieldProductName.addActionListener(this);
        this.fieldProductName.setFont(this.posPanel.getFont());
        this.fieldProductName.setPreferredSize(new Dimension(250, this.posPanel.getFieldHeight()));
        this.fieldProductName.setMinimumSize(new Dimension(250, this.posPanel.getFieldHeight()));
        this.fieldProductName.setFocusable(true);
        this.fieldProductName.setFocusTraversalKeysEnabled(false);
        this.lookupProduct = new POSLookupProduct(this, this.fieldProductName, 0L);
        this.fieldProductName.addKeyListener(this.lookupProduct);
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.fieldProductName, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        if (this.posPanel.isEnableProductLookup() && !this.posPanel.isVirtualKeyboard()) {
            JComboBox<KeyNamePair> jComboBox = new JComboBox<KeyNamePair>();
            Font font = new Font("monospaced", 0, 14);
            jComboBox.setFont(font);
            this.findProductTimer = new Timer(500, this.lookupProduct);
            this.lookupProduct.setFillingComponent(jComboBox);
            this.lookupProduct.setPriceListId(this.posPanel.getM_PriceList_ID());
            this.lookupProduct.setPartnerId(this.posPanel.getC_BPartner_ID());
            this.lookupProduct.setWarehouseId(this.posPanel.getM_Warehouse_ID());
            this.findProductTimer.start();
            this.add(jComboBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 0, 0, 20), 0, 0));
        }
        this.enableButton();
        this.actionProcessMenu = new POSActionMenu(this.posPanel);
        this.posPanel.listOrder();
        this.getMainFocus();
    }

    @Override
    public void dispose() {
        this.fieldProductName = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null || string.length() == 0) {
            return;
        }
        logger.info("PosSubCustomer - actionPerformed: " + string);
        try {
            if (actionEvent.getSource().equals(this.fieldProductName)) {
                return;
            }
            if (actionEvent.getSource().equals(this.buttonNew)) {
                this.posPanel.newOrder();
            } else if (actionEvent.getSource().equals(this.buttonDocType)) {
                if (this.posPanel.isUserPinValid()) {
                    QueryDocType queryDocType = new QueryDocType(this.posPanel);
                    queryDocType.addOptionListener(this);
                    queryDocType.loadData();
                    queryDocType.showView();
                }
            } else if (actionEvent.getSource().equals(this.buttonPrint)) {
                this.posPanel.printTicket();
            } else if (actionEvent.getSource().equals(this.buttonProduct)) {
                this.showWindowProduct("");
            } else if (actionEvent.getSource().equals(this.buttonBPartner)) {
                if (this.posPanel.isDrafted() || this.posPanel.isInProgress()) {
                    QueryBPartner queryBPartner = new QueryBPartner(this.posPanel);
                    queryBPartner.addOptionListener(this);
                    if (this.posPanel.isBPartnerStandard()) {
                        queryBPartner.setResults(null);
                    } else {
                        queryBPartner.loadData();
                    }
                    queryBPartner.showView();
                }
            } else {
                if (actionEvent.getSource().equals(this.buttonProcess)) {
                    if (this.posPanel.isUserPinValid()) {
                        this.actionProcessMenu.show(this, 340, 60);
                    }
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonHistory)) {
                    QueryOrderHistory queryOrderHistory = new QueryOrderHistory(this.posPanel);
                    queryOrderHistory.addOptionListener(this);
                    queryOrderHistory.showView();
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonBack)) {
                    this.previousRecord();
                } else if (actionEvent.getSource().equals(this.buttonNext)) {
                    this.nextRecord();
                } else if (actionEvent.getSource().equals(this.buttonCollect)) {
                    if (this.posPanel.isReturnMaterial()) {
                        this.completeReturn();
                    } else {
                        this.payOrder();
                    }
                } else if (actionEvent.getSource().equals(this.buttonCancel)) {
                    if (this.posPanel.isUserPinValid()) {
                        this.deleteOrder();
                    }
                } else if (actionEvent.getSource().equals(this.buttonLogout)) {
                    this.posPanel.dispose();
                    return;
                }
            }
            if (!actionEvent.getSource().equals(this.buttonCollect)) {
                this.posPanel.refreshPanel();
            }
        }
        catch (Exception exception) {
            ADialog.error(this.posPanel.getWindowNo(), this, exception.getLocalizedMessage());
        }
    }

    private void showWindowProduct(String string) {
        this.posPanel.getFrame().getContentPane().invalidate();
        InfoProduct infoProduct = new InfoProduct(this.posPanel.getFrame(), true, this.posPanel.getWindowNo(), this.posPanel.getM_Warehouse_ID(), this.posPanel.getM_PriceList_ID(), 0, string, true, true, null);
        infoProduct.setVisible(true);
        Object[] objectArray = infoProduct.getSelectedKeys();
        if (objectArray == null) {
            return;
        }
        if (infoProduct.isCancelled()) {
            return;
        }
        for (Object object : objectArray) {
            int n = (Integer)object;
            if (n <= 0) continue;
            String string2 = this.posPanel.getProductValue(n);
            this.posPanel.updateProductPlaceholder(string2);
            try {
                this.posPanel.setAddQty(true);
                this.findProduct(true);
            }
            catch (Exception exception) {
                ADialog.error(0, null, exception.getLocalizedMessage());
            }
            this.fieldProductName.setText("");
            this.fieldProductName.repaint();
        }
    }

    public void getMainFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (POSActionPanel.this.getProductTimer() != null) {
                    POSActionPanel.this.getProductTimer().restart();
                }
                POSActionPanel.this.fieldProductName.requestFocusInWindow();
            }
        });
    }

    @Override
    public void findProduct(boolean bl) throws Exception {
        if (this.getProductTimer() != null) {
            this.getProductTimer().stop();
        }
        String string = this.fieldProductName.getPlaceholder();
        this.posPanel.updateProductPlaceholder("");
        if (string == null || string.length() == 0) {
            return;
        }
        string = string.toUpperCase();
        try {
            Integer.getInteger(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Vector<Object>> list = CPOS.getQueryProduct(string, this.posPanel.getM_Warehouse_ID(), this.posPanel.getM_PriceList_ID(), this.posPanel.getC_BPartner_ID());
        if (list.size() == 1) {
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                Integer n = (Integer)((Vector)optional.get()).elementAt(0);
                this.posPanel.setAddQty(true);
                this.posPanel.addOrUpdateLine(n, bl ? Env.ZERO : Env.ONE);
            }
        } else {
            this.showWindowProduct(string);
        }
        this.posPanel.refreshPanel();
        this.posPanel.changeViewPanel();
        if (bl) {
            this.quantityRequestFocus();
        }
    }

    @Override
    public void quantityRequestFocus() {
        this.posPanel.quantityRequestFocus();
    }

    public void previousRecord() {
        this.posPanel.previousRecord();
        this.posPanel.refreshPanel();
    }

    public void nextRecord() {
        this.posPanel.nextRecord();
        this.posPanel.refreshPanel();
    }

    private void payOrder() {
        if (!this.posPanel.hasOrder()) {
            ADialog.warn(this.posPanel.getWindowNo(), this, Msg.getMsg(this.ctx, "POS.MustCreateOrder"));
        } else {
            this.posPanel.hideKeyboard();
            this.posPanel.showCollectPayment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeReturn() {
        String string = null;
        String string2 = "@new.customer.return.order@ @DisplayDocumentInfo@ : " + this.posPanel.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + this.posPanel.getBPName();
        if (this.posPanel.isCompleted()) {
            return;
        }
        if (ADialog.ask(this.posPanel.getWindowNo(), this, "StartProcess?", Msg.parseTranslation(this.ctx, string2))) {
            this.requestFocus();
            this.posPanel.getFrame().getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.posPanel.completeReturn();
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            finally {
                this.posPanel.getFrame().getContentPane().setCursor(Cursor.getDefaultCursor());
            }
        }
        if (string != null) {
            ADialog.error(this.posPanel.getWindowNo(), this, Msg.parseTranslation(this.ctx, string));
        }
        this.posPanel.refreshPanel();
    }

    private void deleteOrder() {
        String string = null;
        String string2 = "POS.DeleteOrder";
        if (this.posPanel.isCompleted()) {
            string2 = "POS.OrderIsAlreadyCompleted";
        }
        if (ADialog.ask(0, this, Msg.getMsg(this.ctx, Msg.getMsg(this.ctx, string2)))) {
            this.posPanel.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            string = this.posPanel.cancelOrder();
            this.posPanel.getFrame().setCursor(Cursor.getDefaultCursor());
        }
        if (string != null) {
            ADialog.error(this.posPanel.getWindowNo(), this, Msg.parseTranslation(this.ctx, string));
        }
        this.posPanel.refreshPanel();
    }

    @Override
    public String validatePayment() {
        return null;
    }

    @Override
    public void changeViewPanel() {
    }

    @Override
    public void refreshPanel() {
        if (this.posPanel.hasOrder()) {
            if (this.lookupProduct != null && this.posPanel.isEnableProductLookup()) {
                this.lookupProduct.setPriceListId(this.posPanel.getM_PriceList_ID());
                this.lookupProduct.setPartnerId(this.posPanel.getC_BPartner_ID());
                this.lookupProduct.setWarehouseId(this.posPanel.getM_Warehouse_ID());
            }
            this.buttonNext.setEnabled(!this.posPanel.isLastRecord() && this.posPanel.hasRecord());
            this.buttonBack.setEnabled(!this.posPanel.isFirstRecord() && this.posPanel.hasRecord());
            if (this.posPanel.hasLines() && !this.posPanel.isPaid() && !this.posPanel.isVoided()) {
                this.buttonCollect.setEnabled(true);
            } else {
                this.buttonCollect.setEnabled(false);
            }
            if (this.posPanel.isDrafted() || this.posPanel.isInProgress()) {
                this.buttonDocType.setEnabled(true);
                this.buttonBPartner.setEnabled(true);
            } else {
                this.buttonDocType.setEnabled(false);
                this.buttonBPartner.setEnabled(false);
            }
            this.buttonCancel.setEnabled(!this.posPanel.isVoided());
            this.buttonNew.setEnabled(true);
            this.buttonHistory.setEnabled(true);
            this.buttonProcess.setEnabled(true);
        } else {
            this.buttonNew.setEnabled(true);
            this.buttonHistory.setEnabled(true);
            this.buttonNext.setEnabled(!this.posPanel.isLastRecord() && this.posPanel.hasRecord());
            this.buttonBack.setEnabled(!this.posPanel.isFirstRecord() && this.posPanel.hasRecord());
            this.buttonCollect.setEnabled(false);
            this.buttonCancel.setEnabled(false);
            this.buttonDocType.setEnabled(false);
            this.buttonBPartner.setEnabled(false);
        }
        this.buttonNew.setEnabled(true);
        this.buttonHistory.setEnabled(true);
        this.buttonProcess.setEnabled(true);
    }

    public void enableButton() {
        this.buttonNew.setEnabled(true);
        this.buttonCancel.setEnabled(false);
        this.buttonHistory.setEnabled(true);
        this.buttonCollect.setEnabled(false);
    }

    @Override
    public void okAction(POSQueryInterface pOSQueryInterface) {
        try {
            if (pOSQueryInterface.getRecord_ID() <= 0) {
                return;
            }
            if (pOSQueryInterface instanceof QueryOrderHistory) {
                this.posPanel.setOrder(pOSQueryInterface.getRecord_ID());
                this.posPanel.reloadIndex(pOSQueryInterface.getRecord_ID());
            } else if (pOSQueryInterface instanceof QueryBPartner) {
                if (!this.posPanel.hasOrder()) {
                    this.posPanel.newOrder(pOSQueryInterface.getRecord_ID());
                    this.posPanel.getMainFocus();
                } else {
                    this.posPanel.configureBPartner(pOSQueryInterface.getRecord_ID());
                }
                logger.fine("C_BPartner_ID=" + pOSQueryInterface.getRecord_ID());
            } else if (pOSQueryInterface instanceof QueryDocType && pOSQueryInterface.getRecord_ID() > 0) {
                this.posPanel.setC_DocType_ID(pOSQueryInterface.getRecord_ID());
            }
            this.posPanel.refreshPanel();
        }
        catch (AdempiereException adempiereException) {
            ADialog.error(this.posPanel.getWindowNo(), this, adempiereException.getLocalizedMessage());
        }
        catch (Exception exception) {
            ADialog.error(this.posPanel.getWindowNo(), this, exception.getLocalizedMessage());
        }
    }

    @Override
    public void cancelAction(POSQueryInterface pOSQueryInterface) {
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    public void resetPanel() {
        this.buttonNew.setEnabled(false);
        this.buttonHistory.setEnabled(false);
        this.buttonNext.setEnabled(false);
        this.buttonBack.setEnabled(false);
        this.buttonCollect.setEnabled(false);
        this.buttonCancel.setEnabled(false);
        this.buttonDocType.setEnabled(false);
        this.buttonBPartner.setEnabled(false);
        this.buttonProcess.setEnabled(false);
    }

    @Override
    public Timer getProductTimer() {
        return this.findProductTimer;
    }

    public void updateProductPlaceholder(String string) {
        this.fieldProductName.setPlaceholder(string);
        this.fieldProductName.repaint();
    }
}

