/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.pos.POSKeyListener;
import org.adempiere.pos.POSKeyPanel;
import org.adempiere.pos.POSScalesPanel;
import org.adempiere.pos.POSSubPanel;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VCollect;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.search.QueryBPartner;
import org.adempiere.pos.service.POSPanelInterface;
import org.adempiere.pos.service.POSQueryInterface;
import org.adempiere.pos.service.POSQueryListener;
import org.compiere.apps.ADialog;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MPOSKey;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class POSDocumentPanel
extends POSSubPanel
implements POSKeyListener,
ActionListener,
POSPanelInterface,
POSQueryListener {
    private static final long serialVersionUID = 2131406504920855582L;
    private CPanel headerPanel;
    private CPanel totalPanel;
    private CPanel documentInfoPanel;
    private TitledBorder totalTitle;
    private TitledBorder documentTitle;
    private CLabel labelSalesRep;
    private CLabel fieldSalesRep;
    private CLabel labelDocumentType;
    private CLabel fieldDocumentType;
    private CLabel labelDocumentNo;
    private CLabel fieldDocumentNo;
    private CLabel labelDocumentStatus;
    private CLabel fieldDocumentStatus;
    private CLabel labelDocumentDate;
    private CLabel fieldDocumentDate;
    private CLabel labelTotalLines;
    private CLabel fieldTotalLines;
    private CLabel labelTaxAmount;
    private CLabel fieldTaxAmount;
    private CLabel labelGrandTotal;
    private CLabel fieldGrandTotal;
    private POSTextField fieldPartnerName;
    private POSKeyPanel keyboardPanel;
    private VCollect collectPayment;
    private POSScalesPanel scalesPanel;
    private static CLogger logger = CLogger.getCLogger(POSDocumentPanel.class);

    public POSDocumentPanel(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    public void init() {
        int n = this.posPanel.getC_POSKeyLayout_ID();
        this.setLayout(new GridBagLayout());
        int n2 = 0;
        this.headerPanel = new CPanel(new GridBagLayout());
        this.documentInfoPanel = new CPanel(new GridBagLayout());
        this.totalPanel = new CPanel(new GridBagLayout());
        this.documentTitle = BorderFactory.createTitledBorder(Msg.getMsg(Env.getCtx(), "InfoOrder"));
        this.documentTitle.setTitleFont(this.posPanel.getFont());
        this.documentTitle.setTitleColor(AdempierePLAF.getTextColor_Label());
        this.documentInfoPanel.setBorder(this.documentTitle);
        this.totalTitle = BorderFactory.createTitledBorder(Msg.getMsg(Env.getCtx(), "Totals"));
        this.totalTitle.setTitleFont(this.posPanel.getFont());
        this.totalTitle.setTitleColor(AdempierePLAF.getTextColor_Label());
        this.totalPanel.setBorder(this.totalTitle);
        this.labelDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo") + ":");
        this.labelDocumentNo.setFont(this.posPanel.getPlainFont());
        this.documentInfoPanel.add((Component)this.labelDocumentNo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldDocumentNo = new CLabel();
        this.fieldDocumentNo.setFont(this.posPanel.getFont());
        this.labelDocumentNo.setLabelFor(this.fieldDocumentNo);
        this.documentInfoPanel.add((Component)this.fieldDocumentNo, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelDocumentType = new CLabel(Msg.translate(Env.getCtx(), "C_DocType_ID") + ":");
        this.labelDocumentType.setFont(this.posPanel.getPlainFont());
        this.documentInfoPanel.add((Component)this.labelDocumentType, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldDocumentType = new CLabel();
        this.fieldDocumentType.setFont(this.posPanel.getFont());
        this.labelDocumentType.setLabelFor(this.fieldDocumentType);
        this.documentInfoPanel.add((Component)this.fieldDocumentType, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelDocumentStatus = new CLabel(Msg.translate(Env.getCtx(), "DocStatus") + ":");
        this.labelDocumentStatus.setFont(this.posPanel.getPlainFont());
        this.documentInfoPanel.add((Component)this.labelDocumentStatus, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldDocumentStatus = new CLabel();
        this.fieldDocumentStatus.setFont(this.posPanel.getFont());
        this.labelDocumentStatus.setLabelFor(this.fieldDocumentStatus);
        this.documentInfoPanel.add((Component)this.fieldDocumentStatus, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelSalesRep = new CLabel(Msg.translate(Env.getCtx(), "SalesRep_ID") + ":");
        this.labelSalesRep.setFont(this.posPanel.getPlainFont());
        this.documentInfoPanel.add((Component)this.labelSalesRep, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldSalesRep = new CLabel();
        this.fieldSalesRep.setFont(this.posPanel.getFont());
        this.labelSalesRep.setLabelFor(this.fieldSalesRep);
        this.documentInfoPanel.add((Component)this.fieldSalesRep, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelDocumentDate = new CLabel(Msg.translate(Env.getCtx(), "Date") + ":");
        this.labelDocumentDate.setFont(this.posPanel.getPlainFont());
        this.totalPanel.add((Component)this.labelDocumentDate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldDocumentDate = new CLabel();
        this.fieldDocumentDate.setFont(this.posPanel.getFont());
        this.labelDocumentDate.setLabelFor(this.fieldDocumentDate);
        this.totalPanel.add((Component)this.fieldDocumentDate, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelTotalLines = new CLabel(Msg.getMsg(Env.getCtx(), "SubTotal") + ":");
        this.labelTotalLines.setFont(this.posPanel.getPlainFont());
        this.totalPanel.add((Component)this.labelTotalLines, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldTotalLines = new CLabel();
        this.fieldTotalLines.setFont(this.posPanel.getFont());
        this.labelTotalLines.setLabelFor(this.fieldTotalLines);
        this.totalPanel.add((Component)this.fieldTotalLines, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelTaxAmount = new CLabel(Msg.translate(Env.getCtx(), "C_Tax_ID") + ":");
        this.labelTaxAmount.setFont(this.posPanel.getPlainFont());
        this.totalPanel.add((Component)this.labelTaxAmount, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldTaxAmount = new CLabel();
        this.fieldTaxAmount.setFont(this.posPanel.getFont());
        this.labelTaxAmount.setLabelFor(this.fieldTaxAmount);
        this.totalPanel.add((Component)this.fieldTaxAmount, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.labelGrandTotal = new CLabel(Msg.getMsg(this.posPanel.getCtx(), "Total") + ":");
        this.labelGrandTotal.setFont(this.posPanel.getFont());
        this.totalPanel.add((Component)this.labelGrandTotal, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.fieldGrandTotal = new CLabel();
        this.fieldGrandTotal.setFont(this.posPanel.getBigFont());
        this.labelGrandTotal.setLabelFor(this.fieldGrandTotal);
        this.totalPanel.add((Component)this.fieldGrandTotal, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, n2), 0, 0));
        this.headerPanel.add((Component)this.documentInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.headerPanel.add((Component)this.totalPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        String string = Msg.translate(Env.getCtx(), "IsCustomer");
        this.fieldPartnerName = new POSTextField(string, this.posPanel.getKeyboard());
        this.fieldPartnerName.setName(string);
        this.fieldPartnerName.setPlaceholder(string);
        this.fieldPartnerName.addActionListener(this);
        this.fieldPartnerName.setFocusable(true);
        this.fieldPartnerName.setFont(this.posPanel.getFont());
        this.fieldPartnerName.setPreferredSize(new Dimension(530, 50));
        this.fieldPartnerName.setMinimumSize(new Dimension(530, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.headerPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 2;
        this.headerPanel.add((Component)this.fieldPartnerName, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridy = 2;
        this.keyboardPanel = new POSKeyPanel(n, this);
        this.add((Component)this.keyboardPanel, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.gridy = 2;
        this.collectPayment = new VCollect(this.posPanel);
        this.collectPayment.hidePanel();
        this.add((Component)this.collectPayment.getPanel(), gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.gridy = 2;
        this.scalesPanel = new POSScalesPanel(this.posPanel);
        this.scalesPanel.hidePanel();
        this.add((Component)this.scalesPanel.getPanel(), gridBagConstraints5);
        this.refreshPanel();
    }

    @Override
    public void keyReturned(MPOSKey mPOSKey) {
        if (this.posPanel.hasOrder() && this.posPanel.isCompleted()) {
            this.posPanel.refreshProductInfo(mPOSKey);
            return;
        }
        try {
            this.posPanel.setAddQty(true);
            this.posPanel.addOrUpdateLine(mPOSKey.getM_Product_ID(), mPOSKey.getQty());
            this.posPanel.refreshPanel();
            this.posPanel.changeViewPanel();
            this.posPanel.getMainFocus();
        }
        catch (Exception exception) {
            ADialog.error(this.posPanel.getWindowNo(), this, exception.getLocalizedMessage());
        }
        this.posPanel.refreshProductInfo(mPOSKey);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.fieldPartnerName && (this.posPanel.isDrafted() || this.posPanel.isInProgress())) {
            this.findBPartner();
        }
    }

    @Override
    public void okAction(POSQueryInterface pOSQueryInterface) {
        if (pOSQueryInterface.getRecord_ID() > 0) {
            this.fieldPartnerName.setText(pOSQueryInterface.getValue());
            if (!this.posPanel.hasOrder()) {
                this.posPanel.newOrder(pOSQueryInterface.getRecord_ID());
            } else {
                this.posPanel.configureBPartner(pOSQueryInterface.getRecord_ID());
            }
            logger.fine("C_BPartner_ID=" + pOSQueryInterface.getRecord_ID());
        }
    }

    @Override
    public void cancelAction(POSQueryInterface pOSQueryInterface) {
    }

    private void findBPartner() {
        String string = this.fieldPartnerName.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.posPanel.hasBPartner() && this.posPanel.compareBPName(string)) {
            return;
        }
        string = string.toUpperCase();
        boolean bl = true;
        boolean bl2 = true;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isDigit(cArray[i])) continue;
            bl2 = false;
            break;
        }
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        String string2 = string;
        String string3 = string;
        String string4 = bl ? null : string;
        String string5 = bl ? null : string;
        String string6 = bl ? null : string;
        String string7 = string.indexOf(64) != -1 ? string : null;
        String string8 = bl2 ? null : string;
        String string9 = null;
        MBPartnerInfo[] mBPartnerInfoArray = MBPartnerInfo.find(this.ctx, string2, string3, string4, string5, string6, string7, string8, string9);
        if (mBPartnerInfoArray.length == 1) {
            MBPartner mBPartner = MBPartner.get(this.ctx, mBPartnerInfoArray[0].getC_BPartner_ID());
            this.posPanel.configureBPartner(mBPartner.getC_BPartner_ID());
            this.fieldPartnerName.setText(mBPartner.getName());
        } else {
            this.changeBusinessPartner(mBPartnerInfoArray);
        }
        this.posPanel.refreshPanel();
    }

    @Override
    public void refreshPanel() {
        logger.fine("RefreshPanel");
        if (!this.posPanel.hasOrder()) {
            this.totalTitle.setTitle(Msg.getMsg(Env.getCtx(), "Totals"));
            this.fieldSalesRep.setText(this.posPanel.getSalesRepName());
            this.fieldDocumentType.setText(Msg.getMsg(this.posPanel.getCtx(), "Order"));
            this.fieldDocumentNo.setText(Msg.getMsg(this.posPanel.getCtx(), "New"));
            this.fieldDocumentStatus.setText("");
            this.fieldDocumentDate.setText("");
            this.fieldTotalLines.setText(this.posPanel.getNumberFormat().format(Env.ZERO));
            this.fieldGrandTotal.setText(this.posPanel.getNumberFormat().format(Env.ZERO));
            this.fieldTaxAmount.setText(this.posPanel.getNumberFormat().format(Env.ZERO));
            this.fieldPartnerName.setText(null);
        } else {
            String string = this.posPanel.getCurSymbol();
            this.totalTitle.setTitle(Msg.getMsg(Env.getCtx(), "Totals") + " (" + string + ")");
            this.fieldSalesRep.setText(this.posPanel.getOrder().getSalesRep().getName());
            this.fieldDocumentType.setText(this.posPanel.getDocumentTypeName());
            this.fieldDocumentNo.setText(this.posPanel.getDocumentNo());
            this.fieldDocumentStatus.setText(this.posPanel.getOrder().getDocStatusName());
            this.fieldDocumentDate.setText(this.posPanel.getDateOrderedForView());
            this.fieldTotalLines.setText(this.posPanel.getTotaLinesForView());
            this.fieldGrandTotal.setText(this.posPanel.getGrandTotalForView());
            this.fieldTaxAmount.setText(this.posPanel.getTaxAmtForView());
            this.fieldPartnerName.setText(this.posPanel.getBPName());
        }
        this.totalPanel.invalidate();
        this.totalPanel.repaint();
    }

    public boolean changeBusinessPartner(MBPartnerInfo[] mBPartnerInfoArray) {
        QueryBPartner queryBPartner = new QueryBPartner(this.posPanel);
        queryBPartner.addOptionListener(this);
        queryBPartner.setResults(mBPartnerInfoArray);
        queryBPartner.showView();
        if (queryBPartner.getRecord_ID() > 0) {
            this.fieldPartnerName.setText(this.posPanel.getBPName());
            if (!this.posPanel.hasOrder()) {
                this.posPanel.newOrder(queryBPartner.getRecord_ID());
                this.posPanel.refreshPanel();
            } else {
                this.posPanel.configureBPartner(queryBPartner.getRecord_ID());
            }
            logger.fine("C_BPartner_ID=" + queryBPartner.getRecord_ID());
            return true;
        }
        return false;
    }

    @Override
    public String validatePayment() {
        return null;
    }

    @Override
    public void changeViewPanel() {
        if (this.posPanel.hasOrder()) {
            this.fieldPartnerName.setEnabled(!this.posPanel.isCompleted());
        } else {
            this.fieldPartnerName.setEnabled(true);
        }
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    public VCollect getCollectPayment() {
        return this.collectPayment.load(this.posPanel);
    }

    public POSScalesPanel getScalesPanel() {
        return this.scalesPanel;
    }

    public POSKeyPanel getKeyboard() {
        return this.keyboardPanel;
    }
}

