/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.KeyStroke;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.POSSubPanel;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.service.POSPanelInterface;
import org.compiere.apps.ADialog;
import org.compiere.grid.ed.VNumber;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class POSQuantityPanel
extends POSSubPanel
implements POSPanelInterface,
ActionListener {
    private static final long serialVersionUID = -8002370020007368736L;
    private CButton buttonUp;
    private CButton buttonDelete;
    private CButton buttonDown;
    private CButton buttonPlus;
    private CButton buttonMinus;
    private CButton buttonScales;
    private VNumber fieldPrice;
    private VNumber fieldDiscountPercentage;
    private VNumber fieldQuantity;
    private CPanel buttonPanel;
    private int topPadding;
    private int leftPadding;
    private int bottonPadding;
    private int rightPadding;

    public POSQuantityPanel(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    protected void init() {
        this.setLayout(new GridBagLayout());
        this.buttonPanel = new CPanel(new GridBagLayout());
        this.topPadding = 0;
        this.leftPadding = 1;
        this.bottonPadding = 0;
        this.rightPadding = 1;
        this.buttonDelete = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(114, 2));
        this.buttonDelete.setToolTipText("CTL+F3-" + Msg.translate(this.ctx, "DeleteLine"));
        this.buttonDelete.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonDelete.addActionListener(this.posPanel.getUserPinListener());
        this.buttonPanel.add((Component)this.buttonDelete, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonPlus = this.createButtonAction("Plus", KeyStroke.getKeyStroke(49, 2));
        this.buttonPlus.setToolTipText("CTL+1-" + Msg.translate(this.ctx, "add"));
        this.buttonPlus.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonPanel.add((Component)this.buttonPlus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonMinus = this.createButtonAction("Minus", KeyStroke.getKeyStroke(48, 2));
        this.buttonMinus.setToolTipText("CTL+0-" + Msg.translate(this.ctx, "decrement"));
        this.buttonMinus.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonPanel.add((Component)this.buttonMinus, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonUp = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 8));
        this.buttonUp.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonUp.setToolTipText("ALT+up-" + Msg.translate(this.ctx, "Previous"));
        this.buttonPanel.add((Component)this.buttonUp, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.buttonDown = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 8));
        this.buttonDown.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
        this.buttonDown.setToolTipText("ALT+down-" + Msg.translate(this.ctx, "Next"));
        this.buttonPanel.add((Component)this.buttonDown, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        if (this.posPanel.isPresentElectronicScales()) {
            this.buttonScales = this.createButtonAction("Calculator", KeyStroke.getKeyStroke(87, 2));
            this.buttonScales.setToolTipText("ALT+down-" + Msg.translate(this.ctx, "Calculator"));
            this.buttonScales.setPreferredSize(new Dimension(this.posPanel.getButtonSize(), this.posPanel.getButtonSize()));
            this.buttonPanel.add((Component)this.buttonScales, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
            this.buttonScales.addActionListener(this.posPanel.getScalesListener());
        }
        CLabel cLabel = new CLabel(Msg.translate(Env.getCtx(), "Qty"));
        cLabel.setDisplayedMnemonic(81);
        this.buttonPanel.add((Component)cLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        Dimension dimension = new Dimension(70, this.posPanel.getButtonSize());
        Dimension dimension2 = new Dimension(70, this.posPanel.getButtonSize());
        this.fieldQuantity = new VNumber();
        this.fieldQuantity.addActionListener(this);
        this.fieldQuantity.setFont(this.posPanel.getFont());
        this.fieldQuantity.setPreferredSize(dimension);
        this.fieldQuantity.setMinimumSize(dimension2);
        this.fieldQuantity.setDisplayType(29);
        this.fieldQuantity.setValue(Env.ZERO);
        cLabel.setLabelFor(this.fieldQuantity);
        this.buttonPanel.add((Component)this.fieldQuantity, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        CLabel cLabel2 = new CLabel(Msg.translate(Env.getCtx(), "Price"));
        cLabel2.setDisplayedMnemonic(80);
        this.buttonPanel.add((Component)cLabel2, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.fieldPrice = new VNumber();
        this.fieldPrice.setValue(Env.ZERO);
        this.fieldPrice.setFont(this.posPanel.getFont());
        this.fieldPrice.setName(cLabel2.getName());
        this.fieldPrice.setPreferredSize(dimension);
        this.fieldPrice.setMinimumSize(dimension2);
        this.fieldPrice.addActionListener(this);
        if (!this.posPanel.isModifyPrice()) {
            this.fieldPrice.setReadWrite(false);
        } else {
            this.fieldPrice.addActionListener(this.posPanel.getUserPinListener());
            this.fieldPrice.addActionListener(this);
        }
        cLabel2.setLabelFor(this.fieldPrice);
        this.buttonPanel.add((Component)this.fieldPrice, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        CLabel cLabel3 = new CLabel(Msg.translate(Env.getCtx(), "Discount"));
        cLabel3.setDisplayedMnemonic(84);
        this.buttonPanel.add((Component)cLabel3, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.fieldDiscountPercentage = new VNumber();
        this.fieldDiscountPercentage.setValue(Env.ZERO);
        this.fieldDiscountPercentage.addActionListener(this);
        this.fieldDiscountPercentage.setName(cLabel3.getName());
        this.fieldDiscountPercentage.setFont(this.posPanel.getFont());
        this.fieldDiscountPercentage.setPreferredSize(dimension);
        this.fieldDiscountPercentage.setMinimumSize(dimension2);
        if (!this.posPanel.isModifyPrice()) {
            this.fieldDiscountPercentage.setReadWrite(false);
        } else {
            this.fieldDiscountPercentage.addActionListener(this.posPanel.getUserPinListener());
            this.fieldDiscountPercentage.addActionListener(this);
        }
        cLabel3.setLabelFor(this.fieldDiscountPercentage);
        this.buttonPanel.add((Component)this.fieldDiscountPercentage, new GridBagConstraints(11, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(this.topPadding, this.leftPadding, this.bottonPadding, this.rightPadding), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(11, 0, 0, 0), 0, 0));
        this.changeStatus(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this.buttonUp)) {
                this.posPanel.moveUp();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonDown)) {
                this.posPanel.moveDown();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonMinus)) {
                this.fieldQuantity.minus(1);
            } else if (actionEvent.getSource().equals(this.buttonPlus)) {
                this.fieldQuantity.plus();
            } else if (actionEvent.getSource().equals(this.buttonDelete) && this.posPanel.isUserPinValid()) {
                this.posPanel.deleteLine(this.posPanel.getOrderLineId());
                this.fieldQuantity.setValue(0.0);
                this.fieldPrice.setValue(0.0);
                this.fieldDiscountPercentage.setValue(0.0);
                this.posPanel.refreshPanel();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonScales)) {
                this.posPanel.hideKeyboard();
                this.posPanel.getScalesTimer().restart();
                this.posPanel.showScales();
                return;
            }
            BigDecimal bigDecimal = (BigDecimal)this.fieldQuantity.getValue();
            if (this.fieldQuantity.hasChanged() && actionEvent.getSource().equals(this.fieldQuantity) && (actionEvent.getActionCommand().equals("KeyEvent") || actionEvent.getActionCommand().equals("InvocationEvent"))) {
                if (this.posPanel.isAddQty()) {
                    this.posPanel.setQtyAdded(bigDecimal);
                } else {
                    this.posPanel.setQty(bigDecimal);
                }
                this.posPanel.updateLineTable();
                this.posPanel.refreshPanel();
                this.posPanel.changeViewPanel();
                this.posPanel.getMainFocus();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPlus) || actionEvent.getSource().equals(this.buttonMinus)) {
                this.posPanel.setQty((BigDecimal)this.fieldQuantity.getValue());
                this.posPanel.setPrice((BigDecimal)this.fieldPrice.getValue());
                BigDecimal bigDecimal2 = (BigDecimal)this.fieldDiscountPercentage.getValue();
                if (bigDecimal2 == null) {
                    bigDecimal2 = Env.ZERO;
                }
                this.posPanel.setDiscountPercentage(bigDecimal2);
                this.posPanel.updateLineTable();
                this.posPanel.changeViewPanel();
                this.posPanel.refreshPanel();
                return;
            }
            if (actionEvent.getSource().equals(this.fieldDiscountPercentage) && actionEvent.getActionCommand().toString().equals("KeyEvent") || actionEvent.getSource().equals(this.fieldPrice) && actionEvent.getActionCommand().toString().equals("KeyEvent")) {
                BigDecimal bigDecimal3 = (BigDecimal)this.fieldDiscountPercentage.getValue();
                BigDecimal bigDecimal4 = (BigDecimal)this.fieldPrice.getValue();
                if (bigDecimal3.signum() < 0) {
                    throw new AdempierePOSException("@Discount@ @Error@");
                }
                if (bigDecimal4.signum() < 0) {
                    throw new AdempierePOSException("@Price@ @Error@");
                }
                if (this.posPanel.isUserPinValid() && (this.posPanel.getQty().compareTo(bigDecimal) != 0 && this.fieldQuantity.hasChanged() && (actionEvent.getSource().equals(this.fieldQuantity) || actionEvent.getSource().equals(this.buttonPlus) || actionEvent.getSource().equals(this.buttonMinus)) || this.posPanel.getPrice().compareTo(bigDecimal4) != 0 && this.fieldPrice.hasChanged() && actionEvent.getSource().equals(this.fieldPrice) || this.posPanel.getDiscountPercentage().compareTo(bigDecimal3) != 0 && this.fieldDiscountPercentage.hasChanged() && actionEvent.getSource().equals(this.fieldDiscountPercentage))) {
                    this.posPanel.setQty((BigDecimal)this.fieldQuantity.getValue());
                    this.posPanel.setPrice((BigDecimal)this.fieldPrice.getValue());
                    this.posPanel.setDiscountPercentage((BigDecimal)this.fieldDiscountPercentage.getValue());
                    this.posPanel.updateLineTable();
                    this.posPanel.changeViewPanel();
                    this.posPanel.refreshPanel();
                }
                return;
            }
        }
        catch (AdempiereException adempiereException) {
            ADialog.error(this.posPanel.getWindowNo(), this, adempiereException.getLocalizedMessage());
        }
    }

    public void changeStatus(boolean bl) {
        this.fieldQuantity.setEnabled(bl);
        this.fieldPrice.setEnabled(bl);
        this.fieldDiscountPercentage.setEnabled(bl);
        this.buttonDelete.setEnabled(bl);
        this.buttonPlus.setEnabled(bl);
        this.buttonMinus.setEnabled(bl);
        this.fieldQuantity.setReadWrite(true);
        this.fieldPrice.setReadWrite(true);
        this.fieldDiscountPercentage.setReadWrite(true);
    }

    @Override
    public void refreshPanel() {
        if (this.posPanel.hasLines()) {
            this.buttonDown.setEnabled(true);
            this.buttonUp.setEnabled(true);
            if (this.posPanel.getOrder().getDocStatus().compareToIgnoreCase("DR") == 0 || this.posPanel.getOrder().getDocStatus().compareToIgnoreCase("IP") == 0) {
                this.fieldQuantity.setReadWrite(true);
                this.fieldPrice.setReadWrite(true);
                this.fieldDiscountPercentage.setReadWrite(true);
                if (this.posPanel.isPresentElectronicScales()) {
                    this.buttonScales.setEnabled(true);
                }
                this.fieldQuantity.setEnabled(true);
                if (this.posPanel.isReturnMaterial()) {
                    this.fieldPrice.setEnabled(false);
                    this.fieldDiscountPercentage.setEnabled(false);
                } else {
                    this.fieldPrice.setEnabled(true);
                    this.fieldDiscountPercentage.setEnabled(true);
                }
            } else {
                this.fieldQuantity.setReadWrite(false);
                this.fieldPrice.setReadWrite(false);
                this.fieldDiscountPercentage.setReadWrite(false);
                if (this.posPanel.isPresentElectronicScales()) {
                    this.buttonScales.setEnabled(false);
                }
                this.fieldPrice.setEnabled(false);
                this.fieldQuantity.setEnabled(false);
                this.fieldDiscountPercentage.setEnabled(false);
            }
        } else {
            this.buttonDown.setEnabled(false);
            this.buttonUp.setEnabled(false);
        }
        this.changeViewPanel();
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    @Override
    public String validatePayment() {
        return null;
    }

    @Override
    public void changeViewPanel() {
        if (this.posPanel.getQty().compareTo(Env.ZERO) < 0) {
            this.changeStatus(false);
        } else {
            this.changeStatus(true);
        }
        this.fieldQuantity.setValue(this.posPanel.getQty());
        this.fieldPrice.setValue(this.posPanel.getPrice());
        this.fieldDiscountPercentage.setValue(this.posPanel.getDiscountPercentage());
    }

    public void resetPanel() {
        this.fieldQuantity.setValue(0);
        this.fieldPrice.setValue(0);
        this.fieldDiscountPercentage.setValue(0);
        this.buttonDown.setEnabled(false);
        this.buttonUp.setEnabled(false);
        this.buttonDelete.setEnabled(false);
        this.buttonPlus.setEnabled(false);
        this.buttonMinus.setEnabled(false);
        if (this.posPanel.isPresentElectronicScales()) {
            this.buttonScales.setEnabled(false);
        }
        this.fieldPrice.setReadWrite(false);
        this.fieldQuantity.setReadWrite(false);
        this.fieldDiscountPercentage.setReadWrite(false);
    }

    public void setQuantity(BigDecimal bigDecimal) {
        this.fieldQuantity.setValue(bigDecimal);
        this.fieldQuantity.requestFocus();
    }

    @Override
    public void requestFocus() {
        this.fieldQuantity.transferFocus();
    }
}

