/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.adempiere.pos.VPOS;
import org.compiere.apps.AppsAction;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Msg;

public class POSScalesPanel {
    private VPOS pos;
    private CButton buttonCaptureWeight;
    private CLabel labelWeight;
    private CPanel dialog;
    private CPanel mainPanel;
    private CPanel centerPanel;
    private CPanel parameterPanel;
    private BorderLayout mainLayout;
    private GridBagLayout parameterLayout;
    private JScrollPane scrollPane;

    public POSScalesPanel(VPOS vPOS) {
        this.pos = vPOS;
        this.init();
    }

    public void init() {
        this.dialog = new CPanel();
        this.dialog.setName(Msg.translate(this.pos.getCtx(), "@ElectronicScales@"));
        this.mainLayout = new BorderLayout();
        this.parameterLayout = new GridBagLayout();
        this.mainPanel = new CPanel();
        this.parameterPanel = new CPanel();
        this.centerPanel = new CPanel();
        this.scrollPane = new JScrollPane();
        Dimension dimension = this.pos.getSize();
        int n = dimension.width * 40 / 100;
        int n2 = dimension.height * 70 / 100;
        this.scrollPane.setPreferredSize(new Dimension(n, n2));
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.centerPanel.setLayout(this.parameterLayout);
        this.mainPanel.add(this.scrollPane);
        this.scrollPane.getViewport().add(this.centerPanel);
        this.dialog.add((Component)this.mainPanel, "Center");
        if (!this.dynInit()) {
            this.dialog.setVisible(false);
            return;
        }
    }

    private boolean dynInit() {
        this.labelWeight = new CLabel("0.000", 0);
        this.labelWeight.setFont(new Font("Arial", 1, 50));
        this.centerPanel.setLayout(this.parameterLayout);
        this.centerPanel.add(this.labelWeight);
        AppsAction appsAction = new AppsAction("Ok", KeyStroke.getKeyStroke(10, 0), false);
        appsAction.setDelegate(this.pos.getScalesListener());
        this.buttonCaptureWeight = (CButton)appsAction.getButton();
        this.buttonCaptureWeight.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.buttonCaptureWeight.setFocusable(true);
        this.buttonCaptureWeight.addKeyListener(this.pos.getScalesListener());
        this.parameterPanel.add((Component)this.buttonCaptureWeight, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.parameterPanel, "South");
        return true;
    }

    public void hidePanel() {
        this.dialog.setVisible(false);
    }

    public void showPanel() {
        this.dialog.setVisible(true);
        this.buttonCaptureWeight.requestFocus();
    }

    public void setMeasure(String string) {
        this.labelWeight.setText(string);
    }

    public CPanel getPanel() {
        return this.dialog;
    }
}

