/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.POSUserPinDialog;
import org.adempiere.pos.VPOS;
import org.compiere.apps.ADialog;
import org.compiere.grid.ed.VNumber;
import org.compiere.swing.CButton;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class POSUserPinListener
implements ActionListener {
    private VPOS pos;
    private static boolean active = true;

    POSUserPinListener(VPOS vPOS) {
        this.pos = vPOS;
    }

    public static void setActive(boolean bl) {
        active = bl;
    }

    protected void doPerformAction(ActionEvent actionEvent) {
        if (!"KeyEvent".equals(actionEvent.getActionCommand().toString()) || !actionEvent.getActionCommand().toString().equals("Cancel")) {
            return;
        }
        Object object = actionEvent.getSource();
        VNumber vNumber = null;
        CButton cButton = null;
        if (object instanceof VNumber) {
            vNumber = (VNumber)object;
        }
        if (object instanceof CButton) {
            cButton = (CButton)object;
        }
        if (!this.pos.isRequiredPIN()) {
            return;
        }
        if (vNumber != null && (Msg.translate(Env.getCtx(), "Discount").equals(vNumber.getName()) || Msg.translate(Env.getCtx(), "PriceActual").equals(vNumber.getName())) || cButton != null && "Cancel".equals(cButton.getName())) {
            POSUserPinDialog.show(this.pos);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (active) {
            try {
                if (actionEvent.getSource() == this.pos.getUserPinTimer()) {
                    this.pos.invalidateUserPin();
                    this.pos.getUserPinTimer().stop();
                    return;
                }
                if (this.pos.getUserPinTimer().isRunning()) {
                    return;
                }
                this.doPerformAction(actionEvent);
            }
            catch (AdempiereException adempiereException) {
                ADialog.error(this.pos.getWindowNo(), this.pos.getFrame(), adempiereException.getLocalizedMessage());
                throw new AdempiereException(adempiereException.getMessage());
            }
        }
    }
}

