/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pos.POSKeyboard;
import org.adempiere.pos.VCollectDetail;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.service.Collect;
import org.adempiere.pos.service.POSPanelInterface;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class VCollect
extends Collect
implements ActionListener,
POSPanelInterface,
VetoableChangeListener {
    private VPOS pos;
    private CPanel dialog;
    private BorderLayout mainLayout;
    private GridBagLayout parameterLayout;
    private CPanel mainPanel;
    private CPanel parameterPanel;
    private JScrollPane scrollPane;
    private CPanel centerPanel;
    private CLabel labelPaidAmt;
    private CLabel fieldPaidAmt;
    private CLabel labelPayAmt;
    private CLabel fieldPayAmt;
    private CLabel labelOpenAmt;
    private CLabel fieldOpenAmt;
    private CLabel labelReturnAmt;
    private CLabel fieldReturnAmt;
    private CButton buttonPlus;
    private CButton buttonCancel;
    private CButton buttonOk;
    private boolean isProcessed;
    private Properties ctx;
    private int collectRowNo;
    private CLogger log = CLogger.getCLogger(VCollect.class);
    private Dimension screenSize;
    private int widthSize;
    private int heightSize;

    public VCollect(VPOS vPOS) {
        super(vPOS.getCtx(), vPOS.getOrder(), vPOS.getM_POS());
        this.pos = vPOS;
        this.ctx = this.pos.getCtx();
        this.collectRowNo = 0;
        this.init();
    }

    public VCollect load(VPOS vPOS) {
        this.load(vPOS.getCtx(), vPOS.getOrder(), vPOS.getM_POS());
        this.centerPanel.removeAll();
        this.collectRowNo = 0;
        this.calculatePanelData();
        this.refreshPanel();
        this.addCollectType();
        this.pos.disablePOSButtons();
        return this;
    }

    public void init() {
        this.log.info("");
        try {
            this.jbInit();
            this.refreshPanel();
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "", exception);
        }
    }

    private void jbInit() throws Exception {
        this.screenSize = this.pos.getSize();
        this.widthSize = this.screenSize.width * 40 / 100;
        this.heightSize = this.screenSize.height * 50 / 100;
        this.dialog = new CPanel();
        this.dialog.setName(Msg.translate(this.ctx, "Payment"));
        this.mainLayout = new BorderLayout();
        this.parameterLayout = new GridBagLayout();
        this.mainPanel = new CPanel();
        this.parameterPanel = new CPanel();
        this.centerPanel = new CPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(this.widthSize, this.heightSize));
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.centerPanel.setLayout(this.parameterLayout);
        this.mainPanel.add(this.scrollPane);
        this.scrollPane.getViewport().add(this.centerPanel);
        this.labelPayAmt = new CLabel(Msg.translate(this.ctx, "PayAmt") + ":");
        this.labelPayAmt.setFont(this.pos.getBigFont());
        this.fieldPayAmt = new CLabel();
        this.fieldPayAmt.setFont(this.pos.getBigFont());
        this.labelOpenAmt = new CLabel(Msg.translate(this.ctx, "OpenAmt") + ":");
        this.labelOpenAmt.setFont(this.pos.getBigFont());
        this.fieldOpenAmt = new CLabel();
        this.fieldOpenAmt.setFont(this.pos.getBigFont());
        this.labelReturnAmt = new CLabel(Msg.translate(this.ctx, "AmountReturned") + ":");
        this.labelReturnAmt.setFont(this.pos.getBigFont());
        this.fieldReturnAmt = new CLabel();
        this.fieldReturnAmt.setFont(this.pos.getBigFont());
        this.labelPaidAmt = new CLabel(Msg.translate(this.ctx, "PaidAmt") + ":");
        this.labelPaidAmt.setFont(this.pos.getBigFont());
        this.labelPaidAmt.setVisible(false);
        this.fieldPaidAmt = new CLabel();
        this.fieldPaidAmt.setFont(this.pos.getBigFont());
        this.fieldPaidAmt.setVisible(false);
        AppsAction appsAction = new AppsAction("Plus", KeyStroke.getKeyStroke(113, 1009), false);
        appsAction.setDelegate(this);
        this.buttonPlus = (CButton)appsAction.getButton();
        this.buttonPlus.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.buttonPlus.setFocusable(false);
        this.buttonCancel = ConfirmPanel.createCancelButton(true);
        this.buttonCancel.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.buttonOk = ConfirmPanel.createOKButton(true);
        this.buttonOk.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.parameterPanel.add((Component)this.labelPayAmt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldPayAmt, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelOpenAmt, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldOpenAmt, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelReturnAmt, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldReturnAmt, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelPaidAmt, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldPaidAmt, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.buttonPlus, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.buttonCancel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.buttonOk, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.dialog.add((Component)this.mainPanel, "Center");
    }

    private void addCollectType() {
        BigDecimal bigDecimal;
        String string = "X";
        if (this.collectRowNo > 0) {
            string = "C";
        }
        if ((bigDecimal = this.getBalance(this.pos.getOpenAmt())).doubleValue() < 0.0) {
            bigDecimal = Env.ZERO;
        }
        VCollectDetail vCollectDetail = new VCollectDetail(this, string, bigDecimal);
        this.addCollect(vCollectDetail);
        this.centerPanel.add((Component)vCollectDetail.getPanel(), new GridBagConstraints(0, this.collectRowNo, 1, 1, 0.0, 0.0, 13, 11, new Insets(1, 1, 1, 1), 0, 0));
        this.scrollPane.validate();
        this.scrollPane.repaint();
        vCollectDetail.requestFocusInPayAmt();
        ++this.collectRowNo;
        this.calculatePanelData();
    }

    public void executePayment(String string) {
        if (this.pos.processOrder(string, this.isAllowsPartialPayment(), this.getBalance(this.pos.getOpenAmt()).signum() <= 0)) {
            this.processTenderTypes(string, this.pos.getOpenAmt());
            String string2 = this.getErrorMsg();
            if (string2 != null && string2.length() > 0) {
                throw new POSaveFailedException(Msg.parseTranslation(this.ctx, "@order.no@ " + this.pos.getDocumentNo() + ": " + this.getErrorMsg()));
            }
        } else {
            throw new POSaveFailedException(Msg.parseTranslation(this.ctx, "@order.no@ " + this.pos.getDocumentNo() + ": @ProcessRunError@ (" + this.pos.getProcessMsg() + ")"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.isProcessed = false;
        if (actionEvent.getSource().equals(this.buttonPlus)) {
            this.addCollectType();
        } else {
            if (actionEvent.getSource().equals(this.buttonOk)) {
                try {
                    this.pos.getFrame().getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    Trx.run(new TrxRunnable(){

                        @Override
                        public void run(String string) {
                            String string2 = VCollect.this.validatePayment();
                            if (string2 != null) {
                                throw new AdempiereException(string2);
                            }
                            VCollect.this.executePayment(string);
                            if (VCollect.this.pos.isToPrint()) {
                                VCollect.this.pos.printTicket();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    ADialog.warn(this.pos.getWindowNo(), this.dialog, Msg.parseTranslation(this.ctx, exception.getLocalizedMessage()));
                    this.pos.reloadOrder();
                    return;
                }
                finally {
                    this.pos.getFrame().getContentPane().setCursor(Cursor.getDefaultCursor());
                }
                this.isProcessed = true;
                this.hidePanel();
                this.pos.showKeyboard();
                this.pos.refreshPanel();
                this.pos.restoreTable();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonCancel)) {
                this.hidePanel();
                this.pos.showKeyboard();
                this.pos.refreshPanel();
                this.pos.restoreTable();
                return;
            }
        }
        this.changeViewPanel();
    }

    @Override
    public void removeAllCollectDetail() {
        this.centerPanel.removeAll();
        super.removeAllCollectDetail();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    public void removeCollectDetail(VCollectDetail vCollectDetail) {
        CPanel cPanel = vCollectDetail.getPanel();
        this.removeCollect(vCollectDetail);
        this.centerPanel.remove(cPanel);
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    public boolean showPanel() {
        this.dialog.setMinimumSize(new Dimension(this.widthSize, this.heightSize));
        this.dialog.setVisible(true);
        return this.isProcessed;
    }

    public POSKeyboard getKeyboard() {
        return this.pos.getKeyboard();
    }

    @Override
    public void refreshPanel() {
        this.calculatePanelData();
        this.changeViewPanel();
    }

    @Override
    public String validatePayment() {
        String string = null;
        if (!this.pos.hasOrder()) {
            string = "@POS.MustCreateOrder@";
        } else if (!this.pos.isStandardOrder()) {
            string = this.validateTenderTypes(this.pos.getOpenAmt());
        }
        return string;
    }

    @Override
    public void changeViewPanel() {
        boolean bl = this.pos.isCompleted() && this.pos.getOpenAmt().doubleValue() > 0.0;
        boolean bl2 = this.pos.isStandardOrder();
        this.setIsCreditOrder(this.isCreditOrder() || bl && !bl2);
        if (this.pos.isCompleted()) {
            this.buttonPlus.setEnabled(bl);
            this.buttonOk.setEnabled(true);
        } else if (this.pos.isVoided()) {
            this.buttonPlus.setEnabled(false);
            this.buttonOk.setEnabled(false);
        } else if (this.pos.isStandardOrder()) {
            this.buttonPlus.setEnabled(false);
        } else {
            this.buttonPlus.setEnabled(!this.isCreditOrder() || bl);
            this.buttonOk.setEnabled(true);
        }
    }

    private void calculatePanelData() {
        BigDecimal bigDecimal = this.getCollectDetailAmt();
        BigDecimal bigDecimal2 = this.getBalance(this.pos.getOpenAmt());
        String string = this.pos.getCurSymbol();
        if (this.isAllowsPartialPayment()) {
            this.labelPaidAmt.setVisible(true);
            this.fieldPaidAmt.setVisible(true);
            this.fieldPaidAmt.setText(string + " " + this.pos.getNumberFormat().format(this.pos.getPaidAmt()));
        } else {
            this.labelPaidAmt.setVisible(false);
            this.fieldPaidAmt.setVisible(false);
        }
        this.fieldPayAmt.setText(string + " " + this.pos.getNumberFormat().format(bigDecimal));
        BigDecimal bigDecimal3 = Env.ZERO;
        BigDecimal bigDecimal4 = Env.ZERO;
        if (bigDecimal2.doubleValue() < 0.0) {
            bigDecimal3 = bigDecimal2.abs();
        } else if (bigDecimal2.doubleValue() > 0.0) {
            bigDecimal4 = bigDecimal2;
        }
        this.fieldOpenAmt.setText(string + " " + this.pos.getNumberFormat().format(bigDecimal4));
        this.fieldReturnAmt.setText(string + " " + this.pos.getNumberFormat().format(bigDecimal3));
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        this.log.config(string + " = " + object);
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    public void hidePanel() {
        this.dialog.setVisible(false);
    }

    public CPanel getPanel() {
        return this.dialog;
    }

    public VPOS getPOS() {
        return this.pos;
    }
}

