/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Properties;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.adempiere.pos.POSKeyboard;
import org.adempiere.pos.POSLookupListCellRenderer;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VCollect;
import org.adempiere.pos.service.CollectDetail;
import org.adempiere.pos.service.POSPanelInterface;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class VCollectDetail
extends CollectDetail
implements VetoableChangeListener,
ActionListener,
KeyListener,
POSPanelInterface {
    private CPanel mainPanel;
    private CPanel standardPanel;
    private TitledBorder titleBorder;
    private GridBagLayout layout;
    private CButton buttonMinus;
    private CPanel checkPanel;
    private POSTextField fieldCheckNo;
    private POSTextField fieldCheckRoutingNo;
    private VDate fieldCheckDate;
    private CPanel debitPanel;
    private POSTextField fieldDebitRoutingNo;
    private POSTextField fieldDebitCVC;
    private POSTextField fieldDebitCountry;
    private CPanel creditPanel;
    private VLookup fieldCreditCardType;
    private POSTextField fieldCreditCardNumber;
    private POSTextField fieldName;
    private VComboBox fieldCreditCardExpMM;
    private VComboBox fieldCreditCardExpYY;
    private POSTextField fieldCreditCardVV;
    private CPanel creditMemoPanel;
    private VLookup fieldCreditMemo;
    private CLabel labelCreditMemo;
    private Properties ctx;
    private VLookup fieldTenderType;
    private VNumber fieldPayAmt;
    private VCollect parentCollect;
    private POSKeyboard keyboard;
    private Font font;
    private CLogger log = CLogger.getCLogger(VCollect.class);
    private final int FIELD_WIDTH = 200;
    private final int FIELD_HEIGHT = 25;

    public VCollectDetail(VCollect vCollect, String string, BigDecimal bigDecimal) {
        super(string, bigDecimal);
        this.ctx = Env.getCtx();
        this.parentCollect = vCollect;
        this.keyboard = vCollect.getKeyboard();
        this.init();
    }

    public CPanel getPanel() {
        return this.mainPanel;
    }

    private void loadStandardPanel() {
        this.standardPanel = new CPanel(this.layout);
        int n = 8416;
        MLookup mLookup = MLookupFactory.get(Env.getCtx(), 0, 0, n, 17);
        this.fieldTenderType = new VLookup("TenderType", true, false, true, mLookup);
        ((VComboBox)this.fieldTenderType.getCombo()).setRenderer(new POSLookupListCellRenderer(this.font));
        this.fieldTenderType.setPreferredSize(new Dimension(200, 25));
        ((VComboBox)this.fieldTenderType.getCombo()).setFont(this.font);
        this.fieldTenderType.addVetoableChangeListener(this);
        this.fieldPayAmt = new VNumber("PayAmt", true, false, true, 12, "");
        this.fieldPayAmt.setPreferredSize(new Dimension(200, 25));
        this.fieldPayAmt.setFont(this.font);
        this.fieldPayAmt.setValue(Env.ZERO);
        this.fieldPayAmt.addVetoableChangeListener(this);
        this.fieldPayAmt.addKeyListener(this);
        AppsAction appsAction = new AppsAction("Minus", KeyStroke.getKeyStroke(113, 1009), false);
        appsAction.setDelegate(this);
        this.buttonMinus = (CButton)appsAction.getButton();
        this.buttonMinus.setPreferredSize(new Dimension(25, 25));
        this.buttonMinus.setFocusable(false);
        this.standardPanel.add((Component)this.fieldTenderType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.standardPanel.add((Component)this.fieldPayAmt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
    }

    private void loadCheckPanel() {
        this.checkPanel = new CPanel(this.layout);
        String string = Msg.translate(this.ctx, "CheckNo");
        this.fieldCheckNo = new POSTextField(string, this.keyboard);
        this.fieldCheckNo.setPlaceholder(string);
        this.fieldCheckNo.setPreferredSize(new Dimension(200, 25));
        this.fieldCheckNo.setFont(this.font);
        this.fieldCheckNo.addKeyListener(this);
        this.fieldCheckNo.addActionListener(this);
        String string2 = Msg.translate(this.ctx, "RoutingNo");
        this.fieldCheckRoutingNo = new POSTextField(string2, this.keyboard);
        this.fieldCheckRoutingNo.setPlaceholder(string2);
        this.fieldCheckRoutingNo.setPreferredSize(new Dimension(200, 25));
        this.fieldCheckRoutingNo.setFont(this.font);
        this.fieldCheckRoutingNo.addKeyListener(this);
        this.fieldCheckRoutingNo.addActionListener(this);
        String string3 = Env.getAD_Language(this.ctx);
        Language language = Language.getLanguage(string3);
        Language.setLoginLanguage(language);
        Locale locale = language.getLocale();
        Locale.setDefault(locale);
        this.fieldCheckDate = new VDate(15);
        this.fieldCheckDate.setFormat();
        this.fieldCheckDate.setPreferredSize(new Dimension(200, 25));
        this.fieldCheckDate.setFont(this.font);
        this.fieldCheckDate.addActionListener(this);
        this.checkPanel.add((Component)this.fieldCheckRoutingNo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.checkPanel.add((Component)this.fieldCheckNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.checkPanel.add((Component)this.fieldCheckDate, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.checkPanel.setVisible(false);
    }

    private void loadDebitPanel() {
        this.debitPanel = new CPanel(this.layout);
        String string = Msg.translate(this.ctx, "RoutingNo");
        this.fieldDebitRoutingNo = new POSTextField(string, this.keyboard);
        this.fieldDebitRoutingNo.setPlaceholder(string);
        this.fieldDebitRoutingNo.setPreferredSize(new Dimension(200, 25));
        this.fieldDebitRoutingNo.setFont(this.font);
        this.fieldDebitRoutingNo.addKeyListener(this);
        this.fieldDebitRoutingNo.addActionListener(this);
        String string2 = Msg.translate(this.ctx, "R_CVV2Match");
        this.fieldDebitCVC = new POSTextField(string2, this.keyboard);
        this.fieldDebitCVC.setPlaceholder(string2);
        this.fieldDebitCVC.setPreferredSize(new Dimension(200, 25));
        this.fieldDebitCVC.setFont(this.font);
        this.fieldDebitCVC.addKeyListener(this);
        this.fieldDebitCVC.addActionListener(this);
        String string3 = Msg.translate(this.ctx, "A_Country");
        this.fieldDebitCountry = new POSTextField(string3, this.keyboard);
        this.fieldDebitCountry.setPlaceholder(string3);
        this.fieldDebitCountry.setPreferredSize(new Dimension(200, 25));
        this.fieldDebitCountry.setFont(this.font);
        this.fieldDebitCountry.addKeyListener(this);
        this.fieldDebitCountry.addActionListener(this);
        this.debitPanel.add((Component)this.fieldDebitRoutingNo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.debitPanel.add((Component)this.fieldDebitCountry, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.debitPanel.add((Component)this.fieldDebitCVC, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.debitPanel.setVisible(false);
    }

    private void loadCreditPanel() {
        this.creditPanel = new CPanel(this.layout);
        int n = 8374;
        MLookup mLookup = MLookupFactory.get(Env.getCtx(), 0, 0, n, 17);
        this.fieldCreditCardType = new VLookup("CreditCardType", true, false, true, mLookup);
        ((VComboBox)this.fieldCreditCardType.getCombo()).setRenderer(new POSLookupListCellRenderer(this.font));
        this.fieldCreditCardType.setPreferredSize(new Dimension(200, 25));
        ((VComboBox)this.fieldCreditCardType.getCombo()).setFont(this.font);
        this.fieldCreditCardType.addVetoableChangeListener(this);
        String string = Msg.translate(this.ctx, "CreditCardNumber");
        this.fieldCreditCardNumber = new POSTextField(string, this.parentCollect.getKeyboard());
        this.fieldCreditCardNumber.setPlaceholder(string);
        this.fieldCreditCardNumber.setPreferredSize(new Dimension(200, 25));
        this.fieldCreditCardNumber.setFont(this.font);
        this.fieldCreditCardNumber.addKeyListener(this);
        this.fieldCreditCardNumber.addActionListener(this);
        String string2 = Msg.translate(this.ctx, "A_Name");
        this.fieldName = new POSTextField(string2, this.parentCollect.getKeyboard());
        this.fieldName.setPlaceholder(string2);
        this.fieldName.setPreferredSize(new Dimension(200, 25));
        this.fieldName.setFont(this.font);
        this.fieldName.addKeyListener(this);
        this.fieldName.addActionListener(this);
        this.fieldCreditCardExpMM = new VComboBox(this.getCCMonths());
        this.fieldCreditCardExpMM.setName("CreditCardExpMM");
        this.fieldCreditCardExpMM.setValue(-1);
        this.fieldCreditCardExpMM.setMandatory(true);
        this.fieldCreditCardExpMM.setPreferredSize(new Dimension(100, 25));
        this.fieldCreditCardExpMM.setRenderer(new POSLookupListCellRenderer(this.font));
        this.fieldCreditCardExpMM.setFont(this.font);
        this.fieldCreditCardExpMM.addActionListener(this);
        this.fieldCreditCardExpYY = new VComboBox(this.getCCYears());
        this.fieldCreditCardExpYY.setName("CreditCardExpYY");
        this.fieldCreditCardExpYY.setValue(-1);
        this.fieldCreditCardExpYY.setMandatory(true);
        this.fieldCreditCardExpYY.setPreferredSize(new Dimension(100, 25));
        this.fieldCreditCardExpYY.setRenderer(new POSLookupListCellRenderer(this.font));
        this.fieldCreditCardExpYY.setFont(this.font);
        this.fieldCreditCardExpYY.addActionListener(this);
        String string3 = Msg.translate(this.ctx, "CreditCardVV");
        this.fieldCreditCardVV = new POSTextField(string3, this.parentCollect.getKeyboard());
        this.fieldCreditCardVV.setPlaceholder(string3);
        this.fieldCreditCardVV.setPreferredSize(new Dimension(200, 25));
        this.fieldCreditCardVV.setFont(this.font);
        this.fieldCreditCardVV.addKeyListener(this);
        this.fieldCreditCardVV.addActionListener(this);
        this.creditPanel.add((Component)this.fieldCreditCardType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditPanel.add((Component)this.fieldName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditPanel.add((Component)this.fieldCreditCardNumber, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditPanel.add((Component)this.fieldCreditCardVV, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditPanel.add((Component)this.fieldCreditCardExpMM, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditPanel.add((Component)this.fieldCreditCardExpYY, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditPanel.setVisible(false);
    }

    private void loadCreditMemo() {
        this.creditMemoPanel = new CPanel(this.layout);
        this.labelCreditMemo = new CLabel(Msg.translate(Env.getCtx(), "CreditMemo") + ":");
        this.labelCreditMemo.setPreferredSize(new Dimension(200, 25));
        MLookup mLookup = this.getCreditMemoLockup(this.parentCollect.getC_BPartner_ID());
        this.fieldCreditMemo = new VLookup("CreditMemo", false, false, true, mLookup);
        this.fieldCreditMemo.setPreferredSize(new Dimension(200, 25));
        this.fieldCreditMemo.addVetoableChangeListener(this);
        this.creditMemoPanel.add((Component)this.labelCreditMemo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditMemoPanel.add((Component)this.fieldCreditMemo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.creditMemoPanel.setVisible(false);
    }

    private void init() {
        this.font = this.parentCollect.getPOS().getFont();
        this.layout = new GridBagLayout();
        this.mainPanel = new CPanel(this.layout);
        this.loadStandardPanel();
        this.loadCheckPanel();
        this.loadDebitPanel();
        this.loadCreditPanel();
        this.loadCreditMemo();
        this.mainPanel.add((Component)this.standardPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.mainPanel.add((Component)this.buttonMinus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.mainPanel.add((Component)this.checkPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.mainPanel.add((Component)this.debitPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.mainPanel.add((Component)this.creditPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.mainPanel.add((Component)this.creditMemoPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 11, new Insets(2, 0, 2, 2), 0, 0));
        this.fieldTenderType.setValue(this.getTenderType());
        this.fieldCreditCardType.setValue(this.getCreditCardType());
        this.fieldPayAmt.setValue(this.getPayAmt());
        this.changeViewPanel();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        String string2 = this.getTenderType();
        this.log.config(string + " = " + object);
        if (propertyChangeEvent.getSource().equals(this.fieldPayAmt)) {
            BigDecimal bigDecimal = (BigDecimal)this.fieldPayAmt.getValue();
            if (string2.equals("M") && bigDecimal.compareTo(this.getOpenAmtCreditMemo()) > 0 && this.fieldCreditMemo.getValue() != null) {
                ADialog.warn(1, null, Msg.parseTranslation(this.ctx, "POS.MaxAmountAllowed") + ":" + this.getOpenAmtCreditMemo());
                this.fieldPayAmt.setValue(this.getOpenAmtCreditMemo());
            }
            this.setPayAmt((BigDecimal)this.fieldPayAmt.getValue());
            this.parentCollect.refreshPanel();
        } else if (string.equals("TenderType")) {
            String string3 = (String)(object != null ? object : Integer.valueOf(0));
            this.setTenderType(string3);
            this.changeViewPanel();
            this.fieldPayAmt.setValue(this.getInitPayAmt());
            this.setPayAmt((BigDecimal)this.fieldPayAmt.getValue());
            this.parentCollect.refreshPanel();
        } else if (string.equals("CreditCardType")) {
            this.setCreditCardType((String)this.fieldCreditCardType.getValue());
        } else if (string.equals("CreditMemo")) {
            int n = (Integer)(object != null ? object : Integer.valueOf(0));
            this.setC_Invoice_ID(n);
            this.setPayAmt(this.getInitPayAmt());
            this.parentCollect.refreshPanel();
            this.fieldPayAmt.setValue(this.getOpenAmtCreditMemo());
            this.setPayAmt((BigDecimal)this.fieldPayAmt.getValue());
            this.parentCollect.refreshPanel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonMinus)) {
            this.parentCollect.removeCollectDetail(this);
        } else if (actionEvent.getSource().equals(this.fieldCreditCardExpMM)) {
            this.setCreditCardExpMM((String)this.fieldCreditCardExpMM.getValue());
        } else if (actionEvent.getSource().equals(this.fieldCreditCardExpYY)) {
            this.setCreditCardExpYY((String)this.fieldCreditCardExpYY.getValue());
        } else if (actionEvent.getSource().equals(this.fieldCheckNo)) {
            this.setReferenceNo(this.fieldCheckNo.getText());
        } else if (actionEvent.getSource().equals(this.fieldCheckRoutingNo)) {
            this.setRoutingNo(this.fieldCheckRoutingNo.getText());
        } else if (actionEvent.getSource().equals(this.fieldCheckDate)) {
            this.setDateTrx(this.fieldCheckDate.getTimestamp());
        } else if (actionEvent.getSource().equals(this.fieldDebitRoutingNo)) {
            this.setRoutingNo(this.fieldDebitRoutingNo.getText());
        } else if (!actionEvent.getSource().equals(this.fieldDebitCVC)) {
            if (actionEvent.getSource().equals(this.fieldDebitCountry)) {
                this.setA_Country(this.fieldDebitCountry.getText());
            } else if (actionEvent.getSource().equals(this.fieldCreditCardNumber)) {
                this.setCreditCardNumber(this.fieldCreditCardNumber.getText());
            } else if (actionEvent.getSource().equals(this.fieldName)) {
                this.setA_Name(this.fieldName.getText());
            } else if (actionEvent.getSource().equals(this.fieldCreditCardVV)) {
                this.setCreditCardVV(this.fieldCreditCardVV.getText());
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!Character.isLetterOrDigit(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
        if (keyEvent.getSource().equals(this.fieldCheckNo)) {
            this.setReferenceNo(this.fieldCheckNo.getText());
        } else if (keyEvent.getSource().equals(this.fieldCheckRoutingNo)) {
            this.setRoutingNo(this.fieldCheckRoutingNo.getText());
        } else if (keyEvent.getSource().equals(this.fieldCheckDate)) {
            this.setDateTrx(this.fieldCheckDate.getTimestamp());
        } else if (keyEvent.getSource().equals(this.fieldDebitRoutingNo)) {
            this.setRoutingNo(this.fieldDebitRoutingNo.getText());
        } else if (keyEvent.getSource().equals(this.fieldDebitCVC)) {
            this.setCreditCardVV(this.fieldDebitCVC.getText());
        } else if (keyEvent.getSource().equals(this.fieldDebitCountry)) {
            this.setA_Country(this.fieldDebitCountry.getText());
        } else if (keyEvent.getSource().equals(this.fieldCreditCardNumber)) {
            this.setCreditCardNumber(this.fieldCreditCardNumber.getText());
        } else if (keyEvent.getSource().equals(this.fieldName)) {
            this.setA_Name(this.fieldName.getText());
        } else if (keyEvent.getSource().equals(this.fieldCreditCardVV)) {
            this.setCreditCardVV(this.fieldCreditCardVV.getText());
        } else {
            this.setPayAmt((BigDecimal)this.fieldPayAmt.getValue());
        }
        this.parentCollect.refreshPanel();
    }

    @Override
    public void refreshPanel() {
    }

    @Override
    public String validatePayment() {
        return null;
    }

    public void requestFocusInPayAmt() {
        this.fieldPayAmt.requestFocus();
    }

    @Override
    public void changeViewPanel() {
        String string = this.getTenderType();
        if (string == null) {
            return;
        }
        String string2 = this.fieldTenderType.getDisplay();
        if (string.equals("K")) {
            this.checkPanel.setVisible(true);
            this.debitPanel.setVisible(false);
            this.creditPanel.setVisible(false);
            this.creditMemoPanel.setVisible(false);
        } else if (string.equals("D")) {
            this.checkPanel.setVisible(false);
            this.debitPanel.setVisible(true);
            this.creditPanel.setVisible(false);
            this.creditMemoPanel.setVisible(false);
        } else if (string.equals("C")) {
            this.checkPanel.setVisible(false);
            this.debitPanel.setVisible(false);
            this.creditPanel.setVisible(true);
            this.creditMemoPanel.setVisible(false);
        } else if (string.equals("M")) {
            this.checkPanel.setVisible(false);
            this.debitPanel.setVisible(false);
            this.creditPanel.setVisible(false);
            this.creditMemoPanel.setVisible(true);
        } else {
            this.checkPanel.setVisible(false);
            this.debitPanel.setVisible(false);
            this.creditPanel.setVisible(false);
            this.creditMemoPanel.setVisible(false);
        }
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }
}

