/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.command;

import java.util.HashMap;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.command.Command;
import org.adempiere.pos.command.CommandCompleteDocument;
import org.adempiere.pos.command.CommandGenerateReturn;
import org.adempiere.pos.command.CommandImmediateInvoice;
import org.adempiere.pos.command.CommandReceiver;
import org.adempiere.pos.command.CommandReverseSalesTransaction;
import org.adempiere.pos.command.CommandWithdrawal;
import org.adempiere.pos.process.CloseStatementPOS;
import org.adempiere.pos.process.CreateOrderBasedOnAnother;
import org.adempiere.pos.process.GenerateImmediateInvoice;
import org.adempiere.pos.process.GenerateWithdrawal;
import org.adempiere.pos.process.ReverseTheSalesTransaction;

public class CommandManager {
    public static String GENERATE_IMMEDIATE_INVOICE = GenerateImmediateInvoice.getProcessValue();
    public static String GENERATE_REVERSE_SALES = ReverseTheSalesTransaction.getProcessValue();
    public static String GENERATE_RETURN = CreateOrderBasedOnAnother.getProcessValue();
    public static String COMPLETE_DOCUMENT = "Complete Document";
    public static String GENERATE_WITHDRAWAL = GenerateWithdrawal.getProcessValue();
    public static String CLOSE_STATEMENT = CloseStatementPOS.getProcessValue();
    private HashMap<String, Command> commands = new HashMap();
    private HashMap<String, CommandReceiver> receivers = new HashMap<String, CommandReceiver>(){
        {
            CommandReceiver commandReceiver = new CommandReceiver(null, GENERATE_IMMEDIATE_INVOICE, GenerateImmediateInvoice.getProcessName());
            CommandManager.this.commands.put(GENERATE_IMMEDIATE_INVOICE, new CommandImmediateInvoice(GENERATE_IMMEDIATE_INVOICE, commandReceiver.getEvent()));
            this.put(GENERATE_IMMEDIATE_INVOICE, commandReceiver);
            commandReceiver = new CommandReceiver(null, GENERATE_REVERSE_SALES, ReverseTheSalesTransaction.getProcessName());
            CommandManager.this.commands.put(GENERATE_REVERSE_SALES, new CommandReverseSalesTransaction(GENERATE_REVERSE_SALES, commandReceiver.getEvent()));
            this.put(GENERATE_REVERSE_SALES, commandReceiver);
            commandReceiver = new CommandReceiver(null, GENERATE_RETURN, "@Create@ @new.customer.return.order@");
            CommandManager.this.commands.put(GENERATE_RETURN, new CommandGenerateReturn(GENERATE_RETURN, commandReceiver.getEvent()));
            this.put(GENERATE_RETURN, commandReceiver);
            commandReceiver = new CommandReceiver(null, COMPLETE_DOCUMENT, "@smenu.complete.prepared.order@");
            CommandManager.this.commands.put(COMPLETE_DOCUMENT, new CommandCompleteDocument(COMPLETE_DOCUMENT, commandReceiver.getEvent()));
            this.put(COMPLETE_DOCUMENT, commandReceiver);
            commandReceiver = new CommandReceiver(null, GENERATE_WITHDRAWAL, GenerateWithdrawal.getProcessName());
            CommandManager.this.commands.put(GENERATE_WITHDRAWAL, new CommandWithdrawal(GENERATE_WITHDRAWAL, commandReceiver.getEvent()));
            this.put(GENERATE_WITHDRAWAL, commandReceiver);
            commandReceiver = new CommandReceiver(null, CLOSE_STATEMENT, CloseStatementPOS.getProcessName());
            CommandManager.this.commands.put(CLOSE_STATEMENT, new CommandWithdrawal(CLOSE_STATEMENT, commandReceiver.getEvent()));
            this.put(CLOSE_STATEMENT, commandReceiver);
        }
    };

    public HashMap<String, CommandReceiver> getCommandReceivers() {
        return this.receivers;
    }

    public Command getCommand(String string) {
        return this.commands.values().stream().filter(command -> command.getEvent() == string).findFirst().orElseThrow(() -> new AdempierePOSException(string + " @NotFound@"));
    }

    public CommandReceiver getCommandReceivers(String string) {
        return this.receivers.values().stream().filter(commandReceiver -> commandReceiver.getEvent() == string).findFirst().orElseThrow(() -> new AdempierePOSException(string + " @NotFound@ "));
    }
}

