/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.command;

import java.util.Optional;
import java.util.Properties;
import org.adempiere.pos.AdempierePOSException;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CommandReceiver {
    private Properties ctx;
    private Optional<Integer> processId;
    private Optional<Integer> bankAccountId;
    private Optional<Integer> posId;
    private Optional<String> value;
    private Optional<String> name;
    private Optional<Integer> orderId;
    private Optional<Integer> partnerId;
    private Optional<Integer> warehouseId;
    private Optional<String> event;
    private ProcessInfo processInfo;

    public CommandReceiver(Integer n, String string, String string2) {
        this.setValue(string);
        if (n != null && n > 0) {
            this.setName(MProcess.get(Env.getCtx(), n).getName());
            if (string2 != null) {
                this.setEvent(Msg.parseTranslation(Env.getCtx(), string2));
            } else {
                this.setEvent(this.getName());
            }
        } else if (string != null && string.length() > 0) {
            this.setProcessId(MProcess.getProcess_ID(string, null));
            this.setName(MProcess.get(Env.getCtx(), this.getProcessId()).getName());
            if (string2 != null) {
                this.setEvent(Msg.parseTranslation(Env.getCtx(), string2));
            } else {
                this.setEvent(this.getName());
            }
        } else if (string == null && string2 != null && string2.length() > 0) {
            this.setEvent(Msg.parseTranslation(Env.getCtx(), string2));
        }
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public void setCtx(Properties properties) {
        this.ctx = properties;
    }

    public Integer getProcessId() {
        return this.processId.orElseThrow(() -> new AdempierePOSException("@AD_Process_ID@ @NotFound@"));
    }

    public void setProcessId(Integer n) {
        this.processId = Optional.ofNullable(n);
    }

    public String getValue() {
        return this.value.orElseThrow(() -> new AdempierePOSException("@Value@ @NotFound@"));
    }

    public void setValue(String string) {
        this.value = Optional.ofNullable(string);
    }

    public String getName() {
        return this.name.orElseThrow(() -> new AdempierePOSException("@Name@ @NotFound@"));
    }

    public void setName(String string) {
        this.name = Optional.ofNullable(string);
    }

    public String getEvent() {
        return this.event.orElseThrow(() -> new AdempierePOSException("Event Name @NotFound@"));
    }

    public void setEvent(String string) {
        this.event = Optional.ofNullable(string);
    }

    public Integer getOrderId() {
        return this.orderId.orElseThrow(() -> new AdempierePOSException("@C_Order_ID@ @NotFound@"));
    }

    public void setOrderId(int n) {
        this.orderId = Optional.ofNullable(n);
    }

    public void setPartnerId(Integer n) {
        this.partnerId = Optional.ofNullable(n);
    }

    public Integer getPartnerId() {
        return this.partnerId.orElseThrow(() -> new AdempierePOSException("@C_BPartner_ID@ @NotFound@"));
    }

    public void setWarehouseId(Integer n) {
        this.warehouseId = Optional.ofNullable(n);
    }

    public Integer getWarehouseId() {
        return this.warehouseId.orElseThrow(() -> new AdempierePOSException("@M_Warehouse_ID@ @NotFound@"));
    }

    public void setBankAccountId(Integer n) {
        this.bankAccountId = Optional.ofNullable(n);
    }

    public Integer getBankAccountId() {
        return this.bankAccountId.orElseThrow(() -> new AdempierePOSException("@C_BankAccount_ID@ @NotFound@"));
    }

    public void setPOSId(Integer n) {
        this.posId = Optional.ofNullable(n);
    }

    public Integer getPOSId() {
        return this.posId.orElseThrow(() -> new AdempierePOSException("@C_POS_ID@ @NotFound@"));
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }
}

