/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.search.POSQuery;
import org.compiere.grid.ed.VDate;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.PO;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryOrderHistory
extends POSQuery {
    private static final long serialVersionUID = 7713957495649128816L;
    private POSTextField fieldDocumentNo;
    private VDate fieldDateFrom;
    private VDate fieldDateTo;
    private POSTextField fieldBPartner;
    private CCheckBox fieldProcessed;
    private CCheckBox fieldAllowDate;
    private int orderId;
    private static final String DOCUMENTNO = "DocumentNo";
    private static final String DOCTYPE = "C_DocType_ID";
    private static final String BPARTNERID = "C_BPartner_ID";
    private static final String GRANDTOTAL = "GrandTotal";
    private static final String OPENAMT = "OpenAmt";
    private static final String PAID = "IsPaid";
    private static final String PROCESSED = "Processed";
    private static final String DATE = "Date";
    private static final String INVOICED = "IsInvoiced";
    private static final String DATEORDEREDFROM = "From";
    private static final String DATEORDEREDTO = "To";
    private static final String DATEORDERED = "DateOrdered";
    private static final String QUERY = "Query";
    private static ColumnInfo[] columnInfos = new ColumnInfo[]{new ColumnInfo(" ", "C_Order_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DocumentNo"), "DocumentNo", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_DocType_ID"), "C_DocType_ID", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "C_BPartner_ID", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DateOrdered"), "DateOrdered", Date.class), new ColumnInfo(Msg.translate(Env.getCtx(), "GrandTotal"), "GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "OpenAmt"), "OpenAmt", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsPaid"), "IsPaid", Boolean.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Processed"), "Processed", Boolean.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsInvoiced"), "IsInvoiced", Boolean.class)};

    public QueryOrderHistory(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    protected void init() {
        this.setTitle(Msg.translate(Env.getCtx(), "C_Order_ID"));
        this.parameterPanel.setLayout((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        this.parameterPanel.setBorder(new TitledBorder(Msg.getMsg(this.ctx, QUERY)));
        CLabel cLabel = new CLabel(Msg.translate(this.ctx, DOCUMENTNO));
        this.parameterPanel.add((Component)cLabel, " growy");
        this.fieldDocumentNo = new POSTextField("", this.posPanel.getKeyboard());
        cLabel.setLabelFor(this.fieldDocumentNo);
        this.parameterPanel.add((Component)this.fieldDocumentNo, "h 30, w 200");
        this.fieldDocumentNo.addActionListener(this);
        CLabel cLabel2 = new CLabel(Msg.translate(this.ctx, DATEORDEREDFROM));
        this.parameterPanel.add((Component)cLabel2, "growy");
        this.fieldDateFrom = new VDate();
        this.fieldDateFrom.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        cLabel2.setLabelFor(this.fieldDateFrom);
        this.parameterPanel.add((Component)this.fieldDateFrom, "h 30, w 200");
        this.fieldDateFrom.addVetoableChangeListener(this);
        this.fieldAllowDate = new CCheckBox(Msg.translate(this.ctx, DATE));
        this.fieldAllowDate.setSelected(false);
        this.fieldAllowDate.addActionListener(this);
        this.parameterPanel.add((Component)this.fieldAllowDate, "wrap");
        this.posTable.prepareTable(columnInfos, "C_Order", "C_POS_ID = " + this.posPanel.getC_POS_ID(), false, "C_Order");
        this.posTable.growScrollbars();
        CLabel cLabel3 = new CLabel(Msg.translate(this.ctx, BPARTNERID));
        this.parameterPanel.add((Component)cLabel3, "growy");
        this.fieldBPartner = new POSTextField("", this.posPanel.getKeyboard());
        cLabel3.setLabelFor(this.fieldBPartner);
        this.parameterPanel.add((Component)this.fieldBPartner, "h 30, w 200");
        this.fieldBPartner.addActionListener(this);
        CLabel cLabel4 = new CLabel(Msg.translate(this.ctx, DATEORDEREDTO));
        this.parameterPanel.add((Component)cLabel4, "growy");
        this.fieldDateTo = new VDate();
        this.fieldDateTo.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        cLabel4.setLabelFor(this.fieldDateTo);
        this.parameterPanel.add((Component)this.fieldDateTo, "h 30, w 200");
        this.fieldDateTo.addVetoableChangeListener(this);
        this.fieldProcessed = new CCheckBox(Msg.translate(this.ctx, PROCESSED));
        this.fieldProcessed.setSelected(false);
        this.fieldProcessed.addActionListener(this);
        this.parameterPanel.add((Component)this.fieldProcessed, "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryOrderHistory.this.fieldDocumentNo.requestFocus();
            }
        });
        this.pack();
        this.refresh();
    }

    @Override
    public void reset() {
        this.fieldProcessed.setSelected(false);
        this.fieldDocumentNo.setText(null);
        this.fieldDateFrom.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.fieldDateTo.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.refresh();
    }

    private void cleanValues() {
        this.orderId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultsFromArray(Properties properties, boolean bl, String string, Timestamp timestamp, Timestamp timestamp2, String string2, boolean bl2) {
        block16: {
            StringBuffer stringBuffer = new StringBuffer();
            CPreparedStatement cPreparedStatement = null;
            ResultSet resultSet = null;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                stringBuffer.append(" SELECT o.C_Order_ID, o.DocumentNo, dt.Name AS C_DocType_ID ,").append(" b.Name, TRUNC(o.dateordered,'DD') as dateordered, o.GrandTotal, ").append("COALESCE(o.GrandTotal - (SELECT SUM(PayAmt) FROM C_Payment p WHERE p.C_Order_ID=o.C_Order_ID))  AS OpenAmt,").append(" (CASE WHEN o.GrandTotal - (SELECT SUM(PayAmt) FROM C_Payment p WHERE p.C_Order_ID=o.C_Order_ID) = 0 THEN 'Y' ELSE 'N' END) IsPaid, ").append(" o.Processed, ").append(" CASE WHEN COALESCE(COUNT(i.C_Invoice_ID), 0) > 0 THEN 'Y' ELSE 'N' END").append(" FROM C_Order o ").append(" INNER JOIN C_BPartner b ON (o.C_BPartner_ID = b.C_BPartner_ID)");
                if (Env.isBaseLanguage(Env.getAD_Language(properties), "C_DocType")) {
                    stringBuffer.append(" INNER JOIN C_DocType      dt ON (o.C_DocTypeTarget_ID = dt.C_DocType_ID)");
                } else {
                    stringBuffer.append(" INNER JOIN C_DocType_trl  dt ON (o.C_DocTypeTarget_ID = dt.C_DocType_ID AND dt.AD_LANGUAGE = '" + Env.getAD_Language(properties) + "')");
                }
                stringBuffer.append(" LEFT JOIN C_invoice   i ON (i.C_Order_ID = o.C_Order_ID)").append(" LEFT JOIN C_AllocationLine al ON (o.C_Order_ID = al.C_Order_ID)").append(" WHERE  o.DocStatus <> 'VO'").append(" AND o.C_POS_ID = ?").append(" AND o.Processed= ?");
                if (string != null && !string.equalsIgnoreCase("")) {
                    stringBuffer.append(" AND (o.DocumentNo LIKE '%" + string + "%' OR  i.DocumentNo LIKE '%" + string + "%')");
                }
                if (timestamp != null && bl2) {
                    if (timestamp2 != null && !timestamp2.equals(timestamp)) {
                        stringBuffer.append(" AND o.DateOrdered >= ? AND o.DateOrdered <= ?");
                    } else {
                        stringBuffer.append(" AND o.DateOrdered = ? ");
                    }
                }
                if (string2 != null && !string2.equalsIgnoreCase("")) {
                    stringBuffer.append(" AND (UPPER(b.name) LIKE '%" + string2 + "%' OR UPPER(b.value) LIKE '%" + string2 + "%' )");
                }
                stringBuffer.append(" GROUP BY o.C_Order_ID, o.DocumentNo, dt.Name , b.Name, o.GrandTotal, o.Processed, i.IsPaid ");
                stringBuffer.append(" ORDER BY o.Updated");
                int n = 1;
                cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
                cPreparedStatement.setInt(n++, this.posPanel.getC_POS_ID());
                cPreparedStatement.setString(n++, bl ? "Y" : "N");
                if (timestamp != null && bl2) {
                    cPreparedStatement.setTimestamp(n++, timestamp);
                    if (timestamp2 != null && !timestamp2.equals(timestamp)) {
                        cPreparedStatement.setTimestamp(n++, timestamp2);
                    }
                }
                resultSet = cPreparedStatement.executeQuery();
                this.posTable.loadTable(resultSet);
                int n2 = this.posTable.getRowCount();
                if (n2 > 0) {
                    this.posTable.setRowSelectionInterval(0, 0);
                    if (n2 == 1) {
                        this.select();
                    }
                }
                DB.close(resultSet);
            }
            catch (Exception exception) {
                logger.severe("QueryTicket.setResults: " + exception + " -> " + stringBuffer);
                break block16;
            }
            finally {
                DB.close(resultSet);
                DB.close(cPreparedStatement);
                this.setCursor(Cursor.getDefaultCursor());
            }
            DB.close(cPreparedStatement);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void select() {
        Integer n;
        boolean bl;
        this.cleanValues();
        int n2 = this.posTable.getSelectedRow();
        boolean bl2 = bl = n2 != -1;
        if (bl && (n = this.posTable.getSelectedRowKey()) != null) {
            this.orderId = n;
        }
        logger.info("ID=" + this.orderId);
    }

    @Override
    protected void close() {
        this.select();
        this.dispose();
    }

    @Override
    public void refresh() {
        this.cleanValues();
        this.fieldDateTo.setEnabled(this.fieldAllowDate.isSelected());
        this.fieldDateFrom.setEnabled(this.fieldAllowDate.isSelected());
        this.setResultsFromArray(this.ctx, this.fieldProcessed.isSelected(), this.fieldDocumentNo.getText(), this.fieldDateFrom.getTimestamp(), this.fieldDateTo.getTimestamp(), this.fieldBPartner.getText().toUpperCase(), this.fieldAllowDate.isSelected());
    }

    @Override
    public void setResults(PO[] pOArray) {
    }

    @Override
    protected void cancel() {
        this.cleanValues();
        this.dispose();
    }

    @Override
    public int getRecord_ID() {
        return this.orderId;
    }

    @Override
    public String getValue() {
        return null;
    }
}

