/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service.driver;

import java.math.BigDecimal;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.service.driver.POSScalesDriverInterface;

public class POSScalesDriver
implements POSScalesDriverInterface {
    private String electronicScales;
    private String measureRequestCode;
    private boolean loadLibrary;

    private native boolean openPort(String var1);

    private native String getMeasureMessage();

    public native void closePort();

    @Override
    public void setup() {
        this.loadLibrary = false;
        if (this.getElectronicScales() == null) {
            throw new AdempierePOSException("@NotFound@ @Port@ @ElectronicScales@");
        }
        if (this.getMeasureRequestCode() == null) {
            throw new AdempierePOSException("@NotFound@ @MeasureRequestCode@");
        }
    }

    public POSScalesDriver(String string, String string2) {
        this.setElectronicScales(string);
        this.setMeasureRequestCode(string2);
        this.setup();
    }

    @Override
    public String getElectronicScales() {
        return this.electronicScales;
    }

    @Override
    public void setElectronicScales(String string) {
        this.electronicScales = string;
    }

    @Override
    public String getMeasureRequestCode() {
        return this.measureRequestCode;
    }

    @Override
    public void setMeasureRequestCode(String string) {
        this.measureRequestCode = string;
    }

    @Override
    public boolean loadLibrary() {
        if (this.loadLibrary) {
            return this.loadLibrary;
        }
        try {
            System.loadLibrary("scale");
            this.loadLibrary = true;
            return this.loadLibrary;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    @Override
    public BigDecimal getMeasure() {
        if (this.loadLibrary()) {
            String[] stringArray;
            if (!this.openPort(this.getElectronicScales())) {
                throw new AdempierePOSException("@NotFound@ @Port@ @ElectronicScales@");
            }
            String string = this.getMeasureMessage().trim();
            if (string != null && !string.equals("NEG") && (stringArray = string.split(" ")) != null && stringArray.length > 0) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(stringArray[0].trim());
                    if (bigDecimal != null && bigDecimal.signum() > 0) {
                        this.closePort();
                        return bigDecimal;
                    }
                    return BigDecimal.ONE;
                }
                catch (Exception exception) {
                    throw new AdempierePOSException("@Error@ @From@ @ElectronicScales@ : " + string);
                }
            }
        }
        return BigDecimal.ONE;
    }
}

