/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.GenerateNotRealizedGainLossAbstract;
import org.compiere.model.I_T_InvoiceGL;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MElementValue;
import org.compiere.model.MFactAcct;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_T_InvoiceGL;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class GenerateNotRealizedGainLoss
extends GenerateNotRealizedGainLossAbstract {
    private List<X_T_InvoiceGL> exchangeGainLossList = new ArrayList<X_T_InvoiceGL>();
    private HashMap<Integer, MJournalBatch> journalBatches = new HashMap();
    private HashMap<String, MJournal> journals = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() {
        this.cleanTemporaryTable();
        this.getAccountsForeignCurrency().forEach(accountId -> this.getAccountingSchemes().stream().forEach(accountingSchema -> this.getAccountBalanceByCurrency(accountingSchema.get_ID(), (Integer)accountId).stream().forEach(balanceCurrency -> this.getAccountRecordsByCurrency((MAcctSchema)accountingSchema, (Integer)accountId, balanceCurrency.getKey()).stream().forEach(factAcctId -> Trx.run(trxName -> this.createExchangeGainLossReport((MAcctSchema)accountingSchema, (Integer)factAcctId, trxName))))));
        if ("Y".equals(this.getIsCreateNewJournal())) {
            if (this.getDocTypeRevalId() <= 0) {
                throw new AdempiereException("@C_ConversionTypeReval_ID@ @NotFound@");
            }
            Trx.run(trxName -> this.exchangeGainLoss(trxName));
        }
        return "@Ok@";
    }

    private void exchangeGainLoss(String trxName) {
        AtomicInteger lineNo = new AtomicInteger(10);
        this.exchangeGainLossList.stream().collect(Collectors.groupingBy(X_T_InvoiceGL::getC_AcctSchema_ID, Collectors.groupingBy(PO::getAD_Org_ID, Collectors.groupingBy(X_T_InvoiceGL::getAccount_ID, Collectors.groupingBy(X_T_InvoiceGL::getC_Currency_ID))))).entrySet().stream().forEach(organizationEntry -> ((Map)organizationEntry.getValue()).entrySet().stream().forEach(accountSchemeEntry -> ((Map)accountSchemeEntry.getValue()).entrySet().stream().forEach(accountEntry -> ((Map)accountEntry.getValue()).entrySet().stream().map(currencyEntry -> {
            BigDecimal sourceAmountBalance = ((List)currencyEntry.getValue()).stream().collect(Collectors.reducing(BigDecimal.ZERO, I_T_InvoiceGL::getAmtSourceBalance, BigDecimal::add));
            BigDecimal accountAmountBalance = ((List)currencyEntry.getValue()).stream().collect(Collectors.reducing(BigDecimal.ZERO, I_T_InvoiceGL::getAmtAcctBalance, BigDecimal::add));
            BigDecimal debit = ((List)currencyEntry.getValue()).stream().collect(Collectors.reducing(BigDecimal.ZERO, I_T_InvoiceGL::getAmtRevalDrDiff, BigDecimal::add));
            BigDecimal credit = ((List)currencyEntry.getValue()).stream().collect(Collectors.reducing(BigDecimal.ZERO, I_T_InvoiceGL::getAmtRevalCrDiff, BigDecimal::add));
            AccountBalance accountBalance = new AccountBalance();
            accountBalance.companyId = this.getAD_Client_ID();
            accountBalance.organizationId = (Integer)organizationEntry.getKey();
            accountBalance.accountSchemaId = (Integer)accountEntry.getKey();
            accountBalance.accountId = (Integer)accountEntry.getKey();
            accountBalance.currencyId = (Integer)currencyEntry.getKey();
            accountBalance.sourceBalance = sourceAmountBalance;
            accountBalance.accountBalance = accountAmountBalance;
            accountBalance.debit = debit;
            accountBalance.credit = credit;
            return accountBalance;
        }).collect(Collectors.toList()).stream().filter(accountBalance -> accountBalance.debit.subtract(accountBalance.credit).signum() != 0).forEach(accountBalance -> {
            MAcctSchema accountingSchema = MAcctSchema.get(this.getCtx(), (Integer)accountSchemeEntry.getKey());
            MCurrency currency = MCurrency.get(Env.getCtx(), accountBalance.currencyId);
            MElementValue account = new MElementValue(this.getCtx(), accountBalance.accountId, trxName);
            MJournalBatch journalBatch = this.createJournalBatch(accountingSchema, trxName);
            MJournal journal = this.createJournal(journalBatch, accountingSchema, currency, accountBalance.organizationId);
            BigDecimal rate = MConversionRate.getRate(accountBalance.currencyId, accountingSchema.getC_Currency_ID(), this.getDateReval(), this.getConversionTypeRevalId(), accountBalance.companyId, accountBalance.organizationId);
            this.createJournalLine(journal, accountingSchema, account, (AccountBalance)accountBalance, currency, rate, lineNo);
        }))));
    }

    private MJournalBatch createJournalBatch(MAcctSchema accountingSchema, String trxName) {
        if (this.journalBatches.containsKey(accountingSchema.get_ID())) {
            return this.journalBatches.get(accountingSchema.get_ID());
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        MJournalBatch journalBatch = new MJournalBatch(this.getCtx(), 0, trxName);
        StringBuilder journalBatchDescription = new StringBuilder();
        Optional.ofNullable(this.getBatchDescription()).ifPresent(batchDescription -> journalBatchDescription.append((String)batchDescription).append(" "));
        journalBatchDescription.append(this.getName()).append(" @DateAcct@ ").append(this.getDateReval());
        journalBatch.setDateAcct(this.getDateReval());
        journalBatch.setDateDoc(this.getDateReval());
        journalBatch.setDescription(Msg.parseTranslation(this.getCtx(), journalBatchDescription.toString()));
        journalBatch.setC_DocType_ID(this.getDocTypeRevalId());
        journalBatch.setDateDoc(today);
        journalBatch.setDateAcct(this.getDateReval());
        journalBatch.setC_Currency_ID(accountingSchema.getC_Currency_ID());
        journalBatch.saveEx();
        this.journalBatches.put(accountingSchema.get_ID(), journalBatch);
        return journalBatch;
    }

    private MJournal createJournal(MJournalBatch journalBatch, MAcctSchema accountingSchema, MCurrency currency, Integer organizationId) {
        String key = organizationId + "+" + currency.get_ID();
        if (this.journals.containsKey(key)) {
            return this.journals.get(key);
        }
        MDocType documentType = MDocType.get(this.getCtx(), this.getDocTypeRevalId());
        Integer glCategoryId = Optional.ofNullable(MGLCategory.getDefaultSystem(this.getCtx()).get_ID()).orElse(documentType.getGL_Category_ID());
        MJournal journal = new MJournal(journalBatch);
        journal.setDateAcct(this.getDateReval());
        journal.setDateDoc(this.getDateReval());
        journal.setC_AcctSchema_ID(accountingSchema.get_ID());
        journal.setAD_Org_ID(organizationId);
        journal.setC_Currency_ID(accountingSchema.getC_Currency_ID());
        journal.setC_ConversionType_ID(this.getConversionTypeRevalId());
        journal.setGL_Category_ID(glCategoryId);
        journal.setGL_JournalBatch_ID(journalBatch.getGL_JournalBatch_ID());
        StringBuilder journalDescription = new StringBuilder();
        journalDescription.append("@C_AcctSchema_ID@ ").append(accountingSchema.getName()).append(" @C_Currency_ID@ ").append(currency.getISO_Code());
        journal.setDescription(Msg.parseTranslation(Env.getCtx(), journalDescription.toString()));
        journal.saveEx();
        this.journals.put(key, journal);
        return journal;
    }

    private void createJournalLine(MJournal journal, MAcctSchema accountingSchema, MElementValue account, AccountBalance accountBalance, MCurrency currency, BigDecimal rate, AtomicInteger lineNo) {
        MJournalLine journalLine = new MJournalLine(journal);
        journalLine.setLine(lineNo.getAndUpdate(no -> no + 10));
        journalLine.setAccount_ID(account.getC_ElementValue_ID());
        StringBuilder journalDescriptionLine = new StringBuilder();
        journalDescriptionLine.append("@Account_ID@ ").append(account.getName()).append(" @C_Currency_ID@ ").append(currency.getISO_Code()).append(" ").append(accountBalance.sourceBalance).append(" @C_Currency_ID@ ").append(accountingSchema.getC_Currency().getISO_Code()).append(" ").append(accountBalance.accountBalance).append(" @C_Conversion_Rate_ID@ ").append(Optional.of(rate.toString()).orElse(" @NotFound@ "));
        if (accountBalance.debit.compareTo(accountBalance.credit) > 0) {
            BigDecimal exchangeGain = accountBalance.debit.subtract(accountBalance.credit);
            journalLine.setAmtSourceDr(exchangeGain.abs());
            journalLine.setAmtAcctDr(exchangeGain.abs());
            journalLine.setAmtSourceCr(BigDecimal.ZERO);
            journalLine.setAmtAcctCr(BigDecimal.ZERO);
            journalDescriptionLine.append(" @UnrealizedGain_Acct@ ").append(exchangeGain.abs().toString());
        } else if (accountBalance.credit.compareTo(accountBalance.debit) > 0) {
            BigDecimal exchangeLoss = accountBalance.credit.subtract(accountBalance.debit);
            journalLine.setAmtSourceDr(BigDecimal.ZERO);
            journalLine.setAmtAcctDr(BigDecimal.ZERO);
            journalLine.setAmtSourceCr(exchangeLoss.abs());
            journalLine.setAmtAcctCr(exchangeLoss.abs());
            journalDescriptionLine.append(" @UnrealizedLoss_Acct@ ").append(exchangeLoss.abs().toString());
        }
        journalLine.setDescription(Msg.parseTranslation(this.getCtx(), journalDescriptionLine.toString()));
        journalLine.saveEx();
        MAcctSchemaDefault accountShemaDefault = Optional.ofNullable(MAcctSchemaDefault.get(this.getCtx(), accountingSchema.getC_AcctSchema_ID())).orElseThrow(() -> new AdempiereException("@C_AcctSchema_Default@ @NotFound@"));
        this.createExchangeGainLoss(accountShemaDefault, journal, journalLine, lineNo);
    }

    private void createExchangeGainLoss(MAcctSchemaDefault accountSchemaDefault, MJournal journal, MJournalLine journalLine, AtomicInteger lineNo) {
        if (journalLine.getAmtAcctDr().compareTo(journalLine.getAmtAcctCr()) > 0) {
            MJournalLine exchangeGain = new MJournalLine(journal);
            exchangeGain.setLine(lineNo.getAndUpdate(no -> no + 10));
            exchangeGain.setDescription(Msg.getElement(this.getCtx(), "UnrealizedGain_Acct"));
            exchangeGain.setC_ValidCombination_ID(this.getUnrealizedGainLoss(accountSchemaDefault.getUnrealizedGain_Acct(), journalLine));
            BigDecimal exchangeGainAmount = journalLine.getAmtAcctDr().subtract(journalLine.getAmtAcctCr());
            exchangeGain.setAmtSourceCr(exchangeGainAmount.abs());
            exchangeGain.setAmtAcctCr(exchangeGainAmount.abs());
            exchangeGain.saveEx();
        } else if (journalLine.getAmtAcctCr().compareTo(journalLine.getAmtAcctDr()) > 0) {
            MJournalLine exchangeLoss = new MJournalLine(journal);
            exchangeLoss.setLine(lineNo.getAndUpdate(no -> no + 10));
            exchangeLoss.setDescription(Msg.getElement(this.getCtx(), "UnrealizedLoss_Acct"));
            exchangeLoss.setC_ValidCombination_ID(this.getUnrealizedGainLoss(accountSchemaDefault.getRealizedLoss_Acct(), journalLine));
            BigDecimal exchangeLossAmount = journalLine.getAmtAcctDr().subtract(journalLine.getAmtAcctCr());
            exchangeLoss.setAmtSourceDr(exchangeLossAmount.abs());
            exchangeLoss.setAmtAcctDr(exchangeLossAmount.abs());
            exchangeLoss.saveEx();
        }
    }

    private void createExchangeGainLossReport(MAcctSchema acctSchema, Integer factAcctId, String trxName) {
        MFactAcct factAcct = new MFactAcct(this.getCtx(), factAcctId, trxName);
        if (factAcct.getAmtAcctDr().subtract(factAcct.getAmtAcctCr()).signum() == 0) {
            return;
        }
        X_T_InvoiceGL exchangeGainLoss = new X_T_InvoiceGL(this.getCtx(), 0, trxName);
        exchangeGainLoss.setAD_PInstance_ID(this.getAD_PInstance_ID());
        exchangeGainLoss.setAD_Org_ID(factAcct.getAD_Org_ID());
        exchangeGainLoss.setC_AcctSchema_ID(acctSchema.get_ID());
        exchangeGainLoss.setDateReval(this.getDateReval());
        exchangeGainLoss.setC_ConversionTypeReval_ID(this.getConversionTypeRevalId());
        exchangeGainLoss.setC_DocTypeReval_ID(this.getDocTypeRevalId());
        exchangeGainLoss.setAccount_ID(factAcct.getAccount_ID());
        exchangeGainLoss.setC_Currency_ID(factAcct.getC_Currency_ID());
        exchangeGainLoss.setFact_Acct_ID(factAcct.getFact_Acct_ID());
        exchangeGainLoss.setAPAR("A");
        exchangeGainLoss.setAD_Table_ID(factAcct.getAD_Table_ID());
        exchangeGainLoss.setRecord_ID(factAcct.getRecord_ID());
        exchangeGainLoss.setAmtSourceBalance(factAcct.getAmtSourceDr().subtract(factAcct.getAmtSourceCr()));
        exchangeGainLoss.setAmtAcctBalance(factAcct.getAmtAcctDr().subtract(factAcct.getAmtAcctCr()));
        Optional<Object> debitRevaluation = Optional.empty();
        Optional<Object> creditRevaluation = Optional.empty();
        if (factAcct.getAmtSourceDr().signum() != 0) {
            debitRevaluation = Optional.ofNullable(MConversionRate.convert(this.getCtx(), factAcct.getAmtSourceDr(), factAcct.getC_Currency_ID(), acctSchema.getC_Currency_ID(), this.getDateReval(), this.getConversionTypeRevalId(), this.getAD_Client_ID(), factAcct.getAD_Org_ID()));
        }
        if (factAcct.getAmtSourceCr().signum() != 0) {
            creditRevaluation = Optional.ofNullable(MConversionRate.convert(this.getCtx(), factAcct.getAmtSourceCr(), factAcct.getC_Currency_ID(), acctSchema.getC_Currency_ID(), this.getDateReval(), this.getConversionTypeRevalId(), this.getAD_Client_ID(), factAcct.getAD_Org_ID()));
        }
        if (debitRevaluation.orElse(BigDecimal.ZERO).signum() == 0 && creditRevaluation.orElse(BigDecimal.ZERO).signum() == 0) {
            StringBuilder errorMassage = new StringBuilder();
            MConversionType conversionType = new MConversionType(this.getCtx(), this.getConversionTypeRevalId(), trxName);
            errorMassage.append(" @C_ConversionTypeReval_ID@ ").append(conversionType.getName()).append(" @C_Conversion_Rate_ID@ @From@ @C_Currency_ID@ ").append(factAcct.getC_Currency().getISO_Code()).append(" @to@ @C_Currency_ID@ ").append(acctSchema.getC_Currency().getISO_Code()).append(" @DateReval@ ").append(this.getDateReval()).append(" @NotFound@");
            throw new AdempiereException(errorMassage.toString());
        }
        exchangeGainLoss.setAmtRevalDr(debitRevaluation.orElse(BigDecimal.ZERO));
        exchangeGainLoss.setAmtRevalCr(creditRevaluation.orElse(BigDecimal.ZERO));
        exchangeGainLoss.setAmtRevalDrDiff(debitRevaluation.orElse(BigDecimal.ZERO).subtract(factAcct.getAmtAcctDr()));
        exchangeGainLoss.setAmtRevalCrDiff(creditRevaluation.orElse(BigDecimal.ZERO).subtract(factAcct.getAmtAcctCr()));
        exchangeGainLoss.saveEx();
        this.exchangeGainLossList.add(exchangeGainLoss);
    }

    private MAccount getUnrealizedGainLoss(Integer validCombinationId, MJournalLine journalLine) {
        MAccount unrealizedGainLossBase = MAccount.getValidCombination(this.getCtx(), validCombinationId, journalLine.get_TrxName());
        return MAccount.get(this.getCtx(), journalLine.getAD_Client_ID(), journalLine.getAD_Org_ID(), unrealizedGainLossBase.getC_AcctSchema_ID(), unrealizedGainLossBase.getAccount_ID(), unrealizedGainLossBase.getC_SubAcct_ID(), unrealizedGainLossBase.getM_Product_ID(), unrealizedGainLossBase.getC_BPartner_ID(), unrealizedGainLossBase.getAD_OrgTrx_ID(), unrealizedGainLossBase.getC_LocFrom_ID(), unrealizedGainLossBase.getC_LocTo_ID(), unrealizedGainLossBase.getC_SalesRegion_ID(), unrealizedGainLossBase.getC_Project_ID(), unrealizedGainLossBase.getC_Campaign_ID(), unrealizedGainLossBase.getC_Activity_ID(), unrealizedGainLossBase.getUser1_ID(), unrealizedGainLossBase.getUser2_ID(), unrealizedGainLossBase.getUser3_ID(), unrealizedGainLossBase.getUser4_ID(), unrealizedGainLossBase.getUserElement1_ID(), unrealizedGainLossBase.getUserElement2_ID(), unrealizedGainLossBase.get_TrxName());
    }

    private List<MAcctSchema> getAccountingSchemes() {
        List<Object> accountingSchemes = new ArrayList<MAcctSchema>();
        if (this.getAcctSchemaId() > 0) {
            accountingSchemes.add(MAcctSchema.get(this.getCtx(), this.getAcctSchemaId()));
        } else {
            accountingSchemes = Arrays.asList(MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID()));
        }
        return accountingSchemes.stream().collect(Collectors.toList());
    }

    private List<Integer> getAccountsForeignCurrency() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("IsForeignCurrency").append("=? ").append(" AND ").append("AccountType").append(" IN('").append("A").append("','").append("L").append("','").append("O").append("')");
        parameters.add("Y");
        int[] ids = new Query(this.getCtx(), "C_ElementValue", whereClause.toString(), this.get_TrxName()).setParameters(parameters).setOrderBy("C_ElementValue_ID").getIDs();
        List<Integer> accountsIds = Arrays.stream(ids).boxed().collect(Collectors.toList());
        return accountsIds;
    }

    private List<KeyNamePair> getAccountBalanceByCurrency(Integer accountSchemaId, Integer accountId) {
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        StringBuilder sql = new StringBuilder(" SELECT C_Currency_ID , SUM ");
        sql.append("(acctbalance(" + accountId + ", AmtSourceDr , 0 ) - acctbalance(" + accountId + ", 0 , AmtSourceCr)) AS Balance FROM Fact_Acct WHERE ");
        sql.append("C_AcctSchema_ID").append("=? ");
        parameters.add(accountSchemaId);
        sql.append(" AND ").append("Account_ID").append("=?");
        parameters.add(accountId);
        sql.append(" AND ").append("DateAcct").append("<=?");
        parameters.add(this.getDateReval());
        sql.append(" GROUP BY Account_ID , C_Currency_ID ");
        List<KeyNamePair> balances = Arrays.stream(DB.getKeyNamePairs(this.get_TrxName(), sql.toString(), false, parameters.toArray())).filter(balanceCurrency -> balanceCurrency.getName() != null && new BigDecimal(balanceCurrency.getName()).signum() != 0).collect(Collectors.toList());
        return balances;
    }

    private List<Integer> getAccountRecordsByCurrency(MAcctSchema accountingSchema, Integer accountId, Integer currencyId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? ");
        parameters.add(accountingSchema.get_ID());
        whereClause.append(" AND ").append("Account_ID").append("=?");
        parameters.add(accountId);
        whereClause.append(" AND ").append("C_Currency_ID").append("=?");
        parameters.add(currencyId);
        whereClause.append(" AND ").append("C_Currency_ID").append("<>?");
        parameters.add(accountingSchema.getC_Currency_ID());
        whereClause.append(" AND ").append("DateAcct").append("<=?");
        parameters.add(this.getDateReval());
        int[] ids = new Query(this.getCtx(), "Fact_Acct", whereClause.toString(), this.get_TrxName()).setParameters(parameters).setOrderBy("Account_ID,C_Currency_ID").getIDs();
        List<Integer> factAccountIds = Arrays.stream(ids).boxed().collect(Collectors.toList());
        return factAccountIds;
    }

    private void cleanTemporaryTable() {
        Trx.run(trxName -> {
            StringBuilder deleteStatement = new StringBuilder("DELETE FROM ");
            deleteStatement.append("T_InvoiceGL").append(" WHERE ").append("AD_PInstance_ID").append("=?");
            DB.executeUpdate(deleteStatement.toString(), this.getAD_PInstance_ID(), trxName);
        });
    }

    class AccountBalance {
        Integer companyId;
        Integer accountSchemaId;
        Integer organizationId;
        Integer accountId;
        Integer currencyId;
        BigDecimal sourceBalance;
        BigDecimal accountBalance;
        BigDecimal debit;
        BigDecimal credit;

        AccountBalance() {
        }
    }
}

