/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.InitialClientSetupAbstract;
import org.compiere.Adempiere;
import org.compiere.model.MCity;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MLanguage;
import org.compiere.model.MSetup;
import org.compiere.model.Query;
import org.compiere.print.PrintUtil;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;

public class InitialClientSetup
extends InitialClientSetupAbstract {
    public static final int WINDOW_THIS_PROCESS = 9999;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        File chartofAccountsFile;
        MCity city;
        this.log.info("InitialClientSetup: ClientName=" + this.getClientName() + ", OrgValue=" + this.getOrgValue() + ", OrgName=" + this.getOrgName() + ", AdminUserName=" + this.getAdminUserName() + ", NormalUserName=" + this.getNormalUserName() + ", C_Currency_ID=" + this.getCurrencyId() + ", C_Country_ID=" + this.getCountryId() + ", C_Region_ID=" + this.getRegionId() + ", CityName=" + this.getCityName() + ", C_City_ID=" + this.getCityId() + ", IsUseBPDimension=" + this.isUseBPDimension() + ", IsUseProductDimension=" + this.isUseProductDimension() + ", IsUseProjectDimension=" + this.isUseProjectDimension() + ", IsUseCampaignDimension=" + this.isUseCampaignDimension() + ", IsUseSalesRegionDimension=" + this.isUseSalesRegionDimension() + ", ChartofAccountsFile=" + this.getCoAFile());
        if (this.getClientName() == null || this.getClientName().length() == 0 || this.getOrgName() == null || this.getOrgName().length() == 0 || this.getCurrencyId() <= 0 || this.getCountryId() <= 0 || this.getCoAFile() == null || this.getCoAFile().length() == 0) {
            throw new IllegalArgumentException("Missing required parameters");
        }
        if (DB.executeUpdate("UPDATE AD_Client SET CreatedBy=0 WHERE Name=?", new Object[]{this.getClientName()}, false, null) != 0) {
            throw new AdempiereException("@NotUnique@ " + this.getClientName());
        }
        if (DB.executeUpdate("UPDATE AD_User SET CreatedBy=0 WHERE Name=?", new Object[]{this.getAdminUserName()}, false, null) != 0) {
            throw new AdempiereException("@NotUnique@ " + this.getAdminUserName());
        }
        if (DB.executeUpdate("UPDATE AD_User SET CreatedBy=0 WHERE Name=?", new Object[]{this.getNormalUserName()}, false, null) != 0) {
            throw new AdempiereException("@NotUnique@ " + this.getNormalUserName());
        }
        if (this.getCityId() > 0 && !(city = MCity.get(this.getCtx(), this.getCityId())).getName().equals(this.getCityName())) {
            this.log.info("City name changed from " + this.getCityName() + " to " + city.getName());
            this.setCityName(city.getName());
        }
        if (!(chartofAccountsFile = new File(this.getCoAFile())).exists()) {
            throw new AdempiereException("CoaFile " + this.getCoAFile() + " does not exist");
        }
        if (!chartofAccountsFile.canRead()) {
            throw new AdempiereException("Cannot read CoaFile " + this.getCoAFile());
        }
        if (!chartofAccountsFile.isFile()) {
            throw new AdempiereException("CoaFile " + this.getCoAFile() + " is not a file");
        }
        if (chartofAccountsFile.length() <= 0L) {
            throw new AdempiereException("CoaFile " + this.getCoAFile() + " is empty");
        }
        MSetup setup = null;
        MCountry country = MCountry.get(this.getCtx(), this.getCountryId());
        try {
            Class<?> ppClass = Class.forName("org.compiere.model.MSetup_" + country.getCountryCode());
            if (ppClass != null) {
                setup = (MSetup)ppClass.newInstance();
            }
        }
        catch (Exception ppClass) {
            // empty catch block
        }
        if (setup == null) {
            setup = new MSetup();
        }
        setup.initialize(Env.getCtx(), 9999);
        if (!setup.createClient(this.getClientName(), this.getOrgValue(), this.getOrgName(), this.getAdminUserName(), this.getNormalUserName(), this.getPhone(), this.getPhone2(), this.getFax(), this.getEMail(), this.getTaxID(), this.getDUNS(), this.getLogo(), this.getCountryId())) {
            setup.rollback();
            throw new AdempiereException("Create client failed");
        }
        this.addLog(setup.getInfo());
        MCurrency currency = MCurrency.get(this.getCtx(), this.getCurrencyId());
        KeyNamePair currencyKeyNamePair = new KeyNamePair(this.getCurrencyId(), currency.getDescription());
        if (!setup.createAccounting(currencyKeyNamePair, this.isUseProductDimension(), this.isUseBPDimension(), this.isUseProjectDimension(), this.isUseCampaignDimension(), this.isUseSalesRegionDimension(), this.getStartDate(), this.getHistoryYears(), chartofAccountsFile)) {
            setup.rollback();
            throw new AdempiereException("@AccountSetupError@");
        }
        if (!setup.createEntities(this.getCountryId(), this.getCityName(), this.getRegionId(), this.getCurrencyId(), this.getPostal(), this.getAddress1())) {
            setup.rollback();
            throw new AdempiereException("@AccountSetupError@");
        }
        if (!(Util.isEmpty(this.getBankName()) || Util.isEmpty(this.getRoutingNo()) || Util.isEmpty(this.getAccountNo()))) {
            setup.createBank(this.getBankName(), this.getRoutingNo(), this.getAccountNo(), this.getCurrencyId());
        }
        if (!setup.importChart(chartofAccountsFile)) {
            setup.rollback();
            throw new AdempiereException("@AccountSetupError@");
        }
        this.addLog(setup.getInfo());
        PrintUtil.setupPrintForm(setup.getAD_Client_ID());
        String whereClause = "IsSystemLanguage='Y' AND IsActive='Y'";
        List list = new Query(Env.getCtx(), "AD_Language", whereClause, this.get_TrxName()).list();
        for (MLanguage lang : list) {
            this.log.fine("Updating Translation - " + lang);
            lang.maintain(true);
        }
        return "@OK@";
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.CONFIG);
        String propFileName = Adempiere.getAdempiereHome() + File.separatorChar + "clientsetup.properties";
        if (args.length > 0) {
            propFileName = args[0];
        }
        ProcessInfo pi = new ProcessInfo("Initial Client Setup", 53161);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        Properties prop = new Properties();
        try {
            MCountry country;
            MCurrency currency;
            prop.load(new FileInputStream(propFileName));
            pi.addParameter("ClientName", prop.getProperty("ClientName"), prop.getProperty("ClientName"));
            pi.addParameter("OrgValue", prop.getProperty("OrgValue"), prop.getProperty("OrgValue"));
            pi.addParameter("OrgName", prop.getProperty("OrgName"), prop.getProperty("OrgName"));
            pi.addParameter("AdminUserName", prop.getProperty("AdminUserName"), prop.getProperty("AdminUserName"));
            pi.addParameter("NormalUserName", prop.getProperty("NormalUserName"), prop.getProperty("NormalUserName"));
            if (prop.getProperty("CurrencyCode") != null && (currency = MCurrency.get(Env.getCtx(), prop.getProperty("CurrencyCode"))) != null) {
                pi.addParameter("C_Currency_ID", currency.getC_Currency_ID(), currency.getISO_Code());
            }
            if (prop.getProperty("CountryCode") != null && (country = MCountry.get(Env.getCtx(), prop.getProperty("CountryCode"))) != null) {
                pi.addParameter("C_Country_ID", country.getC_Country_ID(), country.getCountryCode());
            }
            pi.addParameter("C_Region_ID", prop.getProperty("C_Region_ID"), prop.getProperty("C_Region_ID"));
            pi.addParameter("CityName", prop.getProperty("CityName"), prop.getProperty("CityName"));
            pi.addParameter("C_City_ID", prop.getProperty("C_City_ID"), prop.getProperty("C_City_ID"));
            pi.addParameter("Postal", prop.getProperty("Postal"), prop.getProperty("Postal"));
            pi.addParameter("Address1", prop.getProperty("Address1"), prop.getProperty("Address1"));
            pi.addParameter("IsUseBPDimension", prop.getProperty("IsUseBPDimension"), prop.getProperty("IsUseBPDimension"));
            pi.addParameter("IsUseProductDimension", prop.getProperty("IsUseProductDimension"), prop.getProperty("IsUseProductDimension"));
            pi.addParameter("IsUseProjectDimension", prop.getProperty("IsUseProjectDimension"), prop.getProperty("IsUseProjectDimension"));
            pi.addParameter("IsUseCampaignDimension", prop.getProperty("IsUseCampaignDimension"), prop.getProperty("IsUseCampaignDimension"));
            pi.addParameter("IsUseSalesRegionDimension", prop.getProperty("IsUseSalesRegionDimension"), prop.getProperty("IsUseSalesRegionDimension"));
            pi.addParameter("CoAFile", prop.getProperty("CoAFile"), prop.getProperty("CoAFile"));
            pi.addParameter("Phone", prop.getProperty("Phone"), prop.getProperty("Phone"));
            pi.addParameter("Phone2", prop.getProperty("Phone2"), prop.getProperty("Phone2"));
            pi.addParameter("Fax", prop.getProperty("Fax"), prop.getProperty("Fax"));
            pi.addParameter("EMail", prop.getProperty("EMail"), prop.getProperty("EMail"));
            pi.addParameter("TaxID", prop.getProperty("TaxID"), prop.getProperty("TaxID"));
            pi.addParameter("Logo", prop.getProperty("Logo"), prop.getProperty("Logo"));
            pi.addParameter("StartDate", prop.getProperty("StartDate"), prop.getProperty("StartDate"));
            pi.addParameter("HistoryYears", prop.getProperty("HistoryYears"), prop.getProperty("HistoryYears"));
            pi.addParameter("DUNS", prop.getProperty("DUNS"), prop.getProperty("DUNS"));
            pi.addParameter("BankName", prop.getProperty("BankName"), prop.getProperty("BankName"));
            pi.addParameter("RoutingNo", prop.getProperty("RoutingNo"), prop.getProperty("RoutingNo"));
            pi.addParameter("AccountNo", prop.getProperty("AccountNo"), prop.getProperty("AccountNo"));
        }
        catch (Exception country) {
            // empty catch block
        }
        InitialClientSetup setup = new InitialClientSetup();
        setup.startProcess(Env.getCtx(), pi, null);
    }
}

