/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PrepareMigrationScripts
extends SvrProcess {
    String path;
    public static boolean found = false;

    @Override
    protected String doIt() throws Exception {
        if (this.path == null) {
            return "ERROR - No path";
        }
        String directory = this.path;
        File dir = new File(directory);
        File[] dirList = dir.listFiles();
        Vector<String> fileName = new Vector<String>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".sql");
            }
        };
        dirList = dir.listFiles(filter);
        this.log.info("Searching for SQL files in the " + dir + " directory");
        String msg = "";
        for (int i = 0; i < dirList.length; ++i) {
            fileName.add(dirList[i].toString().substring(directory.length() + 1));
            this.log.fine("Found file [" + (String)fileName.get(i) + "]. Finding out if the script has or hasn't been applied yet...");
            try {
                String checkScript = "select ad_migrationscript_id from ad_migrationscript where name = ?";
                CPreparedStatement pstmt = DB.prepareStatement(checkScript, this.get_TrxName());
                pstmt.setString(1, (String)fileName.get(i));
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.log.warning("Script " + (String)fileName.get(i) + " already in the database");
                    pstmt.close();
                    continue;
                }
                pstmt.close();
                Scanner scanner = new Scanner(dirList[i]);
                StringBuffer body = new StringBuffer();
                boolean blHeader = false;
                boolean blBody = false;
                boolean isFirstLine = true;
                boolean hasHeader = false;
                String Name = (String)fileName.get(i);
                String Description = "Unknown";
                String ProjectName = "Adempiere";
                String tmp = Adempiere.MAIN_VERSION;
                tmp = tmp.replace("Release ", "");
                String ReleaseNo = tmp = tmp.replace(".", "");
                String DeveloperName = "Not known";
                String Reference = "--";
                String Url = "http://www.sourceforge.net/projects/adempiere";
                Timestamp ts = new Timestamp(Calendar.getInstance().getTimeInMillis());
                while (scanner.hasNextLine()) {
                    String line = null;
                    if (isFirstLine) {
                        line = scanner.nextLine();
                    }
                    if (isFirstLine && line.equals("--BEGINHEADER--")) {
                        hasHeader = true;
                    }
                    if (hasHeader) {
                        if (!isFirstLine) {
                            line = scanner.nextLine();
                        }
                        if (line.equals("--ENDHEADER--")) {
                            blHeader = false;
                            blBody = false;
                        }
                        if (line.equals("--ENDMS--")) {
                            blHeader = false;
                            blBody = false;
                        }
                        if (blHeader) {
                            if (line.startsWith("Name")) {
                                Name = line.substring("Name".length() + 1);
                            } else if (line.startsWith("Description")) {
                                Description = line.substring("Description".length() + 1);
                            } else if (line.startsWith("ProjectName")) {
                                ProjectName = line.substring("ProjectName".length() + 1);
                            } else if (line.startsWith("ReleaseNo")) {
                                ReleaseNo = line.substring("ReleaseNo".length() + 1);
                            } else if (line.startsWith("DeveloperName")) {
                                DeveloperName = line.substring("DeveloperName".length() + 1);
                            } else if (line.startsWith("Reference")) {
                                Reference = line.substring("Reference".length() + 1);
                            } else if (line.startsWith("Url")) {
                                Url = line.substring("Url".length() + 1);
                            }
                        }
                        if (blBody) {
                            body.append(line + '\n');
                        }
                        if (line.equals("--BEGINHEADER--")) {
                            blHeader = true;
                            blBody = false;
                        }
                        if (line.equals("--BEGINMS--")) {
                            blHeader = false;
                            blBody = true;
                        }
                    } else {
                        if (!isFirstLine) {
                            line = scanner.nextLine();
                        }
                        body.append(line + '\n');
                    }
                    isFirstLine = false;
                }
                scanner.close();
                int seqID = DB.getNextID(0, "AD_MigrationScript", this.get_TrxName());
                String sql = "INSERT INTO ad_migrationscript (ad_client_id, ad_org_id, ad_migrationscript_id,  createdby, name, projectname, releaseno, status, url, updatedby, filename, description, developername, reference, isactive, isapply, created, updated) VALUES (0, 0, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, seqID);
                pstmt.setInt(2, Env.getAD_User_ID(Env.getCtx()));
                pstmt.setString(3, Name);
                pstmt.setString(4, ProjectName);
                pstmt.setString(5, ReleaseNo);
                pstmt.setString(6, "IP");
                pstmt.setString(7, Url);
                pstmt.setInt(8, Env.getAD_User_ID(Env.getCtx()));
                pstmt.setString(9, this.path);
                pstmt.setString(10, Description);
                pstmt.setString(11, DeveloperName);
                pstmt.setString(12, Reference);
                pstmt.setString(13, "Y");
                pstmt.setString(14, "Y");
                pstmt.setTimestamp(15, ts);
                pstmt.setTimestamp(16, ts);
                int result = pstmt.executeUpdate();
                pstmt.close();
                if (result <= 0) {
                    this.log.severe("Script " + (String)fileName.get(i) + " failed!");
                    msg = msg + "Script " + (String)fileName.get(i) + " failed!";
                    continue;
                }
                this.log.info("Header inserted. Now inserting the script body");
                sql = "UPDATE AD_MigrationScript SET script = ? WHERE AD_MigrationScript_ID = ?";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setBytes(1, body.toString().getBytes());
                pstmt.setInt(2, seqID);
                result = pstmt.executeUpdate();
                pstmt.close();
                if (result > 0) {
                    this.log.info("Script Body inserted.");
                    continue;
                }
                this.log.severe("Script Body " + (String)fileName.get(i) + " failed!");
                msg = msg + "Script Body " + (String)fileName.get(i) + " failed!";
                pstmt = DB.prepareStatement("DELETE FROM ad_migrationscript WHERE ad_migrationscript_id = ?", this.get_TrxName());
                pstmt.setInt(1, seqID);
                result = pstmt.executeUpdate();
                continue;
            }
            catch (Exception ex) {
                this.log.severe(ex.getMessage());
            }
        }
        return "Sucess";
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("ScriptsPath")) {
                this.path = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }
}

