/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.exp;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.adempiere.process.rpl.IExportProcessor;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MEXPProcessorType;
import org.compiere.model.MImage;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Image;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportHelper {
    private static CLogger log = CLogger.getCLogger(ExportHelper.class);
    private Document outDocument = null;
    private SimpleDateFormat customDateFormat = null;
    private int clientId = -1;
    MReplicationStrategy replicationStrategy = null;

    public ExportHelper(MClient client, MReplicationStrategy replicationStrategy) {
        this.clientId = client.getAD_Client_ID();
        this.replicationStrategy = replicationStrategy;
    }

    public ExportHelper(Properties ctx, int clientId) {
        this.clientId = clientId;
    }

    public String exportRecord(PO po, Integer replicationMode, String replicationType, Integer replicationEvent) throws Exception {
        MClient client = MClient.get(po.getCtx(), this.clientId);
        log.info("Client = " + client.toString());
        log.info("po.getAD_Org_ID() = " + po.getAD_Org_ID());
        log.info("po.get_TrxName() = " + po.get_TrxName());
        if (po.get_TrxName() == null || po.get_TrxName().equals("")) {
            po.set_TrxName("exportRecord");
        }
        log.info("Table = " + po.get_TableName());
        if (po.get_KeyColumns().length < 1) {
            throw new Exception(Msg.getMsg(po.getCtx(), "ExportNoneColumnKeyNotSupported"));
        }
        String version = "3.8.2";
        MEXPFormat exportFormat = null;
        exportFormat = MEXPFormat.getFormatByAD_Client_IDAD_Table_IDAndVersion(po.getCtx(), this.clientId, po.get_Table_ID(), version, po.get_TrxName());
        log.fine("exportFormat = " + exportFormat);
        if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
            MClient systemClient = MClient.get(po.getCtx(), 0);
            log.log(Level.ALL, "SYSTEM client = " + systemClient.toString());
            exportFormat = MEXPFormat.getFormatByAD_Client_IDAD_Table_IDAndVersion(po.getCtx(), 0, po.get_Table_ID(), version, po.get_TrxName());
            if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
                throw new Exception(Msg.getMsg(po.getCtx(), "EXPFormatNotFound"));
            }
        }
        this.outDocument = this.createNewDocument();
        HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
        Element rootElement = this.outDocument.createElement(exportFormat.getValue());
        if (exportFormat.getDescription() != null && !"".equals(exportFormat.getDescription())) {
            rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
        }
        rootElement.setAttribute("AD_Client_Value", client.getValue());
        rootElement.setAttribute("Version", exportFormat.getVersion());
        rootElement.setAttribute("ReplicationMode", replicationMode.toString());
        rootElement.setAttribute("ReplicationType", replicationType);
        rootElement.setAttribute("ReplicationEvent", replicationEvent.toString());
        this.outDocument.appendChild(rootElement);
        this.generateExportFormat(rootElement, exportFormat, po, po.get_ID(), variableMap);
        MEXPProcessor mExportProcessor = null;
        mExportProcessor = new MEXPProcessor(po.getCtx(), this.replicationStrategy.getEXP_Processor_ID(), po.get_TrxName());
        log.fine("ExportProcessor = " + mExportProcessor);
        int EXP_ProcessorType_ID = 0;
        EXP_ProcessorType_ID = mExportProcessor.getEXP_Processor_Type_ID();
        MEXPProcessorType expProcessor_Type = new MEXPProcessorType(po.getCtx(), EXP_ProcessorType_ID, po.get_TrxName());
        String javaClass = expProcessor_Type.getJavaClass();
        try {
            Class<?> clazz = Class.forName(javaClass);
            IExportProcessor exportProcessor = (IExportProcessor)clazz.newInstance();
            exportProcessor.process(po.getCtx(), mExportProcessor, this.outDocument, Trx.get(po.get_TrxName(), false));
        }
        catch (Exception e) {
            log.severe(e.toString());
            throw e;
        }
        return this.outDocument.toString();
    }

    public Document exportRecord(MEXPFormat exportFormat, String where, Integer replicationMode, String replicationType, Integer replicationEvent) throws Exception {
        MClient client = MClient.get(exportFormat.getCtx(), this.clientId);
        MTable table = MTable.get(exportFormat.getCtx(), exportFormat.getAD_Table_ID());
        log.info("Table = " + table);
        List records = new Query(exportFormat.getCtx(), table.getTableName(), exportFormat.getWhereClause(), exportFormat.get_TrxName()).setOnlyActiveRecords(true).list();
        for (PO po : records) {
            log.info("Client = " + client.toString());
            log.finest("po.getAD_Org_ID() = " + po.getAD_Org_ID());
            log.finest("po.get_TrxName() = " + po.get_TrxName());
            if (po.get_TrxName() == null || po.get_TrxName().equals("")) {
                po.set_TrxName("exportRecord");
            }
            if (po.get_KeyColumns().length < 1) {
                throw new Exception(Msg.getMsg(po.getCtx(), "ExportNoneColumnKeyNotSupported"));
            }
            this.outDocument = this.createNewDocument();
            HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
            Element rootElement = this.outDocument.createElement(exportFormat.getValue());
            if (exportFormat.getDescription() != null && !"".equals(exportFormat.getDescription())) {
                rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
            }
            rootElement.setAttribute("AD_Client_Value", client.getValue());
            rootElement.setAttribute("Version", exportFormat.getVersion());
            rootElement.setAttribute("ReplicationMode", replicationMode.toString());
            rootElement.setAttribute("ReplicationType", replicationType);
            rootElement.setAttribute("ReplicationEvent", replicationEvent.toString());
            this.outDocument.appendChild(rootElement);
            this.generateExportFormat(rootElement, exportFormat, po, po.get_ID(), variableMap);
        }
        return this.outDocument;
    }

    private void generateExportFormat(Element rootElement, MEXPFormat exportFormat, PO masterPO, int masterID, HashMap<String, Integer> variableMap) throws SQLException, Exception {
        List<MEXPFormatLine> formatLines = exportFormat.getFormatLines();
        boolean elementHasValue = false;
        for (MEXPFormatLine formatLine : formatLines) {
            StringBuffer whereClause;
            MTable tableEmbedded;
            MEXPFormat embeddedFormat;
            if (formatLine.getType().equals("E")) {
                Element newElement = this.outDocument.createElement(formatLine.getValue());
                log.info("Format Line Search key: " + formatLine.getValue());
                if (formatLine.getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg(masterPO.getCtx(), "EXPColumnMandatory"));
                }
                MColumn column = MColumn.get(masterPO.getCtx(), formatLine.getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg(masterPO.getCtx(), "EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    log.info("This is Virtual Column!");
                }
                Object value = masterPO.get_Value(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else if (formatLine.isMandatory()) {
                    // empty if block
                }
                if (column.getAD_Reference_ID() == 15) {
                    if (valueString != null) {
                        if (formatLine.getDateFormat() != null && !"".equals(formatLine.getDateFormat())) {
                            this.customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                            valueString = this.customDateFormat.format(Timestamp.valueOf(valueString));
                            newElement.setAttribute("DateFormat", this.customDateFormat.toPattern());
                        } else {
                            newElement.setAttribute("DateFormat", valueString);
                        }
                    }
                } else if (column.getAD_Reference_ID() == 16) {
                    if (valueString != null) {
                        if (formatLine.getDateFormat() != null && !"".equals(formatLine.getDateFormat())) {
                            this.customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                            valueString = this.customDateFormat.format(Timestamp.valueOf(valueString));
                            newElement.setAttribute("DateFormat", this.customDateFormat.toPattern());
                        } else {
                            newElement.setAttribute("DateFormat", valueString);
                        }
                    }
                } else if (column.getAD_Reference_ID() == 32 && value != null) {
                    int imageId = (Integer)value;
                    Object image = null;
                    image = new MImage(masterPO.getCtx(), imageId, null);
                    if (((X_AD_Image)image).getAD_Image_ID() > 0) {
                        elementHasValue = true;
                        newElement.setAttribute("id", String.valueOf(((X_AD_Image)image).getAD_Image_ID()));
                        Element nameElement = this.outDocument.createElement("Name");
                        Text newText = this.outDocument.createTextNode(((X_AD_Image)image).getName());
                        nameElement.appendChild(newText);
                        newElement.appendChild(nameElement);
                        if (((X_AD_Image)image).getDescription() != null && ((X_AD_Image)image).getDescription().length() > 0) {
                            Element descriptionElement = this.outDocument.createElement("Description");
                            Text newDesc = this.outDocument.createTextNode(((X_AD_Image)image).getDescription());
                            descriptionElement.appendChild(newDesc);
                            newElement.appendChild(descriptionElement);
                        }
                        if (((X_AD_Image)image).getImageURL() != null && ((X_AD_Image)image).getImageURL().length() > 0) {
                            Element imageURLElement = this.outDocument.createElement("ImageURL");
                            Text newImageUrl = this.outDocument.createTextNode(((X_AD_Image)image).getImageURL());
                            imageURLElement.appendChild(newImageUrl);
                            newElement.appendChild(imageURLElement);
                        }
                        if (((X_AD_Image)image).getBinaryData() != null && ((X_AD_Image)image).getBinaryData().length > 0) {
                            Element binaryDataElement = this.outDocument.createElement("BinaryData");
                            byte[] encodedBytes = null;
                            encodedBytes = Base64.encodeBase64((byte[])((X_AD_Image)image).getBinaryData());
                            String encodedString = new String(encodedBytes);
                            Text encodedText = this.outDocument.createTextNode(encodedString);
                            binaryDataElement.appendChild(encodedText);
                            newElement.appendChild(binaryDataElement);
                        }
                    }
                }
                log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + value);
                if (valueString != null && !"".equals(valueString) && !"null".equals(valueString)) {
                    if (column.getAD_Reference_ID() != 32) {
                        Text newText = this.outDocument.createTextNode(valueString);
                        newElement.appendChild(newText);
                    }
                    rootElement.appendChild(newElement);
                    elementHasValue = true;
                    continue;
                }
                if (!formatLine.isMandatory()) continue;
                Text newText = this.outDocument.createTextNode("");
                newElement.appendChild(newText);
                rootElement.appendChild(newElement);
                elementHasValue = true;
                continue;
            }
            if (formatLine.getType().equals("A")) {
                if (formatLine.getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg(masterPO.getCtx(), "EXPColumnMandatory"));
                }
                MColumn column = MColumn.get(masterPO.getCtx(), formatLine.getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg(masterPO.getCtx(), "EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    log.info("This is Virtual Column!");
                }
                Object value = masterPO.get_Value(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else if (formatLine.isMandatory()) {
                    throw new Exception(Msg.getMsg(masterPO.getCtx(), "EXPFieldMandatory"));
                }
                log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + value);
                if (valueString == null || "".equals(valueString) || "null".equals(valueString)) continue;
                rootElement.setAttribute(formatLine.getValue(), valueString);
                elementHasValue = true;
                continue;
            }
            if (formatLine.getType().equals("M")) {
                int embeddedFormat_ID = formatLine.getEXP_EmbeddedFormat_ID();
                embeddedFormat = MEXPFormat.get(masterPO.getCtx(), embeddedFormat_ID, masterPO.get_TrxName());
                tableEmbedded = MTable.get(masterPO.getCtx(), embeddedFormat.getAD_Table_ID());
                log.info("Table Embedded = " + tableEmbedded);
                whereClause = new StringBuffer(masterPO.get_KeyColumns()[0] + "=?");
                if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                    whereClause.append(" AND ").append(embeddedFormat.getWhereClause());
                }
                List instances = new Query(masterPO.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), masterPO.get_TrxName()).setApplyAccessFilter(true).setParameters(masterID).list();
                for (PO instance : instances) {
                    Element embeddedElement = this.outDocument.createElement(formatLine.getValue());
                    if (formatLine.getDescription() != null && !"".equals(formatLine.getDescription())) {
                        embeddedElement.appendChild(this.outDocument.createComment(formatLine.getDescription()));
                    }
                    this.generateExportFormat(embeddedElement, embeddedFormat, instance, instance.get_ID(), variableMap);
                    rootElement.appendChild(embeddedElement);
                }
                continue;
            }
            if (formatLine.getType().equals("R")) {
                int embeddedFormat_ID = formatLine.getEXP_EmbeddedFormat_ID();
                embeddedFormat = MEXPFormat.get(masterPO.getCtx(), embeddedFormat_ID, masterPO.get_TrxName());
                tableEmbedded = MTable.get(masterPO.getCtx(), embeddedFormat.getAD_Table_ID());
                log.info("Table Embedded = " + tableEmbedded);
                whereClause = new StringBuffer(tableEmbedded.getTableName() + "_ID =?");
                if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                    whereClause.append(" AND ").append(embeddedFormat.getWhereClause());
                }
                String columnName = "";
                if (formatLine.getAD_Reference_ID() == 18 | formatLine.getAD_Reference_ID() == 30) {
                    MColumn column = MColumn.get(masterPO.getCtx(), formatLine.getAD_Column_ID());
                    columnName = column.getColumnName();
                } else {
                    columnName = tableEmbedded.getTableName() + "_ID";
                }
                Object value = masterPO.get_Value(columnName);
                if (value == null) continue;
                List instances = null;
                if (tableEmbedded.getTableName().equals("C_Country") || tableEmbedded.getTableName().equals("C_UOM")) {
                    instances = new Query(masterPO.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), masterPO.get_TrxName()).setParameters(value).list();
                    List tenantSpecificInstances = new Query(masterPO.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), masterPO.get_TrxName()).setApplyAccessFilter(true).setParameters(value).list();
                    instances.addAll(tenantSpecificInstances);
                } else {
                    instances = new Query(masterPO.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), masterPO.get_TrxName()).setApplyAccessFilter(true).setParameters(value).list();
                }
                for (PO instance : instances) {
                    Element embeddedElement = this.outDocument.createElement(formatLine.getValue());
                    if (formatLine.getDescription() != null && !"".equals(formatLine.getDescription())) {
                        embeddedElement.appendChild(this.outDocument.createComment(formatLine.getDescription()));
                    }
                    this.generateExportFormat(embeddedElement, embeddedFormat, instance, instance.get_ID(), variableMap);
                    rootElement.appendChild(embeddedElement);
                }
                continue;
            }
            throw new Exception(Msg.getMsg(masterPO.getCtx(), "EXPUnknownLineType"));
        }
    }

    private void increaseVariable(HashMap<String, Integer> variableMap, String variableName) {
        if (variableName != null && !"".equals(variableName)) {
            Integer var = variableMap.get(variableName);
            if (var == null) {
                var = new Integer(0);
            }
            int intValue = var;
            variableMap.put(variableName, new Integer(++intValue));
        }
    }

    Document createNewDocument() throws ParserConfigurationException {
        Document result = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        result = documentBuilder.newDocument();
        return result;
    }
}

