/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.exp;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.process.rpl.IExportProcessor;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.X_EXP_ProcessorParameter;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.w3c.dom.Document;

public class HDDExportProcessor
implements IExportProcessor {
    protected CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public void process(Properties ctx, MEXPProcessor expProcessor, Document document, Trx trx) throws Exception {
        String fileName = "";
        String folder = "";
        X_EXP_ProcessorParameter[] processorParameters = expProcessor.getEXP_ProcessorParameters(trx.getTrxName());
        if (processorParameters != null && processorParameters.length > 0) {
            for (int i = 0; i < processorParameters.length; ++i) {
                this.log.info("ProcesParameter          Value = " + processorParameters[i].getValue());
                this.log.info("ProcesParameter ParameterValue = " + processorParameters[i].getParameterValue());
                if (processorParameters[i].getValue().equals("fileName")) {
                    fileName = processorParameters[i].getParameterValue();
                    continue;
                }
                if (!processorParameters[i].getValue().equals("folder")) continue;
                folder = processorParameters[i].getParameterValue();
            }
        }
        if (fileName == null || fileName.length() == 0) {
            throw new Exception("Missing EXP_ProcessorParameter with key 'fileName'!");
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        tranFactory.setAttribute("indent-number", 1);
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult dest2 = new StreamResult(writer);
        aTransformer.transform(src, dest2);
        System.err.println(((Object)writer).toString());
        try {
            StreamResult dest = new StreamResult(new File(folder + fileName));
            aTransformer.transform(src, dest);
            ((Writer)writer).close();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

