/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.exp;

import java.io.StringWriter;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.process.rpl.IExportProcessor;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.X_EXP_ProcessorParameter;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.w3c.dom.Document;

public class TopicExportProcessor
implements IExportProcessor {
    protected CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public void process(Properties ctx, MEXPProcessor expProcessor, Document document, Trx trx) throws Exception {
        String host = expProcessor.getHost();
        int port = expProcessor.getPort();
        String account = expProcessor.getAccount();
        String password = expProcessor.getPasswordInfo();
        String protocol = null;
        String topicName = "";
        String clientID = null;
        String timeToLiveStr = null;
        int timeToLive = 10000;
        boolean isDeliveryModePersistent = true;
        X_EXP_ProcessorParameter[] processorParameters = expProcessor.getEXP_ProcessorParameters(trx.getTrxName());
        if (processorParameters != null && processorParameters.length > 0) {
            for (int i = 0; i < processorParameters.length; ++i) {
                this.log.info("ProcesParameter          Value = " + processorParameters[i].getValue());
                this.log.info("ProcesParameter ParameterValue = " + processorParameters[i].getParameterValue());
                if (processorParameters[i].getValue().equals("topicName")) {
                    topicName = processorParameters[i].getParameterValue();
                    continue;
                }
                if (processorParameters[i].getValue().equals("protocol")) {
                    protocol = processorParameters[i].getParameterValue();
                    continue;
                }
                if (processorParameters[i].getValue().equals("clientID")) {
                    clientID = processorParameters[i].getParameterValue();
                    continue;
                }
                if (processorParameters[i].getValue().equals("timeToLive")) {
                    timeToLiveStr = processorParameters[i].getParameterValue();
                    timeToLive = Integer.parseInt(timeToLiveStr);
                    continue;
                }
                if (!processorParameters[i].getValue().equals("isDeliveryModePersistent")) continue;
                isDeliveryModePersistent = Boolean.parseBoolean(processorParameters[i].getParameterValue());
            }
        }
        if (topicName == null || topicName.length() == 0) {
            throw new Exception("Missing EXP_ProcessorParameter with key 'topicName'!");
        }
        if (protocol == null || protocol.length() == 0) {
            throw new Exception("Missing EXP_ProcessorParameter with key 'protocol'!");
        }
        if (clientID == null || clientID.length() == 0) {
            throw new Exception("Missing EXP_ProcessorParameter with key 'clientID'!");
        }
        if (timeToLiveStr == null || timeToLiveStr.length() == 0) {
            throw new Exception("Missing EXP_ProcessorParameter with key 'timeToLive'!");
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        String jVersion = System.getProperty("java.version");
        if (jVersion.startsWith("1.5.0")) {
            tranFactory.setAttribute("indent-number", 1);
        }
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult dest2 = new StreamResult(writer);
        aTransformer.transform(src, dest2);
        this.sendJMSMessage(host, port, ((Object)writer).toString(), protocol, topicName, clientID, account, password, timeToLive, isDeliveryModePersistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJMSMessage(String host, int port, String msg, String protocol, String topicName, String clientID, String userName, String password, int timeToLive, boolean isDeliveryModePersistent) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(protocol + "://" + host + ":" + port);
        Connection connection = null;
        Session session = null;
        try {
            connection = userName != null && password != null ? connectionFactory.createConnection(userName, password) : connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(true, 1);
            Topic destination = session.createTopic(topicName);
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setTimeToLive((long)timeToLive);
            if (isDeliveryModePersistent) {
                producer.setDeliveryMode(2);
            } else {
                producer.setDeliveryMode(1);
            }
            TextMessage message = session.createTextMessage(msg);
            try {
                producer.send((Message)message);
                session.commit();
                this.log.info("JMS Message sent!");
            }
            catch (JMSException ex) {
                session.rollback();
                this.log.info("JMS Can't send the message!");
                throw ex;
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException jMSException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

