/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.ModelInterfaceGenerator;
import org.compiere.Adempiere;
import org.compiere.model.MTable;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class ModelClassGenerator {
    public static final String NL = "\n";
    private static CLogger log = CLogger.getCLogger(ModelClassGenerator.class);
    private String packageName = "";
    private Collection<String> s_importClasses = new TreeSet<String>();

    public ModelClassGenerator(int AD_Table_ID, String directory, String packageName) {
        this.packageName = packageName;
        MTable table = MTable.get(Env.getCtx(), AD_Table_ID);
        if (table == null) {
            throw new RuntimeException("TableName not found for ID=" + AD_Table_ID);
        }
        StringBuffer mandatory = new StringBuffer();
        StringBuffer sb = this.createColumns(AD_Table_ID, mandatory);
        String tableName = this.createHeader(table, sb, mandatory, packageName);
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        this.writeToFile(sb, directory + tableName + ".java");
        if (table.isDocument()) {
            sb = new StringBuffer();
            tableName = this.createHeaderDocument(table, tableName, sb, packageName);
            String fileName = directory + tableName + ".java";
            File out = new File(fileName);
            if (!out.exists()) {
                this.writeToFile(sb, fileName);
            }
        }
    }

    private String createHeader(MTable p_Table, StringBuffer sb, StringBuffer mandatory, String packageName) {
        String tableName = p_Table.getTableName();
        int accessLevel = Integer.parseInt(p_Table.getAccessLevel());
        String accessLevelInfo = accessLevel + " ";
        if (accessLevel >= 4) {
            accessLevelInfo = accessLevelInfo + "- System ";
        }
        if (accessLevel == 2 || accessLevel == 3 || accessLevel == 6 || accessLevel == 7) {
            accessLevelInfo = accessLevelInfo + "- Client ";
        }
        if (accessLevel == 1 || accessLevel == 3 || accessLevel == 5 || accessLevel == 7) {
            accessLevelInfo = accessLevelInfo + "- Org ";
        }
        String keyColumn = tableName + "_ID";
        String className = "X_" + tableName;
        StringBuffer start = new StringBuffer().append("/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.\t\t\t\t\t\t\t\t\t\t*\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net or http://www.adempiere.net/license.html         *\n *****************************************************************************/\n").append("/** Generated Model - DO NOT CHANGE */").append(NL).append("package " + packageName + ";").append(NL).append(NL);
        this.addImportClass(Properties.class);
        this.addImportClass(ResultSet.class);
        if (!packageName.equals("org.compiere.model")) {
            this.addImportClass("org.compiere.model.*");
        }
        this.createImports(start);
        start.append("/** Generated Model for ").append(tableName).append(NL).append(" *  @author Adempiere (generated) ").append(NL).append(" *  @version ").append(Adempiere.MAIN_VERSION).append(" - $Id$ */").append(NL).append("public class ").append(className).append(" extends PO").append(" implements I_").append(tableName).append(", I_Persistent ").append(NL).append("{").append(NL).append(NL).append("\t/**").append(NL).append("\t *").append(NL).append("\t */").append(NL).append("\tprivate static final long serialVersionUID = ").append(String.format("%1$tY%1$tm%1$td", new Timestamp(System.currentTimeMillis()))).append("L;").append(NL).append(NL).append("    /** Standard Constructor */").append(NL).append("    public ").append(className).append(" (Properties ctx, int ").append(keyColumn).append(", String trxName)").append(NL).append("    {").append(NL).append("      super (ctx, ").append(keyColumn).append(", trxName);").append(NL).append("      /** if (").append(keyColumn).append(" == 0)").append(NL).append("        {").append(NL).append(mandatory).append("        } */").append(NL).append("    }").append(NL).append(NL).append("    /** Load Constructor */").append(NL).append("    public ").append(className).append(" (Properties ctx, ResultSet rs, String trxName)").append(NL).append("    {").append(NL).append("      super (ctx, rs, trxName);").append(NL).append("    }").append(NL).append(NL).append("    /** AccessLevel").append(NL).append("      * @return ").append(accessLevelInfo).append(NL).append("      */").append(NL).append("    protected int get_AccessLevel()").append(NL).append("    {").append(NL).append("      return accessLevel.intValue();").append(NL).append("    }").append(NL).append(NL).append("    /** Load Meta Data */").append(NL).append("    protected POInfo initPO (Properties ctx)").append(NL).append("    {").append(NL).append("      POInfo poi = POInfo.getPOInfo (ctx, Table_ID, get_TrxName());").append(NL).append("      return poi;").append(NL).append("    }").append(NL).append(NL).append("    public String toString()").append(NL).append("    {").append(NL).append("      StringBuffer sb = new StringBuffer (\"").append(className).append("[\")").append(NL).append("        .append(get_ID()).append(\"]\");").append(NL).append("      return sb.toString();").append(NL).append("    }").append(NL);
        StringBuffer end = new StringBuffer("}");
        sb.insert(0, start);
        sb.append(end);
        return className;
    }

    private String createHeaderDocument(MTable p_Table, String p_ParentClassName, StringBuffer sb, String packageName) {
        String tableName = p_Table.getTableName();
        String keyColumn = tableName + "_ID";
        String className = "M" + tableName.replaceAll("_", "");
        StringBuffer start = new StringBuffer().append("/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.\t\t\t\t\t\t\t\t\t\t*\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net or http://www.adempiere.net/license.html         *\n *****************************************************************************/\n").append("package " + packageName + ";").append(NL).append(NL);
        this.addImportClass(File.class);
        this.addImportClass(BigDecimal.class);
        this.addImportClass(ResultSet.class);
        this.addImportClass(Timestamp.class);
        this.addImportClass(Properties.class);
        this.addImportClass(DocAction.class);
        this.addImportClass(DocumentEngine.class);
        this.addImportClass(DB.class);
        if (!packageName.equals("org.compiere.model")) {
            this.addImportClass("org.compiere.model.*");
        }
        this.createImports(start);
        start.append("/** Generated Model for ").append(tableName).append(NL).append(" *  @author Adempiere (generated) ").append(NL).append(" *  @version ").append(Adempiere.MAIN_VERSION).append(" - $Id$ */").append(NL).append("public class ").append(className).append(" extends ").append(p_ParentClassName).append(" implements DocAction ").append("{").append(NL).append(NL).append("\t/**").append(NL).append("\t *").append(NL).append("\t */").append(NL).append("\tprivate static final long serialVersionUID = ").append(String.format("%1$tY%1$tm%1$td", new Timestamp(System.currentTimeMillis()))).append("L;").append(NL).append(NL).append("    /** Standard Constructor */").append(NL).append("    public ").append(className).append(" (Properties ctx, int ").append(keyColumn).append(", String trxName)").append(NL).append("    {").append(NL).append("      super (ctx, ").append(keyColumn).append(", trxName);").append(NL).append("    }").append(NL).append(NL).append("    /** Load Constructor */").append(NL).append("    public ").append(className).append(" (Properties ctx, ResultSet rs, String trxName)").append(NL).append("    {").append(NL).append("      super (ctx, rs, trxName);").append(NL).append("    }").append(NL).append(NL);
        start.append("\t/**\n\t * \tGet Document Info\n\t *\t@return document info (untranslated)\n\t */\n\tpublic String getDocumentInfo()\n\t{\n\t\tMDocType dt = MDocType.get(getCtx(), getC_DocType_ID());\n\t\treturn dt.getName() + \" \" + getDocumentNo();\n\t}\t//\tgetDocumentInfo\n\n\t/**\n\t * \tCreate PDF\n\t *\t@return File or null\n\t */\n\tpublic File createPDF ()\n\t{\n\t\ttry\n\t\t{\n\t\t\tFile temp = File.createTempFile(get_TableName() + get_ID() +\"_\", \".pdf\");\n\t\t\treturn createPDF (temp);\n\t\t}\n\t\tcatch (Exception e)\n\t\t{\n\t\t\tlog.severe(\"Could not create PDF - \" + e.getMessage());\n\t\t}\n\t\treturn null;\n\t}\t//\tgetPDF\n\n\t/**\n\t * \tCreate PDF file\n\t *\t@param file output file\n\t *\t@return file if success\n\t */\n\tpublic File createPDF (File file)\n\t{\n\t//\tReportEngine re = ReportEngine.get (getCtx(), ReportEngine.INVOICE, getC_Invoice_ID());\n\t//\tif (re == null)\n\t\t\treturn null;\n\t//\treturn re.getPDF(file);\n\t}\t//\tcreatePDF\n\n\t\n\t/**************************************************************************\n\t * \tProcess document\n\t *\t@param processAction document action\n\t *\t@return true if performed\n\t */\n\tpublic boolean processIt (String processAction)\n\t{\n\t\tm_processMsg = null;\n\t\tDocumentEngine engine = new DocumentEngine (this, getDocStatus());\n\t\treturn engine.processIt (processAction, getDocAction());\n\t}\t//\tprocessIt\n\t\n\t/**\tProcess Message \t\t\t*/\n\tprivate String\t\tm_processMsg = null;\n\t/**\tJust Prepared Flag\t\t\t*/\n\tprivate boolean\t\tm_justPrepared = false;\n\n\t/**\n\t * \tUnlock Document.\n\t * \t@return true if success \n\t */\n\tpublic boolean unlockIt()\n\t{\n\t\tlog.info(\"unlockIt - \" + toString());\n\t//\tsetProcessing(false);\n\t\treturn true;\n\t}\t//\tunlockIt\n\t\n\t/**\n\t * \tInvalidate Document\n\t * \t@return true if success \n\t */\n\tpublic boolean invalidateIt()\n\t{\n\t\tlog.info(\"invalidateIt - \" + toString());\n\t\tsetDocAction(DOCACTION_Prepare);\n\t\treturn true;\n\t}\t//\tinvalidateIt\n\t\n\t/**\n\t *\tPrepare Document\n\t * \t@return new status (In Progress or Invalid) \n\t */\n\tpublic String prepareIt()\n\t{\n\t\tlog.info(toString());\n\t\tm_processMsg = ModelValidationEngine.get().fireDocValidate(this, ModelValidator.TIMING_BEFORE_PREPARE);\n\t\tif (m_processMsg != null)\n\t\t\treturn DocAction.STATUS_Invalid;\n\t\t\n\t\tMDocType dt = MDocType.get(getCtx(), getC_DocType_ID());\n\n\t\t//\tStd Period open?\n\t\tif (!MPeriod.isOpen(getCtx(), getDateDoc(), dt.getDocBaseType(), getAD_Org_ID()))\n\t\t{\n\t\t\tm_processMsg = \"@PeriodClosed@\";\n\t\t\treturn DocAction.STATUS_Invalid;\n\t\t}\n\t\t//\tAdd up Amounts\n\t\tm_processMsg = ModelValidationEngine.get().fireDocValidate(this, ModelValidator.TIMING_AFTER_PREPARE);\n\t\tif (m_processMsg != null)\n\t\t\treturn DocAction.STATUS_Invalid;\n\t\tm_justPrepared = true;\n\t\tif (!DOCACTION_Complete.equals(getDocAction()))\n\t\t\tsetDocAction(DOCACTION_Complete);\n\t\treturn DocAction.STATUS_InProgress;\n\t}\t//\tprepareIt\n\t\n\t/**\n\t * \tApprove Document\n\t * \t@return true if success \n\t */\n\tpublic boolean  approveIt()\n\t{\n\t\tlog.info(\"approveIt - \" + toString());\n\t\tsetIsApproved(true);\n\t\treturn true;\n\t}\t//\tapproveIt\n\t\n\t/**\n\t * \tReject Approval\n\t * \t@return true if success \n\t */\n\tpublic boolean rejectIt()\n\t{\n\t\tlog.info(\"rejectIt - \" + toString());\n\t\tsetIsApproved(false);\n\t\treturn true;\n\t}\t//\trejectIt\n\t\n\t/**\n\t * \tComplete Document\n\t * \t@return new status (Complete, In Progress, Invalid, Waiting ..)\n\t */\n\tpublic String completeIt()\n\t{\n\t\t//\tRe-Check\n\t\tif (!m_justPrepared)\n\t\t{\n\t\t\tString status = prepareIt();\n\t\t\tif (!DocAction.STATUS_InProgress.equals(status))\n\t\t\t\treturn status;\n\t\t}\n\n\t\tm_processMsg = ModelValidationEngine.get().fireDocValidate(this, ModelValidator.TIMING_BEFORE_COMPLETE);\n\t\tif (m_processMsg != null)\n\t\t\treturn DocAction.STATUS_Invalid;\n\t\t\n\t\t//\tImplicit Approval\n\t\tif (!isApproved())\n\t\t\tapproveIt();\n\t\tlog.info(toString());\n\t\t//\n\t\t\n\t\t//\tUser Validation\n\t\tString valid = ModelValidationEngine.get().fireDocValidate(this, ModelValidator.TIMING_AFTER_COMPLETE);\n\t\tif (valid != null)\n\t\t{\n\t\t\tm_processMsg = valid;\n\t\t\treturn DocAction.STATUS_Invalid;\n\t\t}\n\t\t//\tSet Definitive Document No\n\t\tsetDefiniteDocumentNo();\n\n\t\tsetProcessed(true);\n\t\tsetDocAction(DOCACTION_Close);\n\t\treturn DocAction.STATUS_Completed;\n\t}\t//\tcompleteIt\n\t\n\t/**\n\t * \tSet the definite document number after completed\n\t */\n\tprivate void setDefiniteDocumentNo() {\n\t\tMDocType dt = MDocType.get(getCtx(), getC_DocType_ID());\n\t\tif (dt.isOverwriteDateOnComplete()) {\n\t\t\tsetDateDoc(new Timestamp(System.currentTimeMillis()));\n\t\t}\n\t\tif (dt.isOverwriteSeqOnComplete()) {\n\t\t\tString value = null;\n\t\t\tint index = p_info.getColumnIndex(\"C_DocType_ID\");\n\t\t\tif (index == -1)\n\t\t\t\tindex = p_info.getColumnIndex(\"C_DocTypeTarget_ID\");\n\t\t\tif (index != -1)\t\t//\tget based on Doc Type (might return null)\n\t\t\t\tvalue = DB.getDocumentNo(get_ValueAsInt(index), get_TrxName(), true);\n\t\t\tif (value != null) {\n\t\t\t\tsetDocumentNo(value);\n\t\t\t}\n\t\t}\n\t}\n\n\t/**\n\t * \tVoid Document.\n\t * \tSame as Close.\n\t * \t@return true if success \n\t */\n\tpublic boolean voidIt()\n\t{\n\t\tlog.info(\"voidIt - \" + toString());\n\t\treturn closeIt();\n\t}\t//\tvoidIt\n\t\n\t/**\n\t * \tClose Document.\n\t * \tCancel not delivered Qunatities\n\t * \t@return true if success \n\t */\n\tpublic boolean closeIt()\n\t{\n\t\tlog.info(\"closeIt - \" + toString());\n\n\t\t//\tClose Not delivered Qty\n\t\tsetDocAction(DOCACTION_None);\n\t\treturn true;\n\t}\t//\tcloseIt\n\t\n\t/**\n\t * \tReverse Correction\n\t * \t@return true if success \n\t */\n\tpublic boolean reverseCorrectIt()\n\t{\n\t\tlog.info(\"reverseCorrectIt - \" + toString());\n\t\treturn false;\n\t}\t//\treverseCorrectionIt\n\t\n\t/**\n\t * \tReverse Accrual - none\n\t * \t@return true if success \n\t */\n\tpublic boolean reverseAccrualIt()\n\t{\n\t\tlog.info(\"reverseAccrualIt - \" + toString());\n\t\treturn false;\n\t}\t//\treverseAccrualIt\n\t\n\t/** \n\t * \tRe-activate\n\t * \t@return true if success \n\t */\n\tpublic boolean reActivateIt()\n\t{\n\t\tlog.info(\"reActivateIt - \" + toString());\n\t\tsetProcessed(false);\n\t\tif (reverseCorrectIt())\n\t\t\treturn true;\n\t\treturn false;\n\t}\t//\treActivateIt\n\t\n\t\n\t/*************************************************************************\n\t * \tGet Summary\n\t *\t@return Summary of Document\n\t */\n\tpublic String getSummary()\n\t{\n\t\tStringBuffer sb = new StringBuffer();\n\t\tsb.append(getDocumentNo());\n\t//\tsb.append(\": \")\n\t//\t\t.append(Msg.translate(getCtx(),\"TotalLines\")).append(\"=\").append(getTotalLines())\n\t//\t\t.append(\" (#\").append(getLines(false).length).append(\")\");\n\t\t//\t - Description\n\t\tif (getDescription() != null && getDescription().length() > 0)\n\t\t\tsb.append(\" - \").append(getDescription());\n\t\treturn sb.toString();\n\t}\t//\tgetSummary\n\n\t/**\n\t * \tGet Process Message\n\t *\t@return clear text error message\n\t */\n\tpublic String getProcessMsg()\n\t{\n\t\treturn m_processMsg;\n\t}\t//\tgetProcessMsg\n\t\n\t/**\n\t * \tGet Document Owner (Responsible)\n\t *\t@return AD_User_ID\n\t */\n\tpublic int getDoc_User_ID()\n\t{\n\t//\treturn getSalesRep_ID();\n\t\treturn 0;\n\t}\t//\tgetDoc_User_ID\n\n\t/**\n\t * \tGet Document Approval Amount\n\t *\t@return amount\n\t */\n\tpublic BigDecimal getApprovalAmt()\n\t{\n\t\treturn null;\t//getTotalLines();\n\t}\t//\tgetApprovalAmt\n\t\n\t/**\n\t * \tGet Document Currency\n\t *\t@return C_Currency_ID\n\t */\n\tpublic int getC_Currency_ID()\n\t{\n\t//\tMPriceList pl = MPriceList.get(getCtx(), getM_PriceList_ID());\n\t//\treturn pl.getC_Currency_ID();\n\t\treturn 0;\n\t}\t//\tgetC_Currency_ID").append(NL);
        start.append(NL).append("    @Override").append(NL).append("    public String toString()").append(NL).append("    {").append(NL).append("      StringBuffer sb = new StringBuffer (\"").append(className).append("[\")").append(NL).append("        .append(getSummary()).append(\"]\");").append(NL).append("      return sb.toString();").append(NL).append("    }").append(NL);
        StringBuffer end = new StringBuffer("}");
        sb.insert(0, start);
        sb.append(end);
        return className;
    }

    private StringBuffer createColumns(int AD_Table_ID, StringBuffer mandatory) {
        StringBuffer sb = new StringBuffer();
        String sql = "SELECT c.ColumnName, c.IsUpdateable, c.IsMandatory, c.AD_Reference_ID, c.AD_Reference_Value_ID, DefaultValue, SeqNo,  c.FieldLength, c.ValueMin, c.ValueMax, c.VFormat, c.Callout,  c.Name, c.Description, c.ColumnSQL, c.IsEncrypted, c.IsKey, c.IsIdentifier FROM AD_Column c WHERE c.AD_Table_ID=? AND c.ColumnName NOT IN ('AD_Client_ID', 'AD_Org_ID', 'IsActive', 'Created', 'CreatedBy', 'Updated', 'UpdatedBy') AND c.IsActive='Y' ORDER BY c.ColumnName";
        boolean isKeyNamePairCreated = false;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                boolean isUpdateable = "Y".equals(rs.getString(2));
                boolean isMandatory = "Y".equals(rs.getString(3));
                int displayType = rs.getInt(4);
                int AD_Reference_Value_ID = rs.getInt(5);
                String defaultValue = rs.getString(6);
                int seqNo = rs.getInt(7);
                int fieldLength = rs.getInt(8);
                String ValueMin = rs.getString(9);
                String ValueMax = rs.getString(10);
                String VFormat = rs.getString(11);
                String Callout2 = rs.getString(12);
                String Name2 = rs.getString(13);
                String Description = rs.getString(14);
                String ColumnSQL = rs.getString(15);
                boolean virtualColumn = ColumnSQL != null && ColumnSQL.length() > 0;
                boolean IsEncrypted = "Y".equals(rs.getString(16));
                boolean IsKey = "Y".equals(rs.getString(17));
                boolean IsIdentifier = "Y".equals(rs.getString(18));
                sb.append(this.createColumnMethods(mandatory, columnName, isUpdateable, isMandatory, displayType, AD_Reference_Value_ID, fieldLength, defaultValue, ValueMin, ValueMax, VFormat, Callout2, Name2, Description, virtualColumn, IsEncrypted, IsKey, AD_Table_ID));
                if (seqNo != 1 || !IsIdentifier) continue;
                if (!isKeyNamePairCreated) {
                    sb.append(this.createKeyNamePair(columnName, displayType));
                    isKeyNamePairCreated = true;
                    continue;
                }
                throw new RuntimeException("More than one primary identifier found  (AD_Table_ID=" + AD_Table_ID + ", ColumnName=" + columnName + ")");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return sb;
    }

    private String createColumnMethods(StringBuffer mandatory, String columnName, boolean isUpdateable, boolean isMandatory, int displayType, int AD_Reference_ID, int fieldLength, String defaultValue, String ValueMin, String ValueMax, String VFormat, String Callout2, String Name2, String Description, boolean virtualColumn, boolean IsEncrypted, boolean IsKey, int AD_Table_ID) {
        Class<?> clazz = ModelInterfaceGenerator.getClass(columnName, displayType, AD_Reference_ID);
        String dataType = ModelInterfaceGenerator.getDataTypeName(clazz, displayType);
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (DisplayType.isLOB(displayType)) {
            fieldLength = 0;
        }
        String setValue = "\t\tset_Value";
        if (IsEncrypted) {
            setValue = "\t\tset_ValueE";
        }
        if (!isUpdateable) {
            setValue = "\t\tset_ValueNoCheck";
            if (IsEncrypted) {
                setValue = "\t\tset_ValueNoCheckE";
            }
        }
        StringBuffer sb = new StringBuffer();
        if (DisplayType.isID(displayType) && !IsKey) {
            String fieldName = ModelInterfaceGenerator.getFieldName(columnName);
            String referenceClassName = ModelInterfaceGenerator.getReferenceClassName(AD_Table_ID, columnName, displayType, AD_Reference_ID);
            if (fieldName != null && referenceClassName != null) {
                sb.append(NL).append("\tpublic " + referenceClassName + " get").append(fieldName).append("() throws RuntimeException").append(NL).append("    {").append(NL).append("\t\treturn (" + referenceClassName + ")MTable.get(getCtx(), " + referenceClassName + ".Table_Name)").append(NL).append("\t\t\t.getPO(get" + columnName + "(), get_TrxName());").append("\t}").append(NL);
                this.addImportClass(clazz);
            }
        }
        this.generateJavaSetComment(columnName, Name2, Description, sb);
        sb.append("\tpublic void set").append(columnName).append(" (").append(dataType).append(" ").append(columnName).append(")").append(NL).append("\t{").append(NL);
        if (AD_Reference_ID != 0 && String.class == clazz) {
            String staticVar = this.addListValidation(sb, AD_Reference_ID, columnName);
            sb.insert(0, staticVar);
        }
        if (virtualColumn) {
            sb.append("\t\tthrow new IllegalArgumentException (\"").append(columnName).append(" is virtual column\");");
        } else if (clazz.equals(Integer.class)) {
            if (columnName.endsWith("_ID")) {
                int firstOK = 1;
                if (columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("Record_ID") || columnName.equals("C_DocType_ID") || columnName.equals("Node_ID") || columnName.equals("AD_Role_ID") || columnName.equals("M_AttributeSet_ID") || columnName.equals("M_AttributeSetInstance_ID") || columnName.equals("M_Warehouse_ID")) {
                    firstOK = 0;
                }
                sb.append("\t\tif (").append(columnName).append(" < ").append(firstOK).append(") ").append(NL).append("\t").append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", null);").append(NL).append("\t\telse ").append(NL).append("\t");
            }
            sb.append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", Integer.valueOf(").append(columnName).append("));").append(NL);
        } else if (clazz.equals(Boolean.class)) {
            sb.append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", Boolean.valueOf(").append(columnName).append("));").append(NL);
        } else {
            sb.append(setValue).append(" (").append("COLUMNNAME_").append(columnName).append(", ").append(columnName).append(");").append(NL);
        }
        sb.append("\t}").append(NL);
        if (isMandatory) {
            mandatory.append("\t\t\tset").append(columnName).append(" (");
            if (clazz.equals(Integer.class)) {
                mandatory.append("0");
            } else if (clazz.equals(Boolean.class)) {
                if (defaultValue.indexOf(89) != -1) {
                    mandatory.append(true);
                } else {
                    mandatory.append("false");
                }
            } else if (clazz.equals(BigDecimal.class)) {
                mandatory.append("Env.ZERO");
            } else if (clazz.equals(Timestamp.class)) {
                mandatory.append("new Timestamp( System.currentTimeMillis() )");
            } else {
                mandatory.append("null");
            }
            mandatory.append(");").append(NL);
            if (defaultValue.length() > 0) {
                mandatory.append("// ").append(defaultValue).append(NL);
            }
        }
        this.generateJavaGetComment(Name2, Description, sb);
        String getValue = "get_Value";
        if (IsEncrypted) {
            getValue = "get_ValueE";
        }
        sb.append("\tpublic ").append(dataType);
        if (clazz.equals(Boolean.class)) {
            sb.append(" is");
            if (columnName.toLowerCase().startsWith("is")) {
                sb.append(columnName.substring(2));
            } else {
                sb.append(columnName);
            }
        } else {
            sb.append(" get").append(columnName);
        }
        sb.append(" () ").append(NL).append("\t{").append(NL).append("\t\t");
        if (clazz.equals(Integer.class)) {
            sb.append("Integer ii = (Integer)").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL).append("\t\tif (ii == null)").append(NL).append("\t\t\t return 0;").append(NL).append("\t\treturn ii.intValue();").append(NL);
        } else if (clazz.equals(BigDecimal.class)) {
            sb.append("BigDecimal bd = (BigDecimal)").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL).append("\t\tif (bd == null)").append(NL).append("\t\t\t return Env.ZERO;").append(NL).append("\t\treturn bd;").append(NL);
            this.addImportClass(BigDecimal.class);
            this.addImportClass(Env.class);
        } else if (clazz.equals(Boolean.class)) {
            sb.append("Object oo = ").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL).append("\t\tif (oo != null) ").append(NL).append("\t\t{").append(NL).append("\t\t\t if (oo instanceof Boolean) ").append(NL).append("\t\t\t\t return ((Boolean)oo).booleanValue(); ").append(NL).append("\t\t\treturn \"Y\".equals(oo);").append(NL).append("\t\t}").append(NL).append("\t\treturn false;").append(NL);
        } else if (dataType.equals("Object")) {
            sb.append("\t\treturn ").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL);
        } else {
            sb.append("return (").append(dataType).append(")").append(getValue).append("(").append("COLUMNNAME_").append(columnName).append(");").append(NL);
            this.addImportClass(clazz);
        }
        sb.append("\t}").append(NL);
        return sb.toString();
    }

    public void generateJavaSetComment(String columnName, String propertyName, String description, StringBuffer result) {
        result.append(NL).append("\t/** Set ").append(propertyName).append(".").append(NL).append("\t\t@param ").append(columnName).append(" ");
        if (description != null && description.length() > 0) {
            result.append(NL).append("\t\t").append(description).append(NL);
        } else {
            result.append(propertyName);
        }
        result.append("\t  */").append(NL);
    }

    public void generateJavaGetComment(String propertyName, String description, StringBuffer result) {
        result.append(NL).append("\t/** Get ").append(propertyName);
        if (description != null && description.length() > 0) {
            result.append(".").append(NL).append("\t\t@return ").append(description).append(NL);
        } else {
            result.append(".\n\t\t@return ").append(propertyName);
        }
        result.append("\t  */").append(NL);
    }

    private String addListValidation(StringBuffer sb, int AD_Reference_ID, String columnName) {
        StringBuffer retValue = new StringBuffer();
        retValue.append("\n\t/** ").append(columnName).append(" AD_Reference_ID=").append(AD_Reference_ID).append(" */").append("\n\tpublic static final int ").append(columnName.toUpperCase()).append("_AD_Reference_ID=").append(AD_Reference_ID).append(";");
        boolean found = false;
        StringBuffer values = new StringBuffer("Reference_ID=").append(AD_Reference_ID);
        StringBuffer statement = new StringBuffer();
        String sql = "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY AD_Ref_List_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(1);
                values.append(" - ").append(value);
                if (statement.length() == 0) {
                    statement.append("\n\t\tif (").append(columnName).append(".equals(\"").append(value).append("\")");
                } else {
                    statement.append(" || ").append(columnName).append(".equals(\"").append(value).append("\")");
                }
                if (!found) {
                    found = true;
                }
                String name = rs.getString(2);
                char[] nameArray = name.toCharArray();
                StringBuffer nameClean = new StringBuffer();
                boolean initCap = true;
                for (int i = 0; i < nameArray.length; ++i) {
                    char c = nameArray[i];
                    if (Character.isJavaIdentifierPart(c)) {
                        if (initCap) {
                            nameClean.append(Character.toUpperCase(c));
                        } else {
                            nameClean.append(c);
                        }
                        initCap = false;
                        continue;
                    }
                    if (c == '+') {
                        nameClean.append("Plus");
                    } else if (c == '-') {
                        nameClean.append("_");
                    } else if (c == '>') {
                        if (name.indexOf(60) == -1) {
                            nameClean.append("Gt");
                        }
                    } else if (c == '<') {
                        if (name.indexOf(62) == -1) {
                            nameClean.append("Le");
                        }
                    } else if (c == '!') {
                        nameClean.append("Not");
                    } else if (c == '=') {
                        nameClean.append("Eq");
                    } else if (c == '~') {
                        nameClean.append("Like");
                    }
                    initCap = true;
                }
                retValue.append("\n\t/** ").append(name).append(" = ").append(value).append(" */");
                retValue.append("\n\tpublic static final String ").append(columnName.toUpperCase()).append("_").append(nameClean).append(" = \"").append(value).append("\";");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        statement.append("); else throw new IllegalArgumentException (\"").append(columnName).append(" Invalid value - \" + ").append(columnName).append(" + \" - ").append(values).append("\");");
        sb.append(NL);
        return retValue.toString();
    }

    private StringBuffer createKeyNamePair(String columnName, int displayType) {
        String method = "get" + columnName + "()";
        if (displayType != 10) {
            method = "String.valueOf(" + method + ")";
        }
        StringBuffer sb = new StringBuffer(NL).append("    /** Get Record ID/ColumnName").append(NL).append("        @return ID/ColumnName pair").append(NL).append("      */").append(NL).append("    public KeyNamePair getKeyNamePair() ").append(NL).append("    {").append(NL).append("        return new KeyNamePair(get_ID(), ").append(method).append(");").append(NL).append("    }").append(NL);
        this.addImportClass(KeyNamePair.class);
        return sb;
    }

    private void writeToFile(StringBuffer sb, String fileName) {
        try {
            File out = new File(fileName);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    if (!sb.substring(i + 1).startsWith("//")) continue;
                    continue;
                }
                if (c == '{') {
                    ((Writer)fw).write(c);
                    continue;
                }
                ((Writer)fw).write(c);
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            log.info(out.getAbsolutePath() + " - " + (size /= 1024.0f) + " kB");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
            throw new RuntimeException(ex);
        }
    }

    private void addImportClass(String className) {
        if (className == null || className.startsWith("java.lang.") && !className.startsWith("java.lang.reflect.") || className.startsWith(this.packageName + ".")) {
            return;
        }
        for (String name : this.s_importClasses) {
            if (!className.equals(name)) continue;
            return;
        }
        this.s_importClasses.add(className);
    }

    private void addImportClass(Class<?> cl) {
        if (cl.isArray()) {
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            return;
        }
        this.addImportClass(cl.getCanonicalName());
    }

    private void createImports(StringBuffer sb) {
        for (String name : this.s_importClasses) {
            sb.append("import ").append(name).append(";").append(NL);
        }
        sb.append(NL);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GenerateModel[").append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        CLogMgt.setLevel(Level.FINE);
        log.info("Generate Model   $Revision: 1.42 $");
        log.info("----------------------------------");
        String directory = "C:\\Adempiere\\adempiere-all\\extend\\src\\compiere\\model\\";
        if (args.length > 0) {
            directory = args[0];
        }
        if (directory == null || directory.length() == 0) {
            System.err.println("No Directory");
            System.exit(1);
        }
        log.info("Directory: " + directory);
        String packageName = "compiere.model";
        if (args.length > 1) {
            packageName = args[1];
        }
        if (packageName == null || packageName.length() == 0) {
            System.err.println("No package");
            System.exit(1);
        }
        log.info("Package:   " + packageName);
        String entityType = "'U','A'";
        if (args.length > 2) {
            entityType = args[2];
        }
        if (entityType == null || entityType.length() == 0) {
            System.err.println("No EntityType");
            System.exit(1);
        }
        StringBuffer sql = new StringBuffer("EntityType IN (").append(entityType).append(")");
        log.info(sql.toString());
        log.info("----------------------------------");
        String tableLike = "'%'";
        if (args.length > 3) {
            tableLike = args[3];
        }
        log.info("Table Like: " + tableLike);
        sql.insert(0, "SELECT AD_Table_ID FROM AD_Table WHERE (TableName IN ('RV_WarehousePrice','RV_BPartner') OR IsView='N') AND IsActive = 'Y' AND TableName NOT LIKE '%_Trl' AND ");
        sql.append(" AND TableName LIKE ").append(tableLike);
        sql.append(" ORDER BY TableName");
        int count = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                new ModelClassGenerator(rs.getInt(1), directory, packageName);
                ++count;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.info("Generated = " + count);
    }
}

