/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.model.MEntityType;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class ModelInterfaceGenerator {
    private String packageName = "";
    public static final String NL = "\n";
    public static final String COPY = "/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.\t\t\t\t\t\t\t\t\t\t*\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net or http://www.adempiere.net/license.html         *\n *****************************************************************************/\n";
    private static CLogger log = CLogger.getCLogger(ModelInterfaceGenerator.class);
    private Collection<String> s_importClasses = new TreeSet<String>();

    public ModelInterfaceGenerator(int AD_Table_ID, String directory, String packageName) {
        this.packageName = packageName;
        StringBuffer mandatory = new StringBuffer();
        StringBuffer sb = this.createColumns(AD_Table_ID, mandatory);
        String tableName = this.createHeader(AD_Table_ID, sb, mandatory);
        if (!directory.endsWith("/") && !directory.endsWith("\\")) {
            directory = directory + "/";
        }
        this.writeToFile(sb, directory + tableName + ".java");
    }

    private String createHeader(int AD_Table_ID, StringBuffer sb, StringBuffer mandatory) {
        String tableName = "";
        int accessLevel = 0;
        String sql = "SELECT TableName, AccessLevel FROM AD_Table WHERE AD_Table_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                tableName = rs.getString(1);
                accessLevel = rs.getInt(2);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (tableName == null) {
            throw new RuntimeException("TableName not found for ID=" + AD_Table_ID);
        }
        String accessLevelInfo = accessLevel + " ";
        if (accessLevel >= 4) {
            accessLevelInfo = accessLevelInfo + "- System ";
        }
        if (accessLevel == 2 || accessLevel == 3 || accessLevel == 6 || accessLevel == 7) {
            accessLevelInfo = accessLevelInfo + "- Client ";
        }
        if (accessLevel == 1 || accessLevel == 3 || accessLevel == 5 || accessLevel == 7) {
            accessLevelInfo = accessLevelInfo + "- Org ";
        }
        String className = "I_" + tableName;
        StringBuffer start = new StringBuffer().append(COPY).append("package ").append(this.packageName).append(";").append(NL);
        if (!this.packageName.equals("org.compiere.model")) {
            this.addImportClass("org.compiere.model.*");
        }
        this.addImportClass(BigDecimal.class);
        this.addImportClass(KeyNamePair.class);
        this.createImports(start);
        start.append("/** Generated Interface for ").append(tableName).append(NL).append(" *  @author Adempiere (generated) \n").append(" *  @version ").append(Adempiere.MAIN_VERSION).append(NL).append(" */\n").append("public interface ").append(className).append(" {").append(NL).append("    /** TableName=").append(tableName).append(" */\n").append("    public static final String Table_Name = \"").append(tableName).append("\";\n").append("    /** AD_Table_ID=").append(AD_Table_ID).append(" */\n").append("    public static final int Table_ID = MTable.getTable_ID(Table_Name);\n").append("    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);\n").append("    /** AccessLevel = ").append(accessLevelInfo).append(NL).append("     */\n").append("    BigDecimal accessLevel = BigDecimal.valueOf(").append(accessLevel).append(");\n").append("    /** Load Meta Data */\n");
        StringBuffer end = new StringBuffer("}");
        sb.insert(0, start);
        sb.append(end);
        return className;
    }

    private StringBuffer createColumns(int AD_Table_ID, StringBuffer mandatory) {
        StringBuffer sb = new StringBuffer();
        String sql = "SELECT c.ColumnName, c.IsUpdateable, c.IsMandatory, c.AD_Reference_ID, c.AD_Reference_Value_ID, DefaultValue, SeqNo,  c.FieldLength, c.ValueMin, c.ValueMax, c.VFormat, c.Callout,  c.Name, c.Description, c.ColumnSQL, c.IsEncrypted, c.IsKey FROM AD_Column c WHERE c.AD_Table_ID=? AND c.IsActive='Y' ORDER BY c.ColumnName";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                boolean isUpdateable = "Y".equals(rs.getString(2));
                boolean isMandatory = "Y".equals(rs.getString(3));
                int displayType = rs.getInt(4);
                int AD_Reference_Value_ID = rs.getInt(5);
                String defaultValue = rs.getString(6);
                int fieldLength = rs.getInt(8);
                String ValueMin = rs.getString(9);
                String ValueMax = rs.getString(10);
                String VFormat = rs.getString(11);
                String Callout2 = rs.getString(12);
                String Name2 = rs.getString(13);
                String Description = rs.getString(14);
                String ColumnSQL = rs.getString(15);
                boolean virtualColumn = ColumnSQL != null && ColumnSQL.length() > 0;
                boolean IsEncrypted = "Y".equals(rs.getString(16));
                boolean IsKey = "Y".equals(rs.getString(17));
                sb.append(NL).append("    /** Column name ").append(columnName).append(" */\n").append("    public static final String COLUMNNAME_").append(columnName).append(" = \"").append(columnName).append("\";");
                sb.append(this.createColumnMethods(mandatory, columnName, isUpdateable, isMandatory, displayType, AD_Reference_Value_ID, fieldLength, defaultValue, ValueMin, ValueMax, VFormat, Callout2, Name2, Description, virtualColumn, IsEncrypted, IsKey, AD_Table_ID));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return sb;
    }

    private String createColumnMethods(StringBuffer mandatory, String columnName, boolean isUpdateable, boolean isMandatory, int displayType, int AD_Reference_ID, int fieldLength, String defaultValue, String ValueMin, String ValueMax, String VFormat, String Callout2, String Name2, String Description, boolean virtualColumn, boolean IsEncrypted, boolean IsKey, int AD_Table_ID) {
        Class<?> clazz = ModelInterfaceGenerator.getClass(columnName, displayType, AD_Reference_ID);
        String dataType = ModelInterfaceGenerator.getDataTypeName(clazz, displayType);
        if (defaultValue == null) {
            defaultValue = "";
        }
        StringBuffer sb = new StringBuffer();
        if (ModelInterfaceGenerator.isGenerateSetter(columnName)) {
            this.generateJavaComment("Set", Name2, Description, sb);
            sb.append("\tpublic void set").append(columnName).append(" (").append(dataType).append(" ").append(columnName).append(");");
        }
        this.generateJavaComment("Get", Name2, Description, sb);
        sb.append("\tpublic ").append(dataType);
        if (clazz.equals(Boolean.class)) {
            sb.append(" is");
            if (columnName.toLowerCase().startsWith("is")) {
                sb.append(columnName.substring(2));
            } else {
                sb.append(columnName);
            }
        } else {
            sb.append(" get").append(columnName);
        }
        sb.append("();");
        if (ModelInterfaceGenerator.isGenerateModelGetter(columnName) && DisplayType.isID(displayType) && !IsKey) {
            String fieldName = ModelInterfaceGenerator.getFieldName(columnName);
            String referenceClassName = ModelInterfaceGenerator.getReferenceClassName(AD_Table_ID, columnName, displayType, AD_Reference_ID);
            if (fieldName != null && referenceClassName != null) {
                sb.append(NL).append("\tpublic " + referenceClassName + " get").append(fieldName).append("() throws RuntimeException;");
            }
        }
        this.addImportClass(clazz);
        return sb.toString();
    }

    public void generateJavaComment(String startOfComment, String propertyName, String description, StringBuffer result) {
        result.append(NL).append("\t/** ").append(startOfComment).append(" ").append(propertyName);
        if (description != null && description.length() > 0) {
            result.append(".\n\t  * ").append(description).append(NL);
        }
        result.append("\t  */\n");
    }

    private void writeToFile(StringBuffer sb, String fileName) {
        try {
            File out = new File(fileName);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    if (sb.substring(i + 1).startsWith("//")) {
                        ((Writer)fw).write(9);
                        continue;
                    }
                    fw.write(NL);
                    continue;
                }
                if (c == '{') {
                    fw.write(NL);
                    ((Writer)fw).write(c);
                    fw.write(NL);
                    continue;
                }
                ((Writer)fw).write(c);
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            log.info(out.getAbsolutePath() + " - " + (size /= 1024.0f) + " kB");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
            throw new RuntimeException(ex);
        }
    }

    private void addImportClass(String className) {
        if (className == null || className.startsWith("java.lang.") && !className.startsWith("java.lang.reflect.") || className.startsWith(this.packageName + ".")) {
            return;
        }
        for (String name : this.s_importClasses) {
            if (!className.equals(name)) continue;
            return;
        }
        if (className.equals("byte[]")) {
            log.warning("Invalid type - " + className);
            return;
        }
        this.s_importClasses.add(className);
    }

    private void addImportClass(Class<?> cl) {
        if (cl.isArray()) {
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            return;
        }
        this.addImportClass(cl.getCanonicalName());
    }

    private void createImports(StringBuffer sb) {
        for (String name : this.s_importClasses) {
            sb.append("import ").append(name).append(";");
        }
        sb.append(NL);
    }

    public static Class<?> getClass(String columnName, int displayType, int AD_Reference_ID) {
        block7: {
            if (columnName.equalsIgnoreCase("Posted") || columnName.equalsIgnoreCase("Processed") || columnName.equalsIgnoreCase("Processing")) {
                return Boolean.class;
            }
            if (columnName.equalsIgnoreCase("Record_ID")) {
                return Integer.class;
            }
            if (18 != displayType && 30 != displayType || AD_Reference_ID <= 0) break block7;
            String sql = "SELECT c.AD_Reference_ID, c.AD_Reference_Value_ID FROM AD_Ref_Table rt INNER JOIN AD_Column c ON (c.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Reference_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalStateException("Not found AD_Ref_Table/AD_Column - DisplayType=" + displayType + ", AD_Reference_ID=" + AD_Reference_ID);
                }
                displayType = rs.getInt(1);
                AD_Reference_ID = rs.getInt(2);
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return ModelInterfaceGenerator.getClass(columnName, displayType, AD_Reference_ID);
        }
        return DisplayType.getClass(displayType, true);
    }

    public static String getDataTypeName(Class<?> cl, int displayType) {
        String dataType = cl.getName();
        if ((dataType = dataType.substring(dataType.lastIndexOf(46) + 1)).equals("Boolean")) {
            dataType = "boolean";
        } else if (dataType.equals("Integer")) {
            dataType = "int";
        } else if (displayType == 23 || displayType == 32) {
            dataType = "byte[]";
        }
        return dataType;
    }

    public static boolean isGenerateSetter(String columnName) {
        return !"AD_Client_ID".equals(columnName) && !"Created".equals(columnName) && !"CreatedBy".equals(columnName) && !"Updated".equals(columnName) && !"UpdatedBy".equals(columnName);
    }

    public static boolean isGenerateModelGetter(String columnName) {
        return !"AD_Client_ID".equals(columnName) && !"AD_Org_ID".equals(columnName) && !"CreatedBy".equals(columnName) && !"UpdatedBy".equals(columnName);
    }

    public static boolean isGenerateModelGetterForEntity(int AD_Table_ID, String toEntityType) {
        String fromEntityType = DB.getSQLValueString(null, "SELECT EntityType FROM AD_Table where AD_Table_ID=?", AD_Table_ID);
        MEntityType fromEntity = MEntityType.get(Env.getCtx(), fromEntityType);
        MEntityType toEntity = MEntityType.get(Env.getCtx(), toEntityType);
        return fromEntityType.equals(toEntityType) || fromEntity.isSystemMaintained() && toEntity.isSystemMaintained() || !fromEntity.isSystemMaintained() && toEntity.isSystemMaintained();
    }

    public static String getModelPackage(String entityType) {
        if ("D".equals(entityType)) {
            return "org.compiere.model";
        }
        for (MEntityType entity : MEntityType.getEntityTypes(Env.getCtx())) {
            if (!entity.getEntityType().equals(entityType)) continue;
            return entity.getModelPackage();
        }
        return null;
    }

    public static String getFieldName(String columnName) {
        String fieldName = columnName.endsWith("_ID_To") ? columnName.substring(0, columnName.length() - 6) + "_To" : columnName.substring(0, columnName.length() - 3);
        return fieldName;
    }

    public static String getReferenceClassName(int AD_Table_ID, String columnName, int displayType, int AD_Reference_ID) {
        String referenceClassName;
        block19: {
            block20: {
                ResultSet rs;
                CPreparedStatement pstmt;
                block16: {
                    block17: {
                        String refTableName;
                        block18: {
                            referenceClassName = null;
                            if (displayType != 19 && (displayType != 30 || AD_Reference_ID != 0)) break block17;
                            refTableName = MQuery.getZoomTableName(columnName);
                            referenceClassName = "I_" + refTableName;
                            MTable table = MTable.get(Env.getCtx(), refTableName);
                            if (table == null) break block18;
                            String entityType = table.getEntityType();
                            String modelpackage = ModelInterfaceGenerator.getModelPackage(entityType);
                            if (modelpackage != null) {
                                referenceClassName = modelpackage + "." + referenceClassName;
                            }
                            if (!ModelInterfaceGenerator.isGenerateModelGetterForEntity(AD_Table_ID, entityType)) {
                                referenceClassName = null;
                            }
                            break block19;
                        }
                        throw new RuntimeException("No table found for " + refTableName);
                    }
                    if (displayType != 18 && (displayType != 30 || AD_Reference_ID <= 0)) break block20;
                    if (AD_Table_ID == 270 && columnName.equals("Account_ID")) {
                        return null;
                    }
                    if (AD_Table_ID == 707 && columnName.equals("Account_ID")) {
                        return null;
                    }
                    String sql = "SELECT t.TableName, t.EntityType, ck.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (t.AD_Table_ID=rt.AD_Table_ID) INNER JOIN AD_Column ck ON (ck.AD_Table_ID=rt.AD_Table_ID AND ck.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        pstmt = DB.prepareStatement("SELECT t.TableName, t.EntityType, ck.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (t.AD_Table_ID=rt.AD_Table_ID) INNER JOIN AD_Column ck ON (ck.AD_Table_ID=rt.AD_Table_ID AND ck.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?", null);
                        pstmt.setInt(1, AD_Reference_ID);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block16;
                        String refTableName = rs.getString(1);
                        String entityType = rs.getString(2);
                        int refDisplayType = rs.getInt(3);
                        if (refDisplayType != 13) break block16;
                        referenceClassName = "I_" + refTableName;
                        String modelpackage = ModelInterfaceGenerator.getModelPackage(entityType);
                        if (modelpackage != null) {
                            referenceClassName = modelpackage + "." + referenceClassName;
                        }
                        if (ModelInterfaceGenerator.isGenerateModelGetterForEntity(AD_Table_ID, entityType)) break block16;
                        referenceClassName = null;
                    }
                    catch (SQLException e) {
                        try {
                            throw new DBException(e, "SELECT t.TableName, t.EntityType, ck.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (t.AD_Table_ID=rt.AD_Table_ID) INNER JOIN AD_Column ck ON (ck.AD_Table_ID=rt.AD_Table_ID AND ck.AD_Column_ID=rt.AD_Key) WHERE rt.AD_Reference_ID=?");
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                    }
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                break block19;
            }
            if (displayType == 21) {
                referenceClassName = "I_C_Location";
            } else if (displayType == 31) {
                referenceClassName = "I_M_Locator";
            } else if (displayType == 25) {
                referenceClassName = "I_C_ValidCombination";
            } else if (displayType == 35) {
                referenceClassName = "I_M_AttributeSetInstance";
            }
        }
        return referenceClassName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GenerateModel[").append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        CLogMgt.setLevel(Level.FINE);
        log.info("Generate Interface   $Revision: 1.0 $");
        log.info("----------------------------------");
        String directory = "C:\\Adempiere\\adempiere-all\\extend\\src\\compiere\\model\\";
        if (args.length > 0) {
            directory = args[0];
        }
        if (directory == null || directory.length() == 0) {
            System.err.println("No Directory");
            System.exit(1);
        }
        log.info("Directory: " + directory);
        String packageName = "compiere.model";
        if (args.length > 1) {
            packageName = args[1];
        }
        if (packageName == null || packageName.length() == 0) {
            System.err.println("No package");
            System.exit(1);
        }
        log.info("Package:   " + packageName);
        String entityType = "'U','A'";
        if (args.length > 2) {
            entityType = args[2];
        }
        if (entityType == null || entityType.length() == 0) {
            System.err.println("No EntityType");
            System.exit(1);
        }
        StringBuffer sql = new StringBuffer("EntityType IN (").append(entityType).append(")");
        log.info(sql.toString());
        log.info("----------------------------------");
        String tableLike = "'%'";
        if (args.length > 3) {
            tableLike = args[3];
        }
        log.info("Table Like: " + tableLike);
        sql.insert(0, "SELECT AD_Table_ID FROM AD_Table WHERE (TableName IN ('RV_WarehousePrice','RV_BPartner') OR IsView='N') AND IsActive = 'Y' AND TableName NOT LIKE '%_Trl' AND ");
        sql.append(" AND TableName LIKE ").append(tableLike);
        sql.append(" ORDER BY TableName");
        int count = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                new ModelInterfaceGenerator(rs.getInt(1), directory, packageName);
                ++count;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.info("Generated = " + count);
    }
}

