/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MColumn;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRefTable;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class ProcessAbstractClassGenerator {
    private int processId = 0;
    private String processValue = null;
    private String processName = null;
    private String className = null;
    private String directoryName = null;
    private List<String> parameterWithPrefix = new ArrayList<String>();
    private Collection<String> importClasses = new TreeSet<String>();
    private static CLogger log = CLogger.getCLogger(ProcessAbstractClassGenerator.class);
    private StringBuffer parametersName = new StringBuffer();
    private StringBuffer parametersValue = new StringBuffer();
    private StringBuffer parametersFill = new StringBuffer();
    private StringBuffer parametersGetter = new StringBuffer();
    private MProcessPara[] parameters;

    public ProcessAbstractClassGenerator(MProcess process, String directory) {
        this.processId = process.getAD_Process_ID();
        this.className = process.getClassname();
        this.processValue = process.getValue();
        this.processName = process.getName();
        this.directoryName = directory;
    }

    public String createFile() {
        int index = this.className.lastIndexOf(".");
        if (index == -1) {
            throw new AdempiereException("@Classname@ @NotFound@");
        }
        String packageName = this.className.substring(0, index);
        String fileName = this.className.substring(index + 1) + "Abstract";
        StringBuffer header = this.createHeader(packageName, fileName);
        if (!this.directoryName.endsWith(File.separator)) {
            this.directoryName = this.directoryName + File.separator;
        }
        this.writeToFile(header, this.directoryName + fileName + ".java");
        return this.directoryName + fileName + ".java";
    }

    private void createParameters() {
        for (MProcessPara parameter : this.getParameters()) {
            if (parameter.isInfoOnly()) continue;
            this.createParameterName(parameter);
            this.createParameterValue(parameter, false);
            this.createParameterFill(parameter, false);
            if (!parameter.isRange()) continue;
            this.createParameterValue(parameter, true);
            this.createParameterFill(parameter, true);
        }
    }

    private void createParameterGetter() {
        for (MProcessPara parameter : this.getParameters()) {
            if (parameter.isInfoOnly()) continue;
            this.createGetterParameter(parameter, false);
            this.createSetterParameter(parameter, false);
            if (!parameter.isRange()) continue;
            this.createGetterParameter(parameter, true);
            this.createSetterParameter(parameter, true);
        }
        this.createGetterParameter();
    }

    private MProcessPara[] getParameters() {
        if (this.parameters == null || this.parameters.length == 0) {
            MProcess process = new MProcess(Env.getCtx(), this.processId, null);
            this.parameters = process.getParameters();
            this.validatePrefix();
        }
        return this.parameters;
    }

    private void validatePrefix() {
        ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add("processId");
        parameterList.add("processValue");
        parameterList.add("processName");
        for (MProcessPara parameter : this.parameters) {
            String parameterName = this.getVariableName(parameter);
            if (parameterList.contains(parameterName)) {
                this.parameterWithPrefix.add(parameter.getColumnName());
                continue;
            }
            parameterList.add(parameterName);
        }
    }

    private StringBuffer createHeader(String packageName, String className) {
        StringBuffer header = new StringBuffer();
        this.createParameters();
        if (!packageName.equals("org.compiere.process")) {
            this.addImportClass(SvrProcess.class);
        }
        header.append("/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.\t\t\t\t\t\t\t\t\t\t*\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net or http://www.adempiere.net/license.html         *\n *****************************************************************************/\n");
        header.append("\n");
        header.append("package ").append(packageName).append(";\n");
        header.append("\n");
        header.append(this.getImportClass());
        header.append("\n\n/** Generated Process for (").append(this.processName).append(")\n").append(" *  @author ADempiere (generated) \n").append(" *  @version ").append(Adempiere.MAIN_VERSION).append("\n").append(" */\n");
        header.append("public abstract class ").append(className).append(" extends ").append("SvrProcess").append(" {");
        header.append("\n\t/** Process Value \t*/");
        header.append("\n\tprivate static final String VALUE_FOR_PROCESS = ").append("\"").append(this.processValue.trim()).append("\";");
        header.append("\n\t/** Process Name \t*/");
        header.append("\n\tprivate static final String NAME_FOR_PROCESS = ").append("\"").append(this.processName.trim()).append("\";");
        header.append("\n\t/** Process Id \t*/");
        header.append("\n\tprivate static final int ID_FOR_PROCESS = ").append(this.processId).append(";");
        header.append(this.parametersName);
        header.append(this.parametersValue);
        header.append("\n\n\t@Override").append("\n\tprotected void prepare() {");
        header.append(this.parametersFill);
        header.append("\n\t}");
        this.createParameterGetter();
        header.append(this.parametersGetter);
        header.append("\n}");
        return header;
    }

    private void createParameterName(MProcessPara parameter) {
        this.parametersName.append("\n");
        String staticName = this.replaceSpecialCharacter(parameter.getColumnName());
        this.parametersName.append("\t/**\tParameter Name for ").append(parameter.getName()).append("\t*/").append("\n").append("\tpublic static final String ").append(staticName.toUpperCase()).append(" = ").append("\"").append(staticName).append("\";");
    }

    private void createParameterValue(MProcessPara parameter, boolean isTo) {
        this.parametersValue.append("\n");
        String variableName = this.getVariableName(parameter);
        this.parametersValue.append("\t/**\tParameter Value for ").append(parameter.getName()).append(isTo ? "(To)" : "").append("\t*/").append("\n").append("\tprivate ").append(this.getType(parameter)).append(" ").append(variableName.trim()).append(isTo ? "To" : "").append(";");
    }

    private void createGetterParameter() {
        this.parametersGetter.append("\n");
        this.parametersGetter.append("\n\t/**\t Getter Parameter Value for Process ID\t*/").append("\n").append("\tpublic static final int getProcessId() {").append("\n\t\treturn ID_FOR_PROCESS;\n").append("\t}\n");
        this.parametersGetter.append("\n\t/**\t Getter Parameter Value for Process Value\t*/").append("\n").append("\tpublic static final String getProcessValue() {").append("\n\t\treturn VALUE_FOR_PROCESS;\n").append("\t}\n");
        this.parametersGetter.append("\n\t/**\t Getter Parameter Value for Process Name\t*/").append("\n").append("\tpublic static final String getProcessName() {").append("\n\t\treturn NAME_FOR_PROCESS;\n").append("\t}");
    }

    private void createGetterParameter(MProcessPara parameter, boolean isTo) {
        this.parametersGetter.append("\n");
        String variableName = this.getVariableName(parameter);
        this.parametersGetter.append("\n\t/**\t Getter Parameter Value for ").append(parameter.getName()).append(isTo ? "(To)" : "").append("\t*/").append("\n").append("\tprotected ").append(this.getType(parameter)).append(" ").append(this.getMethodNameForGet(parameter)).append(isTo ? "To" : "").append("() {").append("\n\t\treturn ").append(variableName.trim()).append(isTo ? "To" : "").append(";\n").append("\t}");
    }

    private void createSetterParameter(MProcessPara parameter, boolean isTo) {
        this.parametersGetter.append("\n");
        String variableName = this.getVariableName(parameter) + (isTo ? "To" : "");
        this.parametersGetter.append("\n\t/**\t Setter Parameter Value for ").append(parameter.getName()).append(isTo ? "(To)" : "").append("\t*/").append("\n").append("\tprotected void ").append(this.getMethodNameForSet(parameter)).append(isTo ? "To" : "").append("(").append(this.getType(parameter)).append(" ").append(variableName).append(") {").append("\n\t\tthis.").append(variableName.trim()).append(" = ").append(variableName).append(";\n").append("\t}");
    }

    private void createParameterFill(MProcessPara parameter, Boolean isTo) {
        this.parametersFill.append("\n");
        String variableName = this.getVariableName(parameter);
        String staticName = parameter.getColumnName().replace(" ", "").toUpperCase();
        this.parametersFill.append("\t\t").append(variableName).append(isTo != false ? "To" : "").append(" = ").append(this.getProcessMethod(parameter, isTo)).append("(").append(staticName).append(")").append(";");
    }

    private String getVariableName(MProcessPara parameter) {
        String parameterName = this.getParameterName(parameter);
        StringBuilder variableName = new StringBuilder();
        if (20 == parameter.getAD_Reference_ID()) {
            if (parameterName.startsWith("Is")) {
                variableName.append(parameterName.replaceFirst("I", "i"));
            } else {
                variableName.append("is").append(parameterName);
            }
        } else {
            variableName.append(parameterName.substring(0, 1).toLowerCase()).append(parameterName.substring(1, this.getParameterName(parameter).length()));
        }
        if (21 == parameter.getAD_Reference_ID() || 31 == parameter.getAD_Reference_ID() || DisplayType.isLookup(parameter.getAD_Reference_ID()) && 17 != parameter.getAD_Reference_ID() && !this.isReturnString(parameter)) {
            variableName.append("Id");
        }
        return variableName.toString();
    }

    private String replaceSpecialCharacter(String value) {
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$#()* ]", "");
    }

    private String getMethodNameForGet(MProcessPara parameter) {
        String parameterName = this.getParameterName(parameter);
        StringBuilder variableName = new StringBuilder();
        if (20 == parameter.getAD_Reference_ID()) {
            if (parameterName.startsWith("Is")) {
                variableName.append(parameterName.replaceFirst("I", "i"));
            } else {
                variableName.append("is").append(parameterName);
            }
        } else {
            variableName.append("get").append(parameterName);
        }
        if (21 == parameter.getAD_Reference_ID() || 31 == parameter.getAD_Reference_ID() || DisplayType.isLookup(parameter.getAD_Reference_ID()) && 17 != parameter.getAD_Reference_ID() && !this.isReturnString(parameter)) {
            variableName.append("Id");
        }
        return variableName.toString();
    }

    private String getMethodNameForSet(MProcessPara parameter) {
        String parameterName = this.getParameterName(parameter);
        StringBuilder variableName = new StringBuilder();
        variableName.append("set");
        variableName.append(parameterName);
        if (21 == parameter.getAD_Reference_ID() || 31 == parameter.getAD_Reference_ID() || DisplayType.isLookup(parameter.getAD_Reference_ID()) && 17 != parameter.getAD_Reference_ID() && !this.isReturnString(parameter)) {
            variableName.append("Id");
        }
        return variableName.toString();
    }

    private String getType(MProcessPara parameter) {
        Class clazz = DisplayType.getClass(parameter.getAD_Reference_ID(), true);
        if (clazz == String.class && DisplayType.isText(parameter.getAD_Reference_ID()) || DisplayType.isLookup(parameter.getAD_Reference_ID()) && this.isReturnString(parameter)) {
            return "String";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == BigDecimal.class) {
            this.addImportClass(BigDecimal.class);
            return "BigDecimal";
        }
        if (clazz == Timestamp.class) {
            this.addImportClass(Timestamp.class);
            return "Timestamp";
        }
        if (clazz == Boolean.class || 20 == parameter.getAD_Reference_ID()) {
            return "boolean";
        }
        if (17 == parameter.getAD_Reference_ID()) {
            return "String";
        }
        return "Object";
    }

    private String getProcessMethod(MProcessPara parameter, boolean isTo) {
        String type = this.getType(parameter);
        String typeForMethod = type.substring(0, 1);
        typeForMethod = typeForMethod.toUpperCase();
        if ((typeForMethod = typeForMethod + type.substring(1)).equals("Object")) {
            return "getParameter";
        }
        return "getParameter" + (isTo ? "To" : "") + "As" + typeForMethod;
    }

    private void addImportClass(String className) {
        if (className == null || className.startsWith("java.lang.") && !className.startsWith("java.lang.reflect.")) {
            return;
        }
        for (String name : this.importClasses) {
            if (!className.equals(name)) continue;
            return;
        }
        this.importClasses.add(className);
    }

    private void addImportClass(Class<?> cl) {
        if (cl.isArray()) {
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            return;
        }
        this.addImportClass(cl.getCanonicalName());
    }

    private StringBuffer getImportClass() {
        StringBuffer importClass = new StringBuffer();
        for (String imp : this.importClasses) {
            if (importClass.length() > 0) {
                importClass.append("\n");
            }
            importClass.append("import ").append(imp).append(";");
        }
        return importClass;
    }

    private void writeToFile(StringBuffer sb, String fileName) {
        try {
            File out = new File(fileName);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    continue;
                }
                if (c == '{') {
                    ((Writer)fw).write(c);
                    continue;
                }
                ((Writer)fw).write(c);
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            log.info(out.getAbsolutePath() + " - " + (size /= 1024.0f) + " kB");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
            throw new RuntimeException(ex);
        }
    }

    private String getParameterName(MProcessPara processParameter) {
        String parameterName = processParameter.getColumnName();
        if (parameterName.indexOf("_") != -1 && parameterName.indexOf("_") < parameterName.length() && !this.parameterWithPrefix.contains(parameterName)) {
            parameterName = parameterName.substring(parameterName.indexOf("_"));
        }
        if (parameterName.equals("_ID")) {
            parameterName = processParameter.getColumnName();
        }
        parameterName = parameterName.replaceAll("\\s", "").replaceAll("_ID", "").replaceAll("_", "").replaceAll(" ", "").replaceAll("/", "");
        return this.replaceSpecialCharacter(parameterName);
    }

    boolean isReturnString(MProcessPara processParameter) {
        MColumn keyColumn;
        MRefTable referenceTable;
        return 18 == processParameter.getAD_Reference_ID() && (referenceTable = MRefTable.getById(Env.getCtx(), processParameter.getAD_Reference_Value_ID())) != null && DisplayType.isText((keyColumn = MColumn.get(Env.getCtx(), referenceTable.getAD_Key())).getAD_Reference_ID());
    }
}

