/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MProcess;
import org.compiere.util.CLogger;

public class ProcessClassGenerator {
    private String processName = null;
    private String className = null;
    private String parentClassName = null;
    private String directoryName = null;
    private static CLogger log = CLogger.getCLogger(ProcessClassGenerator.class);

    public ProcessClassGenerator(MProcess process, String directory) {
        this.className = process.getClassname();
        this.processName = process.getName();
        this.directoryName = directory;
    }

    public String createFile() {
        int index = this.className.lastIndexOf(".");
        if (index == -1) {
            throw new AdempiereException("@Classname@ @NotFound@");
        }
        String packageName = this.className.substring(0, index);
        String fileName = this.className.substring(index + 1);
        this.parentClassName = fileName + "Abstract";
        StringBuffer header = this.createHeader(packageName, fileName);
        if (!this.directoryName.endsWith(File.separator)) {
            this.directoryName = this.directoryName + File.separator;
        }
        this.writeToFile(header, this.directoryName + fileName + ".java");
        return this.directoryName + fileName + ".java";
    }

    private StringBuffer createHeader(String packageName, String className) {
        StringBuffer header = new StringBuffer();
        header.append("/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.\t\t\t\t\t\t\t\t\t\t*\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net or http://www.adempiere.net/license.html         *\n *****************************************************************************/\n");
        header.append("\n");
        header.append("package ").append(packageName).append(";\n");
        header.append("\n");
        header.append("/** Generated Process for (").append(this.processName).append(")\n").append(" *  @author ADempiere (generated) \n").append(" *  @version ").append(Adempiere.MAIN_VERSION).append("\n").append(" */\n");
        header.append("public class ").append(className).append(" extends ").append(this.parentClassName).append("\n{");
        header.append("\n\t@Override").append("\n\tprotected void prepare()").append("\n\t{").append("\n\t\tsuper.prepare();").append("\n\t}");
        header.append("\n\n\t@Override").append("\n\tprotected String doIt() throws Exception").append("\n\t{").append("\n\t\treturn \"\";").append("\n\t}");
        header.append("\n}");
        return header;
    }

    private void writeToFile(StringBuffer sb, String fileName) {
        try {
            File out = new File(fileName);
            if (out.exists()) {
                return;
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == ';' || c == '}') {
                    ((Writer)fw).write(c);
                    continue;
                }
                if (c == '{') {
                    ((Writer)fw).write(c);
                    continue;
                }
                ((Writer)fw).write(c);
            }
            ((Writer)fw).flush();
            ((Writer)fw).close();
            float size = out.length();
            log.info(out.getAbsolutePath() + " - " + (size /= 1024.0f) + " kB");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
            throw new RuntimeException(ex);
        }
    }
}

