/*
 * Decompiled with CFR 0.152.
 */
package org.compiere;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.ImageIcon;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.model.MSystem;
import org.compiere.model.ModelValidationEngine;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.SecureEngine;
import org.compiere.util.Splash;
import org.compiere.util.Util;

public final class Adempiere {
    public static final String ID = "$Id: Adempiere.java,v 1.8 2006/08/11 02:58:14 jjanke Exp $";
    public static String MAIN_VERSION = "Release 3.9.2";
    public static String DATE_VERSION = "2019-05-03";
    public static String DB_VERSION = "2019-05-03";
    public static final String NAME = "ADempiere\u00ae";
    public static final String URL = "www.adempiere.net";
    private static final String s_File16x16 = "images/AD16.png";
    private static final String s_file32x32 = "images/AD32.png";
    private static final String s_file100x30 = "images/AD10030.png";
    private static final String s_file48x15 = "images/Adempiere.png";
    private static final String s_file48x15HR = "images/AdempiereHR.png";
    private static String s_supportEmail = "";
    public static final String SUB_TITLE = "Smart Suite ERP,CRM and SCM";
    public static final String ADEMPIERE_R = "Powered by ADempiere ERP\u00ae";
    public static final String COPYRIGHT = "\u00a9 1999-2019 ADempiere\u00ae";
    private static String s_ImplementationVersion = null;
    private static String s_ImplementationVendor = null;
    private static Image s_image16;
    private static Image s_image48x15;
    private static Image s_imageLogo;
    private static ImageIcon s_imageIcon32;
    private static ImageIcon s_imageIconLogo;
    private static final String ONLINE_HELP_URL = "http://wiki.adempiere.net/Manual";
    private static final String RESTORE_PASSWORD_PATH = ":8888/webui";
    private static CLogger log;
    private static boolean unitTestMode;

    public static String getName() {
        return NAME;
    }

    public static String getVersion() {
        return MAIN_VERSION + " @ " + DATE_VERSION;
    }

    public static String getSum() {
        StringBuffer sb = new StringBuffer();
        sb.append(NAME).append(" ").append(MAIN_VERSION).append(SUB_TITLE);
        return sb.toString();
    }

    public static String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(NAME).append(" ").append(MAIN_VERSION).append("_").append(DATE_VERSION).append(" -").append(SUB_TITLE).append("- ").append(COPYRIGHT).append("; Implementation: ").append(Adempiere.getImplementationVersion()).append(" - ").append(Adempiere.getImplementationVendor());
        return sb.toString();
    }

    private static void setPackageInfo() {
        if (s_ImplementationVendor != null) {
            return;
        }
        Package adempierePackage = Package.getPackage("org.compiere");
        s_ImplementationVendor = adempierePackage.getImplementationVendor();
        s_ImplementationVersion = adempierePackage.getImplementationVersion();
        if (s_ImplementationVendor == null) {
            s_ImplementationVendor = "Supported by ADempiere community";
            s_ImplementationVersion = "ADempiere";
        }
    }

    public static String getImplementationVersion() {
        if (s_ImplementationVersion == null) {
            Adempiere.setPackageInfo();
        }
        return s_ImplementationVersion;
    }

    public static String getImplementationVendor() {
        if (s_ImplementationVendor == null) {
            Adempiere.setPackageInfo();
        }
        return s_ImplementationVendor;
    }

    public static int getCheckSum() {
        return Adempiere.getSum().hashCode();
    }

    public static String getSummaryAscii() {
        String retValue = Adempiere.getSummary();
        retValue = Util.replace(retValue, "\u00ae", "(r)");
        retValue = Util.replace(retValue, "\u2122", "(tm)");
        retValue = Util.replace(retValue, "\u00a9", "(c)");
        retValue = Util.replace(retValue, Env.NL, " ");
        retValue = Util.replace(retValue, "\n", " ");
        return retValue;
    }

    public static String getJavaInfo() {
        return System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
    }

    public static String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("sun.os.patch.level");
    }

    public static String getURL() {
        return "http://www.adempiere.net";
    }

    public static String getOnlineHelpURL() {
        return ONLINE_HELP_URL;
    }

    public static String getSubtitle() {
        return SUB_TITLE;
    }

    public static String getWebServer(String hostName) {
        return "http://" + hostName + RESTORE_PASSWORD_PATH;
    }

    public static Image getImage16() {
        if (s_image16 == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Adempiere.class.getResource(s_File16x16);
            if (url == null) {
                return null;
            }
            s_image16 = tk.getImage(url);
        }
        return s_image16;
    }

    public static Image getImageLogoSmall(boolean hr) {
        if (s_image48x15 == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = null;
            url = hr ? Adempiere.class.getResource(s_file48x15HR) : Adempiere.class.getResource(s_file48x15);
            if (url == null) {
                return null;
            }
            s_image48x15 = tk.getImage(url);
        }
        return s_image48x15;
    }

    public static Image getImageLogo() {
        if (s_imageLogo == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Adempiere.class.getResource(s_file100x30);
            if (url == null) {
                return null;
            }
            s_imageLogo = tk.getImage(url);
        }
        return s_imageLogo;
    }

    public static ImageIcon getImageIcon32() {
        if (s_imageIcon32 == null) {
            URL url = Adempiere.class.getResource(s_file32x32);
            if (url == null) {
                return null;
            }
            s_imageIcon32 = new ImageIcon(url);
        }
        return s_imageIcon32;
    }

    public static ImageIcon getImageIconLogo() {
        if (s_imageIconLogo == null) {
            URL url = Adempiere.class.getResource(s_file100x30);
            if (url == null) {
                return null;
            }
            s_imageIconLogo = new ImageIcon(url);
        }
        return s_imageIconLogo;
    }

    public static String getAdempiereHome() {
        String retValue = Ini.getAdempiereHome();
        if (retValue == null && System.getProperty("user.dir").indexOf("Adempiere") != -1) {
            retValue = System.getProperty("user.dir");
            int pos = retValue.indexOf("Adempiere");
            retValue = retValue.substring(pos + 9);
        }
        if (retValue == null) {
            retValue = File.separator + "Adempiere";
        }
        return retValue;
    }

    public static String getSupportEMail() {
        return s_supportEmail;
    }

    public static void setSupportEMail(String email) {
        s_supportEmail = email;
    }

    public static URL getCodeBase() {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL url = bs.getCodeBase();
            return url;
        }
        catch (UnavailableServiceException ue) {
            return null;
        }
    }

    public static boolean isWebStartClient() {
        return Adempiere.getCodeBase() != null;
    }

    public static String getCodeBaseHost() {
        URL url = Adempiere.getCodeBase();
        if (url == null) {
            return null;
        }
        return url.getHost();
    }

    public static synchronized boolean startup(boolean isClient) {
        if (log != null) {
            return true;
        }
        if (isClient && !Login.isJavaOK(isClient)) {
            System.exit(1);
        }
        Ini.setClient(isClient);
        log = CLogger.getCLogger(Adempiere.class);
        log.info(Adempiere.getSummaryAscii());
        Ini.loadProperties(false);
        CLogMgt.setLevel(Ini.getProperty("TraceLevel"));
        if (isClient && Ini.isPropertyBool("TraceFile") && CLogFile.get(false, null, isClient) == null) {
            CLogMgt.addHandler(CLogFile.get(true, Ini.findAdempiereHome(), isClient));
        }
        if (isClient && CLogMgt.isLevelAll()) {
            log.log(Level.FINEST, System.getProperties().toString());
        }
        DB.setDBTarget(CConnection.get(Adempiere.getCodeBaseHost()));
        if (isClient) {
            return false;
        }
        return Adempiere.startupEnvironment(isClient);
    }

    public static boolean startupEnvironment(boolean isClient) {
        String className;
        Adempiere.startup(isClient);
        if (!DB.isConnected()) {
            log.severe("No Database");
            return false;
        }
        MSystem system = MSystem.get(Env.getCtx());
        if (system == null) {
            return false;
        }
        ModelValidationEngine.get();
        try {
            className = system.getEncryptionKey();
            if (!(className != null && className.length() != 0 || (className = System.getProperty("ADEMPIERE_SECURE")) == null || className.length() <= 0 || className.equals("org.compiere.util.Secure"))) {
                SecureEngine.init(className);
                system.setEncryptionKey(className);
                system.save();
            }
            SecureEngine.init(className);
            if (isClient) {
                MClient.get(Env.getCtx(), 0);
            } else {
                MClient.getAll(Env.getCtx());
            }
        }
        catch (Exception e) {
            log.warning("Environment problems: " + e.toString());
        }
        className = null;
        try {
            className = "org.compiere.wf.DocWorkflowManager";
            Class.forName(className);
            className = "org.compiere.print.ArchiveEngine";
            Class.forName(className);
        }
        catch (Exception e) {
            log.warning("Not started: " + className + " - " + e.getMessage());
        }
        if (!isClient) {
            DB.updateMail();
        }
        return true;
    }

    public static void main(String[] args) {
        Splash.getSplash();
        Adempiere.startup(true);
        String className = "org.compiere.apps.AMenu";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-debug")) continue;
            className = args[i];
            break;
        }
        try {
            Class<?> startClass = Class.forName(className);
            startClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("ADempiere starting: " + className + " - " + e.toString());
            e.printStackTrace();
        }
    }

    public static void enableUnitTestMode() {
        unitTestMode = true;
    }

    public static boolean isUnitTestMode() {
        return unitTestMode;
    }

    static {
        log = null;
        ClassLoader loader = Adempiere.class.getClassLoader();
        InputStream inputStream = loader.getResourceAsStream("org/adempiere/version.properties");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                if (properties.containsKey("MAIN_VERSION")) {
                    MAIN_VERSION = properties.getProperty("MAIN_VERSION");
                }
                if (properties.containsKey("DATE_VERSION")) {
                    DATE_VERSION = properties.getProperty("DATE_VERSION");
                }
                if (properties.containsKey("DB_VERSION")) {
                    DB_VERSION = properties.getProperty("DB_VERSION");
                }
                if (properties.containsKey("IMPLEMENTATION_VERSION")) {
                    s_ImplementationVersion = properties.getProperty("IMPLEMENTATION_VERSION");
                }
                if (properties.containsKey("IMPLEMENTATION_VENDOR")) {
                    s_ImplementationVendor = properties.getProperty("IMPLEMENTATION_VENDOR");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        unitTestMode = false;
    }
}

