/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComboBox;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRefList;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

class AcctViewerData {
    public int WindowNo;
    public int AD_Client_ID;
    public MAcctSchema[] ASchemas = null;
    public MAcctSchema ASchema = null;
    public boolean documentQuery = false;
    public int C_AcctSchema_ID = 0;
    public String PostingType = "";
    public int AD_Org_ID = 0;
    public Timestamp DateFrom = null;
    public Timestamp DateTo = null;
    public int AD_Table_ID;
    public int Record_ID;
    public HashMap<String, String> whereInfo = new HashMap();
    public HashMap<String, Integer> buttonRecordID = new HashMap();
    public HashMap<String, Integer> tableInfo = new HashMap();
    boolean displayQty = false;
    boolean displaySourceAmt = false;
    boolean displayDocumentInfo = false;
    String sortBy1 = "";
    String sortBy2 = "";
    String sortBy3 = "";
    String sortBy4 = "";
    boolean group1 = false;
    boolean group2 = false;
    boolean group3 = false;
    boolean group4 = false;
    private int m_leadingColumns = 0;
    private String m_ref1 = null;
    private String m_ref2 = null;
    private static CLogger log = CLogger.getCLogger(AcctViewerData.class);

    public AcctViewerData(Properties ctx, int windowNo, int ad_Client_ID, int ad_Table_ID) {
        this.WindowNo = windowNo;
        this.AD_Client_ID = ad_Client_ID;
        if (this.AD_Client_ID == 0) {
            this.AD_Client_ID = Env.getContextAsInt(Env.getCtx(), this.WindowNo, "AD_Client_ID");
        }
        if (this.AD_Client_ID == 0) {
            this.AD_Client_ID = Env.getContextAsInt(Env.getCtx(), "AD_Client_ID");
        }
        this.AD_Table_ID = ad_Table_ID;
        this.ASchemas = MAcctSchema.getClientAcctSchema(ctx, this.AD_Client_ID);
        this.ASchema = this.ASchemas[0];
    }

    public void dispose() {
        this.ASchemas = null;
        this.ASchema = null;
        this.whereInfo.clear();
        this.whereInfo = null;
        Env.clearWinContext(this.WindowNo);
    }

    protected void fillAcctSchema(JComboBox cb) {
        for (int i = 0; i < this.ASchemas.length; ++i) {
            cb.addItem(new KeyNamePair(this.ASchemas[i].getC_AcctSchema_ID(), this.ASchemas[i].getName()));
        }
    }

    protected void fillPostingType(JComboBox cb) {
        int AD_Reference_ID = 125;
        ValueNamePair[] pt = MRefList.getList(Env.getCtx(), AD_Reference_ID, true);
        for (int i = 0; i < pt.length; ++i) {
            cb.addItem(pt[i]);
        }
    }

    protected void fillTable(JComboBox cb) {
        ValueNamePair select = null;
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted') AND IsView='N'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String tableName = rs.getString(2);
                String name = Msg.translate(Env.getCtx(), tableName + "_ID");
                ValueNamePair pp = new ValueNamePair(tableName, name);
                cb.addItem(pp);
                this.tableInfo.put(tableName, new Integer(id));
                if (id != this.AD_Table_ID) continue;
                select = pp;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (select != null) {
            cb.setSelectedItem(select);
        }
    }

    protected void fillOrg(JComboBox cb) {
        KeyNamePair pp = new KeyNamePair(0, "");
        cb.addItem(pp);
        String sql = "SELECT AD_Org_ID, Name FROM AD_Org WHERE AD_Client_ID=? ORDER BY Value";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                cb.addItem(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    protected String getButtonText(String tableName, String columnName, String selectSQL) {
        StringBuffer sql = new StringBuffer("SELECT (");
        Language language = Env.getLanguage(Env.getCtx());
        sql.append(MLookupFactory.getLookup_TableDirEmbed(language, columnName, "avd")).append(") FROM ").append(tableName).append(" avd WHERE avd.").append(selectSQL);
        String retValue = "<" + selectSQL + ">";
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                retValue = rs.getString(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return retValue;
    }

    protected int getButtonRecordID(String keyColumn) {
        Integer record_id = this.buttonRecordID.get(keyColumn);
        if (record_id == null || record_id == 0) {
            return 0;
        }
        return record_id;
    }

    protected RModel query() {
        RColumn col;
        StringBuffer whereClause = new StringBuffer();
        if (this.C_AcctSchema_ID != 0) {
            whereClause.append("zz").append(".C_AcctSchema_ID=").append(this.C_AcctSchema_ID);
        }
        if (this.PostingType != null && this.PostingType.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".PostingType='").append(this.PostingType).append("'");
        }
        if (this.documentQuery) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".AD_Table_ID=").append(this.AD_Table_ID).append(" AND ").append("zz").append(".Record_ID=").append(this.Record_ID);
        } else {
            for (String where : this.whereInfo.values()) {
                if (where == null || where.length() <= 0) continue;
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".").append(where);
            }
            if (this.DateFrom != null || this.DateTo != null) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                if (this.DateFrom != null && this.DateTo != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct, 'DD') BETWEEN ").append(DB.TO_DATE(this.DateFrom)).append(" AND ").append(DB.TO_DATE(this.DateTo));
                } else if (this.DateFrom != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct, 'DD') >= ").append(DB.TO_DATE(this.DateFrom));
                } else {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct, 'DD') <= ").append(DB.TO_DATE(this.DateTo));
                }
            }
            if (this.AD_Org_ID != 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".AD_Org_ID=").append(this.AD_Org_ID);
            }
        }
        RModel rm = this.getRModel();
        StringBuffer orderClause = new StringBuffer();
        if (this.sortBy1.length() > 0) {
            col = rm.getRColumn(this.sortBy1);
            if (col != null) {
                orderClause.append(col.getDisplaySQL());
            } else {
                orderClause.append("zz").append(".").append(this.sortBy1);
            }
        }
        if (this.sortBy2.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            if ((col = rm.getRColumn(this.sortBy2)) != null) {
                orderClause.append(col.getDisplaySQL());
            } else {
                orderClause.append("zz").append(".").append(this.sortBy2);
            }
        }
        if (this.sortBy3.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            if ((col = rm.getRColumn(this.sortBy3)) != null) {
                orderClause.append(col.getDisplaySQL());
            } else {
                orderClause.append("zz").append(".").append(this.sortBy3);
            }
        }
        if (this.sortBy4.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            if ((col = rm.getRColumn(this.sortBy4)) != null) {
                orderClause.append(col.getDisplaySQL());
            } else {
                orderClause.append("zz").append(".").append(this.sortBy4);
            }
        }
        if (orderClause.length() == 0) {
            orderClause.append("zz").append(".Fact_Acct_ID");
        }
        if (this.group1 && this.sortBy1.length() > 0) {
            rm.setGroup(this.sortBy1);
        }
        if (this.group2 && this.sortBy2.length() > 0) {
            rm.setGroup(this.sortBy2);
        }
        if (this.group3 && this.sortBy3.length() > 0) {
            rm.setGroup(this.sortBy3);
        }
        if (this.group4 && this.sortBy4.length() > 0) {
            rm.setGroup(this.sortBy4);
        }
        rm.setFunction("AmtAcctDr", "Sum");
        rm.setFunction("AmtAcctCr", "Sum");
        rm.query(Env.getCtx(), whereClause.toString(), orderClause.toString());
        return rm;
    }

    public RModel getRModel() {
        String column;
        int i;
        Properties ctx = Env.getCtx();
        RModel rm = new RModel("Fact_Acct");
        ArrayList<String> keys = this.createKeyColumns();
        int max = this.m_leadingColumns;
        if (max == 0) {
            max = keys.size();
        }
        for (i = 0; i < max; ++i) {
            column = keys.get(i);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
                continue;
            }
            if (column == null || !column.endsWith("_ID")) continue;
            rm.addColumn(new RColumn(ctx, column, 19));
        }
        rm.addColumn(new RColumn(ctx, "AmtAcctDr", 12));
        rm.addColumn(new RColumn(ctx, "AmtAcctCr", 12));
        if (this.displaySourceAmt) {
            if (!keys.contains("DateTrx")) {
                rm.addColumn(new RColumn(ctx, "DateTrx", 15));
            }
            rm.addColumn(new RColumn(ctx, "C_Currency_ID", 19));
            rm.addColumn(new RColumn(ctx, "AmtSourceDr", 12));
            rm.addColumn(new RColumn(ctx, "AmtSourceCr", 12));
            rm.addColumn(new RColumn(ctx, "Rate", 12, "CASE WHEN (AmtSourceDr + AmtSourceCr) = 0 THEN 0 ELSE (AmtAcctDr + AmtAcctCr) / (AmtSourceDr + AmtSourceCr) END"));
        }
        for (i = max; i < keys.size(); ++i) {
            column = keys.get(i);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
                continue;
            }
            if (column.startsWith("UserElement")) {
                if (column.indexOf(49) != -1) {
                    rm.addColumn(new RColumn(ctx, column, 19, null, 0, this.m_ref1));
                    continue;
                }
                rm.addColumn(new RColumn(ctx, column, 19, null, 0, this.m_ref2));
                continue;
            }
            if (column == null || !column.endsWith("_ID")) continue;
            rm.addColumn(new RColumn(ctx, column, 19));
        }
        if (!keys.contains("DateAcct")) {
            rm.addColumn(new RColumn(ctx, "DateAcct", 15));
        }
        if (!keys.contains("C_Period_ID")) {
            rm.addColumn(new RColumn(ctx, "C_Period_ID", 19));
        }
        if (this.displayQty) {
            rm.addColumn(new RColumn(ctx, "C_UOM_ID", 19));
            rm.addColumn(new RColumn(ctx, "Qty", 29));
        }
        if (this.displayDocumentInfo) {
            rm.addColumn(new RColumn(ctx, "AD_Table_ID", 19));
            rm.addColumn(new RColumn(ctx, "Record_ID", 13));
            rm.addColumn(new RColumn(ctx, "Description", 10));
        }
        if (this.PostingType == null || this.PostingType.length() == 0) {
            rm.addColumn(new RColumn(ctx, "PostingType", 17, "zz.PostingType", 125, null));
        }
        return rm;
    }

    private ArrayList<String> createKeyColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        this.m_leadingColumns = 0;
        columns.add(this.sortBy1);
        if (!columns.contains(this.sortBy2)) {
            columns.add(this.sortBy2);
        }
        if (!columns.contains(this.sortBy3)) {
            columns.add(this.sortBy3);
        }
        if (!columns.contains(this.sortBy4)) {
            columns.add(this.sortBy4);
        }
        MAcctSchemaElement[] elements = this.ASchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length; ++i) {
            MAcctSchemaElement ase;
            String columnName;
            if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
                this.m_leadingColumns = columns.size();
            }
            if ((columnName = (ase = elements[i]).getColumnName()).startsWith("UserElement")) {
                if (columnName.indexOf(49) != -1) {
                    this.m_ref1 = ase.getDisplayColumnName();
                } else {
                    this.m_ref2 = ase.getDisplayColumnName();
                }
            }
            if (columns.contains(columnName)) continue;
            columns.add(columnName);
        }
        if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
            this.m_leadingColumns = columns.size();
        }
        return columns;
    }
}

