/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.acct.FactUtil;
import org.compiere.model.I_C_Project;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MCharge;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AssetAddition
extends Doc {
    public Doc_AssetAddition(MAcctSchema[] mAcctSchemaArray, ResultSet resultSet, String string) {
        super(mAcctSchemaArray, MAssetAddition.class, resultSet, "GLD", string);
    }

    @Override
    protected String loadDocumentDetails() {
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema mAcctSchema) {
        MAssetAddition mAssetAddition = this.getAssetAddition();
        ArrayList<Fact> arrayList = new ArrayList<Fact>();
        Fact fact = new Fact(this, mAcctSchema, mAssetAddition.getPostingType());
        arrayList.add(fact);
        if ("IMP".equals(mAssetAddition.getA_SourceType()) || "Exp".equals(mAssetAddition.getA_CapvsExp())) {
            return arrayList;
        }
        BigDecimal bigDecimal = mAssetAddition.getAssetValueAmt();
        FactLine[] factLineArray = FactUtil.createSimpleOperation(fact, null, this.getA_Asset_Acct(), this.getP_Asset_Acct(mAcctSchema), mAcctSchema.getC_Currency_ID(), bigDecimal, false);
        int n = this.getInvoicePartner_ID();
        int n2 = this.getInvoiceProject_ID();
        if (n > 0) {
            factLineArray[1].setC_BPartner_ID(n);
        }
        if (n2 > 0) {
            factLineArray[1].setC_Project_ID(n2);
        }
        return arrayList;
    }

    private MAssetAddition getAssetAddition() {
        return (MAssetAddition)this.getPO();
    }

    private MAccount getP_Asset_Acct(MAcctSchema mAcctSchema) {
        MAssetAddition mAssetAddition = this.getAssetAddition();
        MAccount mAccount = null;
        if ("PRJ".equals(mAssetAddition.getA_SourceType())) {
            I_C_Project i_C_Project = mAssetAddition.getC_Project();
            return this.getProjectAcct(i_C_Project, mAcctSchema);
        }
        if ("MAN".equals(mAssetAddition.getA_SourceType()) && this.getC_Charge_ID() > 0) {
            mAccount = MCharge.getAccount(this.getC_Charge_ID(), mAcctSchema, null);
            return mAccount;
        }
        if ("INV".equals(mAssetAddition.getA_SourceType()) && mAssetAddition.getC_InvoiceLine().getC_Project_ID() > 0) {
            I_C_Project i_C_Project = mAssetAddition.getC_InvoiceLine().getC_Project();
            return this.getProjectAcct(i_C_Project, mAcctSchema);
        }
        mAccount = this.getP_Expense_Acct(mAssetAddition.getM_Product_ID(), mAcctSchema);
        return mAccount;
    }

    public MAccount getP_Expense_Acct(int n, MAcctSchema mAcctSchema) {
        ProductCost productCost = new ProductCost(this.getCtx(), n, 0, this.getTrxName());
        return productCost.getAccount(2, mAcctSchema);
    }

    private MAccount getProjectAcct(I_C_Project i_C_Project, MAcctSchema mAcctSchema) {
        String string = "PJ_WIP_Acct";
        String string2 = "SELECT " + string + " FROM " + "C_Project_Acct" + " WHERE " + "C_Project_ID" + "=? AND " + "C_AcctSchema_ID" + "=?";
        int n = DB.getSQLValueEx(this.getTrxName(), string2, i_C_Project.getC_Project_ID(), mAcctSchema.get_ID());
        return MAccount.getValidCombination(this.getCtx(), n, this.getTrxName());
    }

    private MAccount getA_Asset_Acct() {
        MAssetAddition mAssetAddition = this.getAssetAddition();
        int n = MAssetAcct.forA_Asset_ID(this.getCtx(), mAssetAddition.getA_Asset_ID(), mAssetAddition.getPostingType(), mAssetAddition.getDateAcct(), this.getTrxName()).getA_Asset_Acct();
        return MAccount.getValidCombination(this.getCtx(), n, this.getTrxName());
    }

    public int getInvoicePartner_ID() {
        MAssetAddition mAssetAddition = this.getAssetAddition();
        if ("INV".equals(mAssetAddition.getA_SourceType()) && mAssetAddition.getC_Invoice_ID() > 0) {
            return mAssetAddition.getC_Invoice().getC_BPartner_ID();
        }
        return 0;
    }

    public int getInvoiceProject_ID() {
        MAssetAddition mAssetAddition = this.getAssetAddition();
        if ("INV".equals(mAssetAddition.getA_SourceType()) && mAssetAddition.getC_Invoice_ID() > 0) {
            return mAssetAddition.getC_InvoiceLine().getC_Project_ID();
        }
        return 0;
    }
}

