/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Payroll;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Concept_Acct;

public class Doc_HRProcess
extends Doc {
    public MHRProcess process = null;
    public static final String DOCTYPE_Payroll = "HRP";

    public Doc_HRProcess(MAcctSchema[] mAcctSchemaArray, ResultSet resultSet, String string) {
        super(mAcctSchemaArray, MHRProcess.class, resultSet, DOCTYPE_Payroll, string);
    }

    @Override
    protected String loadDocumentDetails() {
        this.process = (MHRProcess)this.getPO();
        this.setDateDoc(this.getDateAcct());
        this.p_lines = this.loadLines(this.process);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MHRProcess mHRProcess) {
        ArrayList<DocLine_Payroll> arrayList = new ArrayList<DocLine_Payroll>();
        List list = new Query(this.getCtx(), "HR_Movement", "HR_Movement.HR_Process_ID = ? AND HR_Movement.Amount <> 0 AND EXISTS(SELECT 1 FROM HR_Concept c \t\t\t\t\tWHERE c.HR_Concept_ID = HR_Movement.HR_Concept_ID \t\t\t\t\tAND c.AccountSign != 'N')", this.getTrxName()).setParameters(mHRProcess.getHR_Process_ID()).setOrderBy("C_BPartner_ID").list();
        for (MHRMovement mHRMovement : list) {
            DocLine_Payroll docLine_Payroll = new DocLine_Payroll(mHRMovement, this);
            this.log.fine(docLine_Payroll.toString());
            arrayList.add(docLine_Payroll);
        }
        DocLine[] docLineArray = new DocLine[arrayList.size()];
        arrayList.toArray(docLineArray);
        return docLineArray;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        return bigDecimal;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema mAcctSchema) {
        int n;
        int n2 = 0;
        Fact fact = new Fact(this, mAcctSchema, "A");
        BigDecimal bigDecimal = Env.ZERO;
        BigDecimal bigDecimal2 = Env.ZERO;
        for (DocLine docLine : this.p_lines) {
            FactLine factLine;
            MAccount mAccount;
            if (n2 == 0) {
                n2 = docLine.getC_BPartner_ID();
            }
            if (docLine.getC_BPartner_ID() != 0 && docLine.getC_BPartner_ID() != n2 && this.process.getHR_Payroll().isPostPerEmployee()) {
                this.closeBPartner(bigDecimal, bigDecimal2, fact, mAcctSchema, n2);
                n2 = docLine.getC_BPartner_ID();
                bigDecimal = Env.ZERO;
                bigDecimal2 = Env.ZERO;
            }
            DocLine_Payroll docLine_Payroll = (DocLine_Payroll)docLine;
            BigDecimal bigDecimal3 = docLine.getAmtSource();
            bigDecimal3 = bigDecimal3.setScale(mAcctSchema.getStdPrecision(), 4);
            MHRConcept mHRConcept = MHRConcept.getById(mAcctSchema.getCtx(), docLine_Payroll.getHR_Concept_ID(), this.getTrxName());
            X_HR_Concept_Acct x_HR_Concept_Acct = mHRConcept.getConceptAcct(Optional.ofNullable(docLine_Payroll.getAccountSchemaId()), Optional.ofNullable(docLine_Payroll.getPayrollId()), Optional.ofNullable(docLine_Payroll.getPayrollId()));
            if (x_HR_Concept_Acct == null || docLine_Payroll.getAccountSign() == null || docLine_Payroll.getAccountSign().length() <= 0 || !"D".equals(docLine_Payroll.getAccountSign()) && !"C".equals(docLine_Payroll.getAccountSign())) continue;
            if (x_HR_Concept_Acct.isBalancing()) {
                mAccount = MAccount.getValidCombination(this.getCtx(), x_HR_Concept_Acct.getHR_Expense_Acct(), this.getTrxName());
                factLine = fact.createLine(docLine, mAccount, this.getC_Currency_ID(), bigDecimal3, null);
                factLine.setDescription(this.process.getName() + " " + mHRConcept.getValue() + " " + mHRConcept.getName());
                factLine.saveEx();
                MAccount mAccount2 = MAccount.getValidCombination(this.getCtx(), x_HR_Concept_Acct.getHR_Revenue_Acct(), this.getTrxName());
                FactLine factLine2 = fact.createLine(docLine, mAccount2, this.getC_Currency_ID(), null, bigDecimal3);
                factLine2.setDescription(this.process.getName() + " " + mHRConcept.getValue() + " " + mHRConcept.getName());
                factLine2.saveEx();
                continue;
            }
            if ("D".equals(docLine_Payroll.getAccountSign())) {
                mAccount = MAccount.getValidCombination(this.getCtx(), x_HR_Concept_Acct.getHR_Expense_Acct(), this.getTrxName());
                factLine = fact.createLine(docLine, mAccount, this.getC_Currency_ID(), bigDecimal3, null);
                factLine.setDescription(this.process.getName() + " " + mHRConcept.getValue() + " " + mHRConcept.getName());
                factLine.saveEx();
                bigDecimal = bigDecimal.add(bigDecimal3);
                continue;
            }
            if (!"C".equals(docLine_Payroll.getAccountSign())) continue;
            mAccount = MAccount.getValidCombination(this.getCtx(), x_HR_Concept_Acct.getHR_Revenue_Acct(), this.getTrxName());
            factLine = fact.createLine(docLine, mAccount, this.getC_Currency_ID(), null, bigDecimal3);
            factLine.setDescription(this.process.getName() + " " + mHRConcept.getValue() + " " + mHRConcept.getName());
            factLine.saveEx();
            bigDecimal2 = bigDecimal2.add(bigDecimal3);
        }
        if (this.process.getHR_Payroll().isPostPerEmployee()) {
            this.closeBPartner(bigDecimal, bigDecimal2, fact, mAcctSchema, n2);
        } else if ((bigDecimal.signum() != 0 || bigDecimal2.signum() != 0) && (n = this.process.getHR_Payroll().getC_Charge_ID()) > 0) {
            MAccount mAccount = MCharge.getAccount(n, mAcctSchema, bigDecimal.subtract(bigDecimal2));
            FactLine factLine = null;
            factLine = bigDecimal.abs().compareTo(bigDecimal2.abs()) > 0 ? fact.createLine(null, mAccount, this.getC_Currency_ID(), null, bigDecimal.subtract(bigDecimal2)) : fact.createLine(null, mAccount, this.getC_Currency_ID(), bigDecimal2.abs().subtract(bigDecimal.abs()), null);
            factLine.setAD_Org_ID(this.getAD_Org_ID());
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(fact);
        return arrayList;
    }

    private void closeBPartner(BigDecimal bigDecimal, BigDecimal bigDecimal2, Fact fact, MAcctSchema mAcctSchema, int n) {
        int n2;
        if ((bigDecimal.signum() != 0 || bigDecimal2.signum() != 0) && (n2 = this.process.getHR_Payroll().getC_Charge_ID()) > 0) {
            MAccount mAccount = MCharge.getAccount(n2, mAcctSchema, bigDecimal.subtract(bigDecimal2));
            FactLine factLine = null;
            factLine = bigDecimal.abs().compareTo(bigDecimal2.abs()) > 0 ? fact.createLine(null, mAccount, this.getC_Currency_ID(), null, bigDecimal.subtract(bigDecimal2)) : fact.createLine(null, mAccount, this.getC_Currency_ID(), bigDecimal2.abs().subtract(bigDecimal.abs()), null);
            if (factLine != null) {
                factLine.setAD_Org_ID(this.getAD_Org_ID());
                factLine.setC_BPartner_ID(n);
                factLine.saveEx();
            }
        }
    }
}

