/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProduct;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_InOut
extends Doc {
    private int m_Reversal_ID = 0;

    public Doc_InOut(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInOut.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInOut inout = (MInOut)this.getPO();
        this.setDateDoc(inout.getMovementDate());
        this.m_Reversal_ID = inout.getReversal_ID();
        this.p_lines = this.loadLines(inout);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MInOut inout) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInOutLine[] lines = inout.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MInOutLine line = lines[i];
            if (line.isDescription()) {
                this.log.finer("Ignored: " + line);
                continue;
            }
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getMovementQty();
            docLine.setReversalLine_ID(line.getReversalLine_ID());
            docLine.setQty(Qty, !this.getDocumentType().equals("MMS"));
            String sql = "SELECT PP_Cost_Collector_ID  FROM C_OrderLine WHERE C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL";
            int PP_Cost_Collector_ID = DB.getSQLValueEx(this.getTrxName(), sql, line.getC_OrderLine_ID());
            docLine.setPP_Cost_Collector_ID(PP_Cost_Collector_ID);
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    private boolean isValidLine(DocLine docLine) {
        return docLine.getM_Product_ID() > 0 && docLine.getQty().signum() != 0;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        if (this.getDocumentType().equals("MMS") && this.isSOTrx()) {
            DocLine line;
            int i;
            BigDecimal total = Env.ZERO;
            for (i = 0; i < this.p_lines.length; ++i) {
                line = this.p_lines[i];
                if (!this.isValidLine(line)) continue;
                BigDecimal costs = null;
                for (MCostDetail cost : line.getCostDetail(as, false)) {
                    if (!MCostDetail.existsCost(cost)) continue;
                    costs = MCostDetail.getTotalCost(cost, as);
                    total = total.add(costs);
                    String description = cost.getM_CostElement().getName() + " " + cost.getM_CostType().getName();
                    dr = fact.createLine(line, line.getAccount(4, as), as.getC_Currency_ID(), costs, null);
                    if (dr == null) {
                        this.p_Error = "FactLine DR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    dr.setAD_Org_ID(line.getOrder_Org_ID());
                    dr.setM_Product_ID(cost.getM_Product_ID());
                    dr.setQty(cost.getQty().negate());
                    dr.addDescription(description);
                    if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty().negate(), Env.ONE.negate())) {
                        this.p_Error = "Original Shipment/Receipt not posted yet";
                        return null;
                    }
                    cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), null, costs);
                    if (cr == null) {
                        this.p_Error = "FactLine CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    cr.addDescription(description);
                    cr.setM_Product_ID(cost.getM_Product_ID());
                    cr.setQty(cost.getQty());
                    if (this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0) continue;
                    if (!cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty(), Env.ONE.negate())) {
                        this.p_Error = "Original Shipment/Receipt not posted yet";
                        return null;
                    }
                    costs = cr.getAcctBalance();
                }
            }
            if (as.isAccrual() && as.isCreateSOCommitment()) {
                for (i = 0; i < this.p_lines.length; ++i) {
                    Fact factcomm;
                    line = this.p_lines[i];
                    BigDecimal multiplier = Env.ONE;
                    if (this.m_Reversal_ID != 0 && this.m_Reversal_ID < this.get_ID()) {
                        multiplier = multiplier.negate();
                    }
                    if ((factcomm = Doc_Order.getCommitmentSalesRelease(as, this, line.getQty(), line.get_ID(), multiplier)) == null) continue;
                    facts.add(factcomm);
                }
            }
        } else if (this.getDocumentType().equals("MMR") && this.isSOTrx()) {
            BigDecimal total = Env.ZERO;
            for (int i = 0; i < this.p_lines.length; ++i) {
                DocLine line = this.p_lines[i];
                if (!this.isValidLine(line)) continue;
                BigDecimal costs = null;
                for (MCostDetail cost : line.getCostDetail(as, false)) {
                    if (!MCostDetail.existsCost(cost)) continue;
                    costs = MCostDetail.getTotalCost(cost, as);
                    total = total.add(costs);
                    String description = cost.getM_CostElement().getName() + " " + cost.getM_CostType().getName();
                    dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs, null);
                    if (dr == null) {
                        this.p_Error = "FactLine DR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    dr.setM_Product_ID(cost.getM_Product_ID());
                    dr.setQty(cost.getQty());
                    dr.addDescription(description);
                    if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0) {
                        if (!dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty(), Env.ONE.negate())) {
                            this.p_Error = "Original Shipment/Receipt not posted yet";
                            return null;
                        }
                        costs = dr.getAcctBalance();
                    }
                    if ((cr = fact.createLine(line, line.getAccount(4, as), as.getC_Currency_ID(), null, costs)) == null) {
                        this.p_Error = "FactLine CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    cr.setAD_Org_ID(line.getOrder_Org_ID());
                    cr.setM_Product_ID(cost.getM_Product_ID());
                    cr.setQty(cost.getQty().negate());
                    cr.addDescription(description);
                    if (this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0 || cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty().negate(), Env.ONE.negate())) continue;
                    this.p_Error = "Original Shipment/Receipt not posted yet";
                    return null;
                }
                if (total != null && total.signum() != 0) continue;
            }
        } else if (this.getDocumentType().equals("MMR") && !this.isSOTrx()) {
            BigDecimal total = Env.ZERO;
            for (int i = 0; i < this.p_lines.length; ++i) {
                int C_Currency_ID = as.getC_Currency_ID();
                DocLine line = this.p_lines[i];
                if (!this.isValidLine(line)) continue;
                BigDecimal costs = null;
                MProduct product = line.getProduct();
                for (MCostDetail cost : line.getCostDetail(as, true)) {
                    if (cost.getC_InvoiceLine_ID() > 0 || !MCostDetail.existsCost(cost)) continue;
                    costs = MCostDetail.getTotalCost(cost, as);
                    total = total.add(costs);
                    String description = cost.getM_CostElement().getName() + " " + cost.getM_CostType().getName();
                    MAccount assets = line.getAccount(3, as);
                    if (product.isService()) {
                        assets = line.getPP_Cost_Collector_ID() > 0 ? line.getAccount(11, as) : line.getAccount(2, as);
                    }
                    if ((dr = fact.createLine(line, assets, C_Currency_ID, costs, null)) == null) {
                        this.p_Error = "DR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                    dr.setM_Product_ID(cost.getM_Product_ID());
                    dr.setQty(cost.getQty());
                    dr.addDescription(description);
                    if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty(), Env.ONE.negate())) {
                        this.p_Error = "Original Receipt not posted yet";
                        return null;
                    }
                    cr = fact.createLine(line, this.getAccount(51, as), C_Currency_ID, null, costs);
                    if (cr == null) {
                        this.p_Error = "CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    cr.addDescription(description);
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                    cr.setM_Product_ID(cost.getM_Product_ID());
                    cr.setQty(cost.getQty().negate());
                    if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty().negate(), Env.ONE.negate())) {
                        this.p_Error = "Original Receipt not posted yet";
                        return null;
                    }
                    cost.setProcessed(true);
                    cost.saveEx();
                }
            }
        } else if (this.getDocumentType().equals("MMS") && !this.isSOTrx()) {
            BigDecimal total = Env.ZERO;
            for (int i = 0; i < this.p_lines.length; ++i) {
                int C_Currency_ID = as.getC_Currency_ID();
                DocLine line = this.p_lines[i];
                if (!this.isValidLine(line)) continue;
                BigDecimal costs = null;
                MProduct product = line.getProduct();
                for (MCostDetail cost : line.getCostDetail(as, true)) {
                    if (!MCostDetail.existsCost(cost)) continue;
                    costs = MCostDetail.getTotalCost(cost, as);
                    total = total.add(costs);
                    String description = cost.getM_CostElement().getName() + " " + cost.getM_CostType().getName();
                    dr = fact.createLine(line, this.getAccount(51, as), C_Currency_ID, costs, null);
                    if (dr == null) {
                        this.p_Error = "CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    dr.addDescription(description);
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                    dr.setM_Product_ID(cost.getM_Product_ID());
                    dr.setQty(cost.getQty().negate());
                    if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty().negate(), Env.ONE.negate())) {
                        this.p_Error = "Original Receipt not posted yet";
                        return null;
                    }
                    MAccount assets = line.getAccount(3, as);
                    if (product.isService()) {
                        assets = line.getAccount(2, as);
                    }
                    if ((cr = fact.createLine(line, assets, C_Currency_ID, null, costs)) == null) {
                        this.p_Error = "DR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                    cr.addDescription(description);
                    cr.setM_Product_ID(cost.getM_Product_ID());
                    cr.setQty(cost.getQty());
                    if (this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0 || cr.updateReverseLine(MInOut.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty(), Env.ONE.negate())) continue;
                    this.p_Error = "Original Receipt not posted yet";
                    return null;
                }
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        facts.add(fact);
        return facts;
    }
}

