/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import org.adempiere.apps.toolbar.AProcessActionModel;
import org.compiere.apps.APanel;
import org.compiere.apps.AppsAction;
import org.compiere.grid.ed.VButton;
import org.compiere.model.MProcess;
import org.compiere.swing.CMenuItem;
import org.compiere.util.Env;

public class AProcessAction {
    private AProcessActionModel model = new AProcessActionModel();
    private APanel parent;
    private AppsAction action;

    public static AppsAction createAppsAction(APanel parent) {
        AProcessAction app = new AProcessAction(parent);
        return app.action;
    }

    public AProcessAction(APanel parent) {
        this.parent = parent;
        this.initAction();
    }

    private void initAction() {
        this.action = new AppsAction(this.model.getActionName(), null, false);
        this.action.setDelegate(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AProcessAction.this.showPopup();
            }
        });
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popup = new JPopupMenu("ProcessMenu");
        List<MProcess> processes = this.model.fetchProcesses(Env.getCtx(), this.parent.getCurrentTab());
        if (processes.size() == 0) {
            return null;
        }
        for (MProcess process : processes) {
            CMenuItem mi = this.createProcessMenuItem(process);
            popup.add(mi);
        }
        return popup;
    }

    public void showPopup() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup == null) {
            return;
        }
        AbstractButton button = this.action.getButton();
        if (button.isShowing()) {
            popup.show(button, 0, button.getHeight());
        }
    }

    private CMenuItem createProcessMenuItem(final MProcess process) {
        CMenuItem mi = new CMenuItem(this.model.getDisplayName(process));
        mi.setToolTipText(this.model.getDescription(process));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AProcessAction.this.startProcess(process);
            }
        });
        return mi;
    }

    private void startProcess(MProcess process) {
        VButton button = new VButton("StartProcess", false, false, true, process.get_Translation("Name"), process.get_Translation("Description"), process.get_Translation("Help"), process.getAD_Process_ID());
        this.parent.actionButton(button);
    }
}

