/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.adempiere.controller.SmallViewEditable;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.IProcessDialog;
import org.compiere.apps.ProcessController;
import org.compiere.apps.ProcessCtl;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MPInstance;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CComboBoxEditable;
import org.compiere.swing.CEditor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class ProcessPanel
extends ProcessController
implements SmallViewEditable,
ActionListener,
ASyncProcess {
    private int cols = 0;
    private int row = 0;
    private int[] ids = null;
    private IProcessDialog parent = null;
    private ArrayList<CLabel> m_separators;
    private BorderLayout mainLayout;
    private CPanel centerPanel;
    private CScrollPane parameterScrollPane;
    private CPanel southPanel;
    private CPanel leftPanel;
    private CPanel rightPanel;
    private CButton bOK;
    private CButton bCancel;
    private CButton bPrint;
    private CComboBoxEditable fSavedName;
    private CButton bDelete;
    private CLabel lSaved;
    private VLookup fPrintFormat = null;
    private CComboBox fReportType = new CComboBox();
    private CLabel lPrintFormat = new CLabel(Msg.getMsg(Env.getCtx(), "PrintFormat"));
    private CLabel lReportType = new CLabel(Msg.getMsg(Env.getCtx(), "ReportType"));
    private CPanel mainPanel = new CPanel(){
        private static final long serialVersionUID = 428410337428677817L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMinimumSize();
            if (d.height < m.height || d.width < m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.max(d.height, m.height);
                d1.width = Math.max(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private JEditorPane message = new JEditorPane(){
        private static final long serialVersionUID = -2271852928089812014L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMaximumSize();
            if (d.height > m.height || d.width > m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.min(d.height, m.height);
                d1.width = Math.min(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private JScrollPane messagePane = new JScrollPane(this.message){
        private static final long serialVersionUID = 3605316311642118445L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMaximumSize();
            if (d.height > m.height || d.width > m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.min(d.height, m.height);
                d1.width = Math.min(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private boolean isLocked = false;
    private int labelMinWidth = 0;
    private int fieldMinWidth = 0;
    private final int SEPARATOR = 25;
    private static CLogger log = CLogger.getCLogger(ProcessPanel.class);

    public ProcessPanel(int WindowNo, ProcessInfo pi) {
        super(WindowNo, pi);
    }

    public ProcessPanel(int WindowNo, ProcessInfo pi, int column) {
        super(WindowNo, pi, column);
    }

    public ProcessPanel(IProcessDialog parent, int WindowNo, ProcessInfo pi, int column) {
        super(WindowNo, pi, column);
        this.parent = parent;
    }

    @Override
    public void initComponents() {
        this.mainLayout = new BorderLayout();
        this.centerPanel = new CPanel();
        this.parameterScrollPane = new CScrollPane(this.centerPanel);
        this.southPanel = new CPanel();
        this.leftPanel = new CPanel();
        this.rightPanel = new CPanel();
        this.bOK = ConfirmPanel.createOKButton(true);
        this.bCancel = ConfirmPanel.createCancelButton(true);
        this.bPrint = ConfirmPanel.createPrintButton(true);
        this.fSavedName = new CComboBoxEditable();
        this.bDelete = ConfirmPanel.createDeleteButton(true);
        this.lSaved = new CLabel(Msg.getMsg(Env.getCtx(), "SavedParameter"));
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bPrint.addActionListener(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.setMinimumSize(new Dimension(500, 100));
        this.southPanel.setLayout(new BorderLayout());
        this.leftPanel.setLayout(new FlowLayout());
        this.rightPanel.setLayout(new FlowLayout());
        this.leftPanel.add((Component)this.lSaved, null);
        this.leftPanel.add((Component)this.fSavedName, null);
        this.leftPanel.add((Component)this.bDelete, null);
        this.rightPanel.add((Component)this.bPrint, null);
        this.rightPanel.add((Component)this.bCancel, null);
        this.rightPanel.add((Component)this.bOK, null);
        this.southPanel.add((Component)this.leftPanel, "Before");
        this.southPanel.add((Component)this.rightPanel, "After");
        this.m_separators = new ArrayList();
        this.message.setContentType("text/html");
        this.message.setEditable(false);
        this.message.setBackground(Color.white);
        this.message.setFocusable(true);
        this.centerPanel.setLayout(new ALayout());
        this.centerPanel.setBorder(null);
        if (this.isShowDescription()) {
            this.mainPanel.add((Component)this.messagePane, "North");
            this.messagePane.setMaximumSize(new Dimension(600, 300));
        }
        this.parameterScrollPane.setAutoscrolls(true);
        this.parameterScrollPane.createVerticalScrollBar();
        this.parameterScrollPane.createHorizontalScrollBar();
        this.mainPanel.add((Component)this.parameterScrollPane, "Center");
        this.fSavedName.setEditable(true);
        this.fSavedName.setReadWrite(true);
        this.bDelete.addActionListener(this);
        if (this.isShowButtons()) {
            if (this.isReport()) {
                Lookup lookup = this.listPrintFormat();
                this.fPrintFormat = new VLookup("AD_PrintFormat_ID", false, false, true, lookup);
                this.fPrintFormat.setBackground(AdempierePLAF.getInfoBackground());
                this.fPrintFormat.addActionListener(this);
                MRole roleCurrent = MRole.get(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()));
                boolean m_isAllowHTMLView = roleCurrent.isAllow_HTML_View();
                boolean m_isAllowXLSView = roleCurrent.isAllow_XLS_View();
                String type = MSysConfig.getValue("ZK_REPORT_TABLE_OUTPUT_TYPE", Env.getAD_Client_ID(Env.getCtx()));
                if (type != null && "XLS".equals(type)) {
                    type = "X";
                }
                if (type != null && "XLSX".equals(type)) {
                    type = "XX";
                }
                if (type != null && "HTML".equals(type)) {
                    type = "H";
                }
                ValueNamePair valueNamePairSelection = null;
                this.fReportType.removeAllItems();
                ValueNamePair valueNamePairPDF = new ValueNamePair("P", "PDF");
                this.fReportType.addItem(valueNamePairPDF);
                if (valueNamePairPDF.getValue().equals(type)) {
                    valueNamePairSelection = valueNamePairPDF;
                }
                if (m_isAllowXLSView) {
                    ValueNamePair valueNamePairExcel = new ValueNamePair("X", "Excel");
                    ValueNamePair valueNamePairXLSX = new ValueNamePair("XX", "XLSX");
                    this.fReportType.addItem(valueNamePairExcel);
                    this.fReportType.addItem(valueNamePairXLSX);
                    if (valueNamePairExcel.getValue().equals(type) || "X".equals(type)) {
                        valueNamePairSelection = valueNamePairExcel;
                    }
                    if (valueNamePairXLSX.getValue().equals(type)) {
                        valueNamePairSelection = valueNamePairXLSX;
                    }
                }
                if (m_isAllowHTMLView) {
                    ValueNamePair valueNamePairHTML = new ValueNamePair("H", "HTML");
                    this.fReportType.addItem(valueNamePairHTML);
                    if (valueNamePairHTML.getValue().equals(type)) {
                        valueNamePairSelection = valueNamePairHTML;
                    }
                }
                if (valueNamePairSelection != null) {
                    this.fReportType.setSelectedItem(valueNamePairSelection);
                } else {
                    this.fReportType.setSelectedItem(0);
                }
                this.leftPanel.add((Component)this.lPrintFormat, null);
                this.leftPanel.add((Component)this.fPrintFormat, null);
                this.leftPanel.add((Component)this.lReportType, null);
                this.leftPanel.add((Component)this.fReportType, null);
            }
            this.mainPanel.add((Component)this.southPanel, "South");
        }
        this.mainLayout.setVgap(2);
        this.message.setText(this.getTextMsg());
    }

    @Override
    public void afterInit() {
        this.validateAutoStart();
        this.mainPanel.validate();
        if (this.isAutoStart()) {
            this.bOK.doClick();
        } else {
            this.loadQuerySaved();
        }
        this.fSavedName.addActionListener(this);
    }

    public void setResult(String textMsg) {
        StringBuffer currentText = new StringBuffer(this.getTextMsg());
        currentText.append(textMsg);
        this.message.setText(currentText.toString());
        this.message.setCaretPosition(this.message.getDocument().getLength());
    }

    public CPanel getPanel() {
        return this.mainPanel;
    }

    @Override
    public CEditor createEditor(GridField field) {
        return VEditorFactory.getEditor(field, false);
    }

    @Override
    public void formatEditor(CEditor editor1, CEditor editor2) {
        log.fine("");
        VEditor editor = (VEditor)editor1;
        VEditor editorTo = (VEditor)editor2;
        if (editor == null) {
            return;
        }
        this.configColumns(editor, editorTo);
        CLabel label = VEditorFactory.getLabel(editor.getField());
        if (label == null) {
            this.centerPanel.add(Box.createHorizontalStrut(12), new ALayoutConstraint(this.row, this.cols++));
        } else {
            int currentWidth = label.getPreferredSize().width;
            this.labelMinWidth = currentWidth > this.labelMinWidth ? currentWidth : this.labelMinWidth;
            this.centerPanel.add((Component)label, new ALayoutConstraint(this.row, this.cols++));
        }
        Component component = (Component)((Object)editor);
        this.fieldMinWidth = component.getPreferredSize().width > this.fieldMinWidth ? component.getPreferredSize().width : this.fieldMinWidth;
        this.centerPanel.add((Component)((Object)editor), new ALayoutConstraint(this.row, this.cols++));
        if (editorTo == null) {
            this.m_separators.add(null);
            return;
        }
        CLabel dash = new CLabel(" - ");
        this.centerPanel.add((Component)dash, new ALayoutConstraint(this.row, this.cols++));
        this.m_separators.add(dash);
        this.centerPanel.add((Component)((Object)editorTo), new ALayoutConstraint(this.row, this.cols++));
    }

    private void configColumns(VEditor editor, VEditor editorTo) {
        int maxToAdd = this.getColumns() * 2;
        int columnsToAdd = this.getColumns();
        if (editorTo != null) {
            columnsToAdd += 2;
        }
        if (this.cols + columnsToAdd > maxToAdd) {
            this.cols = 0;
            ++this.row;
        }
    }

    @Override
    public void dynamicDisplay() {
        this.centerPanel.setPreferredSize(new Dimension(this.labelMinWidth + this.fieldMinWidth + 25, (this.row + 1) * 25));
        super.dynamicDisplay();
    }

    @Override
    public void setComponentVisibility(int index, Boolean visible, Boolean isRange) {
        Component[] components;
        VEditor editor = (VEditor)this.getEditor(index);
        VEditor editorTo = (VEditor)this.getEditorTo(index);
        if (editor == null) {
            return;
        }
        for (Component comp : components = this.centerPanel.getComponents()) {
            if (!editor.getField().getColumnName().equals(comp.getName())) continue;
            if (visible.booleanValue()) {
                if (comp.isVisible()) continue;
                comp.setVisible(true);
                if (!isRange.booleanValue() || editorTo == null) continue;
                this.m_separators.get(index).setVisible(true);
                editorTo.setVisible(true);
                continue;
            }
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            if (!isRange.booleanValue() || editorTo == null) continue;
            this.m_separators.get(index).setText("");
            editorTo.setVisible(false);
        }
    }

    @Override
    public String saveParameters() {
        String validError = super.saveParameters();
        if (validError != null) {
            ADialog.error(this.getWindowNo(), this.getPanel(), "FillMandatory", validError);
        }
        return validError;
    }

    public CButton getDefaultButton() {
        return this.bOK;
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.isLocked = true;
        this.bOK.setText("");
        this.bOK.setEnabled(false);
        this.mainPanel.setEnabled(false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.setResult(this.getLogInfo(false));
        this.ids = pi.getIDs();
        this.bOK.setEnabled(true);
        this.mainPanel.setEnabled(true);
        this.isLocked = false;
        this.mainPanel.remove(this.messagePane);
        this.mainPanel.remove(this.parameterScrollPane);
        this.mainPanel.remove(this.southPanel);
        this.mainPanel.add((Component)this.messagePane, "Center");
        this.mainPanel.add((Component)this.southPanel, "South");
        if (this.parent != null) {
            this.parent.validateScreen();
            this.parent.showCenterScreen();
        }
        this.afterProcessTask();
        if (this.isReport() && !pi.isError()) {
            this.dispose();
        }
        if (this.getShowHelp() != null && this.getShowHelp().equals("S")) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.parent != null) {
            this.parent.dispose();
        }
    }

    @Override
    public boolean isUILocked() {
        return this.isLocked;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String saveName = null;
        boolean lastRun = false;
        Object pp = this.fSavedName.getSelectedItem();
        if (pp != null) {
            saveName = pp.toString();
            lastRun = ("** " + Msg.getMsg(Env.getCtx(), "LastRun") + " **").equals(saveName);
        }
        if (e.getSource() == this.bOK) {
            this.setIsOkPressed(true);
            if (this.isOnlyPanel()) {
                if (this.saveOrUpdateParameters(saveName) == null) {
                    this.dispose();
                }
            } else if (this.isProcessed()) {
                this.dispose();
            } else {
                MPrintFormat format;
                if (this.fReportType != null && this.fReportType.getSelectedItem() != null && ((ValueNamePair)this.fReportType.getSelectedItem()).getValue() != null) {
                    this.getProcessInfo().setReportType(((ValueNamePair)this.fReportType.getSelectedItem()).getValue().toString());
                }
                if (this.fPrintFormat != null && this.fPrintFormat.getValue() != null && (format = new MPrintFormat(Env.getCtx(), (Integer)this.fPrintFormat.getValue(), null)) != null) {
                    if (Ini.isClient()) {
                        this.getProcessInfo().setTransientObject(format);
                    } else {
                        this.getProcessInfo().setSerializableObject(format);
                    }
                }
                if (this.validateParameters() == null) {
                    if (this.saveOrUpdateParameters(saveName) == null) {
                        ProcessCtl.process(this.parent.getParentProcess(), this.getWindowNo(), this, this.getProcessInfo(), null);
                    }
                    if (this.parent.isEmbedded()) {
                        this.dispose();
                    }
                }
            }
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.bPrint) {
            if (this.parent != null) {
                this.parent.printScreen();
            }
        } else {
            if (e.getSource() == this.fSavedName) {
                this.loadParameters(saveName);
                boolean enabled = !Util.isEmpty(saveName);
                this.bDelete.setEnabled(enabled && this.fSavedName.getItemCount() > 1);
                return;
            }
            if (e.getSource() == this.bDelete && this.fSavedName != null && !lastRun) {
                Object o = this.fSavedName.getSelectedItem();
                if (o != null) {
                    this.deleteInstance(saveName);
                }
                this.loadQuerySaved();
            }
        }
    }

    private String saveOrUpdateParameters(String saveName) {
        String saveError = null;
        boolean lastRun = ("** " + Msg.getMsg(Env.getCtx(), "LastRun") + " **").equals(saveName);
        if (this.fSavedName != null && !lastRun) {
            if (this.fSavedName.getSelectedIndex() > -1) {
                saveError = this.updateInstance(saveName);
                if (saveError != null) {
                    ADialog.error(this.getWindowNo(), this.getPanel(), "Error", saveError);
                }
            } else {
                saveError = this.saveParameters(saveName);
                if (saveError != null) {
                    ADialog.error(this.getWindowNo(), this.getPanel(), "Error", saveError);
                }
            }
        }
        return saveError;
    }

    private void afterProcessTask() {
        if (this.ids != null && this.ids.length > 0) {
            log.config("");
            if (this.getProcessInfo().getAD_Process_ID() == 119) {
                this.printInvoices();
            } else if (this.getProcessInfo().getAD_Process_ID() == 118) {
                this.printShipments();
            }
        }
        this.openResult();
    }

    private void printShipments() {
        ADialogDialog d;
        if (this.ids == null) {
            return;
        }
        if (!ADialog.ask(this.getWindowNo(), this.getPanel(), "PrintShipments")) {
            return;
        }
        StringBuffer messageText = new StringBuffer();
        messageText.append("<p>").append(Msg.getMsg(Env.getCtx(), "PrintShipments")).append("</p>");
        this.setResult(messageText.toString());
        int retValue = ADialogDialog.A_CANCEL;
        do {
            for (int i = 0; i < this.ids.length; ++i) {
                int M_InOut_ID = this.ids[i];
                ReportCtl.startDocumentPrint(1, M_InOut_ID, this, this.getWindowNo(), true);
            }
        } while ((retValue = (d = new ADialogDialog((Frame)Env.getWindow(this.getWindowNo()), Env.getHeader(Env.getCtx(), this.getWindowNo()), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
    }

    private void loadQuerySaved() {
        List<MPInstance> savedParams = this.getSavedInstances(true);
        this.fSavedName.removeAllItems();
        this.fSavedName.setValue("");
        for (MPInstance instance : savedParams) {
            this.fSavedName.addItem(new KeyNamePair(instance.getAD_PInstance_ID(), instance.getName()));
        }
        this.fSavedName.setSelectedIndex(-1);
    }

    private void printInvoices() {
        ADialogDialog d;
        if (this.ids == null) {
            return;
        }
        if (!ADialog.ask(this.getWindowNo(), this.getPanel(), "PrintInvoices")) {
            return;
        }
        StringBuffer messageText = new StringBuffer();
        messageText.append("<p>").append(Msg.getMsg(Env.getCtx(), "PrintInvoices")).append("</p>");
        this.setResult(messageText.toString());
        int retValue = ADialogDialog.A_CANCEL;
        do {
            for (int i = 0; i < this.ids.length; ++i) {
                int AD_Invoice_ID = this.ids[i];
                ReportCtl.startDocumentPrint(2, AD_Invoice_ID, this, this.getWindowNo(), true);
            }
        } while ((retValue = (d = new ADialogDialog((Frame)Env.getWindow(this.getWindowNo()), Env.getHeader(Env.getCtx(), this.getWindowNo()), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
    }

    @Override
    public String validateParameters() {
        String validError = super.validateParameters();
        if (validError != null) {
            ADialog.error(this.getWindowNo(), this.getPanel(), "FillMandatory", validError);
        }
        return validError;
    }

    @Override
    public void openResult(MQuery query) {
        AEnv.zoom(query);
    }
}

