/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.DeleteEntitiesModel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Trx;

public abstract class DeleteEntityControler {
    private static CLogger log = CLogger.getCLogger(DeleteEntityControler.class);
    private int windowNo;
    private int clientId;
    private int tableId;
    private boolean isDryRun;
    private Stack<DeleteEntitiesModel> stack = new Stack();

    public void init(int windowNo) {
        this.windowNo = windowNo;
    }

    public KeyNamePair[] getClients() {
        return DB.getKeyNamePairs("SELECT AD_Client_ID, Name FROM AD_Client WHERE AD_Client_ID <> 0 ORDER BY Name", true);
    }

    public KeyNamePair[] getTables() {
        return DB.getKeyNamePairs("SELECT AD_Table_ID, (TableName || '_' || Name) AS Table FROM AD_Table WHERE IsView = 'N' AND AccessLevel <> '4' ORDER BY TableName", true);
    }

    public void loadChilds(DeleteEntitiesModel currentNode, Object rootNode) {
        HashSet<String> tablesIgnored = new HashSet<String>(Arrays.asList("T_Report", "T_ReportStatement", "AD_Attribute_Value", "AD_PInstance_Log", "A_Valid_Asset_Combinations"));
        if (tablesIgnored.contains(currentNode.getTableName())) {
            return;
        }
        String sql = "SELECT t.AD_Table_ID, t.TableName, c.ColumnName, c.IsMandatory FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView = 'N' AND c.ColumnName NOT IN ('CreatedBy', 'UpdatedBy') AND t.AD_Table_ID <> ? AND (\t\t(c.ColumnName = ? AND c.IsKey='N' AND c.ColumnSQL IS NULL) \t\tOR EXISTS(SELECT 1 \t\t\t\t\tFROM AD_Ref_Table r \t\t\t\t\tWHERE r.AD_Reference_ID = c.AD_Reference_Value_ID \t\t\t\t\tAND r.AD_Table_ID = ?)) ORDER BY t.LoadSeq DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, currentNode.getTableId());
            pstmt.setString(2, currentNode.getKeyColumnForTable());
            pstmt.setInt(3, currentNode.getTableId());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String isMandatory = rs.getString("IsMandatory");
                DeleteEntitiesModel data = new DeleteEntitiesModel(currentNode.getClientId(), rs.getInt("AD_Table_ID"), rs.getString("TableName"), rs.getString("ColumnName"), isMandatory != null && isMandatory.equals("Y"), currentNode);
                int count = data.getCount();
                if (count > 0) {
                    log.log(Level.FINE, "Adding node: " + data.getTableName() + "." + data.getJoinColumn());
                    this.addToNode(data, rootNode);
                    continue;
                }
                log.log(Level.FINE, "No records:" + data.getTableName());
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.INFO, sql);
                throw new AdempiereException("Couldn't load child tables", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getTableId() {
        return this.tableId;
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public void setDryRun(boolean isDryRun) {
        this.isDryRun = isDryRun;
    }

    public void addToStackForDelete(DeleteEntitiesModel node) {
        this.stack.push(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSelectedNodes() {
        int totalCount = 0;
        String errorMsg = null;
        try (Trx trx = Trx.get(Trx.createTrxName("delete"), true);){
            while (!this.stack.empty()) {
                DeleteEntitiesModel tableData = this.stack.pop();
                totalCount += tableData.delete(trx);
            }
            if (!this.isDryRun()) {
                trx.commit(true);
            } else {
                trx.rollback(true);
            }
        }
        if (errorMsg != null) {
            throw new AdempiereException(errorMsg);
        }
        return totalCount;
    }

    public abstract void addToNode(DeleteEntitiesModel var1, Object var2);
}

